---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              numérotation des équations, numéroter, réinitialiser, section, 
              compteur
---

# Comment réinitialiser la numérotation des équations à chaque section ?

Il peut être intéressant de renuméroter les équations à chaque changement 
de section ou d'autre niveau de sectionnement (comme un chapitre). 
Voici un exemple classique de numérotation que nous allons retravailler.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\section{Systèmes à une variable}
\begin{align}
  x + 4 & = 0 \\
  x & = 3
\end{align}

\section{Systèmes à deux variables}
\begin{align}
  x + 4 & = 0 \\
  8 - y & = 0
\end{align}
\end{document}
```


## Avec l'extension <ctanpkg:mathtools>

Avec l'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>), la commande 
`\numberwithin` permet de numéroter les équations suivant le paragraphe 
auquel elles appartiennent. Il faut alors appeler : 
`\numberwithin{equation}{⟨niveau⟩}` dans le préambule, où `⟨niveau⟩` est 
le nom du niveau de sectionnement : `chapter`, `section`, `subsection`,
`subsubsection`.

Voici notre exemple remanié.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

  \numberwithin{equation}{section}

\begin{document}
\section{Systèmes à une variable}
\begin{align}
  x + 4 & = 0 \\
  x & = 3
\end{align}

\section{Systèmes à deux variables}
\begin{align}
  x + 4 & = 0 \\
  8 - y & = 0
\end{align}
\end{document}
```


## Avec les commandes de base

Pour réinitialiser le compteur d'équations dans chaque section, 
il faut inclure dans le préambule :

```{noedit}
\makeatletter
\renewcommand\theequation{\thesection.\arabic{equation}}
\@addtoreset{equation}{section}
\makeatother
```

Dans ce cas, il ne faut pas mettre d'équation dans un chapitre 
avant la première section numérotée sous peine d'avoir un numéro 
comme "3.0.1".

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

  \makeatletter
  \renewcommand\theequation{\thesection.\arabic{equation}}
  \@addtoreset{equation}{section}
  \makeatother

\begin{document}
\section{Systèmes à une variable}
\begin{align}
  x + 4 & = 0 \\
  x & = 3
\end{align}

\section{Systèmes à deux variables}
\begin{align}
  x + 4 & = 0 \\
  8 - y & = 0
\end{align}
\end{document}
```


## Avec les extensions <ctanpkg:seceqn> et <ctanpkg:apeqnum>

:::{warning}
Les extensions <ctanpkg:seceqn> et <ctanpkg:apeqnum> datent de la fin des années 80. 
Ce qui suit est informatif. 
:::

Les extensions <ctanpkg:seceqn> et <ctanpkg:apeqnum> permettent 
pour la première de numéroter les équations par section et pour la seconde
de numéroter individuellement les équations dans les annexes.


:::{sources}
- [FAQ-reuseq](https://www.texfaq.org/FAQ-reuseq)
:::