---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, boîtes
---

# Comment exploiter les fantômes ?

La notion de *fantôme* en LaTeX est très simple : il s'agit de réserver
de la place pour un objet, sans pour autant faire apparaître l'objet
en question. Les fantômes sont souvent utilisés pour ajuster l'alignement. 
Il y a trois types de fantômes obtenus respectivement par les commandes
`\phantom`, `\hphantom`, et `\vphantom`.

L'exemple classique est celui de l'alignement des radicaux, 
illustré ci-dessous.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[  \sqrt{x} + \sqrt{X} + \sqrt{\vphantom{X}x}  \]
\end{document}
```

La différence est fine mais la composition des deux radicaux de droite 
est plus homogène (ils sont alignés en haut) et donc visuellement 
plus satisfaisante.

Pour un autre cas d'utilisation des fantômes, vous pouvez consulter la question
"[](/4_domaines_specialises/mathematiques/structures/delimiteurs/ne_pas_equilibrer_les_delimiteurs)".

Les fantômes sont un cas particulier d'une notion classique en typographie, 
celle de montants. En LaTeX, les montants sont obtenus en tant que réglures
dont une dimension est nulle. Par exemple, `\vphantom{X}` a 
une action similaire à `\rule{0pt}{\heightof{X}}` (`\heightof` est fournie
par l'extension <ctanpkg:calc>). Il peut parfois être utile d'insérer 
directement une réglure de largeur nulle et de hauteur et profondeur
déterminées à la main pour résoudre des problèmes délicats d'alignement.


:::{sources}
- [Les fantômes sont vos amis](https://www.elzevir.fr/imj/latex/tips.html#phantom), 
  par Manuel Pégourié-Gonnard
:::