///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id$
//
// Copyright (C) 2007 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _ImageParser_h
#define _ImageParser_h

#include "util.h"
#include "Buffer.h"

class AbstractTokenizer;
class AbstractTokenReceiver;
class Message;

class ImageParser
{
public:
  ImageParser(Message *message,
	      AbstractTokenizer *tokenizer,
	      AbstractTokenReceiver *receiver,
	      const string &prefix,
	      const Buffer<unsigned char> &bytes);

  virtual ~ImageParser();

  virtual bool parseImage() = 0;

protected:
  void sendToken(const string &token);
  void digestImage();

private:
  /// Not implemented.
  ImageParser(const ImageParser &);

  /// Not implemented.
  ImageParser& operator=(const ImageParser &);

protected:
  Message *m_message;
  AbstractTokenizer *m_tokenizer;
  AbstractTokenReceiver *m_receiver;
  const string m_prefix;
  const Buffer<unsigned char> &m_bytes;
};

#endif // _ImageParser_h
