// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Serge Steer
// Copyright (C) 2011 - DIGITEO - Michal Baudin
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// Maple code used to create reference
// Digits := 40: 
// writeto("asec.ref"): interface(prettyprint = 0): 
// for i from 1 by 1/100  to 10 do  print(i,evalf[30](arcsec(i), 30)) end do: 
// writeto(terminal):
// writeto("aseci.ref"): interface(prettyprint = 0): 
// for i from 1/100 by 1/100 to 1 do  print(i,evalf[30](Im(arcsec(i)), 30)) end do: 
// writeto(terminal):

ieee(2);

pi=%pi;eps=%eps;Inf=%inf;NaN=%nan; //used to make following code runnable under Matlab

ref=[1, 0.
101/100, .140835873566417262962716091571
51/50, .198354522158804725927077066217
103/100, .241945082765976582280608455646
26/25, .278246822734797159217794098561
21/20, .309844639741626972748627923384
53/50, .338070943621908384158151657501
107/100, .363721269558539565271190011535
27/25, .387316600888653330140351358878
109/100, .409220669555481129716508031173
11/10, .429699666151424517427187196301
111/100, .448955573001789769019839930516
28/25, .467146111008835203354118241871
113/100, .484397342904341469478278386497
57/50, .500811992971360006024806523114
23/20, .516475140846875830244894756978
29/25, .531458237938850853255761023465
117/100, .545822014561875047709033289100
59/50, .559618631424977995219502742438
119/100, .572893303003930547182378603427
6/5, .585685543457150959617757538478
121/100, .598030137383549905558181710227
61/50, .609957906444506092103376570859
123/100, .621496322143838534390921508666
31/25, .632670001018532122023745316220
5/4, .643501108793284386802809228717
63/50, .654009693231556811758831159990
127/100, .664213960542261334121717574389
32/25, .674130506667315177542143130774
129/100, .683774512178142144277477059063
13/10, .693159907576753814013955214106
131/100, .702299514342702718059165849836
33/25, .711205165961066574707135357243
133/100, .719887812317047928295140222887
67/50, .728357610184274650746495007745
27/20, .736624002019128509440825512712
34/25, .744695784867819750435338453801
137/100, .752581170870928058948622765843
69/50, .760287840592710819968632624894
139/100, .767822990195324719616327800915
7/5, .775193373310361307204093711182
141/100, .782405338323463361978656997516
71/50, .789464861675876103563990078063
143/100, .796377577694638606448103272603
36/25, .803148805386865636196971831109
29/20, .809783572570166846624145858019
73/50, .816286637658294100638708447578
147/100, .822662509376686425381480974546
37/25, .828915464645166946646789822036
149/100, .835049564833408325438565286341
3/2, .841068670567930255776525031826
151/100, .846976455246518999083742097183
38/25, .852776417396408035664667708429
153/100, .858471891995792981712337514254
77/50, .864066060863830794943951594112
31/20, .869561962211827942080191485148
39/25, .874962499437552106136224142416
157/100, .880270449235255527395296912966
79/50, .885488469085865131081159287674
159/100, .890619104184699235015419972215
8/5, .895664793857864972022265426345
161/100, .900627877513049929957291055679
81/50, .905510600165640474106308049575
163/100, .910315117576888347662317630861
41/25, .915043501037130382348325644710
33/20, .919697741823778615440801308024
83/50, .924279755360884317309064586543
167/100, .928791385104491811871648472809
42/25, .933234406175695628918806703650
169/100, .937610528761262227689183952069
17/10, .941921401299844844890830041495
171/100, .946168613470180606188254106390
43/25, .950353698996190046173716788188
173/100, .954478138282580740984705380993
87/50, .958543360893371562146601672271
7/4, .962550747884687001151454168993
44/25, .966501634002208876858255269615
177/100, .970397309752803941646445799770
89/50, .974239023359060280569180504390
179/100, .978027982604754008695211157213
9/5, .981765356578622737161817762514
181/100, .985452277323236645215066634552
91/50, .989089841395225617132404244069
183/100, .992679111342636336955389658610
46/25, .996221117104751653814744730551
37/20, .999716857339301649311527818501
93/50, 1.00316730068162784250622777715
187/100, 1.00657338694002546044783035753
47/25, 1.00993602823118065228191325025
189/100, 1.01325611005933722548483547934
19/10, 1.01653449234256851183529251627
191/100, 1.01977201038929215901682491543
48/25, 1.02296947582794704557183472107
193/100, 1.02612767749255038502308507144
97/50, 1.02924738226666784829400878647
39/20, 1.03232933588815877779283075680
49/25, 1.03537426371690101697976955448
197/100, 1.03838287146755438571002008968
99/50, 1.04135584590928735510047311274
199/100, 1.04429385553426707645009912732
2, 1.04719755119659774615421446109
201/100, 1.05006756672328557161220829367
101/50, 1.05290451949870964238121908384
203/100, 1.05570901102398617106289598745
51/25, 1.05848162745252827218384897670
41/20, 1.06122294010302416920303267317
103/50, 1.06393350595098298117456112142
207/100, 1.06661386809992860521093990833
52/25, 1.06926455623325828060363999122
209/100, 1.07188608704772283164776495898
21/10, 1.07447896466943000649168153992
211/100, 1.07704368105322045457690753953
53/25, 1.07958071636621743697153176244
213/100, 1.08209053935630608691863344766
107/50, 1.08457360770625569813491213336
43/20, 1.08703036837415890092643824548
54/25, 1.08946125792082449363610094005
217/100, 1.09186670282472594781295826163
109/50, 1.09424711978507503281350291973
219/100, 1.09660291601355945555543788951
11/5, 1.09893448951525474217080050065
221/100, 1.10124222935919366970749350482
111/50, 1.10352651593905126725735624070
223/100, 1.10578772122437963562950591151
56/25, 1.10802620900280448008068124913
9/4, 1.11024233511357421655055291769
113/50, 1.11243644767283271032815484411
227/100, 1.11460888729096805561825682793
57/25, 1.11675998728237222959811674713
229/100, 1.11889007386792988527744271095
23/10, 1.12099946637053891888481345051
231/100, 1.12308847740395069935164185290
58/25, 1.12515741305520392379324650849
233/100, 1.12720657306091291169616764149
117/50, 1.12923625097765872346134171853
47/20, 1.13124673434671974104155524864
59/25, 1.13323830485336723777570760611
237/100, 1.13521123848094095216184841435
119/50, 1.13716580565990972988188848146
239/100, 1.13910227141211287600658060871
12/5, 1.14102089549036893335739471691
241/100, 1.14292193251363014397616752983
121/50, 1.14480563209785283099966985820
243/100, 1.14667223898274633221006449883
61/25, 1.14852199315455590006814279481
49/20, 1.15035512996502813362719088347
123/50, 1.15217188024670100431167418944
247/100, 1.15397247042465436041188285239
62/25, 1.15575712262485092582886799269
249/100, 1.15752605477919222980211591104
5/2, 1.15927948072740859984658379402
251/100, 1.16101761031589730470496854740
63/25, 1.16274064949361813351334544506
253/100, 1.16444880040515112818666863132
127/50, 1.16614226148101683567419606070
51/20, 1.16782122752535530339413742762
64/25, 1.16948588980105609372277747289
257/100, 1.17113643611242783144061665629
129/50, 1.17277305088549221170123951721
259/100, 1.17439591524598397614162669781
13/5, 1.17600520709513510249122216125
261/100, 1.17760110118331834026384255377
131/50, 1.17918376918162225410840225644
263/100, 1.18075337975142709987247530098
66/25, 1.18231009861204814953397052825
53/20, 1.18385408860651049340752344951
133/50, 1.18538550976551687532590792140
267/100, 1.18690451936966775306786262844
67/25, 1.18841127200999051670877368278
269/100, 1.18990591964683263666801152372
27/10, 1.19138861166717144615811274124
271/100, 1.19285949494039128491432184109
68/25, 1.19431871387257683815627352879
273/100, 1.19576641045936969259992360095
137/50, 1.19720272433743339611143900287
11/4, 1.19862779283457064559783321980
69/25, 1.20004175101853463547960623158
277/100, 1.20144473174457507329069878597
139/50, 1.20283686570175790647639764649
279/100, 1.20421828145809640234959560478
14/5, 1.20558910550452987861322805897
281/100, 1.20694946229778509220020836980
141/50, 1.20829947430215405689714541508
283/100, 1.20963926203022087290911458057
71/25, 1.21096894408256901191624147452
57/20, 1.21228863718649940711039549781
143/50, 1.21359845623378864713208957149
287/100, 1.21489851431751556380659254753
72/25, 1.21618892276798353425411075707
289/100, 1.21746979118776488656317368200
29/10, 1.21874122748589290309721473075
291/100, 1.22000333791122605506187784916
73/25, 1.22125622708500827468244391915
293/100, 1.22249999803264827578796740983
147/50, 1.22373475221474016840170415190
59/20, 1.22496058955734687679241602939
74/25, 1.22617760848156716210666177476
297/100, 1.22738590593240636899573615656
149/50, 1.22858557740697035944593324517
299/100, 1.22977671698200146524372149671
3, 1.23095941734077468213492917825
301/100, 1.23213376979937174279351915102
151/50, 1.23329986433235014127057910697
303/100, 1.23445778959782363776028164892
76/25, 1.23560763296197024845003095481
61/20, 1.23674948052298322010874148533
153/50, 1.23788341713448000213885590261
307/100, 1.23900952642838375933786660860
77/25, 1.24012789083729151588047857657
309/100, 1.24123859161634258437137540634
31/10, 1.24234170886460051258902064962
311/100, 1.24343732154596137412972633557
78/25, 1.24452550750960083698213118286
313/100, 1.24560634350997206555481231237
157/50, 1.24667990522636614630809782131
63/20, 1.24774626728204637439269422290
79/25, 1.24880550326296739808216303591
317/100, 1.24985768573608988883441378215
159/50, 1.25090288626730108708022802500
319/100, 1.25194117543895126688460152112
16/5, 1.25297262286701586604790422100
321/100, 1.25399729721789274161447241784
161/50, 1.25501526622484373375885791589
323/100, 1.25602659670408945326301957945
81/25, 1.25703135457056594893483329231
13/4, 1.25802960485335166101742737699
163/50, 1.25902141171077282458180054000
327/100, 1.26000683844519525277686719135
82/25, 1.26098594751751020333896236762
329/100, 1.26195880056132181265636292345
33/10, 1.26292545839684336967441678437
331/100, 1.26388598104450949675521478869
83/25, 1.26484042773831110602462235938
333/100, 1.26578885693885980751111473761
167/50, 1.26673132634618825927696348139
67/20, 1.26766789291229276954374680906
84/25, 1.26859861285342428631045532553
337/100, 1.26952354166213374095151983132
169/50, 1.27044273411907754856974771543
339/100, 1.27135624430458890927888820591
17/5, 1.27226412561002040092311566859
341/100, 1.27316643074886320483386364741
171/50, 1.27406321176764816191257929692
343/100, 1.27495452005663371645191167693
86/25, 1.27584040636028566951453437910
69/20, 1.27672092078755353223103333296
173/50, 1.27759611282194814191448138093
347/100, 1.27846603133142508028327038312
87/25, 1.27933072457807831320443341821
349/100, 1.28019024022764835509095976712
7/2, 1.28104462535884914828711603646
351/100, 1.28189392647251773833871113880
88/25, 1.28273818950059071985810810941
353/100, 1.28357745981491132464829474629
177/50, 1.28441178223587092374218581245
71/20, 1.28524120104088861794209232187
89/25, 1.28606575997273249721319516376
357/100, 1.28688550224768605780067578521
179/50, 1.28770047056356317711305627212
359/100, 1.28851070710757496015771501847
18/5, 1.28931625356405168754503193735
361/100, 1.29011715112202301371474374815
181/50, 1.29091344048265948500430640616
363/100, 1.29170516186657837039959172662
91/25, 1.29249235502101672321097561716
73/20, 1.29327505922687451943325212242
183/50, 1.29405331330563064810873605260
367/100, 1.29482715562613446055466638009
92/25, 1.29559662411127551877613409071
369/100, 1.29636175624453411870395753092
37/10, 1.29712258907641510101504179610
371/100, 1.29787915923076740115463273552
93/25, 1.29863150291099173073130006461
373/100, 1.29937965590613872464411632881
187/50, 1.30012365359689983207679577985
15/4, 1.30086353096149317480670670185
94/25, 1.30159932258144654308052473156
377/100, 1.30233106264727964755730846489
189/50, 1.30305878496408769546995030294
379/100, 1.30378252295702831016476876096
19/5, 1.30450230967671376550537745376
381/100, 1.30521817780451046023118232548
191/50, 1.30593015965774751220454084583
383/100, 1.30663828719483630852666136004
96/25, 1.30734259202030280471485538896
77/20, 1.30804310538973432447809468430
193/50, 1.30873985821464257107042582441
387/100, 1.30943288106724452171021757138
97/25, 1.31012220418516283809608173067
389/100, 1.31080785747604738859726243129
39/10, 1.31148987052211944121796438549
391/100, 1.31216827258464005090307256822
98/25, 1.31284309260830413013950672133
393/100, 1.31351435922556165808644246847
197/50, 1.31418210076086745061305912300
79/20, 1.31484634523486088160940903557
99/25, 1.31550712036847691474030621132
397/100, 1.31616445358698977441043182929
199/50, 1.31681837202399055507852058643
399/100, 1.31746890252530003917760853361
4, 1.31811607165281796574566425465
401/100, 1.31875990568830996442593090577
201/50, 1.31940043063713334273905993861
403/100, 1.32003767223190288844032245074
101/25, 1.32067165593609782333614497719
81/20, 1.32130240694761102012681637539
203/50, 1.32192995020224156964889406341
407/100, 1.32255431037713176229458464874
102/25, 1.32317551189414952436969165607
409/100, 1.32379357892321732770062207601
41/10, 1.32440853538558856889892202260
411/100, 1.32502040495707239332383954755
103/25, 1.32562921107120791793491494388
413/100, 1.32623497692238878688344153179
207/50, 1.32683772546893897384011471551
83/20, 1.32743747943614072568299760270
104/25, 1.32803426131921552326217950039
417/100, 1.32862809338625891650267609443
209/50, 1.32921899768113007309307655588
419/100, 1.32980699602629686242240301543
21/5, 1.33039211002563727926018022893
421/100, 1.33097436106719799491372353286
211/50, 1.33155377032591080723137342345
423/100, 1.33213035876626774484038318164
106/25, 1.33270414714495556540325545643
17/4, 1.33327515601345037243667400777
213/50, 1.33384340572057306035322367605
427/100, 1.33440891641500628284854810764
107/25, 1.33497170804777362555644227100
429/100, 1.33553180037468165002285670081
43/10, 1.33608921295872546249839575423
431/100, 1.33664396517245844780935975386
108/25, 1.33719607620032679563168361681
433/100, 1.33774556504096943385246400697
217/50, 1.33829245050948397135256631668
87/20, 1.33883675123965924047369963823
109/25, 1.33937848568617501763718804070
437/100, 1.33991767212676948905249715859
219/50, 1.34045432866437501718463885188
439/100, 1.34098847322922275263430530891
22/5, 1.34152012358091662531659269024
441/100, 1.34204929731047723829725634202
221/50, 1.34257601184235617735356023284
443/100, 1.34310028443642123926407522711
111/25, 1.34362213218991307199253881037
89/20, 1.34414157203937371030956479316
223/50, 1.34465862076254748098718961833
447/100, 1.34517329498025474249971427654
112/25, 1.34568561115823891516494296526
449/100, 1.34619558560898724885776605865
9/2, 1.34670323449352576681825516086
451/100, 1.34720857382318881565433236705
113/25, 1.34771161946136364340007174245
453/100, 1.34821238712521041943033907876
227/50, 1.34871089238735810214644643857
91/20, 1.34920715067757655263157716136
114/25, 1.34970117728442528492482385977
457/100, 1.35019298735687923617478481918
229/50, 1.35068259590593193270389762943
459/100, 1.35117001780617642093927039380
23/5, 1.35165526779736432524101811405
461/100, 1.35213836048594338788143964430
231/50, 1.35261931034657383979428809893
463/100, 1.35309813172362394421949557870
116/25, 1.35357483883264504901170132851
93/20, 1.35404944576182647715757718208
233/50, 1.35452196647343057895410557126
467/100, 1.35499241480520826333458523394
117/25, 1.35546080447179531998823904400
469/100, 1.35592714906608983819997509905
47/10, 1.35639146206061102273627913904
471/100, 1.35685375680883970161863902936
118/25, 1.35731404654654081525463657147
473/100, 1.35777234439306817113627310934
237/50, 1.35822866335265174316267482303
19/4, 1.35868301631566778959756765250
119/25, 1.35913541605989205872839994466
477/100, 1.35958587525173634645136393683
239/50, 1.36003440644746866526252545603
479/100, 1.36048102209441727948757304988
24/5, 1.36092573453215885702915784845
481/100, 1.36136855599369098344928326069
241/50, 1.36180949860658927983264189925
483/100, 1.36224857439414936159316050018
121/25, 1.36268579527651387118832706851
97/20, 1.36312117307178481359221208400
243/50, 1.36355471949712141934657909507
487/100, 1.36398644616982375605827757163
122/25, 1.36441636460840230533843579153
489/100, 1.36484448623363371838308104337
49/10, 1.36527082236960295967400853292
491/100, 1.36569538424473204463134067285
123/25, 1.36611818299279557347364699016
493/100, 1.36653922965392326003615317970
247/50, 1.36695853517558965086091568958
99/20, 1.36737611041359122650337279987
124/25, 1.36779196613301107369593794001
497/100, 1.36820611300917131376984484831
249/50, 1.36861856162857346955989041388
499/100, 1.36902932248982694990168649241
5, 1.36943840600456582777619613942
501/100, 1.36984582249835408516039383423
251/50, 1.37025158221157949470458561419
503/100, 1.37065569530033630547501599115
126/25, 1.37105817183729689717366583611
101/20, 1.37145902181257256447442945188
253/50, 1.37185825513456359039499802609
507/100, 1.37225588163079876495564592668
127/25, 1.37265191104876450275861766739
509/100, 1.37304635305672371055387438665
51/10, 1.37343921724452455333753200468
511/100, 1.37383051312439926505738595320
128/25, 1.37422025013175314757447044665
513/100, 1.37460843762594389914966783341
257/50, 1.37499508489105141138901241451
103/20, 1.37538020113663817128959207855
129/25, 1.37576379549850040277893050808
517/100, 1.37614587703941007993354384342
259/50, 1.37652645474984794189614025152
519/100, 1.37690553754872763738482045193
26/5, 1.37728313428411112460081292158
521/100, 1.37765925373391545029292917978
261/50, 1.37803390460661102972626063745
523/100, 1.37840709554191154732888536467
131/25, 1.37877883511145559585275471110
21/4, 1.37914913181948016998274703594
263/50, 1.37951799410348612846038658008
527/100, 1.37988543033489573695522372437
132/25, 1.38025144881970240211666837523
529/100, 1.38061605779911270547148632922
53/10, 1.38097926545018084409654961721
531/100, 1.38134107988643558329213116976
133/25, 1.38170150915849982480742119703
533/100, 1.38206056125470289252640097802
267/50, 1.38241824410168563590813651600
107/20, 1.38277456556499844989036029742
134/25, 1.38312953344969230840831776545
537/100, 1.38348315550090290715170236863
269/50, 1.38383543940442800968053784903
539/100, 1.38418639278729808954554957279
27/5, 1.38453602321834035960937076785
541/100, 1.38488433820873627834133863280
271/50, 1.38523134521257262146014478305
543/100, 1.38557705162738620592472075135
136/25, 1.38592146479470235192397932542
109/20, 1.38626459200056716718992391786
273/50, 1.38660644047607373665571866911
547/100, 1.38694701739788229920012930788
137/25, 1.38728632988873449196185639456
549/100, 1.38762438501796174147125542591
11/2, 1.38796118980198787963234863872
551/100, 1.38829675120482606139446654359
138/25, 1.38863107613857005977990742661
553/100, 1.38896417146388001278127310702
277/50, 1.38929604399046269550924040795
111/20, 1.38962670047754638985807961110
139/25, 1.38995614763435042286186120959
557/100, 1.39028439212054944383863600105
279/50, 1.39061144054673250936257412115
559/100, 1.39093729947485704406475666290
28/5, 1.39126197541869774424168705533
561/100, 1.39158547484429049024629355167
281/50, 1.39190780417037133264890117410
563/100, 1.39222896976881061618504029518
141/25, 1.39254897796504230455271541027
113/20, 1.39286783503848856818357381205
283/50, 1.39318554722297969618998844505
567/100, 1.39350212070716939278310706649
142/25, 1.39381756163494551756513193975
569/100, 1.39413187610583632822219757328
57/10, 1.39444507017541228328193125149
571/100, 1.39475714985568346175184074488
143/25, 1.39506812111549265562080966055
573/100, 1.39537798988090419038593287230
287/50, 1.39568676203558852796043714461
23/4, 1.39599444342120270552525543156
144/25, 1.39630103983776666310671247209
577/100, 1.39660655704403551189549427228
289/50, 1.39691100075786779456737978165
579/100, 1.39721437665658978812387920623
29/5, 1.39751669037735589904072428023
581/100, 1.39781794751750519979387030937
291/50, 1.39811815363491415512608121963
583/100, 1.39841731424834558572206486067
146/25, 1.39871543483779391627629834205
117/20, 1.39901252084482675426492830319
293/50, 1.39930857767292284507124888067
587/100, 1.39960361068780644846305487079
147/25, 1.39989762521777818077944721020
589/100, 1.40019062655404236655424424702
59/10, 1.40048261995103094268284090424
591/100, 1.40077361062672395762897795055
148/25, 1.40106360376296670756725795983
593/100, 1.40135260450578355076619941869
297/50, 1.40164061796568844093498550510
119/20, 1.40192764921799221968467232508
149/25, 1.40221370330310670769130914233
597/100, 1.40249878522684563359402985089
299/50, 1.40278289996072243911554323771
599/100, 1.40306605244224499835542513882
6, 1.40334824757520728867804708560
601/100, 1.40362949022997805009671508071
301/50, 1.40390978524378646954349321908
603/100, 1.40418913742100492591010727683
151/25, 1.40446755153342883124912317849
121/20, 1.40474503232055360303613716428
303/50, 1.40502158448984880191286389672
607/100, 1.40529721271702946885763363201
152/25, 1.40557192164632469526378042926
609/100, 1.40584571589074345894759314611
61/10, 1.40611860003233775865578506266
611/100, 1.40639057862246307919769414992
153/25, 1.40666165618203621888953434072
613/100, 1.40693183720179051056686103116
307/50, 1.40720112614252846699687602848
123/20, 1.40746952743537188110416503741
154/25, 1.40773704548200941101182344941
617/100, 1.40800368465494167949457466677
309/50, 1.40826944929772391704131250606
619/100, 1.40853434372520617733140043943
31/5, 1.40879837222377115354193256915
621/100, 1.40906153905156962352190324011
311/50, 1.40932384843875355149374490959
623/100, 1.40958530458770687357287999708
156/25, 1.40984591167327399403169642065
25/4, 1.41010567384298601887560465649
313/50, 1.41036459521728475294547443785
627/100, 1.41062267988974448641269134339
157/25, 1.41087993192729159619022888604
629/100, 1.41113635537042198744541330851
63/10, 1.41139195423341640006738072802
631/100, 1.41164673250455360461450572776
158/25, 1.41190069414632151194423467885
633/100, 1.41215384309562622040970521583
317/50, 1.41240618326399902419419607577
127/20, 1.41265771853780140604575109077
159/25, 1.41290845277842803737018105602
637/100, 1.41315838982250780834099243209
319/50, 1.41340753348210291038954869347
639/100, 1.41365588754490599314786625343
32/5, 1.41390345577443541762981123454
641/100, 1.41415024191022862715402615344
321/50, 1.41439624966803365723360834490
643/100, 1.41464148273999880538331739188
161/25, 1.41488594479486048152484089327
129/20, 1.41512963947812925940433171089
323/50, 1.41537257041227414917398167519
647/100, 1.41561474119690511103075401745
162/25, 1.41585615540895382955049807243
649/100, 1.41609681660285276810445469294
13/2, 1.41633672831071252249757004257
651/100, 1.41657589404249749272401074328
163/25, 1.41681431728619989149475754092
653/100, 1.41705200150801210795509151739
327/50, 1.41728895015249744477612121686
131/20, 1.41752516664275924657417663401
164/25, 1.41776065438060843738486355747
657/100, 1.41799541674672948469477692935
329/50, 1.41822945710084480731326325016
659/100, 1.41846277878187764414914910373
33/5, 1.41869538510811340074296596020
661/100, 1.41892727937735949019385176429
331/50, 1.41915846486710368491194950685
663/100, 1.41938894483467099542170492129
166/25, 1.41961872251737909223894337216
133/20, 1.41984780113269228664493443962
333/50, 1.42007618387837408598378697092
667/100, 1.42030387393263833891541355672
167/25, 1.42053087445429898586491834427
669/100, 1.42075718858291842972055341234
67/10, 1.42098281943895454164631492362
671/100, 1.42120777012390631669176997646
168/25, 1.42143204372045819370077823524
673/100, 1.42165564329262305384235945615
337/50, 1.42187857188588391191102004497
27/4, 1.42210083252733431437035055155
169/25, 1.42232242822581745794260394146
677/100, 1.42254336197206404237822464338
339/50, 1.42276363673882887087288443663
679/100, 1.42298325548102621143545751498
34/5, 1.42320222113586393234849844453
681/100, 1.42342053662297642470313872068
341/50, 1.42363820484455632483285630099
683/100, 1.42385522868548504931526449495
171/25, 1.42407161101346215505787914073
137/20, 1.42428735467913353683272385069
343/50, 1.42450246251621847447559056486
687/100, 1.42471693734163554181875554458
172/25, 1.42493078195562738928092861932
689/100, 1.42514399914188441189515583150
69/10, 1.42535659166766731441427297210
691/100, 1.42556856228392858499429072055
173/25, 1.42577991372543288881875253926
693/100, 1.42599064871087639289161594034
347/50, 1.42620076994300503309253852445
139/20, 1.42641028010873173445657502877
174/25, 1.42661918187925259551018370389
697/100, 1.42682747791016204736707329996
349/50, 1.42703517084156699816076984660
699/100, 1.42724226329819997326581974959
7, 1.42744875788953126163624741148
701/100, 1.42765465720988007846822693167
351/50, 1.42785996383852475427388417926
703/100, 1.42806468033981196033469377869
176/25, 1.42826880926326498038605181211
141/20, 1.42847235314369103826926621617
353/50, 1.42867531450128769117339019940
707/100, 1.42887769584174829797700716611
177/25, 1.42907949965636657208923660007
709/100, 1.42928072842214022807984749007
71/10, 1.42948138460187373128041787176
711/100, 1.42968147064428015943194496228
178/25, 1.42988098898408218534916955855
713/100, 1.43007994204211218946811057194
357/50, 1.43027833222541151104089082075
143/20, 1.43047616192732884664085385712
179/25, 1.43067343352761780454120434079
717/100, 1.43087014939253362343193227158
359/50, 1.43106631187492906384258553988
719/100, 1.43126192331434948054251733582
36/5, 1.43145698603712708409553684818
721/100, 1.43165150235647439965241554886
361/50, 1.43184547457257693097242964461
723/100, 1.43203890497268503757403471043
181/25, 1.43223179583120503282485409577
29/4, 1.43242414940978951069240168284
363/50, 1.43261596795742690878933550533
727/100, 1.43280725371053031526053539557
182/25, 1.43299800889302552697389926195
729/100, 1.43318823571643836639244310163
73/10, 1.43337793637998126442205396528
731/100, 1.43356711307063911644706759419
183/25, 1.43375576796325441868470836492
733/100, 1.43394390322061169190932375594
367/50, 1.43413152099352119951825427852
147/20, 1.43431862342090196683308839864
184/25, 1.43450521262986410845294634875
737/100, 1.43469129073579047040030303761
369/50, 1.43487685984241759372468487525
739/100, 1.43506192204191600615534481427
37/5, 1.43524647941496984832072104779
741/100, 1.43543053403085584098010458566
371/50, 1.43561408794752159964146653769
743/100, 1.43579714321166330286881475006
186/25, 1.43597970185880272051274904338
149/20, 1.43616176591336360802905245544
373/50, 1.43634333738874747298218055275
747/100, 1.43652441828740871976338017921
187/25, 1.43670501060092917848687127783
749/100, 1.43688511631009202396204914862
15/2, 1.43706473738495509057499836448
751/100, 1.43724387578492358884874240145
188/25, 1.43742253345882222938857386366
753/100, 1.43760071234496675985650817524
377/50, 1.43777841437123492055736811669
151/20, 1.43795564145513682415822710463
189/25, 1.43813239550388476500290531498
757/100, 1.43830867841446246342391444888
379/50, 1.43848449207369375039567411013
759/100, 1.43865983835831069781496552366
38/5, 1.43883471913502119963743694917
761/100, 1.43900913626057600904252004650
381/50, 1.43918309158183523674334819127
763/100, 1.43935658693583431550317701954
191/25, 1.43952962414984943586538514014
153/20, 1.43970220504146245805036996646
383/50, 1.43987433141862530491954109774
767/100, 1.44004600507972384085414286462
192/25, 1.44021722781364124134479991640
769/100, 1.44038800139982085803646656915
77/10, 1.44055832760832858392286367866
771/100, 1.44072820819991472333449780079
193/25, 1.44089764492607537131496822372
773/100, 1.44106663952911330693147009382
387/50, 1.44123519374219840501718841688
31/4, 1.44140330928942757079564042446
194/25, 1.44157098788588420178995498891
777/100, 1.44173823123769718137356990167
389/50, 1.44190504104209940827287345849
779/100, 1.44207141898748586628690859171
39/5, 1.44223736675347123844438853195
781/100, 1.44240288601094706977393554916
391/50, 1.44256797842213848281964170431
783/100, 1.44273264564066044999075582287
196/25, 1.44289688931157362679151726981
157/20, 1.44306071107143974993487784768
393/50, 1.44322411254837660430207163960
787/100, 1.44338709536211256266870235577
197/25, 1.44354966112404070207721228985
789/100, 1.44371181143727250069527001503
79/10, 1.44387354789669111895975920725
791/100, 1.44403487208900426876666232039
198/25, 1.44419578559279667442820419185
793/100, 1.44435628997858212908014604753
397/50, 1.44451638680885515018409391157
159/20, 1.44467607763814223773210129975
199/25, 1.44483536401305273872369856089
797/100, 1.44499424747232932144876468458
399/50, 1.44515272954689806307336625329
799/100, 1.44531081175991815398981699709
8, 1.44546849562683122235675470528
801/100, 1.44562578265541028221998472991
401/50, 1.44578267434580830857019572909
803/100, 1.44593917219060644265940846178
201/25, 1.44609527767486183086416725500
161/20, 1.44625099227615510035002118399
403/50, 1.44640631746463747475876307232
807/100, 1.44656125470307753310719423820
202/25, 1.44671580544690761505385666071
809/100, 1.44686997114426987565821715765
81/10, 1.44702375323606199272519556455
811/100, 1.44717715315598252979669615716
203/25, 1.44733017233057595782092410707
813/100, 1.44748281217927733849974210507
407/50, 1.44763507411445667228414199576
163/20, 1.44778695954146291395806796687
204/25, 1.44793846985866765872132721698
817/100, 1.44808960645750850165315683336
409/50, 1.44824037072253207340917765541
819/100, 1.44839076403143675497595304392
41/5, 1.44854078775511507427917864405
821/100, 1.44869044325769578741365440058
411/50, 1.44883973189658564723562829078
823/100, 1.44898865502251086203084857283
206/25, 1.44913721397955824694471394907
33/4, 1.44928541010521607083426510840
413/50, 1.44943324473041460117541289024
827/100, 1.44958071917956634963274410165
207/25, 1.44972783477060602087348217085
829/100, 1.44987459281503016718170273363
83/10, 1.45002099461793655140371037351
831/100, 1.45016704147806322073056856997
208/25, 1.45031273468782729379913699592
833/100, 1.45045807553336346356860523932
417/50, 1.45060306529456221840541644240
167/20, 1.45074770524510778378564493922
209/25, 1.45089199665251578700032545838
837/100, 1.45103594077817064722592461522
419/50, 1.45117953887736269329909506372
839/100, 1.45132279219932501151205567355
42/5, 1.45146570198727002572239434331
841/100, 1.45160826947842581204879050177
421/50, 1.45175049590407215040209897005
843/100, 1.45189238248957631507942268436
211/25, 1.45203393045442860662722587680
169/20, 1.45217514101227762715819878612
423/50, 1.45231601537096530128547696384
847/100, 1.45245655473256164481693993684
212/25, 1.45259676029339928333166260336
849/100, 1.45273663324410772274016553287
17/2, 1.45287617476964737390990460417
851/100, 1.45301538604934333341745347862
213/25, 1.45315426825691892246906163227
853/100, 1.45329282256052898601171346018
427/50, 1.45343105012279295403746775292
171/20, 1.45356895210082766706471909641
214/25, 1.45370652964627996776109096378
857/100, 1.45384378390535906065394198560
429/50, 1.45398071601886864185593966948
859/100, 1.45411732712223880071482729081
43/5, 1.45425361834555769527837742305
861/100, 1.45438959081360300344758728103
431/50, 1.45452524564587315167342440486
863/100, 1.45466058395661832303487393957
216/25, 1.45479560685487124651866861683
173/20, 1.45493031544447776930389730327
433/50, 1.45506471082412721383768545446
867/100, 1.45519879408738252147131884429
217/25, 1.45533256632271018440953839341
869/100, 1.45546602861350996770926669226
87/10, 1.45559918203814442304773382687
871/100, 1.45573202766996819596384931815
218/25, 1.45586456657735712826071635342
873/100, 1.45599679982373715724140202497
437/50, 1.45612872846761301343446102233
35/4, 1.45626035356259671845025820566
219/25, 1.45639167615743588459384579616
877/100, 1.45652269729604181784502165900
439/50, 1.45665341801751742580122445180
879/100, 1.45678383935618493216410742001
44/5, 1.45691396234161339933597351410
881/100, 1.45704378799864606067774848191
441/50, 1.45717331734742746396581387353
883/100, 1.45730255140343042757081673237
221/25, 1.45743149117748281086751539879
177/20, 1.45756013767579410037080961415
443/50, 1.45768849189998181307933629161
887/100, 1.45781655484709771849438824971
222/25, 1.45794432750965388076843023873
889/100, 1.45807181087564852242414310248
89/10, 1.45819900592859171107172130481
891/100, 1.45832591364753087053907972704
223/25, 1.45845253500707611781669104347
893/100, 1.45857887097742542720597356464
447/50, 1.45870492252438962304747967526
179/20, 1.45883069060941720239259538065
224/25, 1.45895617618961898897005052477
897/100, 1.45908138021779261978625548654
449/50, 1.45920630364244686568632214913
899/100, 1.45933094740782578719059323751
9, 1.45945531245393272690959331963
901/100, 1.45957939971655413982852546949
451/50, 1.45970321012728326274076841836
903/100, 1.45982674461354362409827861113
226/25, 1.45995000409861239553536859549
181/20, 1.46007298950164358631101627303
453/50, 1.46019570173769108190365742380
907/100, 1.46031814171773152798132528390
227/25, 1.46044031034868706095902453109
909/100, 1.46056220853344788634436155278
91/10, 1.46068383717089470606169708791
911/100, 1.46080519715592099593444001664
228/25, 1.46092628937945513449456100321
913/100, 1.46104711472848238427797067679
457/50, 1.46116767408606672675407787508
183/20, 1.46128796833137255202761800478
229/25, 1.46140799833968620444071863387
917/100, 1.46152776498243738519314787899
459/50, 1.46164726912722041308876985895
919/100, 1.46176651163781534450640933598
46/5, 1.46188549337420895368360355853
921/100, 1.46200421519261557439209216466
461/50, 1.46212267794549780407436472849
923/100, 1.46224088248158707150114907185
231/25, 1.46235882964590406900038076988
37/4, 1.46247652027977905029894431746
463/50, 1.46259395522087199500931816853
927/100, 1.46271113530319264078418830231
232/25, 1.46282806135712038415311710946
929/100, 1.46294473420942405104646524140
93/10, 1.46306115468328153800296265184
931/100, 1.46317732359829932504861041855
233/25, 1.46329324177053186122596611385
933/100, 1.46340891001250082374432155452
467/50, 1.46352432913321425171282177711
187/20, 1.46363949993818555541019713590
234/25, 1.46375442322945240203648560108
937/100, 1.46386909980559547888390874951
469/50, 1.46398353046175713485593170431
939/100, 1.46409771598965990125548351843
47/5, 1.46421165717762489275533934829
941/100, 1.46432535481059008945576837257
471/50, 1.46443880967012850092673093543
943/100, 1.46455202253446621312416400000
236/25, 1.46466499417850031906222486356
189/20, 1.46477772537381673411576839730
473/50, 1.46489021688870789681981202694
947/100, 1.46500246948819035602529447262
237/25, 1.46511448393402224526305813147
949/100, 1.46522626098472064516068013969
19/2, 1.46533780139557883474954282667
951/100, 1.46544910591868343249236971367
238/25, 1.46556017530293142785435766714
953/100, 1.46567101029404710423400855106
477/50, 1.46578161163459885406280400443
191/20, 1.46589198006401588687597407639
239/25, 1.46600211631860483114978366922
957/100, 1.46611202113156623069399936392
479/50, 1.46622169523301093638150253630
959/100, 1.46633113934997639399038202645
48/5, 1.46644035420644282892727031903
961/100, 1.46654934052334932859418055411
481/50, 1.46665809901860982315465705388
963/100, 1.46676663040712896544866876155
241/25, 1.46687493540081791079935239653
193/20, 1.46698301470860999744844959265
483/50, 1.46709086903647632835107916919
967/100, 1.46719849908744125505434136111
242/25, 1.46730590556159776437816468569
969/100, 1.46741308915612276861077753465
97/10, 1.46752005056529229992521494935
971/100, 1.46762679048049660971735576274
243/25, 1.46773330959025517356012578395
973/100, 1.46783960858023160246269837630
487/50, 1.46794568813324846111777405702
39/4, 1.46805154892930199381432505873
244/25, 1.46815719164557675868754857137
977/100, 1.46826261695646017097218307286
489/50, 1.46836782553355695591980520421
979/100, 1.46847281804570351203523950557
49/5, 1.46857759515898218528177946391
981/100, 1.46868215753673545489953519876
491/50, 1.46878650583958003147589020173
983/100, 1.46889064072542086790176632831
246/25, 1.46899456284946508384216220192
197/20, 1.46909827286423580434424482026
493/50, 1.46920177141958591320113695140
987/100, 1.46930505916271172168445337212
247/25, 1.46940813673816655325359664357
989/100, 1.46951100478787424484482745258
99/10, 1.46961366395114256533817508975
991/100, 1.46971611486467655179534991334
248/25, 1.46981835816259176405696119061
993/100, 1.46992039447642745828253005071
497/50, 1.47002222443515968001201796740
199/20, 1.47012384866521427732286575966
249/25, 1.47022526779047983465185610715
997/100, 1.47032648243232052784647357872
499/50, 1.47042749320958890100583972944
999/100, 1.47052830073863856566674649882
10, 1.47062890563333682288579851219
];

refi=[1/100, 5.29829236561048459070166683494
1/50, 4.60507017098475715945057255151
3/100, 4.19948000190443579622341357041
1/25, 3.91162276521458846692162328466
1/20, 3.68825386736129666761816757203
3/50, 3.50565667988422588025418229706
7/100, 3.35117996040789760273439678213
2/25, 3.21727197115725787625531558538
9/100, 3.09906161044710277784374762698
1/10, 2.99322284612638089791266771377
11/100, 2.89738327480424948276193878475
3/25, 2.80979111975496533462007736351
13/100, 2.72911597893018568126604939796
7/50, 2.65432362465297741478973650364
3/20, 2.58459410234233415821925890050
4/25, 2.51926631553887363826303725428
17/100, 2.45779944003901340506078299866
9/50, 2.39974538361499823644852730723
19/100, 2.34472870153684957251323974326
1/5, 2.29243166956117768780078731135
21/100, 2.24258300237616220154939553225
11/50, 2.19494919863478206043226207395
23/100, 2.14932781118942637596508429965
6/25, 2.10554215036335439142012591298
1/4, 2.06343706889556054672728117262
13/50, 2.02287557376235110283740345419
27/100, 1.98373607745613930811625711237
7/25, 1.94591014905531330510535274344
29/100, 1.90930065975316177401015730658
3/10, 1.87382024252741442497699798521
31/100, 1.83939000407819337028263020722
8/25, 1.80593844091928647006641838951
33/100, 1.77340052187533955139583017874
17/50, 1.74171690712716563067877135819
7/20, 1.71083328000582707588477616285
9/25, 1.68069977242800356446350924941
37/100, 1.65127046852757629745884658139
19/50, 1.62250297391851330756311085840
39/100, 1.59435804030495178726114049785
2/5, 1.56679923697241107866405686258
41/100, 1.53979266215215038074751273692
21/50, 1.51330668842682145330645792638
43/100, 1.48731173729939019203647098001
11/25, 1.46178007882471027525728233405
9/20, 1.43668565283968581301955881777
23/50, 1.41200390885137437564526498968
47/100, 1.38771166207438258401540757590
12/25, 1.36378696346661126405387716445
49/100, 1.34020898190936490448306031490
1/2, 1.31695789692481670862504634731
51/100, 1.29401480052939600058155955654
13/25, 1.27136160699268928351886652038
53/100, 1.24898096941338899906110392882
27/50, 1.22685620214104048789228913607
11/20, 1.20497120816827395444888668991
14/25, 1.18331041069555615253048481237
57/100, 1.16185868813130886776721007431
29/50, 1.14060131183601502063247998078
59/100, 1.11952388595066476264728576887
3/5, 1.09861228866810969139524523692
61/100, 1.07785261431065644847454560608
31/50, 1.05723111556812390569654548896
63/100, 1.03673414522666822260760263462
16/25, 1.01634809667840380541358127167
13/20, .996059342442956845168396903140
33/50, .975854169851443251736244862718
67/100, .955718712936716064887849943059
17/25, .935638879435400896213162195261
69/100, .915600271629681609942735517730
7/10, .895588099529975822409629914611
71/100, .875587084610170546164345374574
18/25, .855581351937042513752362044356
73/100, .835554308060675306939677635337
37/50, .815488501420204493923772430531
3/4, .795365461223905630527890933148
19/25, .775165509721843556569115519524
77/100, .754867541415153786134169813017
39/50, .734448760913746883587252055267
79/100, .713884368684234666706672779156
4/5, .693147180559945309417232121458
81/100, .672207162226005378963325188137
41/50, .651030853357460935404294320845
83/100, .629580646774159320716981583616
21/25, .607813874464340654560093316492
17/20, .585681632340658005379787325682
43/50, .563127245371378954357318090712
87/100, .540084227905952794733162214118
22/25, .516473519435056575717742231141
89/100, .492199653442518188195136466963
9/10, .467145308103262018128381491666
91/100, .441163316286036491687456555939
23/25, .414064518876478400604077924130
93/100, .385598471143035152471210132926
47/50, .355421083214933030424847843757
19/20, .323036439271803275872468123572
24/25, .287682072451780927439219005991
97/100, .248071421618594871743278727878
49/50, .201688487798836053004338678585
99/100, .142014440746077068745796794296
1, 0.
];


     x=ref(:,1);
	 y = asec(x);
	 e=ref(:,2);
     assert_checkalmostequal(y,e,10*%eps,[],"element");
	 //
     x=-ref(:,1);
	 y = asec(x);
	 e=pi-ref(:,2);
     assert_checkalmostequal(y,e,10*%eps,[],"element");
     
     
     x=refi(:,1);
	 y = asec(x);
	 e = imult(refi(:,2));
     assert_checkalmostequal(y,e,20*%eps,[],"element");
	//
     x=-refi(:,1);
	 y = asec(x);
	 e = pi-imult(refi(:,2));
     assert_checkalmostequal(y,e,20*%eps,[],"element");
 
     assert_checkequal(asec(0),imult(Inf));
     assert_checkalmostequal(asec(Inf),pi/2,%eps,[],"element");

     assert_checkequal(asec(NaN),%nan);

     assert_checkequal(asec([]),[]);

