# Cargo Reference

The reference covers the details of various areas of Cargo.

* [The Manifest Format](manifest.md)
    * [Cargo Targets](cargo-targets.md)
    * [Rust version](rust-version.md)
* [Workspaces](workspaces.md)
* [Specifying Dependencies](specifying-dependencies.md)
    * [Overriding Dependencies](overriding-dependencies.md)
    * [Source Replacement](source-replacement.md)
    * [Dependency Resolution](resolver.md)
* [Features](features.md)
    * [Features Examples](features-examples.md)
* [Profiles](profiles.md)
* [Configuration](config.md)
* [Environment Variables](environment-variables.md)
* [Build Scripts](build-scripts.md)
    * [Build Script Examples](build-script-examples.md)
* [Build Cache](build-cache.md)
* [Package ID Specifications](pkgid-spec.md)
* [External Tools](external-tools.md)
* [Registries](registries.md)
    * [Registry Authentication](registry-authentication.md)
        * [Credential Provider Protocol](credential-provider-protocol.md)
    * [Running a Registry](running-a-registry.md)
        * [Registry Index](registry-index.md)
        * [Registry Web API](registry-web-api.md)
* [SemVer Compatibility](semver.md)
* [Future incompat report](future-incompat-report.md)
* [Reporting build timings](timings.md)
* [Lints](lints.md)
* [Unstable Features](unstable.md)
