---
name: Bug report
about: Create a report to help us improve
title: "[Bug]: "
labels: ["bug", "triage"]

---

### Describe the bug
A clear and concise description of what the bug or problem is.

### To Reproduce
Precise version of rocBLAS installed or rocBLAS commit hash if building from source.
Steps to reproduce the behavior:
1. Install '...' version '...'
2. Run '...' with data '...'
3. See error on logfile '...'

### Expected behavior
A clear and concise description of what you expected to happen.

### Log-files
Add **full** logfiles to help explain your problem.

### Environment

| Hardware | description |
|-----|-----|
| CPU | device name |
| GPU | device name |

The above hardware Table information can be generated by command:
```
rocminfo | grep Marketing
```

| Software | version |
|-----|-----|
| rocm-core | v0.0 |
| rocblas | v0.0 |

The above software Table information can be queried with:
```
Ubuntu/Debian:
dpkg -s rocm-core | grep Version
dpkg -s rocblas | grep Version
Centos/RHEL:
rpm -qa | grep rocm-core
rpm -qa | grep rocblas
SLES:
zypper se -s | grep rocm-core
zypper se -s | grep rocblas
```

Make sure that ROCm is correctly installed and to capture detailed environment information run the following command:
```
printf '=== environment\n' > environment.txt &&
printf '\n\n=== date\n' >> environment.txt && date >> environment.txt &&
printf '\n\n=== Linux Kernel\n' >> environment.txt && uname -a  >> environment.txt &&
printf '\n\n=== rocm-smi' >> environment.txt && rocm-smi  >> environment.txt &&
printf '\n\n' >> environment.txt && hipconfig  >> environment.txt &&
printf '\n\n=== rocminfo\n' >> environment.txt && rocminfo  >> environment.txt &&
printf '\n\n=== lspci VGA\n' >> environment.txt && lspci | grep -i vga >> environment.txt
```

Attach `environment.txt`


### Additional context
Add any other context about the problem here.
