#!/bin/sh

#
# Rhonabwy
#
# Create certificates
#
# Public domain, no copyright. Use at your own risk.
#

DEST=../test/cert
RET=0

# clean old certs
rm -f $DEST/root* $DEST/user* $DEST/fullchain*

echo >> $DEST/certtool.log
echo Generate Rhonabwy test certificates >> $DEST/certtool.log
echo >> $DEST/certtool.log

# CA root
certtool --generate-privkey --outfile $DEST/root1.key --sec-param High 2>>$DEST/certtool.log
STATUS=$?
if [ $STATUS -eq 0 ]; then
  printf "root1.key          \033[0;32mOK\033[0m\n"
else
  printf "root1.key          \033[0;31mError\033[0m\n"
  RET=$STATUS
fi
certtool --generate-self-signed --load-privkey $DEST/root1.key --outfile $DEST/root1.crt --template $DEST/template-ca.cfg 2>>$DEST/certtool.log
STATUS=$?
if [ $STATUS -eq 0 ]; then
  printf "root1.crt          \033[0;32mOK\033[0m\n"
else
  printf "root1.crt          \033[0;31mError\033[0m\n"
  RET=$STATUS
fi

# user 1
certtool --generate-privkey --outfile $DEST/user1.key --sec-param High 2>>$DEST/certtool.log
STATUS=$?
if [ $STATUS -eq 0 ]; then
  printf "user1.key          \033[0;32mOK\033[0m\n"
else
  printf "user1.key          \033[0;31mError\033[0m\n"
  RET=$STATUS
fi
certtool --generate-certificate --load-privkey $DEST/user1.key --load-ca-certificate $DEST/root1.crt --load-ca-privkey $DEST/root1.key --outfile $DEST/user1.crt --template $DEST/template-user.cfg 2>>$DEST/certtool.log
STATUS=$?
if [ $STATUS -eq 0 ]; then
  printf "user1.crt          \033[0;32mOK\033[0m\n"
else
  printf "user1.crt          \033[0;31mError\033[0m\n"
  RET=$STATUS
fi

# CA root 2
certtool --generate-privkey --outfile $DEST/root2.key --sec-param High 2>>$DEST/certtool.log
STATUS=$?
if [ $STATUS -eq 0 ]; then
  printf "root2.key          \033[0;32mOK\033[0m\n"
else
  printf "root2.key          \033[0;31mError\033[0m\n"
  RET=$STATUS
fi
certtool --generate-self-signed --load-privkey $DEST/root2.key --outfile $DEST/root2.crt --template $DEST/template-ca2.cfg 2>>$DEST/certtool.log
STATUS=$?
if [ $STATUS -eq 0 ]; then
  printf "root2.crt          \033[0;32mOK\033[0m\n"
else
  printf "root2.crt          \033[0;31mError\033[0m\n"
  RET=$STATUS
fi

# user 2
certtool --generate-privkey --outfile $DEST/user2.key --sec-param High 2>>$DEST/certtool.log
STATUS=$?
if [ $STATUS -eq 0 ]; then
  printf "user2.key          \033[0;32mOK\033[0m\n"
else
  printf "user2.key          \033[0;31mError\033[0m\n"
  RET=$STATUS
fi
certtool --generate-certificate --load-privkey $DEST/user2.key --load-ca-certificate $DEST/root2.crt --load-ca-privkey $DEST/root2.key --outfile $DEST/user2.crt --template $DEST/template-user.cfg 2>>$DEST/certtool.log
STATUS=$?
if [ $STATUS -eq 0 ]; then
  printf "user2.crt          \033[0;32mOK\033[0m\n"
else
  printf "user2.crt          \033[0;31mError\033[0m\n"
  RET=$STATUS
fi

# create chain files
cat $DEST/user1.crt $DEST/root1.crt > $DEST/fullchain1.crt
cat $DEST/user2.crt $DEST/root2.crt > $DEST/fullchain2.crt
cat $DEST/user2.crt $DEST/root1.crt > $DEST/fullchain-error.crt
