
#line 1 "lexer.rl"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <math.h>

#include "parse.h"
#include "parser.h"
#include "../query_node.h"
#include "../stopwords.h"

/* forward declarations of stuff generated by lemon */
void RSQuery_Parse(void *yyp, int yymajor, QueryToken yyminor, QueryParseCtx *ctx);
void *RSQuery_ParseAlloc(void *(*mallocProc)(size_t));
void RSQuery_ParseFree(void *p, void (*freeProc)(void *));


#line 231 "lexer.rl"



#line 25 "lexer.c"
static const char _query_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	10, 1, 11, 1, 12, 1, 13, 1, 
	14, 1, 15, 1, 16, 1, 17, 1, 
	18, 1, 19, 1, 20, 1, 21, 1, 
	22, 1, 23, 1, 24, 1, 25, 1, 
	26, 1, 27, 1, 28, 1, 29, 1, 
	30, 1, 31, 1, 32, 1, 33, 1, 
	34, 2, 2, 3, 2, 2, 4, 2, 
	2, 5, 2, 2, 6, 2, 2, 7, 
	2, 2, 8, 2, 2, 9
};

static const unsigned char _query_key_offsets[] = {
	0, 10, 20, 21, 22, 24, 34, 72, 
	83, 93, 94, 97, 100, 102, 116, 117, 
	127, 137, 149
};

static const char _query_trans_keys[] = {
	9, 13, 32, 47, 58, 64, 91, 96, 
	123, 126, 9, 13, 32, 47, 58, 64, 
	91, 96, 123, 126, 110, 102, 48, 57, 
	9, 13, 32, 47, 58, 64, 91, 96, 
	123, 126, 32, 34, 36, 37, 39, 40, 
	41, 42, 43, 45, 58, 59, 61, 64, 
	91, 92, 93, 95, 105, 123, 124, 125, 
	126, 127, 0, 8, 9, 13, 14, 31, 
	33, 47, 48, 57, 60, 63, 94, 96, 
	42, 92, 96, 0, 47, 58, 64, 91, 
	94, 123, 127, 92, 96, 0, 47, 58, 
	64, 91, 94, 123, 127, 105, 105, 48, 
	57, 46, 48, 57, 48, 57, 42, 46, 
	92, 96, 0, 47, 48, 57, 58, 64, 
	91, 94, 123, 127, 62, 92, 96, 0, 
	47, 58, 64, 91, 94, 123, 127, 9, 
	13, 32, 47, 58, 64, 91, 96, 123, 
	126, 42, 92, 96, 110, 0, 47, 58, 
	64, 91, 94, 123, 127, 42, 92, 96, 
	102, 0, 47, 58, 64, 91, 94, 123, 
	127, 0
};

static const char _query_single_lengths[] = {
	0, 0, 1, 1, 0, 0, 24, 3, 
	2, 1, 1, 1, 0, 4, 1, 2, 
	0, 4, 4
};

static const char _query_range_lengths[] = {
	5, 5, 0, 0, 1, 5, 7, 4, 
	4, 0, 1, 1, 1, 5, 0, 4, 
	5, 4, 4
};

static const unsigned char _query_index_offsets[] = {
	0, 6, 12, 14, 16, 18, 24, 56, 
	64, 71, 73, 76, 79, 81, 91, 93, 
	100, 106, 115
};

static const char _query_indicies[] = {
	1, 1, 1, 1, 1, 0, 2, 2, 
	2, 2, 2, 0, 3, 0, 4, 0, 
	6, 5, 7, 7, 7, 7, 7, 0, 
	9, 11, 12, 13, 14, 15, 16, 17, 
	14, 18, 20, 21, 22, 23, 24, 25, 
	26, 27, 28, 29, 30, 31, 32, 8, 
	8, 9, 8, 10, 19, 10, 10, 1, 
	33, 34, 0, 0, 0, 0, 0, 1, 
	35, 0, 0, 0, 0, 0, 2, 37, 
	36, 37, 39, 38, 41, 39, 40, 6, 
	40, 33, 41, 34, 40, 40, 19, 40, 
	40, 40, 1, 42, 36, 43, 0, 0, 
	0, 0, 0, 7, 1, 1, 1, 1, 
	1, 36, 33, 34, 44, 45, 44, 44, 
	44, 44, 1, 33, 34, 44, 46, 44, 
	44, 44, 44, 1, 0
};

static const char _query_trans_targs[] = {
	6, 7, 8, 3, 6, 6, 12, 15, 
	6, 6, 6, 6, 8, 6, 9, 6, 
	6, 6, 10, 13, 6, 6, 14, 15, 
	6, 16, 6, 7, 17, 6, 6, 6, 
	6, 6, 0, 1, 6, 2, 6, 11, 
	6, 4, 6, 5, 6, 18, 7
};

static const char _query_trans_actions[] = {
	55, 75, 63, 0, 9, 53, 0, 60, 
	41, 37, 39, 11, 72, 31, 72, 15, 
	17, 29, 69, 57, 23, 25, 0, 72, 
	33, 0, 35, 72, 75, 19, 13, 21, 
	27, 43, 0, 0, 49, 0, 47, 5, 
	45, 0, 7, 0, 51, 75, 66
};

static const char _query_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const char _query_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 3, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const unsigned char _query_eof_trans[] = {
	1, 1, 1, 1, 6, 1, 0, 1, 
	1, 37, 39, 41, 41, 41, 37, 1, 
	37, 45, 45
};

static const int query_start = 6;
static const int query_first_final = 6;
static const int query_error = -1;

static const int query_en_main = 6;


#line 234 "lexer.rl"



QueryNode *Query_Parse(QueryParseCtx *q, char **err) {
  void *pParser = RSQuery_ParseAlloc(malloc);

  
  int cs, act;
  const char* ts = q->raw;
  const char* te = q->raw + q->len;
  
#line 161 "lexer.c"
	{
	cs = query_start;
	ts = 0;
	te = 0;
	act = 0;
	}

#line 245 "lexer.rl"
  QueryToken tok = {.len = 0, .pos = 0, .s = 0};
  
  //parseCtx ctx = {.root = NULL, .ok = 1, .errorMsg = NULL, .q = q};
  const char* p = q->raw;
  const char* pe = q->raw + q->len;
  const char* eof = pe;
  
  
#line 178 "lexer.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
_resume:
	_acts = _query_actions + _query_from_state_actions[cs];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 ) {
		switch ( *_acts++ ) {
	case 1:
#line 1 "NONE"
	{ts = p;}
	break;
#line 197 "lexer.c"
		}
	}

	_keys = _query_trans_keys + _query_key_offsets[cs];
	_trans = _query_index_offsets[cs];

	_klen = _query_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _query_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _query_indicies[_trans];
_eof_trans:
	cs = _query_trans_targs[_trans];

	if ( _query_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _query_actions + _query_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 2:
#line 1 "NONE"
	{te = p+1;}
	break;
	case 3:
#line 48 "lexer.rl"
	{act = 1;}
	break;
	case 4:
#line 60 "lexer.rl"
	{act = 2;}
	break;
	case 5:
#line 69 "lexer.rl"
	{act = 3;}
	break;
	case 6:
#line 87 "lexer.rl"
	{act = 5;}
	break;
	case 7:
#line 156 "lexer.rl"
	{act = 14;}
	break;
	case 8:
#line 199 "lexer.rl"
	{act = 21;}
	break;
	case 9:
#line 202 "lexer.rl"
	{act = 23;}
	break;
	case 10:
#line 78 "lexer.rl"
	{te = p+1;{
    tok.pos = ts-q->raw;
    tok.len = te - ts;
    tok.s = ts+1;
    RSQuery_Parse(pParser, ARROW, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 11:
#line 87 "lexer.rl"
	{te = p+1;{ 
    tok.pos = ts-q->raw;
    tok.s = ts;
    tok.len = te-ts;
    tok.numval = *ts == '-' ? -INFINITY : INFINITY;
    RSQuery_Parse(pParser, NUMBER, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 12:
#line 98 "lexer.rl"
	{te = p+1;{
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, QUOTE, tok, q);  
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 13:
#line 105 "lexer.rl"
	{te = p+1;{ 
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, OR, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 14:
#line 112 "lexer.rl"
	{te = p+1;{ 
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, LP, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 15:
#line 120 "lexer.rl"
	{te = p+1;{ 
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, RP, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 16:
#line 127 "lexer.rl"
	{te = p+1;{ 
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, LB, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 17:
#line 134 "lexer.rl"
	{te = p+1;{ 
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, RB, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 18:
#line 141 "lexer.rl"
	{te = p+1;{ 
     tok.pos = ts-q->raw;
     RSQuery_Parse(pParser, COLON, tok, q);
     if (!q->ok) {
      {p++; goto _out; }
    }
   }}
	break;
	case 19:
#line 148 "lexer.rl"
	{te = p+1;{ 
     tok.pos = ts-q->raw;
     RSQuery_Parse(pParser, SEMICOLON, tok, q);
     if (!q->ok) {
      {p++; goto _out; }
    }
   }}
	break;
	case 20:
#line 163 "lexer.rl"
	{te = p+1;{ 
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, TILDE, tok, q);  
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 21:
#line 170 "lexer.rl"
	{te = p+1;{
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, STAR, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 22:
#line 177 "lexer.rl"
	{te = p+1;{
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, PERCENT, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 23:
#line 184 "lexer.rl"
	{te = p+1;{ 
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, LSQB, tok, q);  
    if (!q->ok) {
      {p++; goto _out; }
    }  
  }}
	break;
	case 24:
#line 191 "lexer.rl"
	{te = p+1;{ 
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, RSQB, tok, q);   
    if (!q->ok) {
      {p++; goto _out; }
    } 
  }}
	break;
	case 25:
#line 198 "lexer.rl"
	{te = p+1;}
	break;
	case 26:
#line 199 "lexer.rl"
	{te = p+1;}
	break;
	case 27:
#line 200 "lexer.rl"
	{te = p+1;}
	break;
	case 28:
#line 216 "lexer.rl"
	{te = p+1;{
    tok.len = te-ts - 1;
    tok.s = ts;
    tok.numval = 0;
    tok.pos = ts-q->raw;
    
    RSQuery_Parse(pParser, PREFIX, tok, q);
    
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 29:
#line 48 "lexer.rl"
	{te = p;p--;{ 
    tok.s = ts;
    tok.len = te-ts;
    char *ne = (char*)te;
    tok.numval = strtod(tok.s, &ne);
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, NUMBER, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
    
  }}
	break;
	case 30:
#line 156 "lexer.rl"
	{te = p;p--;{ 
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, MINUS, tok, q);  
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 31:
#line 199 "lexer.rl"
	{te = p;p--;}
	break;
	case 32:
#line 202 "lexer.rl"
	{te = p;p--;{
    tok.len = te-ts;
    tok.s = ts;
    tok.numval = 0;
    tok.pos = ts-q->raw;
    if (!StopWordList_Contains(q->opts.stopwords, tok.s, tok.len)) {
      RSQuery_Parse(pParser, TERM, tok, q);
    } else {
      RSQuery_Parse(pParser, STOPWORD, tok, q);
    }
    if (!q->ok) {
      {p++; goto _out; }
    }
  }}
	break;
	case 33:
#line 48 "lexer.rl"
	{{p = ((te))-1;}{ 
    tok.s = ts;
    tok.len = te-ts;
    char *ne = (char*)te;
    tok.numval = strtod(tok.s, &ne);
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, NUMBER, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
    
  }}
	break;
	case 34:
#line 1 "NONE"
	{	switch( act ) {
	case 1:
	{{p = ((te))-1;} 
    tok.s = ts;
    tok.len = te-ts;
    char *ne = (char*)te;
    tok.numval = strtod(tok.s, &ne);
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, NUMBER, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
    
  }
	break;
	case 2:
	{{p = ((te))-1;}
    tok.pos = ts-q->raw;
    tok.len = te - (ts + 1);
    tok.s = ts+1;
    RSQuery_Parse(pParser, MODIFIER, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }
	break;
	case 3:
	{{p = ((te))-1;}
    tok.pos = ts-q->raw;
    tok.len = te - (ts + 1);
    tok.s = ts+1;
    RSQuery_Parse(pParser, ATTRIBUTE, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }
	break;
	case 5:
	{{p = ((te))-1;} 
    tok.pos = ts-q->raw;
    tok.s = ts;
    tok.len = te-ts;
    tok.numval = *ts == '-' ? -INFINITY : INFINITY;
    RSQuery_Parse(pParser, NUMBER, tok, q);
    if (!q->ok) {
      {p++; goto _out; }
    }
  }
	break;
	case 14:
	{{p = ((te))-1;} 
    tok.pos = ts-q->raw;
    RSQuery_Parse(pParser, MINUS, tok, q);  
    if (!q->ok) {
      {p++; goto _out; }
    }
  }
	break;
	case 23:
	{{p = ((te))-1;}
    tok.len = te-ts;
    tok.s = ts;
    tok.numval = 0;
    tok.pos = ts-q->raw;
    if (!StopWordList_Contains(q->opts.stopwords, tok.s, tok.len)) {
      RSQuery_Parse(pParser, TERM, tok, q);
    } else {
      RSQuery_Parse(pParser, STOPWORD, tok, q);
    }
    if (!q->ok) {
      {p++; goto _out; }
    }
  }
	break;
	default:
	{{p = ((te))-1;}}
	break;
	}
	}
	break;
#line 620 "lexer.c"
		}
	}

_again:
	_acts = _query_actions + _query_to_state_actions[cs];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 ) {
		switch ( *_acts++ ) {
	case 0:
#line 1 "NONE"
	{ts = 0;}
	break;
#line 633 "lexer.c"
		}
	}

	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _query_eof_trans[cs] > 0 ) {
		_trans = _query_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	_out: {}
	}

#line 253 "lexer.rl"
  
  if (q->ok) {
    RSQuery_Parse(pParser, 0, tok, q);
  } 
  RSQuery_ParseFree(pParser, free);
  if(!q->ok && q->root) {
    QueryNode_Free(q->root);
    q->root = NULL;
  }
  if (err) {
    *err = q->errorMsg;
  }

 
  return q->root;
}

