% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dep-lazyeval.R
\name{deprecated-se}
\alias{deprecated-se}
\alias{complete_}
\alias{drop_na_}
\alias{expand_}
\alias{crossing_}
\alias{nesting_}
\alias{extract_}
\alias{fill_}
\alias{gather_}
\alias{nest_}
\alias{separate_rows_}
\alias{separate_}
\alias{spread_}
\alias{unite_}
\alias{unnest_}
\title{Deprecated SE versions of main verbs}
\usage{
complete_(data, cols, fill = list(), ...)

drop_na_(data, vars)

expand_(data, dots, ...)

crossing_(x)

nesting_(x)

extract_(
  data,
  col,
  into,
  regex = "([[:alnum:]]+)",
  remove = TRUE,
  convert = FALSE,
  ...
)

fill_(data, fill_cols, .direction = c("down", "up"))

gather_(
  data,
  key_col,
  value_col,
  gather_cols,
  na.rm = FALSE,
  convert = FALSE,
  factor_key = FALSE
)

nest_(...)

separate_rows_(data, cols, sep = "[^[:alnum:].]+", convert = FALSE)

separate_(
  data,
  col,
  into,
  sep = "[^[:alnum:]]+",
  remove = TRUE,
  convert = FALSE,
  extra = "warn",
  fill = "warn",
  ...
)

spread_(
  data,
  key_col,
  value_col,
  fill = NA,
  convert = FALSE,
  drop = TRUE,
  sep = NULL
)

unite_(data, col, from, sep = "_", remove = TRUE)

unnest_(...)
}
\arguments{
\item{data}{A data frame}

\item{fill}{A named list that for each variable supplies a single value to
use instead of \code{NA} for missing combinations.}

\item{...}{Specification of columns to expand. Columns can be atomic vectors
or lists.
\itemize{
\item To find all unique combinations of \code{x}, \code{y} and \code{z}, including those not
present in the data, supply each variable as a separate argument:
\code{expand(df, x, y, z)}.
\item To find only the combinations that occur in the
data, use \code{nesting}: \code{expand(df, nesting(x, y, z))}.
\item You can combine the two forms. For example,
\code{expand(df, nesting(school_id, student_id), date)} would produce
a row for each present school-student combination for all possible
dates.
}

When used with factors, \code{expand()} uses the full set of levels, not just
those that appear in the data. If you want to use only the values seen in
the data, use \code{forcats::fct_drop()}.

When used with continuous variables, you may need to fill in values
that do not appear in the data: to do so use expressions like
\code{year = 2010:2020} or \verb{year = \link{full_seq}(year,1)}.}

\item{vars, cols, col}{Name of columns.}

\item{x}{For \code{nesting_} and \code{crossing_} a list of variables.}

\item{into}{Names of new variables to create as character vector.
Use \code{NA} to omit the variable in the output.}

\item{regex}{a regular expression used to extract the desired values.
There should be one group (defined by \verb{()}) for each element of \code{into}.}

\item{remove}{If \code{TRUE}, remove input column from output data frame.}

\item{convert}{If \code{TRUE}, will run \code{\link[=type.convert]{type.convert()}} with
\code{as.is = TRUE} on new columns. This is useful if the component
columns are integer, numeric or logical.

NB: this will cause string \code{"NA"}s to be converted to \code{NA}s.}

\item{fill_cols}{Character vector of column names.}

\item{.direction}{Direction in which to fill missing values. Currently
either "down" (the default), "up", "downup" (i.e. first down and then up)
or "updown" (first up and then down).}

\item{key_col, value_col}{Strings giving names of key and value cols.}

\item{gather_cols}{Character vector giving column names to be gathered into
pair of key-value columns.}

\item{na.rm}{If \code{TRUE}, will remove rows from output where the
value column is \code{NA}.}

\item{factor_key}{If \code{FALSE}, the default, the key values will be
stored as a character vector. If \code{TRUE}, will be stored as a factor,
which preserves the original ordering of the columns.}

\item{sep}{\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}:
use \code{names_sep} instead.}

\item{extra}{If \code{sep} is a character vector, this controls what
happens when there are too many pieces. There are three valid options:
\itemize{
\item "warn" (the default): emit a warning and drop extra values.
\item "drop": drop any extra values without a warning.
\item "merge": only splits at most \code{length(into)} times
}}

\item{drop}{\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}:
all list-columns are now preserved; If there are any that you
don't want in the output use \code{select()} to remove them prior to
unnesting.}

\item{from}{Names of existing columns as character vector}

\item{expand_cols}{Character vector of column names to be expanded.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}

tidyr used to offer twin versions of each verb suffixed with an
underscore. These versions had standard evaluation (SE) semantics:
rather than taking arguments by code, like NSE verbs, they took
arguments by value. Their purpose was to make it possible to
program with tidyr. However, tidyr now uses tidy evaluation
semantics. NSE verbs still capture their arguments, but you can now
unquote parts of these arguments. This offers full programmability
with NSE verbs. Thus, the underscored versions are now superfluous.

Unquoting triggers immediate evaluation of its operand and inlines
the result within the captured expression. This result can be a
value or an expression to be evaluated later with the rest of the
argument. See \code{vignette("programming", "dplyr")} for more information.
}
\keyword{internal}
