% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callr.R
\name{exec_r}
\alias{exec_r}
\alias{r_wait}
\alias{r_internal}
\alias{r_background}
\title{Execute R from R}
\usage{
r_wait(
  args = "--vanilla",
  std_out = stdout(),
  std_err = stderr(),
  std_in = NULL
)

r_internal(args = "--vanilla", std_in = NULL, error = TRUE)

r_background(args = "--vanilla", std_out = TRUE, std_err = TRUE, std_in = NULL)
}
\arguments{
\item{args}{command line arguments for R}

\item{std_out}{if and where to direct child process \code{STDOUT}. Must be one of
\code{TRUE}, \code{FALSE}, filename, connection object or callback function. See section
on \emph{Output Streams} below for details.}

\item{std_err}{if and where to direct child process \code{STDERR}. Must be one of
\code{TRUE}, \code{FALSE}, filename, connection object or callback function. See section
on \emph{Output Streams} below for details.}

\item{std_in}{a file to send to stdin, usually an R script (see examples).}

\item{error}{automatically raise an error if the exit status is non-zero.}
}
\description{
Convenience wrappers for \link{exec_wait} and \link{exec_internal} that shell out to
R itself: \code{R.home("bin/R")}.
}
\details{
This is a simple but robust way to invoke R commands in a separate process.
Use the \href{https://cran.r-project.org/package=callr}{callr} package if you
need more sophisticated control over (multiple) R process jobs.
}
\examples{
# Hello world
r_wait("--version")

# Run some code
r_wait(c('--vanilla', '-q', '-e', 'sessionInfo()'))

# Run a script via stdin
tmp <- tempfile()
writeLines(c("x <- rnorm(100)", "mean(x)"), con = tmp)
r_wait(std_in = tmp)
}
\seealso{
Other sys: 
\code{\link{exec}}
}
\concept{sys}
