% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdweave.R
\name{mdweave}
\alias{mdweave}
\title{Run the code in a markdown file and generate a new markdown file}
\usage{
mdweave(
  fn,
  ofn = file_subs_ext(basename(fn), ".md", FALSE),
  cmd1 = "pandoc -s \\"\%1$s\\" -t json -o \\"\%2$s\\"",
  cmd2 = "pandoc -s \\"\%1$s\\" -t markdown -o \\"\%2$s\\"",
  ...
)
}
\arguments{
\item{fn}{filename of the markdown file (should use pandoc markdown).}

\item{ofn}{name of the resulting markdown file.}

\item{cmd1}{command used to run pandoc. See details.}

\item{cmd2}{command used to run pandoc. See details.}

\item{...}{ignored}
}
\value{
Returns the file name of the file generated (\code{ofn}). Called mainly for the
side effect of parsing and generating a markdown file (and possibly secondary
files such as figures).
}
\description{
Run the code in a markdown file and generate a new markdown file
}
\details{
\code{mdweave} calls pandoc twice. In the first call the markdown file is
parsed by pandoc and the parse tree is written to a temporary file. This
parse tree is the read by mdweave and any R-code in the tree is executed
resulting in a modified parse tree. This file is then stored to a new
temporary file. Pandoc is the called a second time to convert the new
parse tree to a markdown file.

The arguments \code{cmd1} and \code{cmd2} contain the calls used to run
pandoc. The arguments can be used to, for example pas additional arguments
to pandoc. They use positional arguments. In \code{cmd1}, the first argument
(\code{\%1$s}) is the input file name and the second (\code{\%2$s}) the
temporary file containing the parsed tree. In \code{cmd2}, the first argument
is the temporary file with the modified parse tree and the second argument
the output file.
}
