% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/centroids.R, R/segmentation.R,
%   R/molecules.R, R/fov.R
\name{Overlay}
\alias{Overlay}
\alias{Overlay,Centroids,SpatialPolygons-method}
\alias{Overlay,Segmentation,SpatialPolygons-method}
\alias{Overlay,Molecules,SpatialPolygons-method}
\alias{Overlay,FOV,Spatial-method}
\alias{Overlay,FOV,SpatialPolygons-method}
\alias{Overlay,FOV,FOV-method}
\title{Overlay \code{Spatial} Objects Over One Another}
\usage{
Overlay(x, y, invert = FALSE, ...)

\S4method{Overlay}{Centroids,SpatialPolygons}(x, y, invert = FALSE, ...)

\S4method{Overlay}{Segmentation,SpatialPolygons}(x, y, invert = FALSE, ...)

\S4method{Overlay}{Molecules,SpatialPolygons}(x, y, invert = FALSE, ...)

\S4method{Overlay}{FOV,Spatial}(x, y, invert = FALSE, ...)

\S4method{Overlay}{FOV,SpatialPolygons}(x, y, invert = FALSE, ...)

\S4method{Overlay}{FOV,FOV}(x, y, invert = FALSE, ...)
}
\arguments{
\item{x}{Query \code{Spatial} object}

\item{y}{Target \code{Spatial} object}

\item{invert}{Invert the overlay and return only the components of \code{x}
that fall \emph{outside} the bounds of \code{y}}

\item{...}{Ignored}
}
\value{
\code{x} with only the components that fall within the
bounds of \code{y}
}
\description{
Create an overlay of some query spatial object (\code{x}) against some
target object (\code{y}). Basically, find all components of a query that
fall within the bounds of a target spatial region
}
