% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinom_test.R
\name{multinom_test}
\alias{multinom_test}
\title{Exact Multinomial Test}
\usage{
multinom_test(x, p = rep(1/length(x), length(x)), detailed = FALSE)
}
\arguments{
\item{x}{numeric vector containing the counts.}

\item{p}{a vector of probabilities of success. The length of p must be the
same as the number of groups specified by x, and its elements must be
greater than 0 and less than 1.}

\item{detailed}{logical value. Default is FALSE. If TRUE, a detailed result is
shown.}
}
\value{
return a data frame containing the p-value and its significance.

 The \strong{returned object has an attribute called args}, which is a list
 holding the test arguments.
}
\description{
Performs an exact multinomial test. Alternative to the chi-square test of goodness-of-fit-test when the sample
 size is small.
}
\examples{
# Data
tulip <- c(red = 81, yellow = 50, white = 27)

# Question 1: are the color equally common ?
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# this is a test of homogeneity
res <- multinom_test(tulip)
res

attr(res, "descriptives")

# Pairwise comparisons between groups
pairwise_binom_test(tulip, p.adjust.method = "bonferroni")


# Question 2: comparing observed to expected proportions
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# this is a goodness-of-fit test
expected.p <- c(red = 0.5, yellow = 0.33, white = 0.17)
res <- multinom_test(tulip, expected.p)
res
attr(res, "descriptives")

# Pairwise comparisons against a given probabilities
pairwise_binom_test_against_p(tulip, expected.p)
}
\seealso{
\link{binom_test}
}
