% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanoduration.R
\docType{class}
\name{nanoduration-class}
\alias{nanoduration-class}
\alias{nanoduration}
\alias{*,ANY,nanoduration-method}
\alias{*,nanoduration,ANY-method}
\alias{*,nanoduration,nanoduration-method}
\alias{+,ANY,nanoduration-method}
\alias{/,ANY,nanoduration-method}
\alias{/,nanoduration,ANY-method}
\alias{Complex,nanoduration-method}
\alias{Logic,ANY,nanoduration-method}
\alias{Logic,nanoduration,ANY-method}
\alias{Logic,nanoduration,nanoduration-method}
\alias{Math2,nanoduration-method}
\alias{Math,nanoduration-method}
\alias{Summary,nanoduration-method}
\alias{as.nanoduration,character-method}
\alias{as.nanoduration}
\alias{as.nanoduration,integer64-method}
\alias{as.nanoduration,numeric-method}
\alias{as.nanoduration,integer-method}
\alias{as.nanoduration,NULL-method}
\alias{as.nanoduration,missing-method}
\alias{show,nanoduration-method}
\alias{print,nanoduration-method}
\alias{format.nanoduration}
\alias{as.integer64.nanoduration}
\alias{as.character,nanoduration-method}
\alias{is.na,nanoduration-method}
\alias{-,nanoduration,nanoduration-method}
\alias{-,nanoduration,integer64-method}
\alias{-,nanoduration,integer-method}
\alias{-,nanoduration,numeric-method}
\alias{-,nanoduration,ANY-method}
\alias{-,nanotime,nanoduration-method}
\alias{-,integer64,nanoduration-method}
\alias{-,integer,nanoduration-method}
\alias{-,numeric,nanoduration-method}
\alias{-,ANY,nanoduration-method}
\alias{+,nanoduration,ANY-method}
\alias{+,nanoduration,nanoduration-method}
\alias{+,nanoduration,integer64-method}
\alias{+,nanoduration,numeric-method}
\alias{+,nanotime,nanoduration-method}
\alias{+,nanoival,nanoduration-method}
\alias{+,integer64,nanoduration-method}
\alias{+,numeric,nanoduration-method}
\alias{*,nanoduration,numeric-method}
\alias{*,nanoduration,integer64-method}
\alias{*,numeric,nanoduration-method}
\alias{*,integer64,nanoduration-method}
\alias{/,nanoduration,nanoduration-method}
\alias{/,nanoduration,integer64-method}
\alias{/,nanoduration,numeric-method}
\alias{Arith,nanoduration,ANY-method}
\alias{Compare,nanoduration,ANY-method}
\alias{abs,nanoduration-method}
\alias{sign,nanoduration-method}
\alias{sum,nanoduration-method}
\alias{min,nanoduration-method}
\alias{max,nanoduration-method}
\alias{range,nanoduration-method}
\alias{[[,nanoduration-method}
\alias{[,nanoduration,numeric-method}
\alias{[,nanoduration,logical-method}
\alias{[,nanoduration,character-method}
\alias{[,nanoduration,ANY-method}
\alias{[<-,nanoduration,ANY,ANY,ANY-method}
\alias{c.nanoduration}
\alias{NA_nanoduration_}
\title{Duration type with nanosecond precision}
\format{
An object of class \code{nanoduration} of length 1.
}
\usage{
nanoduration(hours, minutes, seconds, nanoseconds)

\S4method{as.nanoduration}{character}(x)

\S4method{as.nanoduration}{integer64}(x)

\S4method{as.nanoduration}{numeric}(x)

\S4method{as.nanoduration}{integer}(x)

\S4method{as.nanoduration}{`NULL`}(x)

\S4method{as.nanoduration}{missing}(x)

\S4method{show}{nanoduration}(object)

\S4method{print}{nanoduration}(x, quote = FALSE, ...)

\method{format}{nanoduration}(x, ...)

\method{as.integer64}{nanoduration}(x, ...)

\S4method{as.character}{nanoduration}(x)

\S4method{is.na}{nanoduration}(x)

\S4method{-}{nanoduration,nanoduration}(e1, e2)

\S4method{-}{nanoduration,integer64}(e1, e2)

\S4method{-}{nanoduration,integer}(e1, e2)

\S4method{-}{nanoduration,numeric}(e1, e2)

\S4method{-}{nanoduration,ANY}(e1, e2)

\S4method{-}{nanotime,nanoduration}(e1, e2)

\S4method{-}{integer64,nanoduration}(e1, e2)

\S4method{-}{integer,nanoduration}(e1, e2)

\S4method{-}{numeric,nanoduration}(e1, e2)

\S4method{-}{ANY,nanoduration}(e1, e2)

\S4method{+}{nanoduration,ANY}(e1, e2)

\S4method{+}{nanoduration,nanoduration}(e1, e2)

\S4method{+}{nanoduration,integer64}(e1, e2)

\S4method{+}{nanoduration,numeric}(e1, e2)

\S4method{+}{nanotime,nanoduration}(e1, e2)

\S4method{+}{nanoival,nanoduration}(e1, e2)

\S4method{+}{integer64,nanoduration}(e1, e2)

\S4method{+}{numeric,nanoduration}(e1, e2)

\S4method{*}{nanoduration,numeric}(e1, e2)

\S4method{*}{nanoduration,integer64}(e1, e2)

\S4method{*}{numeric,nanoduration}(e1, e2)

\S4method{*}{integer64,nanoduration}(e1, e2)

\S4method{/}{nanoduration,nanoduration}(e1, e2)

\S4method{/}{nanoduration,integer64}(e1, e2)

\S4method{/}{nanoduration,numeric}(e1, e2)

\S4method{Arith}{nanoduration,ANY}(e1, e2)

\S4method{Compare}{nanoduration,ANY}(e1, e2)

\S4method{abs}{nanoduration}(x)

\S4method{sign}{nanoduration}(x)

\S4method{sum}{nanoduration}(x, ..., na.rm = FALSE)

\S4method{min}{nanoduration}(x, ..., na.rm = FALSE)

\S4method{max}{nanoduration}(x, ..., na.rm = FALSE)

\S4method{range}{nanoduration}(x, ..., na.rm = FALSE)

\S4method{[[}{nanoduration}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanoduration,numeric}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanoduration,logical}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanoduration,character}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanoduration,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanoduration,ANY,ANY,ANY}(x, i, j, ...) <- value

\method{c}{nanoduration}(...)

NA_nanoduration_
}
\arguments{
\item{hours}{number of hours}

\item{minutes}{number of minutes}

\item{seconds}{number of seconds}

\item{nanoseconds}{number of nanoseconds}

\item{x}{a \code{nanoduration} object}

\item{object}{argument for method \code{show}}

\item{quote}{indicates if the output of \code{print} should be
quoted}

\item{...}{further arguments passed to or from methods.}

\item{e1}{Operand of class \code{nanoival}}

\item{e2}{Operand of class \code{nanoival}}

\item{na.rm}{if \code{TRUE} NA values are removed for the
computation}

\item{i}{index specifying elements to extract or replace.}

\item{j}{Required for \code{[} signature but ignored here}

\item{drop}{Required for \code{[} signature but ignored here}

\item{value}{argument for \code{nanoduration-class}}
}
\value{
A nanoduration object
}
\description{
The type \code{nanoduration} is a length of time (implemented as
an S4 class) with nanosecond precision. It is a count of
nanoseconds and may be negative. The expected arithmetic
operations are provided, including sequence generation.
}
\details{
A \code{nanoduration} can be constructed with the function
\code{as.nanoduration} which can take the types \code{integer64},
\code{integer} and \code{numeric} (all indicating the count in
nanosecond units) or the type \code{character}.

It can also be constructed by specifying with individual arguments
the hours, minutes, seconds and nanoseconds with a call to
\code{nanoduration}.

A \code{nanoduration} is displayed as hours, minutes, seconds and
nanoseconds like this: \code{110:12:34.123_453_001}. The nanosecond
precision displayed is adjusted as necessary, so e.g. 1 second is
displayed as \code{00:00:01}.
}
\examples{
## constructors:
nanoduration(hours=10, minutes=3, seconds=2, nanoseconds=999999999)
as.nanoduration("10:03:02.999_999_999")
as.nanoduration(36182999999999)

## arithmetic:
as.nanoduration(10e9) - as.nanoduration(9e9)
as.nanoduration(10e9) + as.nanoduration(-9e9)
as.nanoduration("24:00:00") / 2
as.nanoduration("24:00:00") / as.nanoduration("12:00:00")

}
\seealso{
\code{\link{nanotime}}
}
\author{
Dirk Eddelbuettel

Leonardo Silvestri
}
\keyword{datasets}
