% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_axes.R
\name{get_y_axis}
\alias{get_y_axis}
\alias{get_x_axis}
\title{Get plot axes}
\usage{
get_y_axis(plot, position = c("left", "right"))

get_x_axis(plot, position = c("bottom", "top"))
}
\arguments{
\item{plot}{A ggplot or gtable.}

\item{position}{Which side of the plot is the axis on? For the x-axis, this
can be "top" or "bottom", and for the y-axis, it can be "left" or "right".}
}
\description{
These functions extract just the axes from a ggplot. \code{get_y_axis()} pulls
the y-axis, while \code{get_x_axis()} pulls the x-axis.
}
\examples{
library(ggplot2)

p <- ggplot(mpg, aes(displ, cty)) +
  geom_point()

ggdraw(get_y_axis(p))
p <- p + scale_x_continuous(position = "top")
ggdraw(get_x_axis(p, position = "top"))

}
