% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCurationFile.R
\name{createCurationFile}
\alias{createCurationFile}
\title{Create file to curate PureCN results}
\usage{
createCurationFile(
  file.rds,
  overwrite.uncurated = TRUE,
  overwrite.curated = FALSE
)
}
\arguments{
\item{file.rds}{Output of the \code{\link{runAbsoluteCN}} function,
serialized with \code{saveRDS}.}

\item{overwrite.uncurated}{Overwrite existing files unless flagged as
\sQuote{Curated}.}

\item{overwrite.curated}{Overwrite existing files even if flagged as
\sQuote{Curated}.}
}
\value{
A \code{data.frame} with the tumor purity and ploidy of the maximum
likelihood solution.
}
\description{
Function to create a CSV file that can be used to mark the correct solution
in the output of a \code{\link{runAbsoluteCN}} run.
}
\examples{

data(purecn.example.output)
file.rds <- "Sample1_PureCN.rds"
saveRDS(purecn.example.output, file=file.rds)
createCurationFile(file.rds) 

}
\seealso{
\code{\link{runAbsoluteCN}}
}
\author{
Markus Riester
}
