# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.supersim.v1.command import CommandList
from twilio.rest.supersim.v1.fleet import FleetList
from twilio.rest.supersim.v1.network import NetworkList
from twilio.rest.supersim.v1.network_access_profile import NetworkAccessProfileList
from twilio.rest.supersim.v1.sim import SimList
from twilio.rest.supersim.v1.usage_record import UsageRecordList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Supersim

        :returns: V1 version of Supersim
        :rtype: twilio.rest.supersim.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._commands = None
        self._fleets = None
        self._networks = None
        self._network_access_profiles = None
        self._sims = None
        self._usage_records = None

    @property
    def commands(self):
        """
        :rtype: twilio.rest.supersim.v1.command.CommandList
        """
        if self._commands is None:
            self._commands = CommandList(self)
        return self._commands

    @property
    def fleets(self):
        """
        :rtype: twilio.rest.supersim.v1.fleet.FleetList
        """
        if self._fleets is None:
            self._fleets = FleetList(self)
        return self._fleets

    @property
    def networks(self):
        """
        :rtype: twilio.rest.supersim.v1.network.NetworkList
        """
        if self._networks is None:
            self._networks = NetworkList(self)
        return self._networks

    @property
    def network_access_profiles(self):
        """
        :rtype: twilio.rest.supersim.v1.network_access_profile.NetworkAccessProfileList
        """
        if self._network_access_profiles is None:
            self._network_access_profiles = NetworkAccessProfileList(self)
        return self._network_access_profiles

    @property
    def sims(self):
        """
        :rtype: twilio.rest.supersim.v1.sim.SimList
        """
        if self._sims is None:
            self._sims = SimList(self)
        return self._sims

    @property
    def usage_records(self):
        """
        :rtype: twilio.rest.supersim.v1.usage_record.UsageRecordList
        """
        if self._usage_records is None:
            self._usage_records = UsageRecordList(self)
        return self._usage_records

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Supersim.V1>'
