# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._azure_machine_learning_workspaces_enums import *


class Artifact(msrest.serialization.Model):
    """Artifact.

    :ivar id:
    :vartype id: str
    :ivar prefix:
    :vartype prefix: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'prefix': {'key': 'prefix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        prefix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword prefix:
        :paramtype prefix: str
        """
        super(Artifact, self).__init__(**kwargs)
        self.id = id
        self.prefix = prefix


class Asset(msrest.serialization.Model):
    """Asset.

    All required parameters must be populated in order to send to Azure.

    :ivar id:
    :vartype id: str
    :ivar name: Required.
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar description:
    :vartype description: str
    :ivar artifacts:
    :vartype artifacts: list[~azure.mgmt.machinelearningservices.models.Artifact]
    :ivar kv_tags: Dictionary of :code:`<string>`.
    :vartype kv_tags: dict[str, str]
    :ivar properties: Dictionary of :code:`<string>`.
    :vartype properties: dict[str, str]
    :ivar runid:
    :vartype runid: str
    :ivar projectid:
    :vartype projectid: str
    :ivar meta: Dictionary of :code:`<string>`.
    :vartype meta: dict[str, str]
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'artifacts': {'key': 'artifacts', 'type': '[Artifact]'},
        'kv_tags': {'key': 'kvTags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'runid': {'key': 'runid', 'type': 'str'},
        'projectid': {'key': 'projectid', 'type': 'str'},
        'meta': {'key': 'meta', 'type': '{str}'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,
        type: Optional[str] = None,
        description: Optional[str] = None,
        artifacts: Optional[List["Artifact"]] = None,
        kv_tags: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        runid: Optional[str] = None,
        projectid: Optional[str] = None,
        meta: Optional[Dict[str, str]] = None,
        created_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name: Required.
        :paramtype name: str
        :keyword type:
        :paramtype type: str
        :keyword description:
        :paramtype description: str
        :keyword artifacts:
        :paramtype artifacts: list[~azure.mgmt.machinelearningservices.models.Artifact]
        :keyword kv_tags: Dictionary of :code:`<string>`.
        :paramtype kv_tags: dict[str, str]
        :keyword properties: Dictionary of :code:`<string>`.
        :paramtype properties: dict[str, str]
        :keyword runid:
        :paramtype runid: str
        :keyword projectid:
        :paramtype projectid: str
        :keyword meta: Dictionary of :code:`<string>`.
        :paramtype meta: dict[str, str]
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        """
        super(Asset, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.description = description
        self.artifacts = artifacts
        self.kv_tags = kv_tags
        self.properties = properties
        self.runid = runid
        self.projectid = projectid
        self.meta = meta
        self.created_time = created_time


class AssetDto(msrest.serialization.Model):
    """AssetDto.

    :ivar asset_id:
    :vartype asset_id: str
    :ivar entity_id:
    :vartype entity_id: str
    :ivar data_items: Dictionary of :code:`<DataItem>`.
    :vartype data_items: dict[str, ~azure.mgmt.machinelearningservices.models.DataItem]
    :ivar data_references:
    :vartype data_references: ~azure.mgmt.machinelearningservices.models.DataReferences
    :ivar should_index:
    :vartype should_index: bool
    :ivar dependencies:
    :vartype dependencies: list[~azure.mgmt.machinelearningservices.models.DependentAsset]
    :ivar intellectual_property_publisher_information:
    :vartype intellectual_property_publisher_information:
     ~azure.mgmt.machinelearningservices.models.IntellectualPropertyPublisherInformation
    """

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'entity_id': {'key': 'entityId', 'type': 'str'},
        'data_items': {'key': 'dataItems', 'type': '{DataItem}'},
        'data_references': {'key': 'dataReferences', 'type': 'DataReferences'},
        'should_index': {'key': 'shouldIndex', 'type': 'bool'},
        'dependencies': {'key': 'dependencies', 'type': '[DependentAsset]'},
        'intellectual_property_publisher_information': {'key': 'intellectualPropertyPublisherInformation', 'type': 'IntellectualPropertyPublisherInformation'},
    }

    def __init__(
        self,
        *,
        asset_id: Optional[str] = None,
        entity_id: Optional[str] = None,
        data_items: Optional[Dict[str, "DataItem"]] = None,
        data_references: Optional["DataReferences"] = None,
        should_index: Optional[bool] = None,
        dependencies: Optional[List["DependentAsset"]] = None,
        intellectual_property_publisher_information: Optional["IntellectualPropertyPublisherInformation"] = None,
        **kwargs
    ):
        """
        :keyword asset_id:
        :paramtype asset_id: str
        :keyword entity_id:
        :paramtype entity_id: str
        :keyword data_items: Dictionary of :code:`<DataItem>`.
        :paramtype data_items: dict[str, ~azure.mgmt.machinelearningservices.models.DataItem]
        :keyword data_references:
        :paramtype data_references: ~azure.mgmt.machinelearningservices.models.DataReferences
        :keyword should_index:
        :paramtype should_index: bool
        :keyword dependencies:
        :paramtype dependencies: list[~azure.mgmt.machinelearningservices.models.DependentAsset]
        :keyword intellectual_property_publisher_information:
        :paramtype intellectual_property_publisher_information:
         ~azure.mgmt.machinelearningservices.models.IntellectualPropertyPublisherInformation
        """
        super(AssetDto, self).__init__(**kwargs)
        self.asset_id = asset_id
        self.entity_id = entity_id
        self.data_items = data_items
        self.data_references = data_references
        self.should_index = should_index
        self.dependencies = dependencies
        self.intellectual_property_publisher_information = intellectual_property_publisher_information


class AssetPaginatedResult(msrest.serialization.Model):
    """AssetPaginatedResult.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Asset]
    :ivar continuation_token:
    :vartype continuation_token: str
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Asset]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Asset"]] = None,
        continuation_token: Optional[str] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Asset]
        :keyword continuation_token:
        :paramtype continuation_token: str
        :keyword next_link:
        :paramtype next_link: str
        """
        super(AssetPaginatedResult, self).__init__(**kwargs)
        self.value = value
        self.continuation_token = continuation_token
        self.next_link = next_link


class BatchGetResolvedUrisDto(msrest.serialization.Model):
    """BatchGetResolvedUrisDto.

    :ivar values:
    :vartype values: list[str]
    """

    _attribute_map = {
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword values:
        :paramtype values: list[str]
        """
        super(BatchGetResolvedUrisDto, self).__init__(**kwargs)
        self.values = values


class BatchModelPathResponseDto(msrest.serialization.Model):
    """BatchModelPathResponseDto.

    :ivar values: Dictionary of :code:`<ModelPathResponseDto>`.
    :vartype values: dict[str, ~azure.mgmt.machinelearningservices.models.ModelPathResponseDto]
    """

    _attribute_map = {
        'values': {'key': 'values', 'type': '{ModelPathResponseDto}'},
    }

    def __init__(
        self,
        *,
        values: Optional[Dict[str, "ModelPathResponseDto"]] = None,
        **kwargs
    ):
        """
        :keyword values: Dictionary of :code:`<ModelPathResponseDto>`.
        :paramtype values: dict[str, ~azure.mgmt.machinelearningservices.models.ModelPathResponseDto]
        """
        super(BatchModelPathResponseDto, self).__init__(**kwargs)
        self.values = values


class BlobReference(msrest.serialization.Model):
    """BlobReference.

    :ivar blob_uri:
    :vartype blob_uri: str
    :ivar storage_account_arm_id:
    :vartype storage_account_arm_id: str
    """

    _attribute_map = {
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'storage_account_arm_id': {'key': 'storageAccountArmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        blob_uri: Optional[str] = None,
        storage_account_arm_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword blob_uri:
        :paramtype blob_uri: str
        :keyword storage_account_arm_id:
        :paramtype storage_account_arm_id: str
        """
        super(BlobReference, self).__init__(**kwargs)
        self.blob_uri = blob_uri
        self.storage_account_arm_id = storage_account_arm_id


class BlobReferenceForConsumptionDto(msrest.serialization.Model):
    """BlobReferenceForConsumptionDto.

    :ivar blob_uri:
    :vartype blob_uri: str
    :ivar storage_account_arm_id:
    :vartype storage_account_arm_id: str
    :ivar credential:
    :vartype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialDto
    """

    _attribute_map = {
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'storage_account_arm_id': {'key': 'storageAccountArmId', 'type': 'str'},
        'credential': {'key': 'credential', 'type': 'DataReferenceCredentialDto'},
    }

    def __init__(
        self,
        *,
        blob_uri: Optional[str] = None,
        storage_account_arm_id: Optional[str] = None,
        credential: Optional["DataReferenceCredentialDto"] = None,
        **kwargs
    ):
        """
        :keyword blob_uri:
        :paramtype blob_uri: str
        :keyword storage_account_arm_id:
        :paramtype storage_account_arm_id: str
        :keyword credential:
        :paramtype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialDto
        """
        super(BlobReferenceForConsumptionDto, self).__init__(**kwargs)
        self.blob_uri = blob_uri
        self.storage_account_arm_id = storage_account_arm_id
        self.credential = credential


class ContainerResourceRequirements(msrest.serialization.Model):
    """ContainerResourceRequirements.

    :ivar cpu:
    :vartype cpu: float
    :ivar cpu_limit:
    :vartype cpu_limit: float
    :ivar memory_in_gb:
    :vartype memory_in_gb: float
    :ivar memory_in_gb_limit:
    :vartype memory_in_gb_limit: float
    :ivar gpu_enabled:
    :vartype gpu_enabled: bool
    :ivar gpu:
    :vartype gpu: int
    :ivar fpga:
    :vartype fpga: int
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'float'},
        'cpu_limit': {'key': 'cpuLimit', 'type': 'float'},
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'float'},
        'memory_in_gb_limit': {'key': 'memoryInGBLimit', 'type': 'float'},
        'gpu_enabled': {'key': 'gpuEnabled', 'type': 'bool'},
        'gpu': {'key': 'gpu', 'type': 'int'},
        'fpga': {'key': 'fpga', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        cpu: Optional[float] = None,
        cpu_limit: Optional[float] = None,
        memory_in_gb: Optional[float] = None,
        memory_in_gb_limit: Optional[float] = None,
        gpu_enabled: Optional[bool] = None,
        gpu: Optional[int] = None,
        fpga: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword cpu:
        :paramtype cpu: float
        :keyword cpu_limit:
        :paramtype cpu_limit: float
        :keyword memory_in_gb:
        :paramtype memory_in_gb: float
        :keyword memory_in_gb_limit:
        :paramtype memory_in_gb_limit: float
        :keyword gpu_enabled:
        :paramtype gpu_enabled: bool
        :keyword gpu:
        :paramtype gpu: int
        :keyword fpga:
        :paramtype fpga: int
        """
        super(ContainerResourceRequirements, self).__init__(**kwargs)
        self.cpu = cpu
        self.cpu_limit = cpu_limit
        self.memory_in_gb = memory_in_gb
        self.memory_in_gb_limit = memory_in_gb_limit
        self.gpu_enabled = gpu_enabled
        self.gpu = gpu
        self.fpga = fpga


class CreatedBy(msrest.serialization.Model):
    """CreatedBy.

    :ivar user_object_id:
    :vartype user_object_id: str
    :ivar user_tenant_id:
    :vartype user_tenant_id: str
    :ivar user_name:
    :vartype user_name: str
    """

    _attribute_map = {
        'user_object_id': {'key': 'userObjectId', 'type': 'str'},
        'user_tenant_id': {'key': 'userTenantId', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_object_id: Optional[str] = None,
        user_tenant_id: Optional[str] = None,
        user_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_object_id:
        :paramtype user_object_id: str
        :keyword user_tenant_id:
        :paramtype user_tenant_id: str
        :keyword user_name:
        :paramtype user_name: str
        """
        super(CreatedBy, self).__init__(**kwargs)
        self.user_object_id = user_object_id
        self.user_tenant_id = user_tenant_id
        self.user_name = user_name


class CreateUnregisteredInputModelDto(msrest.serialization.Model):
    """CreateUnregisteredInputModelDto.

    :ivar run_id:
    :vartype run_id: str
    :ivar input_name:
    :vartype input_name: str
    :ivar path:
    :vartype path: str
    :ivar type:
    :vartype type: str
    """

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
        'input_name': {'key': 'inputName', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_id: Optional[str] = None,
        input_name: Optional[str] = None,
        path: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword run_id:
        :paramtype run_id: str
        :keyword input_name:
        :paramtype input_name: str
        :keyword path:
        :paramtype path: str
        :keyword type:
        :paramtype type: str
        """
        super(CreateUnregisteredInputModelDto, self).__init__(**kwargs)
        self.run_id = run_id
        self.input_name = input_name
        self.path = path
        self.type = type


class CreateUnregisteredOutputModelDto(msrest.serialization.Model):
    """CreateUnregisteredOutputModelDto.

    :ivar run_id:
    :vartype run_id: str
    :ivar output_name:
    :vartype output_name: str
    :ivar path:
    :vartype path: str
    :ivar type:
    :vartype type: str
    """

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
        'output_name': {'key': 'outputName', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_id: Optional[str] = None,
        output_name: Optional[str] = None,
        path: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword run_id:
        :paramtype run_id: str
        :keyword output_name:
        :paramtype output_name: str
        :keyword path:
        :paramtype path: str
        :keyword type:
        :paramtype type: str
        """
        super(CreateUnregisteredOutputModelDto, self).__init__(**kwargs)
        self.run_id = run_id
        self.output_name = output_name
        self.path = path
        self.type = type


class CreationContext(msrest.serialization.Model):
    """CreationContext.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    :ivar created_by:
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.CreatedBy
    :ivar creation_source:
    :vartype creation_source: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'CreatedBy'},
        'creation_source': {'key': 'creationSource', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        created_time: Optional[datetime.datetime] = None,
        created_by: Optional["CreatedBy"] = None,
        creation_source: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        :keyword created_by:
        :paramtype created_by: ~azure.mgmt.machinelearningservices.models.CreatedBy
        :keyword creation_source:
        :paramtype creation_source: str
        """
        super(CreationContext, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.created_time = created_time
        self.created_by = created_by
        self.creation_source = creation_source


class DataItem(msrest.serialization.Model):
    """DataItem.

    :ivar data: Anything.
    :vartype data: any
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        data: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword data: Anything.
        :paramtype data: any
        """
        super(DataItem, self).__init__(**kwargs)
        self.data = data


class DataReferenceCredentialDto(msrest.serialization.Model):
    """DataReferenceCredentialDto.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar credential_type:
    :vartype credential_type: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'credential_type': {'key': 'credentialType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        credential_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword credential_type:
        :paramtype credential_type: str
        """
        super(DataReferenceCredentialDto, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.credential_type = credential_type


class DataReferences(msrest.serialization.Model):
    """DataReferences.

    :ivar blob_references: Dictionary of :code:`<BlobReference>`.
    :vartype blob_references: dict[str, ~azure.mgmt.machinelearningservices.models.BlobReference]
    :ivar image_registry_references: Dictionary of :code:`<ImageReference>`.
    :vartype image_registry_references: dict[str,
     ~azure.mgmt.machinelearningservices.models.ImageReference]
    """

    _attribute_map = {
        'blob_references': {'key': 'blobReferences', 'type': '{BlobReference}'},
        'image_registry_references': {'key': 'imageRegistryReferences', 'type': '{ImageReference}'},
    }

    def __init__(
        self,
        *,
        blob_references: Optional[Dict[str, "BlobReference"]] = None,
        image_registry_references: Optional[Dict[str, "ImageReference"]] = None,
        **kwargs
    ):
        """
        :keyword blob_references: Dictionary of :code:`<BlobReference>`.
        :paramtype blob_references: dict[str, ~azure.mgmt.machinelearningservices.models.BlobReference]
        :keyword image_registry_references: Dictionary of :code:`<ImageReference>`.
        :paramtype image_registry_references: dict[str,
         ~azure.mgmt.machinelearningservices.models.ImageReference]
        """
        super(DataReferences, self).__init__(**kwargs)
        self.blob_references = blob_references
        self.image_registry_references = image_registry_references


class DataReferencesForConsumptionDto(msrest.serialization.Model):
    """DataReferencesForConsumptionDto.

    :ivar blob_references: Dictionary of :code:`<BlobReferenceForConsumptionDto>`.
    :vartype blob_references: dict[str,
     ~azure.mgmt.machinelearningservices.models.BlobReferenceForConsumptionDto]
    :ivar image_registry_references: Dictionary of :code:`<ImageReferenceForConsumptionDto>`.
    :vartype image_registry_references: dict[str,
     ~azure.mgmt.machinelearningservices.models.ImageReferenceForConsumptionDto]
    """

    _attribute_map = {
        'blob_references': {'key': 'blobReferences', 'type': '{BlobReferenceForConsumptionDto}'},
        'image_registry_references': {'key': 'imageRegistryReferences', 'type': '{ImageReferenceForConsumptionDto}'},
    }

    def __init__(
        self,
        *,
        blob_references: Optional[Dict[str, "BlobReferenceForConsumptionDto"]] = None,
        image_registry_references: Optional[Dict[str, "ImageReferenceForConsumptionDto"]] = None,
        **kwargs
    ):
        """
        :keyword blob_references: Dictionary of :code:`<BlobReferenceForConsumptionDto>`.
        :paramtype blob_references: dict[str,
         ~azure.mgmt.machinelearningservices.models.BlobReferenceForConsumptionDto]
        :keyword image_registry_references: Dictionary of :code:`<ImageReferenceForConsumptionDto>`.
        :paramtype image_registry_references: dict[str,
         ~azure.mgmt.machinelearningservices.models.ImageReferenceForConsumptionDto]
        """
        super(DataReferencesForConsumptionDto, self).__init__(**kwargs)
        self.blob_references = blob_references
        self.image_registry_references = image_registry_references


class DatasetReference(msrest.serialization.Model):
    """DatasetReference.

    :ivar name:
    :vartype name: str
    :ivar id:
    :vartype id: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword id:
        :paramtype id: str
        """
        super(DatasetReference, self).__init__(**kwargs)
        self.name = name
        self.id = id


class DependencyMapDto(msrest.serialization.Model):
    """DependencyMapDto.

    :ivar dependencies:
    :vartype dependencies: list[~azure.mgmt.machinelearningservices.models.DependencyMapItemDto]
    """

    _attribute_map = {
        'dependencies': {'key': 'dependencies', 'type': '[DependencyMapItemDto]'},
    }

    def __init__(
        self,
        *,
        dependencies: Optional[List["DependencyMapItemDto"]] = None,
        **kwargs
    ):
        """
        :keyword dependencies:
        :paramtype dependencies: list[~azure.mgmt.machinelearningservices.models.DependencyMapItemDto]
        """
        super(DependencyMapDto, self).__init__(**kwargs)
        self.dependencies = dependencies


class DependencyMapItemDto(msrest.serialization.Model):
    """DependencyMapItemDto.

    :ivar source_id:
    :vartype source_id: str
    :ivar destination_id:
    :vartype destination_id: str
    """

    _attribute_map = {
        'source_id': {'key': 'sourceId', 'type': 'str'},
        'destination_id': {'key': 'destinationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_id: Optional[str] = None,
        destination_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source_id:
        :paramtype source_id: str
        :keyword destination_id:
        :paramtype destination_id: str
        """
        super(DependencyMapItemDto, self).__init__(**kwargs)
        self.source_id = source_id
        self.destination_id = destination_id


class DependentAsset(msrest.serialization.Model):
    """DependentAsset.

    :ivar asset_id:
    :vartype asset_id: str
    """

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        asset_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword asset_id:
        :paramtype asset_id: str
        """
        super(DependentAsset, self).__init__(**kwargs)
        self.asset_id = asset_id


class DependentEntitiesDto(msrest.serialization.Model):
    """DependentEntitiesDto.

    :ivar asset_id:
    :vartype asset_id: str
    :ivar dependencies:
    :vartype dependencies: list[~azure.mgmt.machinelearningservices.models.DependentAsset]
    """

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'dependencies': {'key': 'dependencies', 'type': '[DependentAsset]'},
    }

    def __init__(
        self,
        *,
        asset_id: Optional[str] = None,
        dependencies: Optional[List["DependentAsset"]] = None,
        **kwargs
    ):
        """
        :keyword asset_id:
        :paramtype asset_id: str
        :keyword dependencies:
        :paramtype dependencies: list[~azure.mgmt.machinelearningservices.models.DependentAsset]
        """
        super(DependentEntitiesDto, self).__init__(**kwargs)
        self.asset_id = asset_id
        self.dependencies = dependencies


class ErrorResponse(msrest.serialization.Model):
    """ErrorResponse.

    :ivar code:
    :vartype code: str
    :ivar status_code:
    :vartype status_code: int
    :ivar message:
    :vartype message: str
    :ivar target:
    :vartype target: str
    :ivar details:
    :vartype details: list[~azure.mgmt.machinelearningservices.models.InnerErrorDetails]
    :ivar correlation: Dictionary of :code:`<string>`.
    :vartype correlation: dict[str, str]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[InnerErrorDetails]'},
        'correlation': {'key': 'correlation', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        status_code: Optional[int] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["InnerErrorDetails"]] = None,
        correlation: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword code:
        :paramtype code: str
        :keyword status_code:
        :paramtype status_code: int
        :keyword message:
        :paramtype message: str
        :keyword target:
        :paramtype target: str
        :keyword details:
        :paramtype details: list[~azure.mgmt.machinelearningservices.models.InnerErrorDetails]
        :keyword correlation: Dictionary of :code:`<string>`.
        :paramtype correlation: dict[str, str]
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.status_code = status_code
        self.message = message
        self.target = target
        self.details = details
        self.correlation = correlation


class ExtensiveModel(msrest.serialization.Model):
    """ExtensiveModel.

    :ivar model:
    :vartype model: ~azure.mgmt.machinelearningservices.models.Model
    :ivar service_list:
    :vartype service_list: list[~azure.mgmt.machinelearningservices.models.ServiceResponseBase]
    :ivar asset_list:
    :vartype asset_list: list[~azure.mgmt.machinelearningservices.models.Asset]
    """

    _attribute_map = {
        'model': {'key': 'Model', 'type': 'Model'},
        'service_list': {'key': 'ServiceList', 'type': '[ServiceResponseBase]'},
        'asset_list': {'key': 'AssetList', 'type': '[Asset]'},
    }

    def __init__(
        self,
        *,
        model: Optional["Model"] = None,
        service_list: Optional[List["ServiceResponseBase"]] = None,
        asset_list: Optional[List["Asset"]] = None,
        **kwargs
    ):
        """
        :keyword model:
        :paramtype model: ~azure.mgmt.machinelearningservices.models.Model
        :keyword service_list:
        :paramtype service_list: list[~azure.mgmt.machinelearningservices.models.ServiceResponseBase]
        :keyword asset_list:
        :paramtype asset_list: list[~azure.mgmt.machinelearningservices.models.Asset]
        """
        super(ExtensiveModel, self).__init__(**kwargs)
        self.model = model
        self.service_list = service_list
        self.asset_list = asset_list


class FeedIndexEntityDto(msrest.serialization.Model):
    """FeedIndexEntityDto.

    :ivar index_entity:
    :vartype index_entity: ~azure.mgmt.machinelearningservices.models.IndexEntity
    :ivar schema_id:
    :vartype schema_id: str
    :ivar entity_schema: Anything.
    :vartype entity_schema: any
    """

    _attribute_map = {
        'index_entity': {'key': 'indexEntity', 'type': 'IndexEntity'},
        'schema_id': {'key': 'schemaId', 'type': 'str'},
        'entity_schema': {'key': 'entitySchema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        index_entity: Optional["IndexEntity"] = None,
        schema_id: Optional[str] = None,
        entity_schema: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword index_entity:
        :paramtype index_entity: ~azure.mgmt.machinelearningservices.models.IndexEntity
        :keyword schema_id:
        :paramtype schema_id: str
        :keyword entity_schema: Anything.
        :paramtype entity_schema: any
        """
        super(FeedIndexEntityDto, self).__init__(**kwargs)
        self.index_entity = index_entity
        self.schema_id = schema_id
        self.entity_schema = entity_schema


class FeedIndexEntityRequestDto(msrest.serialization.Model):
    """FeedIndexEntityRequestDto.

    :ivar feed_entity:
    :vartype feed_entity: ~azure.mgmt.machinelearningservices.models.AssetDto
    :ivar label_to_version_mapping: Dictionary of :code:`<string>`.
    :vartype label_to_version_mapping: dict[str, str]
    """

    _attribute_map = {
        'feed_entity': {'key': 'feedEntity', 'type': 'AssetDto'},
        'label_to_version_mapping': {'key': 'labelToVersionMapping', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        feed_entity: Optional["AssetDto"] = None,
        label_to_version_mapping: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword feed_entity:
        :paramtype feed_entity: ~azure.mgmt.machinelearningservices.models.AssetDto
        :keyword label_to_version_mapping: Dictionary of :code:`<string>`.
        :paramtype label_to_version_mapping: dict[str, str]
        """
        super(FeedIndexEntityRequestDto, self).__init__(**kwargs)
        self.feed_entity = feed_entity
        self.label_to_version_mapping = label_to_version_mapping


class ImageReference(msrest.serialization.Model):
    """ImageReference.

    :ivar image_registry_reference:
    :vartype image_registry_reference: str
    """

    _attribute_map = {
        'image_registry_reference': {'key': 'imageRegistryReference', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        image_registry_reference: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword image_registry_reference:
        :paramtype image_registry_reference: str
        """
        super(ImageReference, self).__init__(**kwargs)
        self.image_registry_reference = image_registry_reference


class ImageReferenceForConsumptionDto(msrest.serialization.Model):
    """ImageReferenceForConsumptionDto.

    :ivar image_registry_reference:
    :vartype image_registry_reference: str
    :ivar credential:
    :vartype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialDto
    """

    _attribute_map = {
        'image_registry_reference': {'key': 'imageRegistryReference', 'type': 'str'},
        'credential': {'key': 'credential', 'type': 'DataReferenceCredentialDto'},
    }

    def __init__(
        self,
        *,
        image_registry_reference: Optional[str] = None,
        credential: Optional["DataReferenceCredentialDto"] = None,
        **kwargs
    ):
        """
        :keyword image_registry_reference:
        :paramtype image_registry_reference: str
        :keyword credential:
        :paramtype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialDto
        """
        super(ImageReferenceForConsumptionDto, self).__init__(**kwargs)
        self.image_registry_reference = image_registry_reference
        self.credential = credential


class IndexAnnotations(msrest.serialization.Model):
    """IndexAnnotations.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar archived:
    :vartype archived: bool
    :ivar tags: A set of tags. Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'archived': {'key': 'archived', 'type': 'bool'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        archived: Optional[bool] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword archived:
        :paramtype archived: bool
        :keyword tags: A set of tags. Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        """
        super(IndexAnnotations, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.archived = archived
        self.tags = tags


class IndexEntity(msrest.serialization.Model):
    """IndexEntity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar schema_id:
    :vartype schema_id: str
    :ivar entity_id:
    :vartype entity_id: str
    :ivar kind: Possible values include: "Invalid", "LineageRoot", "Versioned", "Unversioned".
    :vartype kind: str or ~azure.mgmt.machinelearningservices.models.EntityKind
    :ivar annotations:
    :vartype annotations: ~azure.mgmt.machinelearningservices.models.IndexAnnotations
    :ivar properties:
    :vartype properties: ~azure.mgmt.machinelearningservices.models.IndexProperties
    :ivar internal: Dictionary of :code:`<any>`.
    :vartype internal: dict[str, any]
    :ivar update_sequence:
    :vartype update_sequence: long
    :ivar type:
    :vartype type: str
    :ivar version:
    :vartype version: str
    :ivar entity_container_id:
    :vartype entity_container_id: str
    :ivar entity_object_id:
    :vartype entity_object_id: str
    :ivar resource_type:
    :vartype resource_type: str
    :ivar relationships:
    :vartype relationships: list[~azure.mgmt.machinelearningservices.models.Relationship]
    :ivar asset_id:
    :vartype asset_id: str
    """

    _validation = {
        'version': {'readonly': True},
        'entity_container_id': {'readonly': True},
        'entity_object_id': {'readonly': True},
        'resource_type': {'readonly': True},
    }

    _attribute_map = {
        'schema_id': {'key': 'schemaId', 'type': 'str'},
        'entity_id': {'key': 'entityId', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': 'IndexAnnotations'},
        'properties': {'key': 'properties', 'type': 'IndexProperties'},
        'internal': {'key': 'internal', 'type': '{object}'},
        'update_sequence': {'key': 'updateSequence', 'type': 'long'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'entity_container_id': {'key': 'entityContainerId', 'type': 'str'},
        'entity_object_id': {'key': 'entityObjectId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'relationships': {'key': 'relationships', 'type': '[Relationship]'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        schema_id: Optional[str] = None,
        entity_id: Optional[str] = None,
        kind: Optional[Union[str, "EntityKind"]] = None,
        annotations: Optional["IndexAnnotations"] = None,
        properties: Optional["IndexProperties"] = None,
        internal: Optional[Dict[str, Any]] = None,
        update_sequence: Optional[int] = None,
        type: Optional[str] = None,
        relationships: Optional[List["Relationship"]] = None,
        asset_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword schema_id:
        :paramtype schema_id: str
        :keyword entity_id:
        :paramtype entity_id: str
        :keyword kind: Possible values include: "Invalid", "LineageRoot", "Versioned", "Unversioned".
        :paramtype kind: str or ~azure.mgmt.machinelearningservices.models.EntityKind
        :keyword annotations:
        :paramtype annotations: ~azure.mgmt.machinelearningservices.models.IndexAnnotations
        :keyword properties:
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.IndexProperties
        :keyword internal: Dictionary of :code:`<any>`.
        :paramtype internal: dict[str, any]
        :keyword update_sequence:
        :paramtype update_sequence: long
        :keyword type:
        :paramtype type: str
        :keyword relationships:
        :paramtype relationships: list[~azure.mgmt.machinelearningservices.models.Relationship]
        :keyword asset_id:
        :paramtype asset_id: str
        """
        super(IndexEntity, self).__init__(**kwargs)
        self.schema_id = schema_id
        self.entity_id = entity_id
        self.kind = kind
        self.annotations = annotations
        self.properties = properties
        self.internal = internal
        self.update_sequence = update_sequence
        self.type = type
        self.version = None
        self.entity_container_id = None
        self.entity_object_id = None
        self.resource_type = None
        self.relationships = relationships
        self.asset_id = asset_id


class IndexProperties(msrest.serialization.Model):
    """IndexProperties.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar creation_context:
    :vartype creation_context: ~azure.mgmt.machinelearningservices.models.CreationContext
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'creation_context': {'key': 'creationContext', 'type': 'CreationContext'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        creation_context: Optional["CreationContext"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword creation_context:
        :paramtype creation_context: ~azure.mgmt.machinelearningservices.models.CreationContext
        """
        super(IndexProperties, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.creation_context = creation_context


class InnerErrorDetails(msrest.serialization.Model):
    """InnerErrorDetails.

    :ivar code:
    :vartype code: str
    :ivar message:
    :vartype message: str
    :ivar target:
    :vartype target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code:
        :paramtype code: str
        :keyword message:
        :paramtype message: str
        :keyword target:
        :paramtype target: str
        """
        super(InnerErrorDetails, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class IntellectualPropertyPublisherInformation(msrest.serialization.Model):
    """IntellectualPropertyPublisherInformation.

    :ivar intellectual_property_publisher:
    :vartype intellectual_property_publisher: str
    """

    _attribute_map = {
        'intellectual_property_publisher': {'key': 'intellectualPropertyPublisher', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        intellectual_property_publisher: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword intellectual_property_publisher:
        :paramtype intellectual_property_publisher: str
        """
        super(IntellectualPropertyPublisherInformation, self).__init__(**kwargs)
        self.intellectual_property_publisher = intellectual_property_publisher


class ListModelsRequest(msrest.serialization.Model):
    """ListModelsRequest.

    :ivar name:
    :vartype name: str
    :ivar tag:
    :vartype tag: str
    :ivar version:
    :vartype version: str
    :ivar framework:
    :vartype framework: str
    :ivar description:
    :vartype description: str
    :ivar count:
    :vartype count: int
    :ivar offset:
    :vartype offset: int
    :ivar skip_token:
    :vartype skip_token: str
    :ivar tags: A set of tags.
    :vartype tags: str
    :ivar properties:
    :vartype properties: str
    :ivar run_id:
    :vartype run_id: str
    :ivar dataset_id:
    :vartype dataset_id: str
    :ivar order_by: Possible values include: "CreatedAtDesc", "CreatedAtAsc", "UpdatedAtDesc",
     "UpdatedAtAsc".
    :vartype order_by: str or ~azure.mgmt.machinelearningservices.models.OrderString
    :ivar latest_version_only:
    :vartype latest_version_only: bool
    :ivar modified_after:
    :vartype modified_after: ~datetime.datetime
    :ivar modified_before:
    :vartype modified_before: ~datetime.datetime
    :ivar list_view_type: Possible values include: "ActiveOnly", "ArchivedOnly", "All".
    :vartype list_view_type: str or ~azure.mgmt.machinelearningservices.models.ListViewType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'framework': {'key': 'framework', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'offset': {'key': 'offset', 'type': 'int'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
        'tags': {'key': 'tags', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
        'dataset_id': {'key': 'datasetId', 'type': 'str'},
        'order_by': {'key': 'orderBy', 'type': 'str'},
        'latest_version_only': {'key': 'latestVersionOnly', 'type': 'bool'},
        'modified_after': {'key': 'modifiedAfter', 'type': 'iso-8601'},
        'modified_before': {'key': 'modifiedBefore', 'type': 'iso-8601'},
        'list_view_type': {'key': 'listViewType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tag: Optional[str] = None,
        version: Optional[str] = None,
        framework: Optional[str] = None,
        description: Optional[str] = None,
        count: Optional[int] = None,
        offset: Optional[int] = None,
        skip_token: Optional[str] = None,
        tags: Optional[str] = None,
        properties: Optional[str] = None,
        run_id: Optional[str] = None,
        dataset_id: Optional[str] = None,
        order_by: Optional[Union[str, "OrderString"]] = None,
        latest_version_only: Optional[bool] = None,
        modified_after: Optional[datetime.datetime] = None,
        modified_before: Optional[datetime.datetime] = None,
        list_view_type: Optional[Union[str, "ListViewType"]] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword tag:
        :paramtype tag: str
        :keyword version:
        :paramtype version: str
        :keyword framework:
        :paramtype framework: str
        :keyword description:
        :paramtype description: str
        :keyword count:
        :paramtype count: int
        :keyword offset:
        :paramtype offset: int
        :keyword skip_token:
        :paramtype skip_token: str
        :keyword tags: A set of tags.
        :paramtype tags: str
        :keyword properties:
        :paramtype properties: str
        :keyword run_id:
        :paramtype run_id: str
        :keyword dataset_id:
        :paramtype dataset_id: str
        :keyword order_by: Possible values include: "CreatedAtDesc", "CreatedAtAsc", "UpdatedAtDesc",
         "UpdatedAtAsc".
        :paramtype order_by: str or ~azure.mgmt.machinelearningservices.models.OrderString
        :keyword latest_version_only:
        :paramtype latest_version_only: bool
        :keyword modified_after:
        :paramtype modified_after: ~datetime.datetime
        :keyword modified_before:
        :paramtype modified_before: ~datetime.datetime
        :keyword list_view_type: Possible values include: "ActiveOnly", "ArchivedOnly", "All".
        :paramtype list_view_type: str or ~azure.mgmt.machinelearningservices.models.ListViewType
        """
        super(ListModelsRequest, self).__init__(**kwargs)
        self.name = name
        self.tag = tag
        self.version = version
        self.framework = framework
        self.description = description
        self.count = count
        self.offset = offset
        self.skip_token = skip_token
        self.tags = tags
        self.properties = properties
        self.run_id = run_id
        self.dataset_id = dataset_id
        self.order_by = order_by
        self.latest_version_only = latest_version_only
        self.modified_after = modified_after
        self.modified_before = modified_before
        self.list_view_type = list_view_type


class Model(msrest.serialization.Model):
    """Model.

    All required parameters must be populated in order to send to Azure.

    :ivar id:
    :vartype id: str
    :ivar name: Required.
    :vartype name: str
    :ivar framework:
    :vartype framework: str
    :ivar framework_version:
    :vartype framework_version: str
    :ivar version:
    :vartype version: long
    :ivar tags: A set of tags.
    :vartype tags: list[str]
    :ivar datasets:
    :vartype datasets: list[~azure.mgmt.machinelearningservices.models.DatasetReference]
    :ivar url:
    :vartype url: str
    :ivar mime_type: Required.
    :vartype mime_type: str
    :ivar description:
    :vartype description: str
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    :ivar modified_time:
    :vartype modified_time: ~datetime.datetime
    :ivar unpack:
    :vartype unpack: bool
    :ivar parent_model_id:
    :vartype parent_model_id: str
    :ivar run_id:
    :vartype run_id: str
    :ivar experiment_name:
    :vartype experiment_name: str
    :ivar kv_tags: Dictionary of :code:`<string>`.
    :vartype kv_tags: dict[str, str]
    :ivar properties: Dictionary of :code:`<string>`.
    :vartype properties: dict[str, str]
    :ivar derived_model_ids:
    :vartype derived_model_ids: list[str]
    :ivar inputs_schema:
    :vartype inputs_schema: list[~azure.mgmt.machinelearningservices.models.ModelSchema]
    :ivar outputs_schema:
    :vartype outputs_schema: list[~azure.mgmt.machinelearningservices.models.ModelSchema]
    :ivar sample_input_data:
    :vartype sample_input_data: str
    :ivar sample_output_data:
    :vartype sample_output_data: str
    :ivar resource_requirements:
    :vartype resource_requirements:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
    :ivar created_by:
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.User
    :ivar modified_by:
    :vartype modified_by: ~azure.mgmt.machinelearningservices.models.User
    :ivar flavors: Dictionary of
     <components·8urbg9·schemas·model·properties·flavors·additionalproperties>.
    :vartype flavors: dict[str, dict[str, str]]
    :ivar model_format: Possible values include: "CUSTOM", "MLFLOW", "TRITON", "PRESETS".
    :vartype model_format: str or ~azure.mgmt.machinelearningservices.models.ModelFormatEnum
    :ivar stage:
    :vartype stage: str
    :ivar model_container_id:
    :vartype model_container_id: str
    :ivar mms_id:
    :vartype mms_id: str
    :ivar default_deployment_settings:
    :vartype default_deployment_settings:
     ~azure.mgmt.machinelearningservices.models.ModelDeploymentSettings
    :ivar is_anonymous:
    :vartype is_anonymous: bool
    :ivar is_archived:
    :vartype is_archived: bool
    :ivar is_registered:
    :vartype is_registered: bool
    :ivar data_path:
    :vartype data_path: str
    :ivar model_type:
    :vartype model_type: str
    :ivar asset_id:
    :vartype asset_id: str
    """

    _validation = {
        'name': {'required': True},
        'mime_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'framework': {'key': 'framework', 'type': 'str'},
        'framework_version': {'key': 'frameworkVersion', 'type': 'str'},
        'version': {'key': 'version', 'type': 'long'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'datasets': {'key': 'datasets', 'type': '[DatasetReference]'},
        'url': {'key': 'url', 'type': 'str'},
        'mime_type': {'key': 'mimeType', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'unpack': {'key': 'unpack', 'type': 'bool'},
        'parent_model_id': {'key': 'parentModelId', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'kv_tags': {'key': 'kvTags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'derived_model_ids': {'key': 'derivedModelIds', 'type': '[str]'},
        'inputs_schema': {'key': 'inputsSchema', 'type': '[ModelSchema]'},
        'outputs_schema': {'key': 'outputsSchema', 'type': '[ModelSchema]'},
        'sample_input_data': {'key': 'sampleInputData', 'type': 'str'},
        'sample_output_data': {'key': 'sampleOutputData', 'type': 'str'},
        'resource_requirements': {'key': 'resourceRequirements', 'type': 'ContainerResourceRequirements'},
        'created_by': {'key': 'createdBy', 'type': 'User'},
        'modified_by': {'key': 'modifiedBy', 'type': 'User'},
        'flavors': {'key': 'flavors', 'type': '{{str}}'},
        'model_format': {'key': 'modelFormat', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
        'model_container_id': {'key': 'modelContainerId', 'type': 'str'},
        'mms_id': {'key': 'mmsId', 'type': 'str'},
        'default_deployment_settings': {'key': 'defaultDeploymentSettings', 'type': 'ModelDeploymentSettings'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'is_registered': {'key': 'isRegistered', 'type': 'bool'},
        'data_path': {'key': 'dataPath', 'type': 'str'},
        'model_type': {'key': 'modelType', 'type': 'str'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        mime_type: str,
        id: Optional[str] = None,
        framework: Optional[str] = None,
        framework_version: Optional[str] = None,
        version: Optional[int] = None,
        tags: Optional[List[str]] = None,
        datasets: Optional[List["DatasetReference"]] = None,
        url: Optional[str] = None,
        description: Optional[str] = None,
        created_time: Optional[datetime.datetime] = None,
        modified_time: Optional[datetime.datetime] = None,
        unpack: Optional[bool] = None,
        parent_model_id: Optional[str] = None,
        run_id: Optional[str] = None,
        experiment_name: Optional[str] = None,
        kv_tags: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        derived_model_ids: Optional[List[str]] = None,
        inputs_schema: Optional[List["ModelSchema"]] = None,
        outputs_schema: Optional[List["ModelSchema"]] = None,
        sample_input_data: Optional[str] = None,
        sample_output_data: Optional[str] = None,
        resource_requirements: Optional["ContainerResourceRequirements"] = None,
        created_by: Optional["User"] = None,
        modified_by: Optional["User"] = None,
        flavors: Optional[Dict[str, Dict[str, str]]] = None,
        model_format: Optional[Union[str, "ModelFormatEnum"]] = None,
        stage: Optional[str] = None,
        model_container_id: Optional[str] = None,
        mms_id: Optional[str] = None,
        default_deployment_settings: Optional["ModelDeploymentSettings"] = None,
        is_anonymous: Optional[bool] = None,
        is_archived: Optional[bool] = None,
        is_registered: Optional[bool] = None,
        data_path: Optional[str] = None,
        model_type: Optional[str] = None,
        asset_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name: Required.
        :paramtype name: str
        :keyword framework:
        :paramtype framework: str
        :keyword framework_version:
        :paramtype framework_version: str
        :keyword version:
        :paramtype version: long
        :keyword tags: A set of tags.
        :paramtype tags: list[str]
        :keyword datasets:
        :paramtype datasets: list[~azure.mgmt.machinelearningservices.models.DatasetReference]
        :keyword url:
        :paramtype url: str
        :keyword mime_type: Required.
        :paramtype mime_type: str
        :keyword description:
        :paramtype description: str
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time:
        :paramtype modified_time: ~datetime.datetime
        :keyword unpack:
        :paramtype unpack: bool
        :keyword parent_model_id:
        :paramtype parent_model_id: str
        :keyword run_id:
        :paramtype run_id: str
        :keyword experiment_name:
        :paramtype experiment_name: str
        :keyword kv_tags: Dictionary of :code:`<string>`.
        :paramtype kv_tags: dict[str, str]
        :keyword properties: Dictionary of :code:`<string>`.
        :paramtype properties: dict[str, str]
        :keyword derived_model_ids:
        :paramtype derived_model_ids: list[str]
        :keyword inputs_schema:
        :paramtype inputs_schema: list[~azure.mgmt.machinelearningservices.models.ModelSchema]
        :keyword outputs_schema:
        :paramtype outputs_schema: list[~azure.mgmt.machinelearningservices.models.ModelSchema]
        :keyword sample_input_data:
        :paramtype sample_input_data: str
        :keyword sample_output_data:
        :paramtype sample_output_data: str
        :keyword resource_requirements:
        :paramtype resource_requirements:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
        :keyword created_by:
        :paramtype created_by: ~azure.mgmt.machinelearningservices.models.User
        :keyword modified_by:
        :paramtype modified_by: ~azure.mgmt.machinelearningservices.models.User
        :keyword flavors: Dictionary of
         <components·8urbg9·schemas·model·properties·flavors·additionalproperties>.
        :paramtype flavors: dict[str, dict[str, str]]
        :keyword model_format: Possible values include: "CUSTOM", "MLFLOW", "TRITON", "PRESETS".
        :paramtype model_format: str or ~azure.mgmt.machinelearningservices.models.ModelFormatEnum
        :keyword stage:
        :paramtype stage: str
        :keyword model_container_id:
        :paramtype model_container_id: str
        :keyword mms_id:
        :paramtype mms_id: str
        :keyword default_deployment_settings:
        :paramtype default_deployment_settings:
         ~azure.mgmt.machinelearningservices.models.ModelDeploymentSettings
        :keyword is_anonymous:
        :paramtype is_anonymous: bool
        :keyword is_archived:
        :paramtype is_archived: bool
        :keyword is_registered:
        :paramtype is_registered: bool
        :keyword data_path:
        :paramtype data_path: str
        :keyword model_type:
        :paramtype model_type: str
        :keyword asset_id:
        :paramtype asset_id: str
        """
        super(Model, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.framework = framework
        self.framework_version = framework_version
        self.version = version
        self.tags = tags
        self.datasets = datasets
        self.url = url
        self.mime_type = mime_type
        self.description = description
        self.created_time = created_time
        self.modified_time = modified_time
        self.unpack = unpack
        self.parent_model_id = parent_model_id
        self.run_id = run_id
        self.experiment_name = experiment_name
        self.kv_tags = kv_tags
        self.properties = properties
        self.derived_model_ids = derived_model_ids
        self.inputs_schema = inputs_schema
        self.outputs_schema = outputs_schema
        self.sample_input_data = sample_input_data
        self.sample_output_data = sample_output_data
        self.resource_requirements = resource_requirements
        self.created_by = created_by
        self.modified_by = modified_by
        self.flavors = flavors
        self.model_format = model_format
        self.stage = stage
        self.model_container_id = model_container_id
        self.mms_id = mms_id
        self.default_deployment_settings = default_deployment_settings
        self.is_anonymous = is_anonymous
        self.is_archived = is_archived
        self.is_registered = is_registered
        self.data_path = data_path
        self.model_type = model_type
        self.asset_id = asset_id


class ModelBatchDto(msrest.serialization.Model):
    """ModelBatchDto.

    :ivar model_ids:
    :vartype model_ids: list[str]
    """

    _attribute_map = {
        'model_ids': {'key': 'modelIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        model_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword model_ids:
        :paramtype model_ids: list[str]
        """
        super(ModelBatchDto, self).__init__(**kwargs)
        self.model_ids = model_ids


class ModelBatchResponseDto(msrest.serialization.Model):
    """ModelBatchResponseDto.

    :ivar models: Dictionary of :code:`<Model>`.
    :vartype models: dict[str, ~azure.mgmt.machinelearningservices.models.Model]
    """

    _attribute_map = {
        'models': {'key': 'models', 'type': '{Model}'},
    }

    def __init__(
        self,
        *,
        models: Optional[Dict[str, "Model"]] = None,
        **kwargs
    ):
        """
        :keyword models: Dictionary of :code:`<Model>`.
        :paramtype models: dict[str, ~azure.mgmt.machinelearningservices.models.Model]
        """
        super(ModelBatchResponseDto, self).__init__(**kwargs)
        self.models = models


class ModelContainerRequest(msrest.serialization.Model):
    """ModelContainerRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar description:
    :vartype description: str
    :ivar kv_tags: Dictionary of :code:`<string>`.
    :vartype kv_tags: dict[str, str]
    :ivar is_archived:
    :vartype is_archived: bool
    :ivar is_registered:
    :vartype is_registered: bool
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'kv_tags': {'key': 'kvTags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'is_registered': {'key': 'isRegistered', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        kv_tags: Optional[Dict[str, str]] = None,
        is_archived: Optional[bool] = None,
        is_registered: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword description:
        :paramtype description: str
        :keyword kv_tags: Dictionary of :code:`<string>`.
        :paramtype kv_tags: dict[str, str]
        :keyword is_archived:
        :paramtype is_archived: bool
        :keyword is_registered:
        :paramtype is_registered: bool
        """
        super(ModelContainerRequest, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.kv_tags = kv_tags
        self.is_archived = is_archived
        self.is_registered = is_registered


class ModelDeploymentSettings(msrest.serialization.Model):
    """ModelDeploymentSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar model_format: Required. Possible values include: "CUSTOM", "MLFLOW", "TRITON", "PRESETS".
    :vartype model_format: str or ~azure.mgmt.machinelearningservices.models.ModelFormatEnum
    :ivar model_name:
    :vartype model_name: str
    :ivar model_version:
    :vartype model_version: str
    :ivar model_type:
    :vartype model_type: str
    """

    _validation = {
        'model_format': {'required': True},
    }

    _attribute_map = {
        'model_format': {'key': 'modelFormat', 'type': 'str'},
        'model_name': {'key': 'ModelName', 'type': 'str'},
        'model_version': {'key': 'ModelVersion', 'type': 'str'},
        'model_type': {'key': 'ModelType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        model_format: Union[str, "ModelFormatEnum"],
        model_name: Optional[str] = None,
        model_version: Optional[str] = None,
        model_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword model_format: Required. Possible values include: "CUSTOM", "MLFLOW", "TRITON",
         "PRESETS".
        :paramtype model_format: str or ~azure.mgmt.machinelearningservices.models.ModelFormatEnum
        :keyword model_name:
        :paramtype model_name: str
        :keyword model_version:
        :paramtype model_version: str
        :keyword model_type:
        :paramtype model_type: str
        """
        super(ModelDeploymentSettings, self).__init__(**kwargs)
        self.model_format = model_format
        self.model_name = model_name
        self.model_version = model_version
        self.model_type = model_type


class ModelListModelsRequestPagedResponse(msrest.serialization.Model):
    """ModelListModelsRequestPagedResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Model]
    :ivar next_link:
    :vartype next_link: str
    :ivar continuation_token:
    :vartype continuation_token: str
    :ivar next_request:
    :vartype next_request: ~azure.mgmt.machinelearningservices.models.ListModelsRequest
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Model]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_request': {'key': 'nextRequest', 'type': 'ListModelsRequest'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Model"]] = None,
        next_link: Optional[str] = None,
        continuation_token: Optional[str] = None,
        next_request: Optional["ListModelsRequest"] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Model]
        :keyword next_link:
        :paramtype next_link: str
        :keyword continuation_token:
        :paramtype continuation_token: str
        :keyword next_request:
        :paramtype next_request: ~azure.mgmt.machinelearningservices.models.ListModelsRequest
        """
        super(ModelListModelsRequestPagedResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link
        self.continuation_token = continuation_token
        self.next_request = next_request


class ModelPagedResponse(msrest.serialization.Model):
    """ModelPagedResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Model]
    :ivar continuation_token:
    :vartype continuation_token: str
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Model]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Model"]] = None,
        continuation_token: Optional[str] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Model]
        :keyword continuation_token:
        :paramtype continuation_token: str
        :keyword next_link:
        :paramtype next_link: str
        """
        super(ModelPagedResponse, self).__init__(**kwargs)
        self.value = value
        self.continuation_token = continuation_token
        self.next_link = next_link


class ModelPathResponseDto(msrest.serialization.Model):
    """ModelPathResponseDto.

    :ivar path:
    :vartype path: str
    :ivar type:
    :vartype type: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword path:
        :paramtype path: str
        :keyword type:
        :paramtype type: str
        """
        super(ModelPathResponseDto, self).__init__(**kwargs)
        self.path = path
        self.type = type


class ModelSchema(msrest.serialization.Model):
    """ModelSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar data_type: Possible values include: "undefined", "bool", "uint8", "uint16", "uint32",
     "uint64", "int8", "int16", "int32", "int64", "float16", "float32", "float64", "bfloat16",
     "complex64", "complex128", "string".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.ModelSchemaDataType
    :ivar shape:
    :vartype shape: list[int]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'shape': {'key': 'shape', 'type': '[int]'},
    }

    def __init__(
        self,
        *,
        name: str,
        data_type: Optional[Union[str, "ModelSchemaDataType"]] = None,
        shape: Optional[List[int]] = None,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword data_type: Possible values include: "undefined", "bool", "uint8", "uint16", "uint32",
         "uint64", "int8", "int16", "int32", "int64", "float16", "float32", "float64", "bfloat16",
         "complex64", "complex128", "string".
        :paramtype data_type: str or ~azure.mgmt.machinelearningservices.models.ModelSchemaDataType
        :keyword shape:
        :paramtype shape: list[int]
        """
        super(ModelSchema, self).__init__(**kwargs)
        self.name = name
        self.data_type = data_type
        self.shape = shape


class ModelSettingsIdentifiers(msrest.serialization.Model):
    """ModelSettingsIdentifiers.

    :ivar model_id:
    :vartype model_id: str
    :ivar engine_id:
    :vartype engine_id: str
    """

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'engine_id': {'key': 'engineId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        model_id: Optional[str] = None,
        engine_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword model_id:
        :paramtype model_id: str
        :keyword engine_id:
        :paramtype engine_id: str
        """
        super(ModelSettingsIdentifiers, self).__init__(**kwargs)
        self.model_id = model_id
        self.engine_id = engine_id


class Operation(msrest.serialization.Model):
    """Operation.

    :ivar value: Anything.
    :vartype value: any
    :ivar path:
    :vartype path: str
    :ivar op:
    :vartype op: str
    :ivar from_property:
    :vartype from_property: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'object'},
        'path': {'key': 'path', 'type': 'str'},
        'op': {'key': 'op', 'type': 'str'},
        'from_property': {'key': 'from', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[Any] = None,
        path: Optional[str] = None,
        op: Optional[str] = None,
        from_property: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Anything.
        :paramtype value: any
        :keyword path:
        :paramtype path: str
        :keyword op:
        :paramtype op: str
        :keyword from_property:
        :paramtype from_property: str
        """
        super(Operation, self).__init__(**kwargs)
        self.value = value
        self.path = path
        self.op = op
        self.from_property = from_property


class ProviderFeedEntityRequestDto(msrest.serialization.Model):
    """ProviderFeedEntityRequestDto.

    :ivar source_and_target_asset_ids:
    :vartype source_and_target_asset_ids:
     ~azure.mgmt.machinelearningservices.models.DependencyMapItemDto
    :ivar dependency_map_dto:
    :vartype dependency_map_dto: ~azure.mgmt.machinelearningservices.models.DependencyMapDto
    :ivar label_to_version_mapping: Dictionary of :code:`<string>`.
    :vartype label_to_version_mapping: dict[str, str]
    """

    _attribute_map = {
        'source_and_target_asset_ids': {'key': 'sourceAndTargetAssetIds', 'type': 'DependencyMapItemDto'},
        'dependency_map_dto': {'key': 'dependencyMapDto', 'type': 'DependencyMapDto'},
        'label_to_version_mapping': {'key': 'labelToVersionMapping', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        source_and_target_asset_ids: Optional["DependencyMapItemDto"] = None,
        dependency_map_dto: Optional["DependencyMapDto"] = None,
        label_to_version_mapping: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword source_and_target_asset_ids:
        :paramtype source_and_target_asset_ids:
         ~azure.mgmt.machinelearningservices.models.DependencyMapItemDto
        :keyword dependency_map_dto:
        :paramtype dependency_map_dto: ~azure.mgmt.machinelearningservices.models.DependencyMapDto
        :keyword label_to_version_mapping: Dictionary of :code:`<string>`.
        :paramtype label_to_version_mapping: dict[str, str]
        """
        super(ProviderFeedEntityRequestDto, self).__init__(**kwargs)
        self.source_and_target_asset_ids = source_and_target_asset_ids
        self.dependency_map_dto = dependency_map_dto
        self.label_to_version_mapping = label_to_version_mapping


class Relationship(msrest.serialization.Model):
    """Relationship.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar relation_type:
    :vartype relation_type: str
    :ivar target_entity_id:
    :vartype target_entity_id: str
    :ivar asset_id:
    :vartype asset_id: str
    :ivar entity_type:
    :vartype entity_type: str
    :ivar direction:
    :vartype direction: str
    :ivar entity_container_id:
    :vartype entity_container_id: str
    """

    _validation = {
        'entity_type': {'readonly': True},
        'entity_container_id': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'relation_type': {'key': 'relationType', 'type': 'str'},
        'target_entity_id': {'key': 'targetEntityId', 'type': 'str'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'entity_type': {'key': 'entityType', 'type': 'str'},
        'direction': {'key': 'direction', 'type': 'str'},
        'entity_container_id': {'key': 'entityContainerId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        relation_type: Optional[str] = None,
        target_entity_id: Optional[str] = None,
        asset_id: Optional[str] = None,
        direction: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword relation_type:
        :paramtype relation_type: str
        :keyword target_entity_id:
        :paramtype target_entity_id: str
        :keyword asset_id:
        :paramtype asset_id: str
        :keyword direction:
        :paramtype direction: str
        """
        super(Relationship, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.relation_type = relation_type
        self.target_entity_id = target_entity_id
        self.asset_id = asset_id
        self.entity_type = None
        self.direction = direction
        self.entity_container_id = None


class ServiceResponseBase(msrest.serialization.Model):
    """ServiceResponseBase.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar description:
    :vartype description: str
    :ivar tags: A set of tags.
    :vartype tags: list[str]
    :ivar kv_tags: Dictionary of :code:`<string>`.
    :vartype kv_tags: dict[str, str]
    :ivar properties: Dictionary of :code:`<string>`.
    :vartype properties: dict[str, str]
    :ivar operation_id:
    :vartype operation_id: str
    :ivar state: Possible values include: "Transitioning", "Healthy", "Unhealthy", "Failed",
     "Unschedulable".
    :vartype state: str or ~azure.mgmt.machinelearningservices.models.WebServiceState
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    :ivar updated_time:
    :vartype updated_time: ~datetime.datetime
    :ivar error:
    :vartype error: ~azure.mgmt.machinelearningservices.models.ErrorResponse
    :ivar compute_type: Possible values include: "ACS", "FPGA", "ACI", "AKS", "AMLCOMPUTE", "IOT",
     "MIR", "AKSENDPOINT", "MIRSINGLEMODEL", "MIRAMLCOMPUTE", "MIRGA", "AMLARC", "BATCHAMLCOMPUTE",
     "UNKNOWN".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeEnvironmentType
    :ivar deployment_type: Possible values include: "GRPCRealtimeEndpoint", "HttpRealtimeEndpoint",
     "Batch".
    :vartype deployment_type: str or ~azure.mgmt.machinelearningservices.models.DeploymentType
    :ivar created_by:
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.User
    :ivar endpoint_name:
    :vartype endpoint_name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'kv_tags': {'key': 'kvTags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'updated_time': {'key': 'updatedTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'deployment_type': {'key': 'deploymentType', 'type': 'str'},
        'created_by': {'key': 'createdBy', 'type': 'User'},
        'endpoint_name': {'key': 'endpointName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        tags: Optional[List[str]] = None,
        kv_tags: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        operation_id: Optional[str] = None,
        state: Optional[Union[str, "WebServiceState"]] = None,
        created_time: Optional[datetime.datetime] = None,
        updated_time: Optional[datetime.datetime] = None,
        error: Optional["ErrorResponse"] = None,
        compute_type: Optional[Union[str, "ComputeEnvironmentType"]] = None,
        deployment_type: Optional[Union[str, "DeploymentType"]] = None,
        created_by: Optional["User"] = None,
        endpoint_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name:
        :paramtype name: str
        :keyword description:
        :paramtype description: str
        :keyword tags: A set of tags.
        :paramtype tags: list[str]
        :keyword kv_tags: Dictionary of :code:`<string>`.
        :paramtype kv_tags: dict[str, str]
        :keyword properties: Dictionary of :code:`<string>`.
        :paramtype properties: dict[str, str]
        :keyword operation_id:
        :paramtype operation_id: str
        :keyword state: Possible values include: "Transitioning", "Healthy", "Unhealthy", "Failed",
         "Unschedulable".
        :paramtype state: str or ~azure.mgmt.machinelearningservices.models.WebServiceState
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        :keyword updated_time:
        :paramtype updated_time: ~datetime.datetime
        :keyword error:
        :paramtype error: ~azure.mgmt.machinelearningservices.models.ErrorResponse
        :keyword compute_type: Possible values include: "ACS", "FPGA", "ACI", "AKS", "AMLCOMPUTE",
         "IOT", "MIR", "AKSENDPOINT", "MIRSINGLEMODEL", "MIRAMLCOMPUTE", "MIRGA", "AMLARC",
         "BATCHAMLCOMPUTE", "UNKNOWN".
        :paramtype compute_type: str or
         ~azure.mgmt.machinelearningservices.models.ComputeEnvironmentType
        :keyword deployment_type: Possible values include: "GRPCRealtimeEndpoint",
         "HttpRealtimeEndpoint", "Batch".
        :paramtype deployment_type: str or ~azure.mgmt.machinelearningservices.models.DeploymentType
        :keyword created_by:
        :paramtype created_by: ~azure.mgmt.machinelearningservices.models.User
        :keyword endpoint_name:
        :paramtype endpoint_name: str
        """
        super(ServiceResponseBase, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.tags = tags
        self.kv_tags = kv_tags
        self.properties = properties
        self.operation_id = operation_id
        self.state = state
        self.created_time = created_time
        self.updated_time = updated_time
        self.error = error
        self.compute_type = compute_type
        self.deployment_type = deployment_type
        self.created_by = created_by
        self.endpoint_name = endpoint_name


class User(msrest.serialization.Model):
    """User.

    :ivar user_object_id:
    :vartype user_object_id: str
    :ivar user_pu_id:
    :vartype user_pu_id: str
    :ivar user_idp:
    :vartype user_idp: str
    :ivar user_alt_sec_id:
    :vartype user_alt_sec_id: str
    :ivar user_iss:
    :vartype user_iss: str
    :ivar user_tenant_id:
    :vartype user_tenant_id: str
    :ivar user_name:
    :vartype user_name: str
    :ivar upn:
    :vartype upn: str
    """

    _attribute_map = {
        'user_object_id': {'key': 'userObjectId', 'type': 'str'},
        'user_pu_id': {'key': 'userPuId', 'type': 'str'},
        'user_idp': {'key': 'userIdp', 'type': 'str'},
        'user_alt_sec_id': {'key': 'userAltSecId', 'type': 'str'},
        'user_iss': {'key': 'userIss', 'type': 'str'},
        'user_tenant_id': {'key': 'userTenantId', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'upn': {'key': 'upn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_object_id: Optional[str] = None,
        user_pu_id: Optional[str] = None,
        user_idp: Optional[str] = None,
        user_alt_sec_id: Optional[str] = None,
        user_iss: Optional[str] = None,
        user_tenant_id: Optional[str] = None,
        user_name: Optional[str] = None,
        upn: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_object_id:
        :paramtype user_object_id: str
        :keyword user_pu_id:
        :paramtype user_pu_id: str
        :keyword user_idp:
        :paramtype user_idp: str
        :keyword user_alt_sec_id:
        :paramtype user_alt_sec_id: str
        :keyword user_iss:
        :paramtype user_iss: str
        :keyword user_tenant_id:
        :paramtype user_tenant_id: str
        :keyword user_name:
        :paramtype user_name: str
        :keyword upn:
        :paramtype upn: str
        """
        super(User, self).__init__(**kwargs)
        self.user_object_id = user_object_id
        self.user_pu_id = user_pu_id
        self.user_idp = user_idp
        self.user_alt_sec_id = user_alt_sec_id
        self.user_iss = user_iss
        self.user_tenant_id = user_tenant_id
        self.user_name = user_name
        self.upn = upn
