# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DatabaseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Select the database if this is a database server. Leave blank or add Not Applicable for all
    other instances except the Database Instance.
    """

    ADABAS = "Adabas"
    """The type of Database- Adabas."""
    ORACLE = "Oracle"
    """The type of Database- Oracle."""
    SAP_MAX_DB = "SAPMaxDB"
    """The type of Database- SAPMaxDB."""
    DB2 = "Db2"
    """The type of Database- Db2."""
    SAPASE = "SAPASE"
    """The type of Database- SAPASE."""
    SQL_SERVER = "SQLServer"
    """The type of Database- SQLServer."""
    INFORMIX = "Informix"
    """The type of Database- Informix."""
    SAPDB = "SAPDB"
    """The type of Database- SAPDB."""
    HANA = "HANA"
    """The type of Database- HANA."""


class DataSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data source for this resource."""

    EXCEL = "Excel"
    """The type of DataSource- Excel."""
    NATIVE = "Native"
    """The type of DataSource- Native."""


class OperatingSystem(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This is Operating System on which the host server is running."""

    IBMAIX = "IBMAIX"
    """The type of Operating system- IBMAIX."""
    RED_HAT = "RedHat"
    """The type of Operating system- RedHat."""
    SUSE = "SUSE"
    """The type of Operating system- SUSE."""
    SOLARIS = "Solaris"
    """The type of Operating system- Solaris."""
    UNIX = "Unix"
    """The type of Operating system- Unix."""
    WINDOWS_SERVER = "WindowsServer"
    """The type of Operating system- WindowsServer."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the provisioning states."""

    SUCCEEDED = "Succeeded"
    """The provisioning state Succeeded."""
    UPDATING = "Updating"
    """The provisioning state Updating."""
    FAILED = "Failed"
    """The provisioning state Failed."""
    CREATING = "Creating"
    """The provisioning state Creating."""
    CANCELED = "Canceled"
    """The provisioning state Cancelled."""
    ACCEPTED = "Accepted"
    """The provisioning state Accepted."""
    DELETING = "Deleting"
    """The provisioning state Deleting."""
    UNKNOWN = "Unknown"
    """The provisioning state Unknown."""


class SapInstanceEnvironment(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Environment; PRD, QA, DEV, etc to which SAP system belongs to. Select from the list of
    available dropdown values.
    """

    PRODUCTION = "Production"
    """The type of Sap Instance Environment- Production."""
    PRE_PRODUCTION = "PreProduction"
    """The type of Sap Instance Environment- PreProduction."""
    TEST = "Test"
    """The type of Sap Instance Environment- Test."""
    QUALITY_ASSURANCE = "QualityAssurance"
    """The type of Sap Instance Environment- QualityAssurance."""
    DEVELOPMENT = "Development"
    """The type of Sap Instance Environment- Development."""
    SANDBOX = "Sandbox"
    """The type of Sap Instance Environment- Sandbox."""
    DISASTER_RECOVERY = "DisasterRecovery"
    """The type of Sap Instance Environment- DisasterRecovery."""
    TRAINING = "Training"
    """The type of Sap Instance Environment- Training."""


class SapInstanceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SAP instance type running on this machine, e.g., App, ASCS, DB, etc. Select from the list
    of available dropdown values. Only single server and distributed architectures are supported.
    """

    ASCS = "ASCS"
    """The type of Sap Instance- ASCS."""
    DB = "DB"
    """The type of Sap Instance- DB."""
    APP = "APP"
    """The type of Sap Instance- APP."""
    SCS = "SCS"
    """The type of Sap Instance- SCS."""
    WEBDISP = "WEBDISP"
    """The type of Sap Instance- WEBDISP."""


class Versions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The available API versions."""

    V2023_10_01_PREVIEW = "2023-10-01-preview"
    """The 2023-10-01-preview API version."""
