# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError
from . import models


class TextAnalyticsClientConfiguration(Configuration):
    """Configuration for TextAnalyticsClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param endpoint: Supported Cognitive Services endpoints (protocol and
     hostname, for example: https://westus.api.cognitive.microsoft.com).
    :type endpoint: str
    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    """

    def __init__(
            self, endpoint, credentials):

        if endpoint is None:
            raise ValueError("Parameter 'endpoint' must not be None.")
        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        base_url = '{Endpoint}/text/analytics/v2.1'

        super(TextAnalyticsClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-cognitiveservices-language-textanalytics/{}'.format(VERSION))

        self.endpoint = endpoint
        self.credentials = credentials


class TextAnalyticsClient(SDKClient):
    """The Text Analytics API is a suite of text analytics web services built with best-in-class Microsoft machine learning algorithms. The API can be used to analyze unstructured text for tasks such as sentiment analysis, key phrase extraction and language detection. No training data is needed to use this API; just bring your text data. This API uses advanced natural language processing techniques to deliver best in class predictions. Further documentation can be found in https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/overview

    :ivar config: Configuration for client.
    :vartype config: TextAnalyticsClientConfiguration

    :param endpoint: Supported Cognitive Services endpoints (protocol and
     hostname, for example: https://westus.api.cognitive.microsoft.com).
    :type endpoint: str
    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    """

    def __init__(
            self, endpoint, credentials):

        self.config = TextAnalyticsClientConfiguration(endpoint, credentials)
        super(TextAnalyticsClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = 'v2.1'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)


    def detect_language(
            self, show_stats=None, documents=None, custom_headers=None, raw=False, **operation_config):
        """The API returns the detected language and a numeric score between 0 and
        1.

        Scores close to 1 indicate 100% certainty that the identified language
        is true. A total of 120 languages are supported.

        :param show_stats: (optional) if set to true, response will contain
         input and document level statistics.
        :type show_stats: bool
        :param documents:
        :type documents:
         list[~azure.cognitiveservices.language.textanalytics.models.LanguageInput]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: LanguageBatchResult or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.language.textanalytics.models.LanguageBatchResult
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.cognitiveservices.language.textanalytics.models.ErrorResponseException>`
        """
        language_batch_input = None
        if documents is not None:
            language_batch_input = models.LanguageBatchInput(documents=documents)

        # Construct URL
        url = self.detect_language.metadata['url']
        path_format_arguments = {
            'Endpoint': self._serialize.url("self.config.endpoint", self.config.endpoint, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if show_stats is not None:
            query_parameters['showStats'] = self._serialize.query("show_stats", show_stats, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if language_batch_input is not None:
            body_content = self._serialize.body(language_batch_input, 'LanguageBatchInput')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('LanguageBatchResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    detect_language.metadata = {'url': '/languages'}

    def entities(
            self, show_stats=None, documents=None, custom_headers=None, raw=False, **operation_config):
        """The API returns a list of recognized entities in a given document.

        To get even more information on each recognized entity we recommend
        using the Bing Entity Search API by querying for the recognized
        entities names. See the <a
        href="https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/text-analytics-supported-languages">Supported
        languages in Text Analytics API</a> for the list of enabled languages.

        :param show_stats: (optional) if set to true, response will contain
         input and document level statistics.
        :type show_stats: bool
        :param documents:
        :type documents:
         list[~azure.cognitiveservices.language.textanalytics.models.MultiLanguageInput]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: EntitiesBatchResult or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.language.textanalytics.models.EntitiesBatchResult
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.cognitiveservices.language.textanalytics.models.ErrorResponseException>`
        """
        multi_language_batch_input = None
        if documents is not None:
            multi_language_batch_input = models.MultiLanguageBatchInput(documents=documents)

        # Construct URL
        url = self.entities.metadata['url']
        path_format_arguments = {
            'Endpoint': self._serialize.url("self.config.endpoint", self.config.endpoint, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if show_stats is not None:
            query_parameters['showStats'] = self._serialize.query("show_stats", show_stats, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if multi_language_batch_input is not None:
            body_content = self._serialize.body(multi_language_batch_input, 'MultiLanguageBatchInput')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('EntitiesBatchResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    entities.metadata = {'url': '/entities'}

    def key_phrases(
            self, show_stats=None, documents=None, custom_headers=None, raw=False, **operation_config):
        """The API returns a list of strings denoting the key talking points in
        the input text.

        See the <a
        href="https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/overview#supported-languages">Text
        Analytics Documentation</a> for details about the languages that are
        supported by key phrase extraction.

        :param show_stats: (optional) if set to true, response will contain
         input and document level statistics.
        :type show_stats: bool
        :param documents:
        :type documents:
         list[~azure.cognitiveservices.language.textanalytics.models.MultiLanguageInput]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: KeyPhraseBatchResult or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.language.textanalytics.models.KeyPhraseBatchResult
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.cognitiveservices.language.textanalytics.models.ErrorResponseException>`
        """
        multi_language_batch_input = None
        if documents is not None:
            multi_language_batch_input = models.MultiLanguageBatchInput(documents=documents)

        # Construct URL
        url = self.key_phrases.metadata['url']
        path_format_arguments = {
            'Endpoint': self._serialize.url("self.config.endpoint", self.config.endpoint, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if show_stats is not None:
            query_parameters['showStats'] = self._serialize.query("show_stats", show_stats, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if multi_language_batch_input is not None:
            body_content = self._serialize.body(multi_language_batch_input, 'MultiLanguageBatchInput')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('KeyPhraseBatchResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    key_phrases.metadata = {'url': '/keyPhrases'}

    def sentiment(
            self, show_stats=None, documents=None, custom_headers=None, raw=False, **operation_config):
        """The API returns a numeric score between 0 and 1.

        Scores close to 1 indicate positive sentiment, while scores close to 0
        indicate negative sentiment. A score of 0.5 indicates the lack of
        sentiment (e.g. a factoid statement). See the <a
        href="https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/overview#supported-languages">Text
        Analytics Documentation</a> for details about the languages that are
        supported by sentiment analysis.

        :param show_stats: (optional) if set to true, response will contain
         input and document level statistics.
        :type show_stats: bool
        :param documents:
        :type documents:
         list[~azure.cognitiveservices.language.textanalytics.models.MultiLanguageInput]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        multi_language_batch_input = None
        if documents is not None:
            multi_language_batch_input = models.MultiLanguageBatchInput(documents=documents)

        # Construct URL
        url = self.sentiment.metadata['url']
        path_format_arguments = {
            'Endpoint': self._serialize.url("self.config.endpoint", self.config.endpoint, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if show_stats is not None:
            query_parameters['showStats'] = self._serialize.query("show_stats", show_stats, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if multi_language_batch_input is not None:
            body_content = self._serialize.body(multi_language_batch_input, 'MultiLanguageBatchInput')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 500]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SentimentBatchResult', response)
        if response.status_code == 500:
            deserialized = self._deserialize('ErrorResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    sentiment.metadata = {'url': '/sentiment'}
