# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._cdn_management_client_enums import *


class CacheExpirationActionParameters(msrest.serialization.Model):
    """Defines the parameters for the cache expiration action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheExpirationActionParameters".
    :vartype odata_type: str
    :param cache_behavior: Required. Caching behavior for the requests. Possible values include:
     "BypassCache", "Override", "SetIfMissing".
    :type cache_behavior: str or ~azure.mgmt.cdn.models.CacheBehavior
    :param cache_type: Required. The level at which the content needs to be cached. Possible values
     include: "All".
    :type cache_type: str or ~azure.mgmt.cdn.models.CacheType
    :param cache_duration: The duration for which the content needs to be cached. Allowed format is
     [d.]hh:mm:ss.
    :type cache_duration: str
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'cache_behavior': {'required': True},
        'cache_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'cache_behavior': {'key': 'cacheBehavior', 'type': 'str'},
        'cache_type': {'key': 'cacheType', 'type': 'str'},
        'cache_duration': {'key': 'cacheDuration', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheExpirationActionParameters"

    def __init__(
        self,
        *,
        cache_behavior: Union[str, "CacheBehavior"],
        cache_type: Union[str, "CacheType"],
        cache_duration: Optional[str] = None,
        **kwargs
    ):
        super(CacheExpirationActionParameters, self).__init__(**kwargs)
        self.cache_behavior = cache_behavior
        self.cache_type = cache_type
        self.cache_duration = cache_duration


class CacheKeyQueryStringActionParameters(msrest.serialization.Model):
    """Defines the parameters for the cache-key query string action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheKeyQueryStringBehaviorActionParameters".
    :vartype odata_type: str
    :param query_string_behavior: Required. Caching behavior for the requests. Possible values
     include: "Include", "IncludeAll", "Exclude", "ExcludeAll".
    :type query_string_behavior: str or ~azure.mgmt.cdn.models.QueryStringBehavior
    :param query_parameters: query parameters to include or exclude (comma separated).
    :type query_parameters: str
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'query_string_behavior': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'query_string_behavior': {'key': 'queryStringBehavior', 'type': 'str'},
        'query_parameters': {'key': 'queryParameters', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheKeyQueryStringBehaviorActionParameters"

    def __init__(
        self,
        *,
        query_string_behavior: Union[str, "QueryStringBehavior"],
        query_parameters: Optional[str] = None,
        **kwargs
    ):
        super(CacheKeyQueryStringActionParameters, self).__init__(**kwargs)
        self.query_string_behavior = query_string_behavior
        self.query_parameters = query_parameters


class CdnCertificateSourceParameters(msrest.serialization.Model):
    """Defines the parameters for using CDN managed certificate for securing custom domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.CdnCertificateSourceParameters".
    :vartype odata_type: str
    :param certificate_type: Required. Type of certificate used. Possible values include: "Shared",
     "Dedicated".
    :type certificate_type: str or ~azure.mgmt.cdn.models.CertificateType
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'certificate_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'certificate_type': {'key': 'certificateType', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.CdnCertificateSourceParameters"

    def __init__(
        self,
        *,
        certificate_type: Union[str, "CertificateType"],
        **kwargs
    ):
        super(CdnCertificateSourceParameters, self).__init__(**kwargs)
        self.certificate_type = certificate_type


class CdnEndpoint(msrest.serialization.Model):
    """Defines the ARM Resource ID for the linked endpoints.

    :param id: ARM Resource ID string.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(CdnEndpoint, self).__init__(**kwargs)
        self.id = id


class CustomDomainHttpsParameters(msrest.serialization.Model):
    """The JSON object that contains the properties to secure a custom domain.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: UserManagedHttpsParameters, CdnManagedHttpsParameters.

    All required parameters must be populated in order to send to Azure.

    :param certificate_source: Required. Defines the source of the SSL certificate.Constant filled
     by server.  Possible values include: "AzureKeyVault", "Cdn".
    :type certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :param protocol_type: Required. Defines the TLS extension protocol that is used for secure
     delivery. Possible values include: "ServerNameIndication", "IPBased".
    :type protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :param minimum_tls_version: TLS protocol version that will be used for Https. Possible values
     include: "None", "TLS10", "TLS12".
    :type minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    """

    _validation = {
        'certificate_source': {'required': True},
        'protocol_type': {'required': True},
    }

    _attribute_map = {
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
    }

    _subtype_map = {
        'certificate_source': {'AzureKeyVault': 'UserManagedHttpsParameters', 'Cdn': 'CdnManagedHttpsParameters'}
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "ProtocolType"],
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        **kwargs
    ):
        super(CustomDomainHttpsParameters, self).__init__(**kwargs)
        self.certificate_source = None  # type: Optional[str]
        self.protocol_type = protocol_type
        self.minimum_tls_version = minimum_tls_version


class CdnManagedHttpsParameters(CustomDomainHttpsParameters):
    """Defines the certificate source parameters using CDN managed certificate for enabling SSL.

    All required parameters must be populated in order to send to Azure.

    :param certificate_source: Required. Defines the source of the SSL certificate.Constant filled
     by server.  Possible values include: "AzureKeyVault", "Cdn".
    :type certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :param protocol_type: Required. Defines the TLS extension protocol that is used for secure
     delivery. Possible values include: "ServerNameIndication", "IPBased".
    :type protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :param minimum_tls_version: TLS protocol version that will be used for Https. Possible values
     include: "None", "TLS10", "TLS12".
    :type minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    :param certificate_source_parameters: Required. Defines the certificate source parameters using
     CDN managed certificate for enabling SSL.
    :type certificate_source_parameters: ~azure.mgmt.cdn.models.CdnCertificateSourceParameters
    """

    _validation = {
        'certificate_source': {'required': True},
        'protocol_type': {'required': True},
        'certificate_source_parameters': {'required': True},
    }

    _attribute_map = {
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'certificate_source_parameters': {'key': 'certificateSourceParameters', 'type': 'CdnCertificateSourceParameters'},
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "ProtocolType"],
        certificate_source_parameters: "CdnCertificateSourceParameters",
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        **kwargs
    ):
        super(CdnManagedHttpsParameters, self).__init__(protocol_type=protocol_type, minimum_tls_version=minimum_tls_version, **kwargs)
        self.certificate_source = 'Cdn'  # type: str
        self.certificate_source_parameters = certificate_source_parameters


class Resource(msrest.serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class CdnWebApplicationFirewallPolicy(TrackedResource):
    """Defines web application firewall policy for Azure CDN.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param sku: Required. The pricing tier (defines a CDN provider, feature list and rate) of the
     CdnWebApplicationFirewallPolicy.
    :type sku: ~azure.mgmt.cdn.models.Sku
    :param policy_settings: Describes  policySettings for policy.
    :type policy_settings: ~azure.mgmt.cdn.models.PolicySettings
    :param rate_limit_rules: Describes rate limit rules inside the policy.
    :type rate_limit_rules: ~azure.mgmt.cdn.models.RateLimitRuleList
    :param custom_rules: Describes custom rules inside the policy.
    :type custom_rules: ~azure.mgmt.cdn.models.CustomRuleList
    :param managed_rules: Describes managed rules inside the policy.
    :type managed_rules: ~azure.mgmt.cdn.models.ManagedRuleSetList
    :ivar endpoint_links: Describes Azure CDN endpoints associated with this Web Application
     Firewall policy.
    :vartype endpoint_links: list[~azure.mgmt.cdn.models.CdnEndpoint]
    :ivar provisioning_state: Provisioning state of the WebApplicationFirewallPolicy. Possible
     values include: "Creating", "Succeeded", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.ProvisioningState
    :ivar resource_state: Resource status of the policy. Possible values include: "Creating",
     "Enabling", "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.PolicyResourceState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'endpoint_links': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'policy_settings': {'key': 'properties.policySettings', 'type': 'PolicySettings'},
        'rate_limit_rules': {'key': 'properties.rateLimitRules', 'type': 'RateLimitRuleList'},
        'custom_rules': {'key': 'properties.customRules', 'type': 'CustomRuleList'},
        'managed_rules': {'key': 'properties.managedRules', 'type': 'ManagedRuleSetList'},
        'endpoint_links': {'key': 'properties.endpointLinks', 'type': '[CdnEndpoint]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        policy_settings: Optional["PolicySettings"] = None,
        rate_limit_rules: Optional["RateLimitRuleList"] = None,
        custom_rules: Optional["CustomRuleList"] = None,
        managed_rules: Optional["ManagedRuleSetList"] = None,
        **kwargs
    ):
        super(CdnWebApplicationFirewallPolicy, self).__init__(location=location, tags=tags, **kwargs)
        self.etag = etag
        self.sku = sku
        self.policy_settings = policy_settings
        self.rate_limit_rules = rate_limit_rules
        self.custom_rules = custom_rules
        self.managed_rules = managed_rules
        self.endpoint_links = None
        self.provisioning_state = None
        self.resource_state = None


class CdnWebApplicationFirewallPolicyList(msrest.serialization.Model):
    """Defines a list of WebApplicationFirewallPolicies for Azure CDN. It contains a list of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Azure CDN WebApplicationFirewallPolicies within a resource group.
    :vartype value: list[~azure.mgmt.cdn.models.CdnWebApplicationFirewallPolicy]
    :param next_link: URL to get the next set of WebApplicationFirewallPolicy objects if there are
     any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CdnWebApplicationFirewallPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(CdnWebApplicationFirewallPolicyList, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CdnWebApplicationFirewallPolicyPatchParameters(msrest.serialization.Model):
    """Properties required to update a CdnWebApplicationFirewallPolicy.

    :param tags: A set of tags. CdnWebApplicationFirewallPolicy tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(CdnWebApplicationFirewallPolicyPatchParameters, self).__init__(**kwargs)
        self.tags = tags


class CheckNameAvailabilityInput(msrest.serialization.Model):
    """Input of CheckNameAvailability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The resource name to validate.
    :type name: str
    :ivar type: Required. The type of the resource whose name is to be validated. Default value:
     "Microsoft.Cdn/Profiles/Endpoints".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Cdn/Profiles/Endpoints"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(CheckNameAvailabilityInput, self).__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityOutput(msrest.serialization.Model):
    """Output of check name availability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the name is not available.
    :vartype reason: str
    :ivar message: The detailed error message describing why the name is not available.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityOutput, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CidrIpAddress(msrest.serialization.Model):
    """CIDR Ip address.

    :param base_ip_address: Ip address itself.
    :type base_ip_address: str
    :param prefix_length: The length of the prefix of the ip address.
    :type prefix_length: int
    """

    _attribute_map = {
        'base_ip_address': {'key': 'baseIpAddress', 'type': 'str'},
        'prefix_length': {'key': 'prefixLength', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        base_ip_address: Optional[str] = None,
        prefix_length: Optional[int] = None,
        **kwargs
    ):
        super(CidrIpAddress, self).__init__(**kwargs)
        self.base_ip_address = base_ip_address
        self.prefix_length = prefix_length


class CookiesMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for Cookies match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleCookiesConditionParameters".
    :vartype odata_type: str
    :param selector: Name of Cookies to be matched.
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual".
    :type operator: str or ~azure.mgmt.cdn.models.CookiesOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCookiesConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "CookiesOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(CookiesMatchConditionParameters, self).__init__(**kwargs)
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class CustomDomain(Resource):
    """Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param host_name: The host name of the custom domain. Must be a domain name.
    :type host_name: str
    :ivar resource_state: Resource status of the custom domain. Possible values include:
     "Creating", "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.CustomDomainResourceState
    :ivar custom_https_provisioning_state: Provisioning status of Custom Https of the custom
     domain. Possible values include: "Enabling", "Enabled", "Disabling", "Disabled", "Failed".
    :vartype custom_https_provisioning_state: str or
     ~azure.mgmt.cdn.models.CustomHttpsProvisioningState
    :ivar custom_https_provisioning_substate: Provisioning substate shows the progress of custom
     HTTPS enabling/disabling process step by step. Possible values include:
     "SubmittingDomainControlValidationRequest", "PendingDomainControlValidationREquestApproval",
     "DomainControlValidationRequestApproved", "DomainControlValidationRequestRejected",
     "DomainControlValidationRequestTimedOut", "IssuingCertificate", "DeployingCertificate",
     "CertificateDeployed", "DeletingCertificate", "CertificateDeleted".
    :vartype custom_https_provisioning_substate: str or
     ~azure.mgmt.cdn.models.CustomHttpsProvisioningSubstate
    :param validation_data: Special validation or data may be required when delivering CDN to some
     regions due to local compliance reasons. E.g. ICP license number of a custom domain is required
     to deliver content in China.
    :type validation_data: str
    :ivar provisioning_state: Provisioning status of the custom domain.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_state': {'readonly': True},
        'custom_https_provisioning_state': {'readonly': True},
        'custom_https_provisioning_substate': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'custom_https_provisioning_state': {'key': 'properties.customHttpsProvisioningState', 'type': 'str'},
        'custom_https_provisioning_substate': {'key': 'properties.customHttpsProvisioningSubstate', 'type': 'str'},
        'validation_data': {'key': 'properties.validationData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        validation_data: Optional[str] = None,
        **kwargs
    ):
        super(CustomDomain, self).__init__(**kwargs)
        self.host_name = host_name
        self.resource_state = None
        self.custom_https_provisioning_state = None
        self.custom_https_provisioning_substate = None
        self.validation_data = validation_data
        self.provisioning_state = None


class CustomDomainListResult(msrest.serialization.Model):
    """Result of the request to list custom domains. It contains a list of custom domain objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN CustomDomains within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.CustomDomain]
    :param next_link: URL to get the next set of custom domain objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CustomDomain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(CustomDomainListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CustomDomainParameters(msrest.serialization.Model):
    """The customDomain JSON object required for custom domain creation or update.

    :param host_name: The host name of the custom domain. Must be a domain name.
    :type host_name: str
    """

    _attribute_map = {
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        **kwargs
    ):
        super(CustomDomainParameters, self).__init__(**kwargs)
        self.host_name = host_name


class CustomRule(msrest.serialization.Model):
    """Defines the common attributes for a custom rule that can be included in a waf policy.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Defines the name of the custom rule.
    :type name: str
    :param enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to
     Enabled if not specified. Possible values include: "Disabled", "Enabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
    :param priority: Required. Defines in what order this rule be evaluated in the overall list of
     custom rules.
    :type priority: int
    :param match_conditions: Required. List of match conditions.
    :type match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
    :param action: Required. Describes what action to be applied when rule matches. Possible values
     include: "Allow", "Block", "Log", "Redirect".
    :type action: str or ~azure.mgmt.cdn.models.ActionType
    """

    _validation = {
        'name': {'required': True},
        'priority': {'required': True, 'maximum': 1000, 'minimum': 0},
        'match_conditions': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'match_conditions': {'key': 'matchConditions', 'type': '[MatchCondition]'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        priority: int,
        match_conditions: List["MatchCondition"],
        action: Union[str, "ActionType"],
        enabled_state: Optional[Union[str, "CustomRuleEnabledState"]] = None,
        **kwargs
    ):
        super(CustomRule, self).__init__(**kwargs)
        self.name = name
        self.enabled_state = enabled_state
        self.priority = priority
        self.match_conditions = match_conditions
        self.action = action


class CustomRuleList(msrest.serialization.Model):
    """Defines contents of custom rules.

    :param rules: List of rules.
    :type rules: list[~azure.mgmt.cdn.models.CustomRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[CustomRule]'},
    }

    def __init__(
        self,
        *,
        rules: Optional[List["CustomRule"]] = None,
        **kwargs
    ):
        super(CustomRuleList, self).__init__(**kwargs)
        self.rules = rules


class DeepCreatedOrigin(msrest.serialization.Model):
    """The main origin of CDN content which is added when creating a CDN endpoint.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Origin name which must be unique within the endpoint.
    :type name: str
    :param host_name: The address of the origin. It can be a domain name, IPv4 address, or IPv6
     address. This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param enabled: Origin is enabled for load balancing or not. By default, origin is always
     enabled.
    :type enabled: bool
    :param private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :type private_link_alias: str
    :param private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :type private_link_resource_id: str
    :param private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :type private_link_location: str
    :param private_link_approval_message: A custom message to be included in the approval request
     to connect to the Private Link.
    :type private_link_approval_message: str
    """

    _validation = {
        'name': {'required': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'properties.privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'properties.privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'properties.privateLinkApprovalMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        super(DeepCreatedOrigin, self).__init__(**kwargs)
        self.name = name
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message


class DeepCreatedOriginGroup(msrest.serialization.Model):
    """The origin group for CDN content which is added when creating a CDN endpoint. Traffic is sent to the origins within the origin group based on origin health.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Origin group name which must be unique within the endpoint.
    :type name: str
    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param origins: The source of the content being delivered via CDN within given origin group.
    :type origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses.This property is currently
     not supported.
    :type response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        'name': {'required': True},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'properties.origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'properties.responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
    }

    def __init__(
        self,
        *,
        name: str,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        super(DeepCreatedOriginGroup, self).__init__(**kwargs)
        self.name = name
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class DeliveryRule(msrest.serialization.Model):
    """A rule that specifies a set of actions and conditions.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the rule.
    :type name: str
    :param order: Required. The order in which the rules are applied for the endpoint. Possible
     values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater
     order. Rule with order 0 is a special rule. It does not require any condition and actions
     listed in it will always be applied.
    :type order: int
    :param conditions: A list of conditions that must be matched for the actions to be executed.
    :type conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :param actions: Required. A list of actions that are executed when all the conditions of a rule
     are satisfied.
    :type actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    """

    _validation = {
        'order': {'required': True},
        'actions': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'order': {'key': 'order', 'type': 'int'},
        'conditions': {'key': 'conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'actions', 'type': '[DeliveryRuleAction]'},
    }

    def __init__(
        self,
        *,
        order: int,
        actions: List["DeliveryRuleAction"],
        name: Optional[str] = None,
        conditions: Optional[List["DeliveryRuleCondition"]] = None,
        **kwargs
    ):
        super(DeliveryRule, self).__init__(**kwargs)
        self.name = name
        self.order = order
        self.conditions = conditions
        self.actions = actions


class DeliveryRuleAction(msrest.serialization.Model):
    """An action for the delivery rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DeliveryRuleCacheExpirationAction, DeliveryRuleCacheKeyQueryStringAction, DeliveryRuleRequestHeaderAction, DeliveryRuleResponseHeaderAction, UrlRedirectAction, UrlRewriteAction, UrlSigningAction.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'name': {'CacheExpiration': 'DeliveryRuleCacheExpirationAction', 'CacheKeyQueryString': 'DeliveryRuleCacheKeyQueryStringAction', 'ModifyRequestHeader': 'DeliveryRuleRequestHeaderAction', 'ModifyResponseHeader': 'DeliveryRuleResponseHeaderAction', 'UrlRedirect': 'UrlRedirectAction', 'UrlRewrite': 'UrlRewriteAction', 'UrlSigning': 'UrlSigningAction'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeliveryRuleAction, self).__init__(**kwargs)
        self.name = None  # type: Optional[str]


class DeliveryRuleCacheExpirationAction(DeliveryRuleAction):
    """Defines the cache expiration action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionName
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.CacheExpirationActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CacheExpirationActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "CacheExpirationActionParameters",
        **kwargs
    ):
        super(DeliveryRuleCacheExpirationAction, self).__init__(**kwargs)
        self.name = 'CacheExpiration'  # type: str
        self.parameters = parameters


class DeliveryRuleCacheKeyQueryStringAction(DeliveryRuleAction):
    """Defines the cache-key query string action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionName
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.CacheKeyQueryStringActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CacheKeyQueryStringActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "CacheKeyQueryStringActionParameters",
        **kwargs
    ):
        super(DeliveryRuleCacheKeyQueryStringAction, self).__init__(**kwargs)
        self.name = 'CacheKeyQueryString'  # type: str
        self.parameters = parameters


class DeliveryRuleCondition(msrest.serialization.Model):
    """A condition for the delivery rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DeliveryRuleCookiesCondition, DeliveryRuleHttpVersionCondition, DeliveryRuleIsDeviceCondition, DeliveryRulePostArgsCondition, DeliveryRuleQueryStringCondition, DeliveryRuleRemoteAddressCondition, DeliveryRuleRequestBodyCondition, DeliveryRuleRequestHeaderCondition, DeliveryRuleRequestMethodCondition, DeliveryRuleRequestSchemeCondition, DeliveryRuleRequestUriCondition, DeliveryRuleUrlFileExtensionCondition, DeliveryRuleUrlFileNameCondition, DeliveryRuleUrlPathCondition.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'name': {'Cookies': 'DeliveryRuleCookiesCondition', 'HttpVersion': 'DeliveryRuleHttpVersionCondition', 'IsDevice': 'DeliveryRuleIsDeviceCondition', 'PostArgs': 'DeliveryRulePostArgsCondition', 'QueryString': 'DeliveryRuleQueryStringCondition', 'RemoteAddress': 'DeliveryRuleRemoteAddressCondition', 'RequestBody': 'DeliveryRuleRequestBodyCondition', 'RequestHeader': 'DeliveryRuleRequestHeaderCondition', 'RequestMethod': 'DeliveryRuleRequestMethodCondition', 'RequestScheme': 'DeliveryRuleRequestSchemeCondition', 'RequestUri': 'DeliveryRuleRequestUriCondition', 'UrlFileExtension': 'DeliveryRuleUrlFileExtensionCondition', 'UrlFileName': 'DeliveryRuleUrlFileNameCondition', 'UrlPath': 'DeliveryRuleUrlPathCondition'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeliveryRuleCondition, self).__init__(**kwargs)
        self.name = None  # type: Optional[str]


class DeliveryRuleCookiesCondition(DeliveryRuleCondition):
    """Defines the Cookies condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.CookiesMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CookiesMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "CookiesMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleCookiesCondition, self).__init__(**kwargs)
        self.name = 'Cookies'  # type: str
        self.parameters = parameters


class DeliveryRuleHttpVersionCondition(DeliveryRuleCondition):
    """Defines the HttpVersion condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.HttpVersionMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HttpVersionMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "HttpVersionMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleHttpVersionCondition, self).__init__(**kwargs)
        self.name = 'HttpVersion'  # type: str
        self.parameters = parameters


class DeliveryRuleIsDeviceCondition(DeliveryRuleCondition):
    """Defines the IsDevice condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.IsDeviceMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'IsDeviceMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "IsDeviceMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleIsDeviceCondition, self).__init__(**kwargs)
        self.name = 'IsDevice'  # type: str
        self.parameters = parameters


class DeliveryRulePostArgsCondition(DeliveryRuleCondition):
    """Defines the PostArgs condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.PostArgsMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'PostArgsMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "PostArgsMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRulePostArgsCondition, self).__init__(**kwargs)
        self.name = 'PostArgs'  # type: str
        self.parameters = parameters


class DeliveryRuleQueryStringCondition(DeliveryRuleCondition):
    """Defines the QueryString condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.QueryStringMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'QueryStringMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "QueryStringMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleQueryStringCondition, self).__init__(**kwargs)
        self.name = 'QueryString'  # type: str
        self.parameters = parameters


class DeliveryRuleRemoteAddressCondition(DeliveryRuleCondition):
    """Defines the RemoteAddress condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RemoteAddressMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RemoteAddressMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RemoteAddressMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRemoteAddressCondition, self).__init__(**kwargs)
        self.name = 'RemoteAddress'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestBodyCondition(DeliveryRuleCondition):
    """Defines the RequestBody condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RequestBodyMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestBodyMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestBodyMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestBodyCondition, self).__init__(**kwargs)
        self.name = 'RequestBody'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestHeaderAction(DeliveryRuleAction):
    """Defines the request header action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionName
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HeaderActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "HeaderActionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestHeaderAction, self).__init__(**kwargs)
        self.name = 'ModifyRequestHeader'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestHeaderCondition(DeliveryRuleCondition):
    """Defines the RequestHeader condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RequestHeaderMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestHeaderMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestHeaderMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestHeaderCondition, self).__init__(**kwargs)
        self.name = 'RequestHeader'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestMethodCondition(DeliveryRuleCondition):
    """Defines the RequestMethod condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RequestMethodMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestMethodMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestMethodMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestMethodCondition, self).__init__(**kwargs)
        self.name = 'RequestMethod'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestSchemeCondition(DeliveryRuleCondition):
    """Defines the RequestScheme condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestSchemeMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestSchemeMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestSchemeCondition, self).__init__(**kwargs)
        self.name = 'RequestScheme'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestUriCondition(DeliveryRuleCondition):
    """Defines the RequestUri condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RequestUriMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestUriMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestUriMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestUriCondition, self).__init__(**kwargs)
        self.name = 'RequestUri'  # type: str
        self.parameters = parameters


class DeliveryRuleResponseHeaderAction(DeliveryRuleAction):
    """Defines the response header action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionName
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HeaderActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "HeaderActionParameters",
        **kwargs
    ):
        super(DeliveryRuleResponseHeaderAction, self).__init__(**kwargs)
        self.name = 'ModifyResponseHeader'  # type: str
        self.parameters = parameters


class DeliveryRuleUrlFileExtensionCondition(DeliveryRuleCondition):
    """Defines the UrlFileExtension condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.UrlFileExtensionMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlFileExtensionMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlFileExtensionMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleUrlFileExtensionCondition, self).__init__(**kwargs)
        self.name = 'UrlFileExtension'  # type: str
        self.parameters = parameters


class DeliveryRuleUrlFileNameCondition(DeliveryRuleCondition):
    """Defines the UrlFileName condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.UrlFileNameMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlFileNameMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlFileNameMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleUrlFileNameCondition, self).__init__(**kwargs)
        self.name = 'UrlFileName'  # type: str
        self.parameters = parameters


class DeliveryRuleUrlPathCondition(DeliveryRuleCondition):
    """Defines the UrlPath condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.UrlPathMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlPathMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlPathMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleUrlPathCondition, self).__init__(**kwargs)
        self.name = 'UrlPath'  # type: str
        self.parameters = parameters


class EdgeNode(Resource):
    """Edgenode is a global Point of Presence (POP) location used to deliver CDN content to end users.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param ip_address_groups: List of ip address groups.
    :type ip_address_groups: list[~azure.mgmt.cdn.models.IpAddressGroup]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'ip_address_groups': {'key': 'properties.ipAddressGroups', 'type': '[IpAddressGroup]'},
    }

    def __init__(
        self,
        *,
        ip_address_groups: Optional[List["IpAddressGroup"]] = None,
        **kwargs
    ):
        super(EdgeNode, self).__init__(**kwargs)
        self.ip_address_groups = ip_address_groups


class EdgenodeResult(msrest.serialization.Model):
    """Result of the request to list CDN edgenodes. It contains a list of ip address group and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Edge node of CDN service.
    :vartype value: list[~azure.mgmt.cdn.models.EdgeNode]
    :param next_link: URL to get the next set of edgenode list results if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EdgeNode]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EdgenodeResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Endpoint(TrackedResource):
    """CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format :code:`<endpointname>`.azureedge.net.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :type content_types_to_compress: list[str]
    :param origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :type origin_host_header: str
    :param is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :type is_compression_enabled: bool
    :param is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_http_allowed: bool
    :param is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_https_allowed: bool
    :param query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :type probe_path: str
    :param geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
     geo filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :type geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :param default_origin_group: A reference to the origin group.
    :type default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param url_signing_keys: List of keys used to validate the signed URL hashes.
    :type url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :param delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :type delivery_policy: ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     the endpoint (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :param origins: The source of the content being delivered via CDN.
    :type origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
    :param origin_groups: The origin groups comprising of origins that are used for load balancing
     the traffic based on availability.
    :type origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
    :ivar resource_state: Resource status of the endpoint. Possible values include: "Creating",
     "Deleting", "Running", "Starting", "Stopped", "Stopping".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.EndpointResourceState
    :ivar provisioning_state: Provisioning status of the endpoint.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'host_name': {'readonly': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'properties.contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'properties.isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'properties.isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'properties.isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'properties.queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'properties.optimizationType', 'type': 'str'},
        'probe_path': {'key': 'properties.probePath', 'type': 'str'},
        'geo_filters': {'key': 'properties.geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'properties.defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'properties.urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'properties.deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'properties.webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'origins': {'key': 'properties.origins', 'type': '[DeepCreatedOrigin]'},
        'origin_groups': {'key': 'properties.originGroups', 'type': '[DeepCreatedOriginGroup]'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        origins: Optional[List["DeepCreatedOrigin"]] = None,
        origin_groups: Optional[List["DeepCreatedOriginGroup"]] = None,
        **kwargs
    ):
        super(Endpoint, self).__init__(location=location, tags=tags, **kwargs)
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link
        self.host_name = None
        self.origins = origins
        self.origin_groups = origin_groups
        self.resource_state = None
        self.provisioning_state = None


class EndpointListResult(msrest.serialization.Model):
    """Result of the request to list endpoints. It contains a list of endpoint objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN endpoints within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.Endpoint]
    :param next_link: URL to get the next set of endpoint objects if there is any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Endpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EndpointListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class EndpointPropertiesUpdateParameters(msrest.serialization.Model):
    """The JSON object containing endpoint update parameters.

    :param origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :type content_types_to_compress: list[str]
    :param origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :type origin_host_header: str
    :param is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :type is_compression_enabled: bool
    :param is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_http_allowed: bool
    :param is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_https_allowed: bool
    :param query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :type probe_path: str
    :param geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
     geo filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :type geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :param default_origin_group: A reference to the origin group.
    :type default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param url_signing_keys: List of keys used to validate the signed URL hashes.
    :type url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :param delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :type delivery_policy: ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     the endpoint (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        'origin_path': {'key': 'originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'optimizationType', 'type': 'str'},
        'probe_path': {'key': 'probePath', 'type': 'str'},
        'geo_filters': {'key': 'geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
    }

    def __init__(
        self,
        *,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        **kwargs
    ):
        super(EndpointPropertiesUpdateParameters, self).__init__(**kwargs)
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link


class EndpointProperties(EndpointPropertiesUpdateParameters):
    """The JSON object that contains the properties required to create an endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :type content_types_to_compress: list[str]
    :param origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :type origin_host_header: str
    :param is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :type is_compression_enabled: bool
    :param is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_http_allowed: bool
    :param is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_https_allowed: bool
    :param query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :type probe_path: str
    :param geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
     geo filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :type geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :param default_origin_group: A reference to the origin group.
    :type default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param url_signing_keys: List of keys used to validate the signed URL hashes.
    :type url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :param delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :type delivery_policy: ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     the endpoint (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :param origins: Required. The source of the content being delivered via CDN.
    :type origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
    :param origin_groups: The origin groups comprising of origins that are used for load balancing
     the traffic based on availability.
    :type origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
    :ivar resource_state: Resource status of the endpoint. Possible values include: "Creating",
     "Deleting", "Running", "Starting", "Stopped", "Stopping".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.EndpointResourceState
    :ivar provisioning_state: Provisioning status of the endpoint.
    :vartype provisioning_state: str
    """

    _validation = {
        'host_name': {'readonly': True},
        'origins': {'required': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'origin_path': {'key': 'originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'optimizationType', 'type': 'str'},
        'probe_path': {'key': 'probePath', 'type': 'str'},
        'geo_filters': {'key': 'geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'origins': {'key': 'origins', 'type': '[DeepCreatedOrigin]'},
        'origin_groups': {'key': 'originGroups', 'type': '[DeepCreatedOriginGroup]'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        origins: List["DeepCreatedOrigin"],
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        origin_groups: Optional[List["DeepCreatedOriginGroup"]] = None,
        **kwargs
    ):
        super(EndpointProperties, self).__init__(origin_path=origin_path, content_types_to_compress=content_types_to_compress, origin_host_header=origin_host_header, is_compression_enabled=is_compression_enabled, is_http_allowed=is_http_allowed, is_https_allowed=is_https_allowed, query_string_caching_behavior=query_string_caching_behavior, optimization_type=optimization_type, probe_path=probe_path, geo_filters=geo_filters, default_origin_group=default_origin_group, url_signing_keys=url_signing_keys, delivery_policy=delivery_policy, web_application_firewall_policy_link=web_application_firewall_policy_link, **kwargs)
        self.host_name = None
        self.origins = origins
        self.origin_groups = origin_groups
        self.resource_state = None
        self.provisioning_state = None


class EndpointPropertiesUpdateParametersDeliveryPolicy(msrest.serialization.Model):
    """A policy that specifies the delivery rules to be used for an endpoint.

    All required parameters must be populated in order to send to Azure.

    :param description: User-friendly description of the policy.
    :type description: str
    :param rules: Required. A list of the delivery rules.
    :type rules: list[~azure.mgmt.cdn.models.DeliveryRule]
    """

    _validation = {
        'rules': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[DeliveryRule]'},
    }

    def __init__(
        self,
        *,
        rules: List["DeliveryRule"],
        description: Optional[str] = None,
        **kwargs
    ):
        super(EndpointPropertiesUpdateParametersDeliveryPolicy, self).__init__(**kwargs)
        self.description = description
        self.rules = rules


class EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink(msrest.serialization.Model):
    """Defines the Web Application Firewall policy for the endpoint (if applicable).

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink, self).__init__(**kwargs)
        self.id = id


class EndpointUpdateParameters(msrest.serialization.Model):
    """Properties required to create or update an endpoint.

    :param tags: A set of tags. Endpoint tags.
    :type tags: dict[str, str]
    :param origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :type content_types_to_compress: list[str]
    :param origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :type origin_host_header: str
    :param is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :type is_compression_enabled: bool
    :param is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_http_allowed: bool
    :param is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_https_allowed: bool
    :param query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :type probe_path: str
    :param geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
     geo filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :type geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :param default_origin_group: A reference to the origin group.
    :type default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param url_signing_keys: List of keys used to validate the signed URL hashes.
    :type url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :param delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :type delivery_policy: ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     the endpoint (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'properties.contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'properties.isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'properties.isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'properties.isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'properties.queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'properties.optimizationType', 'type': 'str'},
        'probe_path': {'key': 'properties.probePath', 'type': 'str'},
        'geo_filters': {'key': 'properties.geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'properties.defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'properties.urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'properties.deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'properties.webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        **kwargs
    ):
        super(EndpointUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates CDN service is not able to process the incoming request. The reason is provided in the error message.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None


class GeoFilter(msrest.serialization.Model):
    """Rules defining user's geo access within a CDN endpoint.

    All required parameters must be populated in order to send to Azure.

    :param relative_path: Required. Relative path applicable to geo filter. (e.g. '/mypictures',
     '/mypicture/kitty.jpg', and etc.).
    :type relative_path: str
    :param action: Required. Action of the geo filter, i.e. allow or block access. Possible values
     include: "Block", "Allow".
    :type action: str or ~azure.mgmt.cdn.models.GeoFilterActions
    :param country_codes: Required. Two letter country codes defining user country access in a geo
     filter, e.g. AU, MX, US.
    :type country_codes: list[str]
    """

    _validation = {
        'relative_path': {'required': True},
        'action': {'required': True},
        'country_codes': {'required': True},
    }

    _attribute_map = {
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'country_codes': {'key': 'countryCodes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        relative_path: str,
        action: Union[str, "GeoFilterActions"],
        country_codes: List[str],
        **kwargs
    ):
        super(GeoFilter, self).__init__(**kwargs)
        self.relative_path = relative_path
        self.action = action
        self.country_codes = country_codes


class HeaderActionParameters(msrest.serialization.Model):
    """Defines the parameters for the request header action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleHeaderActionParameters".
    :vartype odata_type: str
    :param header_action: Required. Action to perform. Possible values include: "Append",
     "Overwrite", "Delete".
    :type header_action: str or ~azure.mgmt.cdn.models.HeaderAction
    :param header_name: Required. Name of the header to modify.
    :type header_name: str
    :param value: Value for the specified action.
    :type value: str
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'header_action': {'required': True},
        'header_name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'header_action': {'key': 'headerAction', 'type': 'str'},
        'header_name': {'key': 'headerName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleHeaderActionParameters"

    def __init__(
        self,
        *,
        header_action: Union[str, "HeaderAction"],
        header_name: str,
        value: Optional[str] = None,
        **kwargs
    ):
        super(HeaderActionParameters, self).__init__(**kwargs)
        self.header_action = header_action
        self.header_name = header_name
        self.value = value


class HealthProbeParameters(msrest.serialization.Model):
    """The JSON object that contains the properties to send health probes to origin.

    :param probe_path: The path relative to the origin that is used to determine the health of the
     origin.
    :type probe_path: str
    :param probe_request_type: The type of health probe request that is made. Possible values
     include: "NotSet", "GET", "HEAD".
    :type probe_request_type: str or ~azure.mgmt.cdn.models.HealthProbeRequestType
    :param probe_protocol: Protocol to use for health probe. Possible values include: "NotSet",
     "Http", "Https".
    :type probe_protocol: str or ~azure.mgmt.cdn.models.ProbeProtocol
    :param probe_interval_in_seconds: The number of seconds between health probes.Default is
     240sec.
    :type probe_interval_in_seconds: int
    """

    _validation = {
        'probe_interval_in_seconds': {'maximum': 255, 'minimum': 1},
    }

    _attribute_map = {
        'probe_path': {'key': 'probePath', 'type': 'str'},
        'probe_request_type': {'key': 'probeRequestType', 'type': 'str'},
        'probe_protocol': {'key': 'probeProtocol', 'type': 'str'},
        'probe_interval_in_seconds': {'key': 'probeIntervalInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        probe_path: Optional[str] = None,
        probe_request_type: Optional[Union[str, "HealthProbeRequestType"]] = None,
        probe_protocol: Optional[Union[str, "ProbeProtocol"]] = None,
        probe_interval_in_seconds: Optional[int] = None,
        **kwargs
    ):
        super(HealthProbeParameters, self).__init__(**kwargs)
        self.probe_path = probe_path
        self.probe_request_type = probe_request_type
        self.probe_protocol = probe_protocol
        self.probe_interval_in_seconds = probe_interval_in_seconds


class HttpErrorRangeParameters(msrest.serialization.Model):
    """The JSON object that represents the range for http status codes.

    :param begin: The inclusive start of the http status code range.
    :type begin: int
    :param end: The inclusive end of the http status code range.
    :type end: int
    """

    _validation = {
        'begin': {'maximum': 999, 'minimum': 100},
        'end': {'maximum': 999, 'minimum': 100},
    }

    _attribute_map = {
        'begin': {'key': 'begin', 'type': 'int'},
        'end': {'key': 'end', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        begin: Optional[int] = None,
        end: Optional[int] = None,
        **kwargs
    ):
        super(HttpErrorRangeParameters, self).__init__(**kwargs)
        self.begin = begin
        self.end = end


class HttpVersionMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for HttpVersion match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleHttpVersionConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Equal".
    :type operator: str or ~azure.mgmt.cdn.models.HttpVersionOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleHttpVersionConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "HttpVersionOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        **kwargs
    ):
        super(HttpVersionMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values


class IpAddressGroup(msrest.serialization.Model):
    """CDN Ip address group.

    :param delivery_region: The delivery region of the ip address group.
    :type delivery_region: str
    :param ipv4_addresses: The list of ip v4 addresses.
    :type ipv4_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
    :param ipv6_addresses: The list of ip v6 addresses.
    :type ipv6_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
    """

    _attribute_map = {
        'delivery_region': {'key': 'deliveryRegion', 'type': 'str'},
        'ipv4_addresses': {'key': 'ipv4Addresses', 'type': '[CidrIpAddress]'},
        'ipv6_addresses': {'key': 'ipv6Addresses', 'type': '[CidrIpAddress]'},
    }

    def __init__(
        self,
        *,
        delivery_region: Optional[str] = None,
        ipv4_addresses: Optional[List["CidrIpAddress"]] = None,
        ipv6_addresses: Optional[List["CidrIpAddress"]] = None,
        **kwargs
    ):
        super(IpAddressGroup, self).__init__(**kwargs)
        self.delivery_region = delivery_region
        self.ipv4_addresses = ipv4_addresses
        self.ipv6_addresses = ipv6_addresses


class IsDeviceMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for IsDevice match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleIsDeviceConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Equal".
    :type operator: str or ~azure.mgmt.cdn.models.IsDeviceOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str or
     ~azure.mgmt.cdn.models.IsDeviceMatchConditionParametersMatchValuesItem]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleIsDeviceConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "IsDeviceOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[Union[str, "IsDeviceMatchConditionParametersMatchValuesItem"]]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(IsDeviceMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class KeyVaultCertificateSourceParameters(msrest.serialization.Model):
    """Describes the parameters for using a user's KeyVault certificate for securing custom domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.KeyVaultCertificateSourceParameters".
    :vartype odata_type: str
    :param subscription_id: Required. Subscription Id of the user's Key Vault containing the SSL
     certificate.
    :type subscription_id: str
    :param resource_group_name: Required. Resource group of the user's Key Vault containing the SSL
     certificate.
    :type resource_group_name: str
    :param vault_name: Required. The name of the user's Key Vault containing the SSL certificate.
    :type vault_name: str
    :param secret_name: Required. The name of Key Vault Secret (representing the full certificate
     PFX) in Key Vault.
    :type secret_name: str
    :param secret_version: The version(GUID) of Key Vault Secret in Key Vault.
    :type secret_version: str
    :param update_rule: Required. Describes the action that shall be taken when the certificate is
     updated in Key Vault. Possible values include: "NoAction".
    :type update_rule: str or ~azure.mgmt.cdn.models.UpdateRule
    :param delete_rule: Required. Describes the action that shall be taken when the certificate is
     removed from Key Vault. Possible values include: "NoAction".
    :type delete_rule: str or ~azure.mgmt.cdn.models.DeleteRule
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'vault_name': {'required': True},
        'secret_name': {'required': True},
        'update_rule': {'required': True},
        'delete_rule': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'secret_name': {'key': 'secretName', 'type': 'str'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
        'update_rule': {'key': 'updateRule', 'type': 'str'},
        'delete_rule': {'key': 'deleteRule', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.KeyVaultCertificateSourceParameters"

    def __init__(
        self,
        *,
        subscription_id: str,
        resource_group_name: str,
        vault_name: str,
        secret_name: str,
        update_rule: Union[str, "UpdateRule"],
        delete_rule: Union[str, "DeleteRule"],
        secret_version: Optional[str] = None,
        **kwargs
    ):
        super(KeyVaultCertificateSourceParameters, self).__init__(**kwargs)
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version
        self.update_rule = update_rule
        self.delete_rule = delete_rule


class KeyVaultSigningKeyParameters(msrest.serialization.Model):
    """Describes the parameters for using a user's KeyVault for URL Signing Key.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.KeyVaultSigningKeyParameters".
    :vartype odata_type: str
    :param subscription_id: Required. Subscription Id of the user's Key Vault containing the
     secret.
    :type subscription_id: str
    :param resource_group_name: Required. Resource group of the user's Key Vault containing the
     secret.
    :type resource_group_name: str
    :param vault_name: Required. The name of the user's Key Vault containing the secret.
    :type vault_name: str
    :param secret_name: Required. The name of secret in Key Vault.
    :type secret_name: str
    :param secret_version: Required. The version(GUID) of secret in Key Vault.
    :type secret_version: str
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'vault_name': {'required': True},
        'secret_name': {'required': True},
        'secret_version': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'secret_name': {'key': 'secretName', 'type': 'str'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.KeyVaultSigningKeyParameters"

    def __init__(
        self,
        *,
        subscription_id: str,
        resource_group_name: str,
        vault_name: str,
        secret_name: str,
        secret_version: str,
        **kwargs
    ):
        super(KeyVaultSigningKeyParameters, self).__init__(**kwargs)
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version


class LoadParameters(msrest.serialization.Model):
    """Parameters required for content load.

    All required parameters must be populated in order to send to Azure.

    :param content_paths: Required. The path to the content to be loaded. Path should be a relative
     file URL of the origin.
    :type content_paths: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        content_paths: List[str],
        **kwargs
    ):
        super(LoadParameters, self).__init__(**kwargs)
        self.content_paths = content_paths


class ManagedRuleDefinition(msrest.serialization.Model):
    """Describes a managed rule definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_id: Identifier for the managed rule.
    :vartype rule_id: str
    :ivar description: Describes the functionality of the managed rule.
    :vartype description: str
    """

    _validation = {
        'rule_id': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleDefinition, self).__init__(**kwargs)
        self.rule_id = None
        self.description = None


class ManagedRuleGroupDefinition(msrest.serialization.Model):
    """Describes a managed rule group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_group_name: Name of the managed rule group.
    :vartype rule_group_name: str
    :ivar description: Description of the managed rule group.
    :vartype description: str
    :ivar rules: List of rules within the managed rule group.
    :vartype rules: list[~azure.mgmt.cdn.models.ManagedRuleDefinition]
    """

    _validation = {
        'rule_group_name': {'readonly': True},
        'description': {'readonly': True},
        'rules': {'readonly': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleGroupDefinition, self).__init__(**kwargs)
        self.rule_group_name = None
        self.description = None
        self.rules = None


class ManagedRuleGroupOverride(msrest.serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. Describes the managed rule group within the rule set to
     override.
    :type rule_group_name: str
    :param rules: List of rules that will be disabled. If none specified, all rules in the group
     will be disabled.
    :type rules: list[~azure.mgmt.cdn.models.ManagedRuleOverride]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleOverride]'},
    }

    def __init__(
        self,
        *,
        rule_group_name: str,
        rules: Optional[List["ManagedRuleOverride"]] = None,
        **kwargs
    ):
        super(ManagedRuleGroupOverride, self).__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ManagedRuleOverride(msrest.serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_id: Required. Identifier for the managed rule.
    :type rule_id: str
    :param enabled_state: Describes if the managed rule is in enabled or disabled state. Defaults
     to Disabled if not specified. Possible values include: "Disabled", "Enabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.ManagedRuleEnabledState
    :param action: Describes the override action to be applied when rule matches. Possible values
     include: "Allow", "Block", "Log", "Redirect".
    :type action: str or ~azure.mgmt.cdn.models.ActionType
    """

    _validation = {
        'rule_id': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        rule_id: str,
        enabled_state: Optional[Union[str, "ManagedRuleEnabledState"]] = None,
        action: Optional[Union[str, "ActionType"]] = None,
        **kwargs
    ):
        super(ManagedRuleOverride, self).__init__(**kwargs)
        self.rule_id = rule_id
        self.enabled_state = enabled_state
        self.action = action


class ManagedRuleSet(msrest.serialization.Model):
    """Defines a managed rule set.

    All required parameters must be populated in order to send to Azure.

    :param rule_set_type: Required. Defines the rule set type to use.
    :type rule_set_type: str
    :param rule_set_version: Required. Defines the version of the rule set to use.
    :type rule_set_version: str
    :param anomaly_score: Verizon only : If the rule set supports anomaly detection mode, this
     describes the threshold for blocking requests.
    :type anomaly_score: int
    :param rule_group_overrides: Defines the rule overrides to apply to the rule set.
    :type rule_group_overrides: list[~azure.mgmt.cdn.models.ManagedRuleGroupOverride]
    """

    _validation = {
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
        'anomaly_score': {'maximum': 20, 'minimum': 0},
    }

    _attribute_map = {
        'rule_set_type': {'key': 'ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'ruleSetVersion', 'type': 'str'},
        'anomaly_score': {'key': 'anomalyScore', 'type': 'int'},
        'rule_group_overrides': {'key': 'ruleGroupOverrides', 'type': '[ManagedRuleGroupOverride]'},
    }

    def __init__(
        self,
        *,
        rule_set_type: str,
        rule_set_version: str,
        anomaly_score: Optional[int] = None,
        rule_group_overrides: Optional[List["ManagedRuleGroupOverride"]] = None,
        **kwargs
    ):
        super(ManagedRuleSet, self).__init__(**kwargs)
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.anomaly_score = anomaly_score
        self.rule_group_overrides = rule_group_overrides


class ManagedRuleSetDefinition(Resource):
    """Describes a managed rule set definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: The pricing tier (defines a CDN provider, feature list and rate) of the
     CdnWebApplicationFirewallPolicy.
    :type sku: ~azure.mgmt.cdn.models.Sku
    :ivar provisioning_state: Provisioning state of the managed rule set.
    :vartype provisioning_state: str
    :ivar rule_set_type: Type of the managed rule set.
    :vartype rule_set_type: str
    :ivar rule_set_version: Version of the managed rule set type.
    :vartype rule_set_version: str
    :ivar rule_groups: Rule groups of the managed rule set.
    :vartype rule_groups: list[~azure.mgmt.cdn.models.ManagedRuleGroupDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'rule_set_type': {'readonly': True},
        'rule_set_version': {'readonly': True},
        'rule_groups': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'rule_set_type': {'key': 'properties.ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'properties.ruleSetVersion', 'type': 'str'},
        'rule_groups': {'key': 'properties.ruleGroups', 'type': '[ManagedRuleGroupDefinition]'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        super(ManagedRuleSetDefinition, self).__init__(**kwargs)
        self.sku = sku
        self.provisioning_state = None
        self.rule_set_type = None
        self.rule_set_version = None
        self.rule_groups = None


class ManagedRuleSetDefinitionList(msrest.serialization.Model):
    """List of managed rule set definitions available for use in a policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of managed rule set definitions.
    :vartype value: list[~azure.mgmt.cdn.models.ManagedRuleSetDefinition]
    :param next_link: URL to retrieve next set of managed rule set definitions.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedRuleSetDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ManagedRuleSetDefinitionList, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ManagedRuleSetList(msrest.serialization.Model):
    """Defines the list of managed rule sets for the policy.

    :param managed_rule_sets: List of rule sets.
    :type managed_rule_sets: list[~azure.mgmt.cdn.models.ManagedRuleSet]
    """

    _attribute_map = {
        'managed_rule_sets': {'key': 'managedRuleSets', 'type': '[ManagedRuleSet]'},
    }

    def __init__(
        self,
        *,
        managed_rule_sets: Optional[List["ManagedRuleSet"]] = None,
        **kwargs
    ):
        super(ManagedRuleSetList, self).__init__(**kwargs)
        self.managed_rule_sets = managed_rule_sets


class MatchCondition(msrest.serialization.Model):
    """Define match conditions.

    All required parameters must be populated in order to send to Azure.

    :param match_variable: Required. Match variable to compare against. Possible values include:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type match_variable: str or ~azure.mgmt.cdn.models.MatchVariable
    :param selector: Selector can used to match a specific key for QueryString, Cookies,
     RequestHeader or PostArgs.
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "IPMatch", "GeoMatch", "Equal", "Contains", "LessThan", "GreaterThan", "LessThanOrEqual",
     "GreaterThanOrEqual", "BeginsWith", "EndsWith", "RegEx".
    :type operator: str or ~azure.mgmt.cdn.models.Operator
    :param negate_condition: Describes if the result of this condition should be negated.
    :type negate_condition: bool
    :param match_value: Required. List of possible match values.
    :type match_value: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.TransformType]
    """

    _validation = {
        'match_variable': {'required': True},
        'operator': {'required': True},
        'match_value': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_value': {'key': 'matchValue', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        match_variable: Union[str, "MatchVariable"],
        operator: Union[str, "Operator"],
        match_value: List[str],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        transforms: Optional[List[Union[str, "TransformType"]]] = None,
        **kwargs
    ):
        super(MatchCondition, self).__init__(**kwargs)
        self.match_variable = match_variable
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_value = match_value
        self.transforms = transforms


class Operation(msrest.serialization.Model):
    """CDN REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.cdn.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.Cdn.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationsListResult(msrest.serialization.Model):
    """Result of the request to list CDN operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN operations supported by the CDN resource provider.
    :vartype value: list[~azure.mgmt.cdn.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Origin(Resource):
    """CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param enabled: Origin is enabled for load balancing or not.
    :type enabled: bool
    :param private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :type private_link_alias: str
    :param private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :type private_link_resource_id: str
    :param private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :type private_link_location: str
    :param private_link_approval_message: A custom message to be included in the approval request
     to connect to the Private Link.
    :type private_link_approval_message: str
    :ivar resource_state: Resource status of the origin. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginResourceState
    :ivar provisioning_state: Provisioning status of the origin.
    :vartype provisioning_state: str
    :ivar private_endpoint_status: The approval status for the connection to the Private Link.
     Possible values include: "Pending", "Approved", "Rejected", "Disconnected", "Timeout".
    :vartype private_endpoint_status: str or ~azure.mgmt.cdn.models.PrivateEndpointStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_endpoint_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'properties.privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'properties.privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'properties.privateLinkApprovalMessage', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint_status': {'key': 'properties.privateEndpointStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        super(Origin, self).__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message
        self.resource_state = None
        self.provisioning_state = None
        self.private_endpoint_status = None


class OriginGroup(Resource):
    """Origin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param origins: The source of the content being delivered via CDN within given origin group.
    :type origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :ivar resource_state: Resource status of the origin group. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginGroupResourceState
    :ivar provisioning_state: Provisioning status of the origin group.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'properties.origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'properties.responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        super(OriginGroup, self).__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings
        self.resource_state = None
        self.provisioning_state = None


class OriginGroupListResult(msrest.serialization.Model):
    """Result of the request to list origin groups. It contains a list of origin groups objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origin groups within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.OriginGroup]
    :param next_link: URL to get the next set of origin objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OriginGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OriginGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class OriginGroupUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the origin group.

    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param origins: The source of the content being delivered via CDN within given origin group.
    :type origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        super(OriginGroupUpdatePropertiesParameters, self).__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class OriginGroupProperties(OriginGroupUpdatePropertiesParameters):
    """The JSON object that contains the properties of the origin group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param origins: The source of the content being delivered via CDN within given origin group.
    :type origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :ivar resource_state: Resource status of the origin group. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginGroupResourceState
    :ivar provisioning_state: Provisioning status of the origin group.
    :vartype provisioning_state: str
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        super(OriginGroupProperties, self).__init__(health_probe_settings=health_probe_settings, origins=origins, traffic_restoration_time_to_healed_or_new_endpoints_in_minutes=traffic_restoration_time_to_healed_or_new_endpoints_in_minutes, response_based_origin_error_detection_settings=response_based_origin_error_detection_settings, **kwargs)
        self.resource_state = None
        self.provisioning_state = None


class OriginGroupUpdateParameters(msrest.serialization.Model):
    """Origin group properties needed for origin group creation or update.

    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param origins: The source of the content being delivered via CDN within given origin group.
    :type origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'properties.origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'properties.responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        super(OriginGroupUpdateParameters, self).__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class OriginListResult(msrest.serialization.Model):
    """Result of the request to list origins. It contains a list of origin objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origins within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.Origin]
    :param next_link: URL to get the next set of origin objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Origin]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OriginListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class OriginUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the origin.

    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param enabled: Origin is enabled for load balancing or not.
    :type enabled: bool
    :param private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :type private_link_alias: str
    :param private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :type private_link_resource_id: str
    :param private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :type private_link_location: str
    :param private_link_approval_message: A custom message to be included in the approval request
     to connect to the Private Link.
    :type private_link_approval_message: str
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'privateLinkApprovalMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        super(OriginUpdatePropertiesParameters, self).__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message


class OriginProperties(OriginUpdatePropertiesParameters):
    """The JSON object that contains the properties of the origin.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param enabled: Origin is enabled for load balancing or not.
    :type enabled: bool
    :param private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :type private_link_alias: str
    :param private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :type private_link_resource_id: str
    :param private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :type private_link_location: str
    :param private_link_approval_message: A custom message to be included in the approval request
     to connect to the Private Link.
    :type private_link_approval_message: str
    :ivar resource_state: Resource status of the origin. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginResourceState
    :ivar provisioning_state: Provisioning status of the origin.
    :vartype provisioning_state: str
    :ivar private_endpoint_status: The approval status for the connection to the Private Link.
     Possible values include: "Pending", "Approved", "Rejected", "Disconnected", "Timeout".
    :vartype private_endpoint_status: str or ~azure.mgmt.cdn.models.PrivateEndpointStatus
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_endpoint_status': {'readonly': True},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'privateLinkApprovalMessage', 'type': 'str'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'private_endpoint_status': {'key': 'privateEndpointStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        super(OriginProperties, self).__init__(host_name=host_name, http_port=http_port, https_port=https_port, origin_host_header=origin_host_header, priority=priority, weight=weight, enabled=enabled, private_link_alias=private_link_alias, private_link_resource_id=private_link_resource_id, private_link_location=private_link_location, private_link_approval_message=private_link_approval_message, **kwargs)
        self.resource_state = None
        self.provisioning_state = None
        self.private_endpoint_status = None


class OriginUpdateParameters(msrest.serialization.Model):
    """Origin properties needed for origin update.

    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param enabled: Origin is enabled for load balancing or not.
    :type enabled: bool
    :param private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :type private_link_alias: str
    :param private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :type private_link_resource_id: str
    :param private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :type private_link_location: str
    :param private_link_approval_message: A custom message to be included in the approval request
     to connect to the Private Link.
    :type private_link_approval_message: str
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'properties.privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'properties.privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'properties.privateLinkApprovalMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        super(OriginUpdateParameters, self).__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message


class PolicySettings(msrest.serialization.Model):
    """Defines contents of a web application firewall global configuration.

    :param enabled_state: describes if the policy is in enabled state or disabled state. Possible
     values include: "Disabled", "Enabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.PolicyEnabledState
    :param mode: Describes if it is in detection mode or prevention mode at policy level. Possible
     values include: "Prevention", "Detection".
    :type mode: str or ~azure.mgmt.cdn.models.PolicyMode
    :param default_redirect_url: If action type is redirect, this field represents the default
     redirect URL for the client.
    :type default_redirect_url: str
    :param default_custom_block_response_status_code: If the action type is block, this field
     defines the default customer overridable http response status code. Possible values include:
     200, 403, 405, 406, 429.
    :type default_custom_block_response_status_code: str or ~azure.mgmt.cdn.models.Enum16
    :param default_custom_block_response_body: If the action type is block, customer can override
     the response body. The body must be specified in base64 encoding.
    :type default_custom_block_response_body: str
    """

    _validation = {
        'default_custom_block_response_body': {'pattern': r'^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$'},
    }

    _attribute_map = {
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'default_redirect_url': {'key': 'defaultRedirectUrl', 'type': 'str'},
        'default_custom_block_response_status_code': {'key': 'defaultCustomBlockResponseStatusCode', 'type': 'int'},
        'default_custom_block_response_body': {'key': 'defaultCustomBlockResponseBody', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled_state: Optional[Union[str, "PolicyEnabledState"]] = None,
        mode: Optional[Union[str, "PolicyMode"]] = None,
        default_redirect_url: Optional[str] = None,
        default_custom_block_response_status_code: Optional[Union[int, "Enum16"]] = None,
        default_custom_block_response_body: Optional[str] = None,
        **kwargs
    ):
        super(PolicySettings, self).__init__(**kwargs)
        self.enabled_state = enabled_state
        self.mode = mode
        self.default_redirect_url = default_redirect_url
        self.default_custom_block_response_status_code = default_custom_block_response_status_code
        self.default_custom_block_response_body = default_custom_block_response_body


class PostArgsMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for PostArgs match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRulePostArgsConditionParameters".
    :vartype odata_type: str
    :param selector: Name of PostArg to be matched.
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual".
    :type operator: str or ~azure.mgmt.cdn.models.PostArgsOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRulePostArgsConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "PostArgsOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(PostArgsMatchConditionParameters, self).__init__(**kwargs)
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class Profile(TrackedResource):
    """CDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and pricing tier.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Required. The pricing tier (defines a CDN provider, feature list and rate) of the
     CDN profile.
    :type sku: ~azure.mgmt.cdn.models.Sku
    :ivar resource_state: Resource status of the profile. Possible values include: "Creating",
     "Active", "Deleting", "Disabled".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.ProfileResourceState
    :ivar provisioning_state: Provisioning status of the profile.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Profile, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.resource_state = None
        self.provisioning_state = None


class ProfileListResult(msrest.serialization.Model):
    """Result of the request to list profiles. It contains a list of profile objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN profiles within a resource group.
    :vartype value: list[~azure.mgmt.cdn.models.Profile]
    :param next_link: URL to get the next set of profile objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Profile]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ProfileListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ProfileUpdateParameters(msrest.serialization.Model):
    """Properties required to update a profile.

    :param tags: A set of tags. Profile tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ProfileUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class PurgeParameters(msrest.serialization.Model):
    """Parameters required for content purge.

    All required parameters must be populated in order to send to Azure.

    :param content_paths: Required. The path to the content to be purged. Can describe a file path
     or a wild card directory.
    :type content_paths: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        content_paths: List[str],
        **kwargs
    ):
        super(PurgeParameters, self).__init__(**kwargs)
        self.content_paths = content_paths


class QueryStringMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for QueryString match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleQueryStringConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual".
    :type operator: str or ~azure.mgmt.cdn.models.QueryStringOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleQueryStringConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "QueryStringOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(QueryStringMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RateLimitRule(CustomRule):
    """Defines a rate limiting rule that can be included in a waf policy.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Defines the name of the custom rule.
    :type name: str
    :param enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to
     Enabled if not specified. Possible values include: "Disabled", "Enabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
    :param priority: Required. Defines in what order this rule be evaluated in the overall list of
     custom rules.
    :type priority: int
    :param match_conditions: Required. List of match conditions.
    :type match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
    :param action: Required. Describes what action to be applied when rule matches. Possible values
     include: "Allow", "Block", "Log", "Redirect".
    :type action: str or ~azure.mgmt.cdn.models.ActionType
    :param rate_limit_threshold: Required. Defines rate limit threshold.
    :type rate_limit_threshold: int
    :param rate_limit_duration_in_minutes: Required. Defines rate limit duration. Default is 1
     minute.
    :type rate_limit_duration_in_minutes: int
    """

    _validation = {
        'name': {'required': True},
        'priority': {'required': True, 'maximum': 1000, 'minimum': 0},
        'match_conditions': {'required': True},
        'action': {'required': True},
        'rate_limit_threshold': {'required': True, 'minimum': 0},
        'rate_limit_duration_in_minutes': {'required': True, 'maximum': 60, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'match_conditions': {'key': 'matchConditions', 'type': '[MatchCondition]'},
        'action': {'key': 'action', 'type': 'str'},
        'rate_limit_threshold': {'key': 'rateLimitThreshold', 'type': 'int'},
        'rate_limit_duration_in_minutes': {'key': 'rateLimitDurationInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        priority: int,
        match_conditions: List["MatchCondition"],
        action: Union[str, "ActionType"],
        rate_limit_threshold: int,
        rate_limit_duration_in_minutes: int,
        enabled_state: Optional[Union[str, "CustomRuleEnabledState"]] = None,
        **kwargs
    ):
        super(RateLimitRule, self).__init__(name=name, enabled_state=enabled_state, priority=priority, match_conditions=match_conditions, action=action, **kwargs)
        self.rate_limit_threshold = rate_limit_threshold
        self.rate_limit_duration_in_minutes = rate_limit_duration_in_minutes


class RateLimitRuleList(msrest.serialization.Model):
    """Defines contents of rate limit rules.

    :param rules: List of rules.
    :type rules: list[~azure.mgmt.cdn.models.RateLimitRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[RateLimitRule]'},
    }

    def __init__(
        self,
        *,
        rules: Optional[List["RateLimitRule"]] = None,
        **kwargs
    ):
        super(RateLimitRuleList, self).__init__(**kwargs)
        self.rules = rules


class RemoteAddressMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RemoteAddress match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRemoteAddressConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "IPMatch", "GeoMatch".
    :type operator: str or ~azure.mgmt.cdn.models.RemoteAddressOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: Match values to match against. The operator will apply to each value in
     here with OR semantics. If any of them match the variable with the given operator this match
     condition is considered a match.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRemoteAddressConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RemoteAddressOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(RemoteAddressMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestBodyMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestBody match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestBodyConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual".
    :type operator: str or ~azure.mgmt.cdn.models.RequestBodyOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestBodyConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestBodyOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(RequestBodyMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestHeaderMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestHeader match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestHeaderConditionParameters".
    :vartype odata_type: str
    :param selector: Name of Header to be matched.
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual".
    :type operator: str or ~azure.mgmt.cdn.models.RequestHeaderOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestHeaderConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestHeaderOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(RequestHeaderMatchConditionParameters, self).__init__(**kwargs)
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestMethodMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestMethod match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestMethodConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Equal".
    :type operator: str or ~azure.mgmt.cdn.models.RequestMethodOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str or
     ~azure.mgmt.cdn.models.RequestMethodMatchConditionParametersMatchValuesItem]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestMethodConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestMethodOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[Union[str, "RequestMethodMatchConditionParametersMatchValuesItem"]]] = None,
        **kwargs
    ):
        super(RequestMethodMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values


class RequestSchemeMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestScheme match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestSchemeConditionParameters".
    :vartype odata_type: str
    :ivar operator: Required. Describes operator to be matched. Default value: "Equal".
    :vartype operator: str
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str or
     ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParametersMatchValuesItem]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestSchemeConditionParameters"
    operator = "Equal"

    def __init__(
        self,
        *,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[Union[str, "RequestSchemeMatchConditionParametersMatchValuesItem"]]] = None,
        **kwargs
    ):
        super(RequestSchemeMatchConditionParameters, self).__init__(**kwargs)
        self.negate_condition = negate_condition
        self.match_values = match_values


class RequestUriMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestUri match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestUriConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual".
    :type operator: str or ~azure.mgmt.cdn.models.RequestUriOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestUriConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestUriOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(RequestUriMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class ResourceReference(msrest.serialization.Model):
    """Reference to another resource.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ResourceReference, self).__init__(**kwargs)
        self.id = id


class ResourceUsage(msrest.serialization.Model):
    """Output of check resource usage API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: Resource type for which the usage is provided.
    :vartype resource_type: str
    :ivar unit: Unit of the usage. e.g. Count.
    :vartype unit: str
    :ivar current_value: Actual value of usage on the specified resource type.
    :vartype current_value: int
    :ivar limit: Quota of the specified resource type.
    :vartype limit: int
    """

    _validation = {
        'resource_type': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceUsage, self).__init__(**kwargs)
        self.resource_type = None
        self.unit = None
        self.current_value = None
        self.limit = None


class ResourceUsageListResult(msrest.serialization.Model):
    """Output of check resource usage API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of resource usages.
    :vartype value: list[~azure.mgmt.cdn.models.ResourceUsage]
    :param next_link: URL to get the next set of custom domain objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceUsage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ResourceUsageListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ResponseBasedOriginErrorDetectionParameters(msrest.serialization.Model):
    """The JSON object that contains the properties to determine origin health using real requests/responses.

    :param response_based_detected_error_types: Type of response errors for real user requests for
     which origin will be deemed unhealthy. Possible values include: "None", "TcpErrorsOnly",
     "TcpAndHttpErrors".
    :type response_based_detected_error_types: str or
     ~azure.mgmt.cdn.models.ResponseBasedDetectedErrorTypes
    :param response_based_failover_threshold_percentage: The percentage of failed requests in the
     sample where failover should trigger.
    :type response_based_failover_threshold_percentage: int
    :param http_error_ranges: The list of Http status code ranges that are considered as server
     errors for origin and it is marked as unhealthy.
    :type http_error_ranges: list[~azure.mgmt.cdn.models.HttpErrorRangeParameters]
    """

    _validation = {
        'response_based_failover_threshold_percentage': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'response_based_detected_error_types': {'key': 'responseBasedDetectedErrorTypes', 'type': 'str'},
        'response_based_failover_threshold_percentage': {'key': 'responseBasedFailoverThresholdPercentage', 'type': 'int'},
        'http_error_ranges': {'key': 'httpErrorRanges', 'type': '[HttpErrorRangeParameters]'},
    }

    def __init__(
        self,
        *,
        response_based_detected_error_types: Optional[Union[str, "ResponseBasedDetectedErrorTypes"]] = None,
        response_based_failover_threshold_percentage: Optional[int] = None,
        http_error_ranges: Optional[List["HttpErrorRangeParameters"]] = None,
        **kwargs
    ):
        super(ResponseBasedOriginErrorDetectionParameters, self).__init__(**kwargs)
        self.response_based_detected_error_types = response_based_detected_error_types
        self.response_based_failover_threshold_percentage = response_based_failover_threshold_percentage
        self.http_error_ranges = http_error_ranges


class Sku(msrest.serialization.Model):
    """The pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.

    :param name: Name of the pricing tier. Possible values include: "Standard_Verizon",
     "Premium_Verizon", "Custom_Verizon", "Standard_Akamai", "Standard_ChinaCdn",
     "Standard_Microsoft", "Premium_ChinaCdn".
    :type name: str or ~azure.mgmt.cdn.models.SkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "SkuName"]] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name


class SsoUri(msrest.serialization.Model):
    """The URI required to login to the supplemental portal from the Azure portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sso_uri_value: The URI used to login to the supplemental portal.
    :vartype sso_uri_value: str
    """

    _validation = {
        'sso_uri_value': {'readonly': True},
    }

    _attribute_map = {
        'sso_uri_value': {'key': 'ssoUriValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SsoUri, self).__init__(**kwargs)
        self.sso_uri_value = None


class SupportedOptimizationTypesListResult(msrest.serialization.Model):
    """The result of the GetSupportedOptimizationTypes API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar supported_optimization_types: Supported optimization types for a profile.
    :vartype supported_optimization_types: list[str or ~azure.mgmt.cdn.models.OptimizationType]
    """

    _validation = {
        'supported_optimization_types': {'readonly': True},
    }

    _attribute_map = {
        'supported_optimization_types': {'key': 'supportedOptimizationTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SupportedOptimizationTypesListResult, self).__init__(**kwargs)
        self.supported_optimization_types = None


class UrlFileExtensionMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for UrlFileExtension match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFileExtensionMatchConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual".
    :type operator: str or ~azure.mgmt.cdn.models.UrlFileExtensionOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFileExtensionMatchConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "UrlFileExtensionOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(UrlFileExtensionMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlFileNameMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for UrlFilename match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFilenameConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual".
    :type operator: str or ~azure.mgmt.cdn.models.UrlFileNameOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFilenameConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "UrlFileNameOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(UrlFileNameMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlPathMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for UrlPath match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlPathMatchConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "Wildcard".
    :type operator: str or ~azure.mgmt.cdn.models.UrlPathOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlPathMatchConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "UrlPathOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(UrlPathMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlRedirectAction(DeliveryRuleAction):
    """Defines the url redirect action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionName
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.UrlRedirectActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlRedirectActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlRedirectActionParameters",
        **kwargs
    ):
        super(UrlRedirectAction, self).__init__(**kwargs)
        self.name = 'UrlRedirect'  # type: str
        self.parameters = parameters


class UrlRedirectActionParameters(msrest.serialization.Model):
    """Defines the parameters for the url redirect action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRedirectActionParameters".
    :vartype odata_type: str
    :param redirect_type: Required. The redirect type the rule will use when redirecting traffic.
     Possible values include: "Moved", "Found", "TemporaryRedirect", "PermanentRedirect".
    :type redirect_type: str or ~azure.mgmt.cdn.models.RedirectType
    :param destination_protocol: Protocol to use for the redirect. The default value is
     MatchRequest. Possible values include: "MatchRequest", "Http", "Https".
    :type destination_protocol: str or ~azure.mgmt.cdn.models.DestinationProtocol
    :param custom_path: The full path to redirect. Path cannot be empty and must start with /.
     Leave empty to use the incoming path as destination path.
    :type custom_path: str
    :param custom_hostname: Host to redirect. Leave empty to use the incoming host as the
     destination host.
    :type custom_hostname: str
    :param custom_query_string: The set of query strings to be placed in the redirect URL. Setting
     this value would replace any existing query string; leave empty to preserve the incoming query
     string. Query string must be in :code:`<key>`=:code:`<value>` format. ? and & will be added
     automatically so do not include them.
    :type custom_query_string: str
    :param custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL
     that comes after #. Do not include the #.
    :type custom_fragment: str
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'redirect_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'redirect_type': {'key': 'redirectType', 'type': 'str'},
        'destination_protocol': {'key': 'destinationProtocol', 'type': 'str'},
        'custom_path': {'key': 'customPath', 'type': 'str'},
        'custom_hostname': {'key': 'customHostname', 'type': 'str'},
        'custom_query_string': {'key': 'customQueryString', 'type': 'str'},
        'custom_fragment': {'key': 'customFragment', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRedirectActionParameters"

    def __init__(
        self,
        *,
        redirect_type: Union[str, "RedirectType"],
        destination_protocol: Optional[Union[str, "DestinationProtocol"]] = None,
        custom_path: Optional[str] = None,
        custom_hostname: Optional[str] = None,
        custom_query_string: Optional[str] = None,
        custom_fragment: Optional[str] = None,
        **kwargs
    ):
        super(UrlRedirectActionParameters, self).__init__(**kwargs)
        self.redirect_type = redirect_type
        self.destination_protocol = destination_protocol
        self.custom_path = custom_path
        self.custom_hostname = custom_hostname
        self.custom_query_string = custom_query_string
        self.custom_fragment = custom_fragment


class UrlRewriteAction(DeliveryRuleAction):
    """Defines the url rewrite action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionName
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.UrlRewriteActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlRewriteActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlRewriteActionParameters",
        **kwargs
    ):
        super(UrlRewriteAction, self).__init__(**kwargs)
        self.name = 'UrlRewrite'  # type: str
        self.parameters = parameters


class UrlRewriteActionParameters(msrest.serialization.Model):
    """Defines the parameters for the url rewrite action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRewriteActionParameters".
    :vartype odata_type: str
    :param source_pattern: Required. define a request URI pattern that identifies the type of
     requests that may be rewritten. If value is blank, all strings are matched.
    :type source_pattern: str
    :param destination: Required. Define the relative URL to which the above requests will be
     rewritten by.
    :type destination: str
    :param preserve_unmatched_path: Whether to preserve unmatched path. Default value is true.
    :type preserve_unmatched_path: bool
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'source_pattern': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'source_pattern': {'key': 'sourcePattern', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'str'},
        'preserve_unmatched_path': {'key': 'preserveUnmatchedPath', 'type': 'bool'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRewriteActionParameters"

    def __init__(
        self,
        *,
        source_pattern: str,
        destination: str,
        preserve_unmatched_path: Optional[bool] = None,
        **kwargs
    ):
        super(UrlRewriteActionParameters, self).__init__(**kwargs)
        self.source_pattern = source_pattern
        self.destination = destination
        self.preserve_unmatched_path = preserve_unmatched_path


class UrlSigningAction(DeliveryRuleAction):
    """Defines the url signing action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionName
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.UrlSigningActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlSigningActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlSigningActionParameters",
        **kwargs
    ):
        super(UrlSigningAction, self).__init__(**kwargs)
        self.name = 'UrlSigning'  # type: str
        self.parameters = parameters


class UrlSigningActionParameters(msrest.serialization.Model):
    """Defines the parameters for the Url Signing action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type:  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlSigningActionParameters".
    :vartype odata_type: str
    :param key_id: Required. Id reference of the key to be used to verify the hash and should be
     defined in UrlSigningKeys.
    :type key_id: str
    :param algorithm: Algorithm to use for URL signing. Possible values include: "SHA256".
    :type algorithm: str or ~azure.mgmt.cdn.models.Algorithm
    :param parameter_name_override: Defines which query string parameters in the url to be
     considered for expires, key id etc.
    :type parameter_name_override: list[~azure.mgmt.cdn.models.UrlSigningParamIdentifier]
    :param ip_subnets: Match values to match against. Supports CIDR ranges (both IPv4 and IPv6).
    :type ip_subnets: list[str]
    """

    _validation = {
        'odata_type': {'constant': True},
        'key_id': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'key_id': {'key': 'keyId', 'type': 'str'},
        'algorithm': {'key': 'algorithm', 'type': 'str'},
        'parameter_name_override': {'key': 'parameterNameOverride', 'type': '[UrlSigningParamIdentifier]'},
        'ip_subnets': {'key': 'ipSubnets', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlSigningActionParameters"

    def __init__(
        self,
        *,
        key_id: str,
        algorithm: Optional[Union[str, "Algorithm"]] = None,
        parameter_name_override: Optional[List["UrlSigningParamIdentifier"]] = None,
        ip_subnets: Optional[List[str]] = None,
        **kwargs
    ):
        super(UrlSigningActionParameters, self).__init__(**kwargs)
        self.key_id = key_id
        self.algorithm = algorithm
        self.parameter_name_override = parameter_name_override
        self.ip_subnets = ip_subnets


class UrlSigningKey(msrest.serialization.Model):
    """Url signing key.

    All required parameters must be populated in order to send to Azure.

    :param key_id: Required. Defines the customer defined key Id. This id will exist in the
     incoming request to indicate the key used to form the hash.
    :type key_id: str
    :param key_source_parameters: Required. Defines the parameters for using customer key vault for
     Url Signing Key.
    :type key_source_parameters: ~azure.mgmt.cdn.models.KeyVaultSigningKeyParameters
    """

    _validation = {
        'key_id': {'required': True},
        'key_source_parameters': {'required': True},
    }

    _attribute_map = {
        'key_id': {'key': 'keyId', 'type': 'str'},
        'key_source_parameters': {'key': 'keySourceParameters', 'type': 'KeyVaultSigningKeyParameters'},
    }

    def __init__(
        self,
        *,
        key_id: str,
        key_source_parameters: "KeyVaultSigningKeyParameters",
        **kwargs
    ):
        super(UrlSigningKey, self).__init__(**kwargs)
        self.key_id = key_id
        self.key_source_parameters = key_source_parameters


class UrlSigningParamIdentifier(msrest.serialization.Model):
    """Defines how to identify a parameter for a specific purpose e.g. expires.

    All required parameters must be populated in order to send to Azure.

    :param param_indicator: Required. Indicates the purpose of the parameter. Possible values
     include: "Expires", "KeyId", "Signature".
    :type param_indicator: str or ~azure.mgmt.cdn.models.ParamIndicator
    :param param_name: Required. Parameter name.
    :type param_name: str
    """

    _validation = {
        'param_indicator': {'required': True},
        'param_name': {'required': True},
    }

    _attribute_map = {
        'param_indicator': {'key': 'paramIndicator', 'type': 'str'},
        'param_name': {'key': 'paramName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        param_indicator: Union[str, "ParamIndicator"],
        param_name: str,
        **kwargs
    ):
        super(UrlSigningParamIdentifier, self).__init__(**kwargs)
        self.param_indicator = param_indicator
        self.param_name = param_name


class UserManagedHttpsParameters(CustomDomainHttpsParameters):
    """Defines the certificate source parameters using user's keyvault certificate for enabling SSL.

    All required parameters must be populated in order to send to Azure.

    :param certificate_source: Required. Defines the source of the SSL certificate.Constant filled
     by server.  Possible values include: "AzureKeyVault", "Cdn".
    :type certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :param protocol_type: Required. Defines the TLS extension protocol that is used for secure
     delivery. Possible values include: "ServerNameIndication", "IPBased".
    :type protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :param minimum_tls_version: TLS protocol version that will be used for Https. Possible values
     include: "None", "TLS10", "TLS12".
    :type minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    :param certificate_source_parameters: Required. Defines the certificate source parameters using
     user's keyvault certificate for enabling SSL.
    :type certificate_source_parameters: ~azure.mgmt.cdn.models.KeyVaultCertificateSourceParameters
    """

    _validation = {
        'certificate_source': {'required': True},
        'protocol_type': {'required': True},
        'certificate_source_parameters': {'required': True},
    }

    _attribute_map = {
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'certificate_source_parameters': {'key': 'certificateSourceParameters', 'type': 'KeyVaultCertificateSourceParameters'},
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "ProtocolType"],
        certificate_source_parameters: "KeyVaultCertificateSourceParameters",
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        **kwargs
    ):
        super(UserManagedHttpsParameters, self).__init__(protocol_type=protocol_type, minimum_tls_version=minimum_tls_version, **kwargs)
        self.certificate_source = 'AzureKeyVault'  # type: str
        self.certificate_source_parameters = certificate_source_parameters


class ValidateCustomDomainInput(msrest.serialization.Model):
    """Input of the custom domain to be validated for DNS mapping.

    All required parameters must be populated in order to send to Azure.

    :param host_name: Required. The host name of the custom domain. Must be a domain name.
    :type host_name: str
    """

    _validation = {
        'host_name': {'required': True},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: str,
        **kwargs
    ):
        super(ValidateCustomDomainInput, self).__init__(**kwargs)
        self.host_name = host_name


class ValidateCustomDomainOutput(msrest.serialization.Model):
    """Output of custom domain validation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar custom_domain_validated: Indicates whether the custom domain is valid or not.
    :vartype custom_domain_validated: bool
    :ivar reason: The reason why the custom domain is not valid.
    :vartype reason: str
    :ivar message: Error message describing why the custom domain is not valid.
    :vartype message: str
    """

    _validation = {
        'custom_domain_validated': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'custom_domain_validated': {'key': 'customDomainValidated', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateCustomDomainOutput, self).__init__(**kwargs)
        self.custom_domain_validated = None
        self.reason = None
        self.message = None


class ValidateProbeInput(msrest.serialization.Model):
    """Input of the validate probe API.

    All required parameters must be populated in order to send to Azure.

    :param probe_url: Required. The probe URL to validate.
    :type probe_url: str
    """

    _validation = {
        'probe_url': {'required': True},
    }

    _attribute_map = {
        'probe_url': {'key': 'probeURL', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        probe_url: str,
        **kwargs
    ):
        super(ValidateProbeInput, self).__init__(**kwargs)
        self.probe_url = probe_url


class ValidateProbeOutput(msrest.serialization.Model):
    """Output of the validate probe API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_valid: Indicates whether the probe URL is accepted or not.
    :vartype is_valid: bool
    :ivar error_code: Specifies the error code when the probe url is not accepted.
    :vartype error_code: str
    :ivar message: The detailed error message describing why the probe URL is not accepted.
    :vartype message: str
    """

    _validation = {
        'is_valid': {'readonly': True},
        'error_code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'is_valid': {'key': 'isValid', 'type': 'bool'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateProbeOutput, self).__init__(**kwargs)
        self.is_valid = None
        self.error_code = None
        self.message = None
