// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <avtTensorMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose:
//   Init utility for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtTensorMetaData::Init()
{
    dim = 0;

    avtTensorMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose:
//   Copy utility for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtTensorMetaData::Copy(const avtTensorMetaData &obj)
{
    dim = obj.dim;

    avtTensorMetaData::SelectAll();
}

// Type map format string
const char *avtTensorMetaData::TypeMapFormatString = AVTTENSORMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtTensorMetaData::TmfsStruct = {AVTTENSORMETADATA_TMFS};


// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose:
//   Default constructor for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtTensorMetaData::avtTensorMetaData() :
    avtVarMetaData(avtTensorMetaData::TmfsStruct)
{
    avtTensorMetaData::Init();
}

// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose:
//   Constructor for the derived classes of avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtTensorMetaData::avtTensorMetaData(private_tmfs_t tmfs) :
    avtVarMetaData(tmfs)
{
    avtTensorMetaData::Init();
}

// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose:
//   Copy constructor for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtTensorMetaData::avtTensorMetaData(const avtTensorMetaData &obj) :
    avtVarMetaData(obj,avtTensorMetaData::TmfsStruct)
{
    avtTensorMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose:
//   Copy constructor for derived classes of the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtTensorMetaData::avtTensorMetaData(const avtTensorMetaData &obj, private_tmfs_t tmfs) :
    avtVarMetaData(obj,tmfs)
{
    avtTensorMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtTensorMetaData::~avtTensorMetaData
//
// Purpose:
//   Destructor for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtTensorMetaData::~avtTensorMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtTensorMetaData::operator =
//
// Purpose:
//   Assignment operator for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtTensorMetaData&
avtTensorMetaData::operator = (const avtTensorMetaData &obj)
{
    if (this == &obj) return *this;

    // call the base class' assignment operator first
    avtVarMetaData::operator=(obj);

    avtTensorMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtTensorMetaData::operator ==
//
// Purpose:
//   Comparison operator == for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtTensorMetaData::operator == (const avtTensorMetaData &obj) const
{
    // Create the return value
    return ((dim == obj.dim) &&
            avtVarMetaData::operator==(obj));
}

// ****************************************************************************
// Method: avtTensorMetaData::operator !=
//
// Purpose:
//   Comparison operator != for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtTensorMetaData::operator != (const avtTensorMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtTensorMetaData::TypeName
//
// Purpose:
//   Type name method for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
avtTensorMetaData::TypeName() const
{
    return "avtTensorMetaData";
}

// ****************************************************************************
// Method: avtTensorMetaData::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtTensorMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtTensorMetaData *tmp = (const avtTensorMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtTensorMetaData::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtTensorMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtTensorMetaData(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: avtTensorMetaData::NewInstance
//
// Purpose:
//   NewInstance method for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtTensorMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtTensorMetaData(*this);
    else
        retval = new avtTensorMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtTensorMetaData::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
avtTensorMetaData::SelectAll()
{
    // call the base class' SelectAll() first
    avtVarMetaData::SelectAll();
    Select(ID_dim, (void *)&dim);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtTensorMetaData::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtTensorMetaData::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_dim: return "dim";
    default:  return avtVarMetaData::GetFieldName(index);
    }
}

// ****************************************************************************
// Method: avtTensorMetaData::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
avtTensorMetaData::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_dim: return FieldType_int;
    default:  return avtVarMetaData::GetFieldType(index);
    }
}

// ****************************************************************************
// Method: avtTensorMetaData::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtTensorMetaData::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_dim: return "int";
    default:  return avtVarMetaData::GetFieldTypeName(index);
    }
}

// ****************************************************************************
// Method: avtTensorMetaData::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtTensorMetaData::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const avtTensorMetaData &obj = *((const avtTensorMetaData*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_dim:
        {  // new scope
        retval = (dim == obj.dim);
        }
        break;
    default: retval = avtVarMetaData::FieldsEqual(index_, rhs);
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtTensorMetaData constructor
//
//  Arguments:
//      n           The name of the tensor variable.
//      mn          The name of the mesh the tensor var is defined on.
//      c           The centering of the variable.
//      vd          The dimension of the variable.
//
//  Programmer: Hank Childs
//  Creation:   September 20, 2003
//
//  Modifications:
//    Brad Whitlock, Tue Jul 20 13:52:39 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
// ****************************************************************************

avtTensorMetaData::avtTensorMetaData(std::string n, std::string mn,
                                     avtCentering c, int vd)
    : avtVarMetaData(avtTensorMetaData::TmfsStruct, n, mn, c)
{
    avtTensorMetaData::Init();
    dim = vd;
}

// ****************************************************************************
//  Method: avtTensorMetaData::Print
//
//  Purpose:
//      Print statement for debugging.
//
//  Arguments:
//      out      The stream to output to.
//      indent   The number of tabs to indent each line with.
//
//  Programmer:  Hank Childs
//  Creation:    September 20, 2003
//
//  Modifications:
//    Brad Whitlock, Tue Jul 20 13:54:42 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
// ****************************************************************************
inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}
void
avtTensorMetaData::Print(ostream &out, int indent) const
{
    avtVarMetaData::Print(out, indent);

    Indent(out, indent);
    out << "Variable Dimension = " << dim << endl;
}

