<p align="center">
  <a href="https://squidfunk.github.io/mkdocs-material/">
    <img src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/logo.svg" width="320" alt="Material for MkDocs">
  </a>
</p>

<p align="center">
  <strong>
    A 
    <a href="https://material.io/">Material Design</a> 
    theme for 
    <a href="https://www.mkdocs.org/">MkDocs</a>
  </strong>
</p>

<p align="center">
  <a href="https://github.com/squidfunk/mkdocs-material/actions"><img
    src="https://github.com/squidfunk/mkdocs-material/workflows/build/badge.svg?branch=master"
    alt="Build"
  /></a>
  <a href="https://pypistats.org/packages/mkdocs-material"><img
    src="https://img.shields.io/pypi/dm/mkdocs-material.svg" 
    alt="Downloads"
  /></a>
  <a href="https://gitter.im/squidfunk/mkdocs-material"><img 
    src="https://badges.gitter.im/squidfunk/mkdocs-material.svg" 
    alt="Chat on Gitter"
  /></a>
  <a href="https://pypi.org/project/mkdocs-material"><img 
    src="https://img.shields.io/pypi/v/mkdocs-material.svg" 
    alt="Python Package Index"
  /></a>
  <a href="https://hub.docker.com/r/squidfunk/mkdocs-material/"><img 
    src="https://img.shields.io/docker/pulls/squidfunk/mkdocs-material" 
    alt="Docker Pulls"
  /></a>
</p>

<p align="center">
  Create a branded static site from a set of Markdown files to host the
  documentation of your Open Source or commercial project – customizable,
  searchable, mobile-friendly, 50+ languages. Set up in 5 minutes.
</p>

<p align="center">
  <a href="https://squidfunk.github.io/mkdocs-material/getting-started/">
    <img src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/screenshot.png" width="700" />
  </a>
</p>

<p align="center">
  <em>
    Check out the demo – 
    <a
      href="https://squidfunk.github.io/mkdocs-material/"
    >squidfunk.github.io/mkdocs-material</a>.
  </em>
</p>

<h2></h2>
<p>&nbsp;</p>
<p id="premium-sponsors" align="center"><strong>Special thanks</strong> to our <strong>premium sponsors</strong>:</p>
<p>&nbsp;</p>
<p align="center">
  <a href="https://cirrus-ci.org/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-cirrus-ci.png" height="65"
  /></a>
  <a href="https://docs.baslerweb.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-basler.png" height="65"
  /></a>
  <a href="https://hummingbot.io/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-hummingbot.png" height="65"
  /></a>
  <a href="https://kx.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-kx.png" height="65"
  /></a>
  <a href="https://www.manticoregames.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-manticore-games.png" height="65"
  /></a>
  <a href="https://www.accounttechnologies.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-account-technologies.png" height="65"
  /></a>
  <a href="https://orion-docs.prefect.io/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-prefect.png" height="65"
  /></a>
  <a href="https://datadoghq.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-datadog.png" height="65"
  /></a>
  <a href="https://www.zenoss.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-zenoss.png" height="65"
  /></a>
  <a href="https://www.elli.eco/en/home" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-elli.png" height="65"
  /></a>
</p>
<p>&nbsp;</p>

## Features

* **It's just Markdown ...** — write your technical documentation in Markdown –
  no need to know HTML, JavaScript or CSS. Material for MkDocs will do the heavy
  lifting and create a beautiful and functional website.

* **... but there's more** — integrates natively with Python Markdown
  Extensions, adding callouts, tabbed content containers, mathematical formulas,
  critic markup, task lists, and [more than 10k icons and emojis][icons-emojis].

* **Responsive by design** — built from the ground up to work on all kinds of
  devices – from mobile phones to widescreens. The underlying fluid layout will
  always adapt perfectly to the available screen space.

* **Static, but searchable** — almost magically, your technical documentation
  website will be searchable without any further ado. Material for MkDocs comes
  with built-in search – no server needed.

* **Many configuration options** — change the color palette, font families,
  language, icons, favicon and logo. Add a source repository link, links to your
  social profiles, and Google Analytics - all with a few lines of config.

* **Truly international** — thanks to many contributors, Material for MkDocs
  includes translations for more than 40 languages and offers full native RTL
  (right-to-left) support.

* **Accessible** — Material for MkDocs provides extensible keyboard navigation
  and semantic markup including role attributes and landmarks. Furthermore, the
  layout respects the user's default font size.

* **Modern architecture** — Material for MkDocs's underlying codebase is built
  on top of TypeScript, RxJS, and SCSS, bringing excellent possibilities for
  theme extension and customization.

Material for MkDocs follows the __sponsorware__ release strategy, which means
that new features are first exclusively released to sponsors as part of
[Insiders]. Read on to learn [what sponsorships achieve],
[how to become a sponsor] to get access to Insiders, and
[what's in for you][available features]!

  [icons-emojis]: https://squidfunk.github.io/mkdocs-material/reference/icons-emojis/
  [Insiders]: https://squidfunk.github.io/mkdocs-material/insiders/#what-is-insiders
  [what sponsorships achieve]: https://squidfunk.github.io/mkdocs-material/insiders/#what-sponsorships-achieve
  [how to become a sponsor]: https://squidfunk.github.io/mkdocs-material/insiders/#how-to-become-a-sponsor
  [available features]: https://squidfunk.github.io/mkdocs-material/insiders/#available-features

## Quick start

Material for MkDocs can be installed with `pip`:

``` sh
pip install mkdocs-material
```

Add the following line to `mkdocs.yml`:

``` yaml
theme:
  name: material
```

For other installation methods, configuration options, and a demo, visit
[squidfunk.github.io/mkdocs-material][Material for MkDocs]

  [Material for MkDocs]: https://squidfunk.github.io/mkdocs-material/

## Trusted by ...

### ... leading organizations

[Atlassian](https://atlassian.github.io/data-center-helm-charts/),
[AWS](https://aws.github.io/copilot-cli/),
[Binance](https://docs.binance.org/),
[Bloomberg](https://bloomberg.github.io/selekt/),
[CERN](http://abpcomputing.web.cern.ch/),
[Datadog](https://datadoghq.dev/integrations-core/),
[Google](https://google.github.io/accompanist/),
[ING](https://ing-bank.github.io/baker/),
[Intel](https://open-amt-cloud-toolkit.github.io/docs/),
[LinkedIn](https://linkedin.github.io/school-of-sre/),
[Microsoft](https://microsoft.github.io/code-with-engineering-playbook/),
[Mozilla](https://mozillafoundation.github.io/engineering-handbook/),
[Netflix](https://netflix.github.io/titus/),
[Salesforce](https://policy-sentry.readthedocs.io/en/latest/),
[SoundCloud](https://intervene.dev/),
[Square](https://square.github.io/okhttp/),
[Zalando](https://opensource.zalando.com/skipper/)

### ... and successful Open Source projects

[Arduino](https://arduino.github.io/arduino-cli/),
[AutoKeras](https://autokeras.com/),
[BFE](https://www.bfe-networks.net/),
[CentOS](https://docs.infra.centos.org/),
[Crystal](https://crystal-lang.org/reference/),
[Electron](https://www.electron.build/),
[FastAPI](https://fastapi.tiangolo.com/),
[Knative](https://knative.dev/docs/),
[Kubernetes](https://kops.sigs.k8s.io/),
[kSQL](https://docs.ksqldb.io/),
[Nokogiri](https://nokogiri.org/),
[OpenFaaS](https://docs.openfaas.com/),
[Pi-Hole](https://docs.pi-hole.net/),
[Pydantic](https://pydantic-docs.helpmanual.io/),
[Renovate](https://docs.renovatebot.com/),
[Traefik](https://docs.traefik.io/),
[Vapor](https://docs.vapor.codes/),
[ZeroNet](https://zeronet.io/docs/),
[WTF](https://wtfutil.com/)

## License

**MIT License**

Copyright (c) 2016-2022 Martin Donath

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.
