/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2019 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QLabel>
#include <QSlider>
#include <QStyleOptionSlider>

/////////////////////// pappsomspp includes


/////////////////////// Local includes

namespace MsXpS
{
namespace MineXpert
{


class VerticalRuleSlider: public QSlider
{
  Q_OBJECT

  public:
  explicit VerticalRuleSlider(QWidget *parent_p = nullptr);
  virtual ~VerticalRuleSlider();

  void updatePosLabelXaxisValue(double x = -1);
  void setXposLabelVisible(bool visible);

  public slots:
  void computeHandlePosition(int value = -1);

  signals:
  void sliderHandleCenterPositionXChangedSignal(int xPosLocal);

  protected:
  QRect m_sliderHandleRect;
  QLabel *mp_xPosLabel    = nullptr;
  double m_lastXaxisValue = 0;
};


} // namespace MineXpert
} // namespace MsXpS
