# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class ResampleWithDataSet(PassInputTypeAlgorithm):
    r"""
    ResampleWithDataSet - sample point and cell data of a dataset on
    points from another dataset.
    
    Superclass: PassInputTypeAlgorithm
    
    Similar to CompositeDataProbeFilter, ResampleWithDataSet takes
    two inputs - Input and Source, and samples the point and cell values
    of Source on to the point locations of Input. The output has the same
    structure as Input but its point data have the resampled values from
    Source. Unlike CompositeDataProbeFilter, this filter support
    composite datasets for both Input and Source.
    @sa
    CompositeDataProbeFilter ResampleToImage
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkResampleWithDataSet, obj, update, **traits)
    
    compute_tolerance = tvtk_base.true_bool_trait(desc=\
        r"""
        Set whether to use the Tolerance field or precompute the
        tolerance. When on, the tolerance will be computed and the field
        value is ignored. Off by default.
        """
    )

    def _compute_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeTolerance,
                        self.compute_tolerance_)

    mark_blank_points_and_cells = tvtk_base.true_bool_trait(desc=\
        r"""
        Set whether points without resampled values, and their
        corresponding cells, should be marked as Blank. Default is On.
        """
    )

    def _mark_blank_points_and_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMarkBlankPointsAndCells,
                        self.mark_blank_points_and_cells_)

    pass_cell_arrays = tvtk_base.false_bool_trait(desc=\
        r"""
        Shallow copy the input cell data arrays to the output. Off by
        default.
        """
    )

    def _pass_cell_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassCellArrays,
                        self.pass_cell_arrays_)

    pass_field_arrays = tvtk_base.true_bool_trait(desc=\
        r"""
        Set whether to pass the field-data arrays from the Input i.e. the
        input providing the geometry to the output. On by default.
        """
    )

    def _pass_field_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassFieldArrays,
                        self.pass_field_arrays_)

    pass_partial_arrays = tvtk_base.false_bool_trait(desc=\
        r"""
        When sampling from composite datasets, partial arrays are common
        i.e. data-arrays that are not available in all of the blocks. By
        default, this filter only passes those point and cell data-arrays
        that are available in all the blocks i.e. partial arrays are
        removed.  When pass_partial_arrays is turned on, this behavior is
        changed to take a union of all arrays present thus partial arrays
        are passed as well. However, for composite dataset input, this
        filter still produces a non-composite output. For all those
        locations in a block of where a particular data array is missing,
        this filter uses Math::Nan() for double and float arrays, and
        0 for all other types of arrays e.g. int, char, etc. Off by
        default.
        """
    )

    def _pass_partial_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassPartialArrays,
                        self.pass_partial_arrays_)

    pass_point_arrays = tvtk_base.false_bool_trait(desc=\
        r"""
        Shallow copy the input point data arrays to the output Off by
        default.
        """
    )

    def _pass_point_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassPointArrays,
                        self.pass_point_arrays_)

    categorical_data = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Control whether the source point data is to be treated as
        categorical. If the data is categorical, then the resultant data
        will be determined by a nearest neighbor interpolation scheme.
        """
    )

    def _categorical_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCategoricalData,
                        self.categorical_data)

    def _get_cell_locator_prototype(self):
        return wrap_vtk(self._vtk_obj.GetCellLocatorPrototype())
    def _set_cell_locator_prototype(self, arg):
        old_val = self._get_cell_locator_prototype()
        self._wrap_call(self._vtk_obj.SetCellLocatorPrototype,
                        deref_vtk(arg))
        self.trait_property_changed('cell_locator_prototype', old_val, arg)
    cell_locator_prototype = traits.Property(_get_cell_locator_prototype, _set_cell_locator_prototype, desc=\
        r"""
        Set whether points without resampled values, and their
        corresponding cells, should be marked as Blank. Default is On.
        """
    )

    tolerance = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set the tolerance used to compute whether a point in the source
        is in a cell of the input.  This value is only used if
        compute_tolerance is off.
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def set_source_connection(self, *args):
        """
        set_source_connection(self, algOutput:AlgorithmOutput) -> None
        C++: void set_source_connection(AlgorithmOutput *algOutput)
        Specify the data set that will be probed at the input points. The
        Input gives the geometry (the points and cells) for the output,
        while the Source is probed (interpolated) to generate the
        scalars, vectors, etc. for the output points based on the point
        locations.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceConnection, *my_args)
        return ret

    def set_source_data(self, *args):
        """
        set_source_data(self, source:DataObject) -> None
        C++: void set_source_data(DataObject *source)
        Specify the data set that will be probed at the input points. The
        Input gives the geometry (the points and cells) for the output,
        while the Source is probed (interpolated) to generate the
        scalars, vectors, etc. for the output points based on the point
        locations.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceData, *my_args)
        return ret

    _updateable_traits_ = \
    (('compute_tolerance', 'GetComputeTolerance'),
    ('mark_blank_points_and_cells', 'GetMarkBlankPointsAndCells'),
    ('pass_cell_arrays', 'GetPassCellArrays'), ('pass_field_arrays',
    'GetPassFieldArrays'), ('pass_partial_arrays',
    'GetPassPartialArrays'), ('pass_point_arrays', 'GetPassPointArrays'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('categorical_data', 'GetCategoricalData'), ('tolerance',
    'GetTolerance'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_tolerance', 'debug',
    'global_warning_display', 'mark_blank_points_and_cells',
    'pass_cell_arrays', 'pass_field_arrays', 'pass_partial_arrays',
    'pass_point_arrays', 'release_data_flag', 'categorical_data',
    'progress_text', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ResampleWithDataSet, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ResampleWithDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_tolerance', 'mark_blank_points_and_cells',
            'pass_cell_arrays', 'pass_field_arrays', 'pass_partial_arrays',
            'pass_point_arrays'], [], ['categorical_data', 'tolerance']),
            title='Edit ResampleWithDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ResampleWithDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

