/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef EXTENSIONS_HELPIDS_H
#define EXTENSIONS_HELPIDS_H

#include <rtl/ustring.hxx>

inline constexpr OUString HID_ABSPILOT_PREVIOUS = u"EXTENSIONS_HID_ABSPILOT_PREVIOUS"_ustr;
inline constexpr OUString HID_ABSPILOT_NEXT = u"EXTENSIONS_HID_ABSPILOT_NEXT"_ustr;
inline constexpr OUString HID_ABSPILOT_CANCEL = u"EXTENSIONS_HID_ABSPILOT_CANCEL"_ustr;
inline constexpr OUString HID_ABSPILOT_FINISH = u"EXTENSIONS_HID_ABSPILOT_FINISH"_ustr;
inline constexpr OUString UID_ABSPILOT_HELP = u"EXTENSIONS_UID_ABSPILOT_HELP"_ustr;
inline constexpr OUString HID_ABSPILOT = u"EXTENSIONS_HID_ABSPILOT"_ustr;

inline constexpr OUString HID_BIB_IDENTIFIER_POS = u"EXTENSIONS_HID_BIB_IDENTIFIER_POS"_ustr;
inline constexpr OUString HID_BIB_AUTHORITYTYPE_POS = u"EXTENSIONS_HID_BIB_AUTHORITYTYPE_POS"_ustr;
inline constexpr OUString HID_BIB_AUTHOR_POS = u"EXTENSIONS_HID_BIB_AUTHOR_POS"_ustr;
inline constexpr OUString HID_BIB_TITLE_POS = u"EXTENSIONS_HID_BIB_TITLE_POS"_ustr;
inline constexpr OUString HID_BIB_YEAR_POS = u"EXTENSIONS_HID_BIB_YEAR_POS"_ustr;
inline constexpr OUString HID_BIB_ISBN_POS = u"EXTENSIONS_HID_BIB_ISBN_POS"_ustr;
inline constexpr OUString HID_BIB_BOOKTITLE_POS = u"EXTENSIONS_HID_BIB_BOOKTITLE_POS"_ustr;
inline constexpr OUString HID_BIB_CHAPTER_POS = u"EXTENSIONS_HID_BIB_CHAPTER_POS"_ustr;
inline constexpr OUString HID_BIB_EDITION_POS = u"EXTENSIONS_HID_BIB_EDITION_POS"_ustr;
inline constexpr OUString HID_BIB_EDITOR_POS = u"EXTENSIONS_HID_BIB_EDITOR_POS"_ustr;
inline constexpr OUString HID_BIB_HOWPUBLISHED_POS = u"EXTENSIONS_HID_BIB_HOWPUBLISHED_POS"_ustr;
inline constexpr OUString HID_BIB_INSTITUTION_POS = u"EXTENSIONS_HID_BIB_INSTITUTION_POS"_ustr;
inline constexpr OUString HID_BIB_JOURNAL_POS = u"EXTENSIONS_HID_BIB_JOURNAL_POS"_ustr;
inline constexpr OUString HID_BIB_MONTH_POS = u"EXTENSIONS_HID_BIB_MONTH_POS"_ustr;
inline constexpr OUString HID_BIB_NOTE_POS = u"EXTENSIONS_HID_BIB_NOTE_POS"_ustr;
inline constexpr OUString HID_BIB_ANNOTE_POS = u"EXTENSIONS_HID_BIB_ANNOTE_POS"_ustr;
inline constexpr OUString HID_BIB_NUMBER_POS = u"EXTENSIONS_HID_BIB_NUMBER_POS"_ustr;
inline constexpr OUString HID_BIB_ORGANIZATIONS_POS = u"EXTENSIONS_HID_BIB_ORGANIZATIONS_POS"_ustr;
inline constexpr OUString HID_BIB_PAGES_POS = u"EXTENSIONS_HID_BIB_PAGES_POS"_ustr;
inline constexpr OUString HID_BIB_PUBLISHER_POS = u"EXTENSIONS_HID_BIB_PUBLISHER_POS"_ustr;
inline constexpr OUString HID_BIB_ADDRESS_POS = u"EXTENSIONS_HID_BIB_ADDRESS_POS"_ustr;
inline constexpr OUString HID_BIB_SCHOOL_POS = u"EXTENSIONS_HID_BIB_SCHOOL_POS"_ustr;
inline constexpr OUString HID_BIB_SERIES_POS = u"EXTENSIONS_HID_BIB_SERIES_POS"_ustr;
inline constexpr OUString HID_BIB_REPORTTYPE_POS = u"EXTENSIONS_HID_BIB_REPORTTYPE_POS"_ustr;
inline constexpr OUString HID_BIB_VOLUME_POS = u"EXTENSIONS_HID_BIB_VOLUME_POS"_ustr;
inline constexpr OUString HID_BIB_URL_POS = u"EXTENSIONS_HID_BIB_URL_POS"_ustr;
inline constexpr OUString HID_BIB_CUSTOM1_POS = u"EXTENSIONS_HID_BIB_CUSTOM1_POS"_ustr;
inline constexpr OUString HID_BIB_CUSTOM2_POS = u"EXTENSIONS_HID_BIB_CUSTOM2_POS"_ustr;
inline constexpr OUString HID_BIB_CUSTOM3_POS = u"EXTENSIONS_HID_BIB_CUSTOM3_POS"_ustr;
inline constexpr OUString HID_BIB_CUSTOM4_POS = u"EXTENSIONS_HID_BIB_CUSTOM4_POS"_ustr;
inline constexpr OUString HID_BIB_CUSTOM5_POS = u"EXTENSIONS_HID_BIB_CUSTOM5_POS"_ustr;
inline constexpr OUString HID_BIB_LOCAL_URL_POS = u"EXTENSIONS_HID_BIB_LOCAL_URL_POS"_ustr;
#define HID_BIB_DB_GRIDCTRL                             "EXTENSIONS_HID_BIB_DB_GRIDCTRL"

inline constexpr OUString HID_GROUPWIZARD_PREVIOUS = u"EXTENSIONS_HID_GROUPWIZARD_PREVIOUS"_ustr;
inline constexpr OUString HID_GROUPWIZARD_NEXT = u"EXTENSIONS_HID_GROUPWIZARD_NEXT"_ustr;
inline constexpr OUString HID_GROUPWIZARD_CANCEL = u"EXTENSIONS_HID_GROUPWIZARD_CANCEL"_ustr;
inline constexpr OUString HID_GROUPWIZARD_FINISH = u"EXTENSIONS_HID_GROUPWIZARD_FINISH"_ustr;
inline constexpr OUString HID_LISTWIZARD_PREVIOUS = u"EXTENSIONS_HID_LISTWIZARD_PREVIOUS"_ustr;
inline constexpr OUString HID_LISTWIZARD_NEXT = u"EXTENSIONS_HID_LISTWIZARD_NEXT"_ustr;
inline constexpr OUString HID_LISTWIZARD_CANCEL = u"EXTENSIONS_HID_LISTWIZARD_CANCEL"_ustr;
inline constexpr OUString HID_LISTWIZARD_FINISH = u"EXTENSIONS_HID_LISTWIZARD_FINISH"_ustr;
inline constexpr OUString HID_GRIDWIZARD_PREVIOUS = u"EXTENSIONS_HID_GRIDWIZARD_PREVIOUS"_ustr;
inline constexpr OUString HID_GRIDWIZARD_NEXT = u"EXTENSIONS_HID_GRIDWIZARD_NEXT"_ustr;
inline constexpr OUString HID_GRIDWIZARD_CANCEL = u"EXTENSIONS_HID_GRIDWIZARD_CANCEL"_ustr;
inline constexpr OUString HID_GRIDWIZARD_FINISH = u"EXTENSIONS_HID_GRIDWIZARD_FINISH"_ustr;

inline constexpr OUString HID_PROP_INPUT_REQUIRED = u"EXTENSIONS_HID_PROP_INPUT_REQUIRED"_ustr;
inline constexpr OUString HID_PROP_CONTROLSOURCE = u"EXTENSIONS_HID_PROP_CONTROLSOURCE"_ustr;
inline constexpr OUString HID_PROP_NAME = u"EXTENSIONS_HID_PROP_NAME"_ustr;
inline constexpr OUString HID_PROP_TABINDEX = u"EXTENSIONS_HID_PROP_TABINDEX"_ustr;
inline constexpr OUString HID_PROP_MASTERFIELDS = u"EXTENSIONS_HID_PROP_MASTERFIELDS"_ustr;
inline constexpr OUString HID_PROP_SLAVEFIELDS = u"EXTENSIONS_HID_PROP_SLAVEFIELDS"_ustr;
inline constexpr OUString HID_PROP_DATASOURCE = u"EXTENSIONS_HID_PROP_DATASOURCE"_ustr;
inline constexpr OUString HID_PROP_CURSORSOURCE = u"EXTENSIONS_HID_PROP_CURSORSOURCE"_ustr;
inline constexpr OUString HID_PROP_CURSORSOURCETYPE = u"EXTENSIONS_HID_PROP_CURSORSOURCETYPE"_ustr;
inline constexpr OUString HID_PROP_READONLY = u"EXTENSIONS_HID_PROP_READONLY"_ustr;
inline constexpr OUString HID_PROP_DATAENTRY = u"EXTENSIONS_HID_PROP_DATAENTRY"_ustr;
inline constexpr OUString HID_PROP_NAVIGATION = u"EXTENSIONS_HID_PROP_NAVIGATION"_ustr;
inline constexpr OUString HID_PROP_CYCLE = u"EXTENSIONS_HID_PROP_CYCLE"_ustr;
inline constexpr OUString HID_PROP_ALLOW_ADDITIONS = u"EXTENSIONS_HID_PROP_ALLOW_ADDITIONS"_ustr;
inline constexpr OUString HID_PROP_ALLOW_EDITS = u"EXTENSIONS_HID_PROP_ALLOW_EDITS"_ustr;
inline constexpr OUString HID_PROP_ALLOW_DELETIONS = u"EXTENSIONS_HID_PROP_ALLOW_DELETIONS"_ustr;
inline constexpr OUString HID_PROP_VALUE = u"EXTENSIONS_HID_PROP_VALUE"_ustr;
inline constexpr OUString HID_PROP_FORMATKEY = u"EXTENSIONS_HID_PROP_FORMATKEY"_ustr;
inline constexpr OUString HID_PROP_WHEEL_BEHAVIOR = u"EXTENSIONS_HID_PROP_WHEEL_BEHAVIOR"_ustr;
inline constexpr OUString HID_PROP_HEIGHT = u"EXTENSIONS_HID_PROP_HEIGHT"_ustr;
inline constexpr OUString HID_PROP_WIDTH = u"EXTENSIONS_HID_PROP_WIDTH"_ustr;
inline constexpr OUString HID_PROP_AUTOGROW = u"EXTENSIONS_HID_PROP_AUTOGROW"_ustr;
inline constexpr OUString HID_PROP_BOUNDCOLUMN = u"EXTENSIONS_HID_PROP_BOUNDCOLUMN"_ustr;
inline constexpr OUString HID_PROP_LISTSOURCETYPE = u"EXTENSIONS_HID_PROP_LISTSOURCETYPE"_ustr;
inline constexpr OUString HID_PROP_LISTSOURCE = u"EXTENSIONS_HID_PROP_LISTSOURCE"_ustr;
inline constexpr OUString HID_PROP_LISTINDEX = u"EXTENSIONS_HID_PROP_LISTINDEX"_ustr;
inline constexpr OUString HID_PROP_TEXT = u"EXTENSIONS_HID_PROP_TEXT"_ustr;
inline constexpr OUString HID_PROP_LABEL = u"EXTENSIONS_HID_PROP_LABEL"_ustr;
inline constexpr OUString HID_PROP_STRINGITEMLIST = u"EXTENSIONS_HID_PROP_STRINGITEMLIST"_ustr;
inline constexpr OUString HID_PROP_FONT = u"EXTENSIONS_HID_PROP_FONT"_ustr;
inline constexpr OUString HID_PROP_ROWHEIGHT = u"EXTENSIONS_HID_PROP_ROWHEIGHT"_ustr;
inline constexpr OUString HID_PROP_BACKGROUNDCOLOR = u"EXTENSIONS_HID_PROP_BACKGROUNDCOLOR"_ustr;
inline constexpr OUString HID_PROP_FILLCOLOR = u"EXTENSIONS_HID_PROP_FILLCOLOR"_ustr;
inline constexpr OUString HID_PROP_LINECOLOR = u"EXTENSIONS_HID_PROP_LINECOLOR"_ustr;
inline constexpr OUString HID_PROP_BORDER = u"EXTENSIONS_HID_PROP_BORDER"_ustr;
inline constexpr OUString HID_PROP_ALIGN = u"EXTENSIONS_HID_PROP_ALIGN"_ustr;
inline constexpr OUString HID_PROP_VERTICAL_ALIGN = u"EXTENSIONS_HID_PROP_VERTICAL_ALIGN"_ustr;
inline constexpr OUString HID_PROP_DROPDOWN = u"EXTENSIONS_HID_PROP_DROPDOWN"_ustr;
inline constexpr OUString HID_PROP_MULTILINE = u"EXTENSIONS_HID_PROP_MULTILINE"_ustr;
inline constexpr OUString HID_PROP_HSCROLL = u"EXTENSIONS_HID_PROP_HSCROLL"_ustr;
inline constexpr OUString HID_PROP_VSCROLL = u"EXTENSIONS_HID_PROP_VSCROLL"_ustr;
inline constexpr OUString HID_PROP_TABSTOP = u"EXTENSIONS_HID_PROP_TABSTOP"_ustr;
inline constexpr OUString HID_PROP_REFVALUE = u"EXTENSIONS_HID_PROP_REFVALUE"_ustr;
inline constexpr OUString HID_PROP_BUTTONTYPE = u"EXTENSIONS_HID_PROP_BUTTONTYPE"_ustr;
inline constexpr OUString HID_PROP_SUBMIT_ACTION = u"EXTENSIONS_HID_PROP_SUBMIT_ACTION"_ustr;
inline constexpr OUString HID_PROP_SUBMIT_METHOD = u"EXTENSIONS_HID_PROP_SUBMIT_METHOD"_ustr;
inline constexpr OUString HID_PROP_SUBMIT_ENCODING = u"EXTENSIONS_HID_PROP_SUBMIT_ENCODING"_ustr;
inline constexpr OUString HID_PROP_DEFAULTVALUE = u"EXTENSIONS_HID_PROP_DEFAULTVALUE"_ustr;
inline constexpr OUString HID_PROP_SUBMIT_TARGET = u"EXTENSIONS_HID_PROP_SUBMIT_TARGET"_ustr;
inline constexpr OUString HID_PROP_DEFAULT_STATE = u"EXTENSIONS_HID_PROP_DEFAULT_STATE"_ustr;
inline constexpr OUString HID_PROP_IMAGE_URL = u"EXTENSIONS_HID_PROP_IMAGE_URL"_ustr;
inline constexpr OUString HID_PROP_DEFAULT_SELECT_SEQ = u"EXTENSIONS_HID_PROP_DEFAULT_SELECT_SEQ"_ustr;
inline constexpr OUString HID_PROP_MULTISELECTION = u"EXTENSIONS_HID_PROP_MULTISELECTION"_ustr;
inline constexpr OUString HID_PROP_DATE = u"EXTENSIONS_HID_PROP_DATE"_ustr;
inline constexpr OUString HID_PROP_DATEMIN = u"EXTENSIONS_HID_PROP_DATEMIN"_ustr;
inline constexpr OUString HID_PROP_DATEMAX = u"EXTENSIONS_HID_PROP_DATEMAX"_ustr;
inline constexpr OUString HID_PROP_DATEFORMAT = u"EXTENSIONS_HID_PROP_DATEFORMAT"_ustr;
inline constexpr OUString HID_PROP_TIME = u"EXTENSIONS_HID_PROP_TIME"_ustr;
inline constexpr OUString HID_PROP_TIMEMIN = u"EXTENSIONS_HID_PROP_TIMEMIN"_ustr;
inline constexpr OUString HID_PROP_TIMEMAX = u"EXTENSIONS_HID_PROP_TIMEMAX"_ustr;
inline constexpr OUString HID_PROP_TIMEFORMAT = u"EXTENSIONS_HID_PROP_TIMEFORMAT"_ustr;
inline constexpr OUString HID_PROP_VALUEMIN = u"EXTENSIONS_HID_PROP_VALUEMIN"_ustr;
inline constexpr OUString HID_PROP_VALUEMAX = u"EXTENSIONS_HID_PROP_VALUEMAX"_ustr;
inline constexpr OUString HID_PROP_VALUESTEP = u"EXTENSIONS_HID_PROP_VALUESTEP"_ustr;
inline constexpr OUString HID_PROP_CURRENCYSYMBOL = u"EXTENSIONS_HID_PROP_CURRENCYSYMBOL"_ustr;
inline constexpr OUString HID_PROP_EDITMASK = u"EXTENSIONS_HID_PROP_EDITMASK"_ustr;
inline constexpr OUString HID_PROP_LITERALMASK = u"EXTENSIONS_HID_PROP_LITERALMASK"_ustr;
inline constexpr OUString HID_PROP_ENABLED = u"EXTENSIONS_HID_PROP_ENABLED"_ustr;
inline constexpr OUString HID_PROP_AUTOCOMPLETE = u"EXTENSIONS_HID_PROP_AUTOCOMPLETE"_ustr;
inline constexpr OUString HID_PROP_LINECOUNT = u"EXTENSIONS_HID_PROP_LINECOUNT"_ustr;
inline constexpr OUString HID_PROP_MAXTEXTLEN = u"EXTENSIONS_HID_PROP_MAXTEXTLEN"_ustr;
inline constexpr OUString HID_PROP_SPIN = u"EXTENSIONS_HID_PROP_SPIN"_ustr;
inline constexpr OUString HID_PROP_STRICTFORMAT = u"EXTENSIONS_HID_PROP_STRICTFORMAT"_ustr;
inline constexpr OUString HID_PROP_SHOWTHOUSANDSEP = u"EXTENSIONS_HID_PROP_SHOWTHOUSANDSEP"_ustr;
inline constexpr OUString HID_PROP_PRINTABLE = u"EXTENSIONS_HID_PROP_PRINTABLE"_ustr;
inline constexpr OUString HID_PROP_TARGET_URL = u"EXTENSIONS_HID_PROP_TARGET_URL"_ustr;
inline constexpr OUString HID_PROP_TARGET_FRAME = u"EXTENSIONS_HID_PROP_TARGET_FRAME"_ustr;
inline constexpr OUString HID_PROP_TAG = u"EXTENSIONS_HID_PROP_TAG"_ustr;
inline constexpr OUString HID_PROP_ECHO_CHAR = u"EXTENSIONS_HID_PROP_ECHO_CHAR"_ustr;
inline constexpr OUString HID_PROP_EMPTY_IS_NULL = u"EXTENSIONS_HID_PROP_EMPTY_IS_NULL"_ustr;
inline constexpr OUString HID_PROP_DECIMAL_ACCURACY = u"EXTENSIONS_HID_PROP_DECIMAL_ACCURACY"_ustr;
inline constexpr OUString HID_PROP_ENABLE_VISIBLE = u"EXTENSIONS_HID_PROP_ENABLE_VISIBLE"_ustr;
inline constexpr OUString HID_PROP_DEFAULT_BUTTON = u"EXTENSIONS_HID_PROP_DEFAULT_BUTTON"_ustr;
inline constexpr OUString HID_PROP_HIDDEN_VALUE = u"EXTENSIONS_HID_PROP_HIDDEN_VALUE"_ustr;
inline constexpr OUString HID_PROP_TRISTATE = u"EXTENSIONS_HID_PROP_TRISTATE"_ustr;
inline constexpr OUString HID_PROP_NAVIGATIONBAR = u"EXTENSIONS_HID_PROP_NAVIGATIONBAR"_ustr;
inline constexpr OUString HID_PROP_FILTER = u"EXTENSIONS_HID_PROP_FILTER"_ustr;
inline constexpr OUString HID_PROP_SORT_CRITERIA = u"EXTENSIONS_HID_PROP_SORT_CRITERIA"_ustr;
inline constexpr OUString HID_PROP_DEFAULT_LONG_VALUE = u"EXTENSIONS_HID_PROP_DEFAULT_LONG_VALUE"_ustr;
inline constexpr OUString HID_PROP_DEFAULT_TIME = u"EXTENSIONS_HID_PROP_DEFAULT_TIME"_ustr;
inline constexpr OUString HID_PROP_DEFAULT_DATE = u"EXTENSIONS_HID_PROP_DEFAULT_DATE"_ustr;
inline constexpr OUString HID_PROP_HELPTEXT = u"EXTENSIONS_HID_PROP_HELPTEXT"_ustr;
inline constexpr OUString HID_PROP_HELPURL = u"EXTENSIONS_HID_PROP_HELPURL"_ustr;
inline constexpr OUString HID_PROP_RECORDMARKER = u"EXTENSIONS_HID_PROP_RECORDMARKER"_ustr;
inline constexpr OUString HID_PROP_FILTERPROPOSAL = u"EXTENSIONS_HID_PROP_FILTERPROPOSAL"_ustr;
inline constexpr OUString HID_PROP_EFFECTIVEMIN = u"EXTENSIONS_HID_PROP_EFFECTIVEMIN"_ustr;
inline constexpr OUString HID_PROP_EFFECTIVEMAX = u"EXTENSIONS_HID_PROP_EFFECTIVEMAX"_ustr;
inline constexpr OUString HID_PROP_EFFECTIVEDEFAULT = u"EXTENSIONS_HID_PROP_EFFECTIVEDEFAULT"_ustr;
inline constexpr OUString HID_PROP_CONTROLLABEL = u"EXTENSIONS_HID_PROP_CONTROLLABEL"_ustr;
inline constexpr OUString HID_PROP_CURRSYM_POSITION = u"EXTENSIONS_HID_PROP_CURRSYM_POSITION"_ustr;
inline constexpr OUString HID_PROP_ESCAPE_PROCESSING = u"EXTENSIONS_HID_PROP_ESCAPE_PROCESSING"_ustr;
inline constexpr OUString HID_PROP_TITLE = u"EXTENSIONS_HID_PROP_TITLE"_ustr;
inline constexpr OUString HID_PROP_STEP = u"EXTENSIONS_HID_PROP_STEP"_ustr;
inline constexpr OUString HID_PROP_PROGRESSVALUE = u"EXTENSIONS_HID_PROP_PROGRESSVALUE"_ustr;
inline constexpr OUString HID_PROP_PROGRESSVALUE_MIN = u"EXTENSIONS_HID_PROP_PROGRESSVALUE_MIN"_ustr;
inline constexpr OUString HID_PROP_PROGRESSVALUE_MAX = u"EXTENSIONS_HID_PROP_PROGRESSVALUE_MAX"_ustr;
inline constexpr OUString HID_PROP_SCROLLVALUE = u"EXTENSIONS_HID_PROP_SCROLLVALUE"_ustr;
inline constexpr OUString HID_PROP_SCROLLVALUE_MAX = u"EXTENSIONS_HID_PROP_SCROLLVALUE_MAX"_ustr;
inline constexpr OUString HID_PROP_SCROLL_WIDTH = u"EXTENSIONS_HID_PROP_SCROLL_WIDTH"_ustr;
inline constexpr OUString HID_PROP_SCROLL_HEIGHT = u"EXTENSIONS_HID_PROP_SCROLL_HEIGHT"_ustr;
inline constexpr OUString HID_PROP_SCROLL_TOP = u"EXTENSIONS_HID_PROP_SCROLL_TOP"_ustr;
inline constexpr OUString HID_PROP_SCROLL_LEFT = u"EXTENSIONS_HID_PROP_SCROLL_LEFT"_ustr;
inline constexpr OUString HID_PROP_LINEINCREMENT = u"EXTENSIONS_HID_PROP_LINEINCREMENT"_ustr;
inline constexpr OUString HID_PROP_BLOCKINCREMENT = u"EXTENSIONS_HID_PROP_BLOCKINCREMENT"_ustr;
inline constexpr OUString HID_PROP_VISIBLESIZE = u"EXTENSIONS_HID_PROP_VISIBLESIZE"_ustr;
inline constexpr OUString HID_PROP_ORIENTATION = u"EXTENSIONS_HID_PROP_ORIENTATION"_ustr;
inline constexpr OUString HID_PROP_POSITIONX = u"EXTENSIONS_HID_PROP_POSITIONX"_ustr;
inline constexpr OUString HID_PROP_POSITIONY = u"EXTENSIONS_HID_PROP_POSITIONY"_ustr;
inline constexpr OUString HID_PROP_PUSHBUTTONTYPE = u"EXTENSIONS_HID_PROP_PUSHBUTTONTYPE"_ustr;
inline constexpr OUString HID_PROP_STATE = u"EXTENSIONS_HID_PROP_STATE"_ustr;
inline constexpr OUString HID_PROP_SCALEIMAGE = u"EXTENSIONS_HID_PROP_SCALEIMAGE"_ustr;
inline constexpr OUString HID_PROP_BOUND_CELL = u"EXTENSIONS_HID_PROP_BOUND_CELL"_ustr;
inline constexpr OUString HID_PROP_LIST_CELL_RANGE = u"EXTENSIONS_HID_PROP_LIST_CELL_RANGE"_ustr;
inline constexpr OUString HID_PROP_CELL_EXCHANGE_TYPE = u"EXTENSIONS_HID_PROP_CELL_EXCHANGE_TYPE"_ustr;
inline constexpr OUString HID_PROP_SELECTEDITEMS = u"EXTENSIONS_HID_PROP_SELECTEDITEMS"_ustr;
inline constexpr OUString HID_PROP_SCROLLVALUE_MIN = u"EXTENSIONS_HID_PROP_SCROLLVALUE_MIN"_ustr;
inline constexpr OUString HID_PROP_DEFAULT_SCROLLVALUE = u"EXTENSIONS_HID_PROP_DEFAULT_SCROLLVALUE"_ustr;
inline constexpr OUString HID_PROP_REPEAT_DELAY = u"EXTENSIONS_HID_PROP_REPEAT_DELAY"_ustr;
inline constexpr OUString HID_PROP_SYMBOLCOLOR = u"EXTENSIONS_HID_PROP_SYMBOLCOLOR"_ustr;
inline constexpr OUString HID_PROP_SPINVALUE = u"EXTENSIONS_HID_PROP_SPINVALUE"_ustr;
inline constexpr OUString HID_PROP_SPINVALUE_MIN = u"EXTENSIONS_HID_PROP_SPINVALUE_MIN"_ustr;
inline constexpr OUString HID_PROP_SPINVALUE_MAX = u"EXTENSIONS_HID_PROP_SPINVALUE_MAX"_ustr;
inline constexpr OUString HID_PROP_DEFAULT_SPINVALUE = u"EXTENSIONS_HID_PROP_DEFAULT_SPINVALUE"_ustr;
inline constexpr OUString HID_PROP_SPININCREMENT = u"EXTENSIONS_HID_PROP_SPININCREMENT"_ustr;
inline constexpr OUString HID_PROP_REPEAT = u"EXTENSIONS_HID_PROP_REPEAT"_ustr;
inline constexpr OUString HID_PROP_WORDBREAK = u"EXTENSIONS_HID_PROP_WORDBREAK"_ustr;
inline constexpr OUString HID_PROP_SHOW_SCROLLBARS = u"EXTENSIONS_HID_PROP_SHOW_SCROLLBARS"_ustr;
inline constexpr OUString HID_PROP_ICONSIZE = u"EXTENSIONS_HID_PROP_ICONSIZE"_ustr;
inline constexpr OUString HID_PROP_SHOW_POSITION = u"EXTENSIONS_HID_PROP_SHOW_POSITION"_ustr;
inline constexpr OUString HID_PROP_SHOW_NAVIGATION = u"EXTENSIONS_HID_PROP_SHOW_NAVIGATION"_ustr;
inline constexpr OUString HID_PROP_SHOW_RECORDACTIONS = u"EXTENSIONS_HID_PROP_SHOW_RECORDACTIONS"_ustr;
inline constexpr OUString HID_PROP_SHOW_FILTERSORT = u"EXTENSIONS_HID_PROP_SHOW_FILTERSORT"_ustr;
inline constexpr OUString HID_PROP_TEXTTYPE = u"EXTENSIONS_HID_PROP_TEXTTYPE"_ustr;
inline constexpr OUString HID_PROP_LINEEND_FORMAT = u"EXTENSIONS_HID_PROP_LINEEND_FORMAT"_ustr;
inline constexpr OUString HID_PROP_XSD_TOTAL_DIGITS = u"EXTENSIONS_HID_PROP_XSD_TOTAL_DIGITS"_ustr;
inline constexpr OUString HID_PROP_XSD_FRACTION_DIGITS = u"EXTENSIONS_HID_PROP_XSD_FRACTION_DIGITS"_ustr;
inline constexpr OUString HID_PROP_XSD_MAX_INCLUSIVE = u"EXTENSIONS_HID_PROP_XSD_MAX_INCLUSIVE"_ustr;
inline constexpr OUString HID_PROP_XSD_MAX_EXCLUSIVE = u"EXTENSIONS_HID_PROP_XSD_MAX_EXCLUSIVE"_ustr;
inline constexpr OUString HID_PROP_XSD_MIN_INCLUSIVE = u"EXTENSIONS_HID_PROP_XSD_MIN_INCLUSIVE"_ustr;
inline constexpr OUString HID_PROP_XSD_MIN_EXCLUSIVE = u"EXTENSIONS_HID_PROP_XSD_MIN_EXCLUSIVE"_ustr;
inline constexpr OUString HID_PROP_UNCHECKEDREFVALUE = u"EXTENSIONS_HID_PROP_UNCHECKEDREFVALUE"_ustr;
inline constexpr OUString HID_PROP_SUBMISSION_ID = u"EXTENSIONS_HID_PROP_SUBMISSION_ID"_ustr;
inline constexpr OUString HID_PROP_XML_DATA_MODEL = u"EXTENSIONS_HID_PROP_XML_DATA_MODEL"_ustr;
inline constexpr OUString HID_PROP_BIND_EXPRESSION = u"EXTENSIONS_HID_PROP_BIND_EXPRESSION"_ustr;
inline constexpr OUString HID_PROP_XSD_REQUIRED = u"EXTENSIONS_HID_PROP_XSD_REQUIRED"_ustr;
inline constexpr OUString HID_PROP_XSD_RELEVANT = u"EXTENSIONS_HID_PROP_XSD_RELEVANT"_ustr;
inline constexpr OUString HID_PROP_XSD_READONLY = u"EXTENSIONS_HID_PROP_XSD_READONLY"_ustr;
inline constexpr OUString HID_PROP_XSD_CONSTRAINT = u"EXTENSIONS_HID_PROP_XSD_CONSTRAINT"_ustr;
inline constexpr OUString HID_PROP_XSD_CALCULATION = u"EXTENSIONS_HID_PROP_XSD_CALCULATION"_ustr;
inline constexpr OUString HID_PROP_XSD_DATA_TYPE = u"EXTENSIONS_HID_PROP_XSD_DATA_TYPE"_ustr;
inline constexpr OUString HID_PROP_XSD_WHITESPACES = u"EXTENSIONS_HID_PROP_XSD_WHITESPACES"_ustr;
inline constexpr OUString HID_PROP_URL = u"EXTENSIONS_HID_PROP_URL"_ustr;
inline constexpr OUString HID_PROP_XSD_PATTERN = u"EXTENSIONS_HID_PROP_XSD_PATTERN"_ustr;
inline constexpr OUString HID_PROP_XSD_LENGTH = u"EXTENSIONS_HID_PROP_XSD_LENGTH"_ustr;
inline constexpr OUString HID_PROP_XSD_MIN_LENGTH = u"EXTENSIONS_HID_PROP_XSD_MIN_LENGTH"_ustr;
inline constexpr OUString HID_PROP_XSD_MAX_LENGTH = u"EXTENSIONS_HID_PROP_XSD_MAX_LENGTH"_ustr;
inline constexpr OUString HID_PROP_LIST_BINDING = u"EXTENSIONS_HID_PROP_LIST_BINDING"_ustr;
inline constexpr OUString HID_PROP_BINDING_NAME = u"EXTENSIONS_HID_PROP_BINDING_NAME"_ustr;
inline constexpr OUString HID_PROP_SELECTION_TYPE = u"EXTENSIONS_HID_PROP_SELECTION_TYPE"_ustr;
inline constexpr OUString HID_PROP_ROOT_DISPLAYED = u"EXTENSIONS_HID_PROP_ROOT_DISPLAYED"_ustr;
inline constexpr OUString HID_PROP_SHOWS_HANDLES = u"EXTENSIONS_HID_PROP_SHOWS_HANDLES"_ustr;
inline constexpr OUString HID_PROP_SHOWS_ROOT_HANDLES = u"EXTENSIONS_HID_PROP_SHOWS_ROOT_HANDLES"_ustr;
inline constexpr OUString HID_PROP_EDITABLE = u"EXTENSIONS_HID_PROP_EDITABLE"_ustr;
inline constexpr OUString HID_PROP_INVOKES_STOP_NOT_EDITING = u"EXTENSIONS_HID_PROP_INVOKES_STOP_NOT_EDITING"_ustr;
inline constexpr OUString HID_PROP_DECORATION = u"EXTENSIONS_HID_PROP_DECORATION"_ustr;
inline constexpr OUString HID_EVT_ACTIONPERFORMED = u"EXTENSIONS_HID_EVT_ACTIONPERFORMED"_ustr;
inline constexpr OUString HID_EVT_AFTERUPDATE = u"EXTENSIONS_HID_EVT_AFTERUPDATE"_ustr;
inline constexpr OUString HID_EVT_BEFOREUPDATE = u"EXTENSIONS_HID_EVT_BEFOREUPDATE"_ustr;
inline constexpr OUString HID_EVT_CONFIRMDELETE = u"EXTENSIONS_HID_EVT_CONFIRMDELETE"_ustr;
inline constexpr OUString HID_EVT_ERROROCCURRED = u"EXTENSIONS_HID_EVT_ERROROCCURRED"_ustr;
inline constexpr OUString HID_EVT_FOCUSGAINED = u"EXTENSIONS_HID_EVT_FOCUSGAINED"_ustr;
inline constexpr OUString HID_EVT_FOCUSLOST = u"EXTENSIONS_HID_EVT_FOCUSLOST"_ustr;
inline constexpr OUString HID_EVT_ITEMSTATECHANGED = u"EXTENSIONS_HID_EVT_ITEMSTATECHANGED"_ustr;
inline constexpr OUString HID_EVT_KEYTYPED = u"EXTENSIONS_HID_EVT_KEYTYPED"_ustr;
inline constexpr OUString HID_EVT_LOADED = u"EXTENSIONS_HID_EVT_LOADED"_ustr;
inline constexpr OUString HID_EVT_MOUSEDRAGGED = u"EXTENSIONS_HID_EVT_MOUSEDRAGGED"_ustr;
inline constexpr OUString HID_EVT_MOUSEENTERED = u"EXTENSIONS_HID_EVT_MOUSEENTERED"_ustr;
inline constexpr OUString HID_EVT_MOUSEEXITED = u"EXTENSIONS_HID_EVT_MOUSEEXITED"_ustr;
inline constexpr OUString HID_EVT_MOUSEMOVED = u"EXTENSIONS_HID_EVT_MOUSEMOVED"_ustr;
inline constexpr OUString HID_EVT_MOUSEPRESSED = u"EXTENSIONS_HID_EVT_MOUSEPRESSED"_ustr;
inline constexpr OUString HID_EVT_MOUSERELEASED = u"EXTENSIONS_HID_EVT_MOUSERELEASED"_ustr;
inline constexpr OUString HID_EVT_POSITIONED = u"EXTENSIONS_HID_EVT_POSITIONED"_ustr;
inline constexpr OUString HID_EVT_RESETTED = u"EXTENSIONS_HID_EVT_RESETTED"_ustr;
inline constexpr OUString HID_EVT_SUBMITTED = u"EXTENSIONS_HID_EVT_SUBMITTED"_ustr;
inline constexpr OUString HID_EVT_TEXTCHANGED = u"EXTENSIONS_HID_EVT_TEXTCHANGED"_ustr;
inline constexpr OUString HID_EVT_UNLOADED = u"EXTENSIONS_HID_EVT_UNLOADED"_ustr;
inline constexpr OUString HID_EVT_CHANGED = u"EXTENSIONS_HID_EVT_CHANGED"_ustr;
inline constexpr OUString HID_EVT_APPROVEACTIONPERFORMED = u"EXTENSIONS_HID_EVT_APPROVEACTIONPERFORMED"_ustr;
inline constexpr OUString HID_EVT_APPROVERESETTED = u"EXTENSIONS_HID_EVT_APPROVERESETTED"_ustr;
inline constexpr OUString HID_EVT_KEYUP = u"EXTENSIONS_HID_EVT_KEYUP"_ustr;
inline constexpr OUString HID_EVT_APPROVEPARAMETER = u"EXTENSIONS_HID_EVT_APPROVEPARAMETER"_ustr;
inline constexpr OUString HID_EVT_POSITIONING = u"EXTENSIONS_HID_EVT_POSITIONING"_ustr;
inline constexpr OUString HID_EVT_RELOADED = u"EXTENSIONS_HID_EVT_RELOADED"_ustr;
inline constexpr OUString HID_EVT_APPROVEROWCHANGE = u"EXTENSIONS_HID_EVT_APPROVEROWCHANGE"_ustr;
inline constexpr OUString HID_EVT_ROWCHANGE = u"EXTENSIONS_HID_EVT_ROWCHANGE"_ustr;
inline constexpr OUString HID_EVT_RELOADING = u"EXTENSIONS_HID_EVT_RELOADING"_ustr;
inline constexpr OUString HID_EVT_UNLOADING = u"EXTENSIONS_HID_EVT_UNLOADING"_ustr;
inline constexpr OUString HID_EVT_ADJUSTMENTVALUECHANGED = u"EXTENSIONS_HID_EVT_ADJUSTMENTVALUECHANGED"_ustr;
inline constexpr OUString HID_PROP_TOGGLE = u"EXTENSIONS_HID_PROP_TOGGLE"_ustr;
inline constexpr OUString HID_PROP_FOCUSONCLICK = u"EXTENSIONS_HID_PROP_FOCUSONCLICK"_ustr;
inline constexpr OUString HID_PROP_HIDEINACTIVESELECTION = u"EXTENSIONS_HID_PROP_HIDEINACTIVESELECTION"_ustr;
inline constexpr OUString HID_PROP_VISUALEFFECT = u"EXTENSIONS_HID_PROP_VISUALEFFECT"_ustr;
inline constexpr OUString HID_PROP_BORDERCOLOR = u"EXTENSIONS_HID_PROP_BORDERCOLOR"_ustr;
inline constexpr OUString HID_PROP_IMAGEPOSITION = u"EXTENSIONS_HID_PROP_IMAGEPOSITION"_ustr;
inline constexpr OUString HID_PROP_NOLABEL = u"EXTENSIONS_HID_PROP_NOLABEL"_ustr;
inline constexpr OUString HID_PROP_WRITING_MODE = u"EXTENSIONS_HID_PROP_WRITING_MODE"_ustr;
inline constexpr OUString HID_PROP_ANCHOR_TYPE = u"EXTENSIONS_HID_PROP_ANCHOR_TYPE"_ustr;
inline constexpr OUString HID_FM_PROPDLG_TABCTR = u"EXTENSIONS_HID_FM_PROPDLG_TABCTR"_ustr;
inline constexpr OUString HID_FM_PROPDLG_TAB_GENERAL = u"EXTENSIONS_HID_FM_PROPDLG_TAB_GENERAL"_ustr;
inline constexpr OUString HID_FM_PROPDLG_TAB_DATA = u"EXTENSIONS_HID_FM_PROPDLG_TAB_DATA"_ustr;
inline constexpr OUString HID_FM_PROPDLG_TAB_EVT = u"EXTENSIONS_HID_FM_PROPDLG_TAB_EVT"_ustr;
inline constexpr OUString HID_PROP_GROUP_NAME = u"EXTENSIONS_HID_PROP_GROUP_NAME"_ustr;

inline constexpr OUString HID_PROP_SELECTIONMODEL = u"EXTENSIONS_HID_PROP_SELECTIONMODEL"_ustr;
inline constexpr OUString HID_PROP_USEGRIDLINE = u"EXTENSIONS_HID_PROP_USEGRIDLINE"_ustr;
inline constexpr OUString HID_PROP_GRIDLINECOLOR = u"EXTENSIONS_HID_PROP_GRIDLINECOLOR"_ustr;
inline constexpr OUString HID_PROP_SHOWCOLUMNHEADER = u"EXTENSIONS_HID_PROP_SHOWCOLUMNHEADER"_ustr;
inline constexpr OUString HID_PROP_SHOWROWHEADER = u"EXTENSIONS_HID_PROP_SHOWROWHEADER"_ustr;
inline constexpr OUString HID_PROP_HEADERBACKGROUNDCOLOR = u"EXTENSIONS_HID_PROP_HEADERBACKGROUNDCOLOR"_ustr;
inline constexpr OUString HID_PROP_HEADERTEXTCOLOR = u"EXTENSIONS_HID_PROP_HEADERTEXTCOLOR"_ustr;
inline constexpr OUString HID_PROP_ACTIVESELECTIONBACKGROUNDCOLOR = u"EXTENSIONS_HID_PROP_ACTIVESELECTIONBACKGROUNDCOLOR"_ustr;
inline constexpr OUString HID_PROP_ACTIVESELECTIONTEXTCOLOR = u"EXTENSIONS_HID_PROP_ACTIVESELECTIONTEXTCOLOR"_ustr;
inline constexpr OUString HID_PROP_INACTIVESELECTIONBACKGROUNDCOLOR = u"EXTENSIONS_HID_PROP_INACTIVESELECTIONBACKGROUNDCOLOR"_ustr;
inline constexpr OUString HID_PROP_INACTIVESELECTIONTEXTCOLOR = u"EXTENSIONS_HID_PROP_INACTIVESELECTIONTEXTCOLOR"_ustr;

#define HID_CHECK_FOR_UPD_DLG                           "EXTENSIONS_HID_CHECK_FOR_UPD_DLG"
#define HID_CHECK_FOR_UPD_CLOSE                         "EXTENSIONS_HID_CHECK_FOR_UPD_CLOSE"
#define HID_CHECK_FOR_UPD_PAUSE                         "EXTENSIONS_HID_CHECK_FOR_UPD_PAUSE"
#define HID_CHECK_FOR_UPD_RESUME                        "EXTENSIONS_HID_CHECK_FOR_UPD_RESUME"
#define HID_CHECK_FOR_UPD_DOWNLOAD                      "EXTENSIONS_HID_CHECK_FOR_UPD_DOWNLOAD"
#define HID_CHECK_FOR_UPD_DOWNLOAD2                     "EXTENSIONS_HID_CHECK_FOR_UPD_DOWNLOAD2"
#define HID_CHECK_FOR_UPD_STATUS                        "EXTENSIONS_HID_CHECK_FOR_UPD_STATUS"
#define HID_CHECK_FOR_UPD_DESCRIPTION                   "EXTENSIONS_HID_CHECK_FOR_UPD_DESCRIPTION"
#define HID_CHECK_FOR_UPD_CANCEL                        "EXTENSIONS_HID_CHECK_FOR_UPD_CANCEL"

#endif // EXTENSIONS_ABPILOT_HRC

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
