# Copyright (C) 2023 Linaro Limited
#
# Author: Rémi Duraffort <remi.duraffort@linaro.org>
#
# SPDX-License-Identifier: GPL-2.0-or-later

# Generated by Django 3.2.19 on 2023-06-28 09:00

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("lava_results_app", "0018_drop_buglink"),
    ]

    operations = [
        migrations.AlterField(
            model_name="query",
            name="content_type",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    ("model__in", ["testsuite", "testjob"]),
                    models.Q(("app_label", "lava_results_app"), ("model", "testcase")),
                    _connector="OR",
                ),
                on_delete=django.db.models.deletion.CASCADE,
                to="contenttypes.contenttype",
                verbose_name="Query object set",
            ),
        ),
        migrations.AlterField(
            model_name="querycondition",
            name="table",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    ("model__in", ["testsuite", "testjob", "namedtestattribute"]),
                    models.Q(("app_label", "lava_results_app"), ("model", "testcase")),
                    _connector="OR",
                ),
                on_delete=django.db.models.deletion.CASCADE,
                to="contenttypes.contenttype",
                verbose_name="Condition model",
            ),
        ),
        migrations.DeleteModel(
            name="ActionData",
        ),
        migrations.DeleteModel(
            name="MetaType",
        ),
    ]
