// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package securitycentermanagement

import (
	securitycentermanagementpb "cloud.google.com/go/securitycentermanagement/apiv1/securitycentermanagementpb"
	"google.golang.org/api/iterator"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
)

// EffectiveEventThreatDetectionCustomModuleIterator manages a stream of *securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule.
type EffectiveEventThreatDetectionCustomModuleIterator struct {
	items    []*securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *EffectiveEventThreatDetectionCustomModuleIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *EffectiveEventThreatDetectionCustomModuleIterator) Next() (*securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule, error) {
	var item *securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *EffectiveEventThreatDetectionCustomModuleIterator) bufLen() int {
	return len(it.items)
}

func (it *EffectiveEventThreatDetectionCustomModuleIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// EffectiveSecurityHealthAnalyticsCustomModuleIterator manages a stream of *securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule.
type EffectiveSecurityHealthAnalyticsCustomModuleIterator struct {
	items    []*securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *EffectiveSecurityHealthAnalyticsCustomModuleIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *EffectiveSecurityHealthAnalyticsCustomModuleIterator) Next() (*securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule, error) {
	var item *securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *EffectiveSecurityHealthAnalyticsCustomModuleIterator) bufLen() int {
	return len(it.items)
}

func (it *EffectiveSecurityHealthAnalyticsCustomModuleIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// EventThreatDetectionCustomModuleIterator manages a stream of *securitycentermanagementpb.EventThreatDetectionCustomModule.
type EventThreatDetectionCustomModuleIterator struct {
	items    []*securitycentermanagementpb.EventThreatDetectionCustomModule
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*securitycentermanagementpb.EventThreatDetectionCustomModule, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *EventThreatDetectionCustomModuleIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *EventThreatDetectionCustomModuleIterator) Next() (*securitycentermanagementpb.EventThreatDetectionCustomModule, error) {
	var item *securitycentermanagementpb.EventThreatDetectionCustomModule
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *EventThreatDetectionCustomModuleIterator) bufLen() int {
	return len(it.items)
}

func (it *EventThreatDetectionCustomModuleIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// LocationIterator manages a stream of *locationpb.Location.
type LocationIterator struct {
	items    []*locationpb.Location
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*locationpb.Location, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *LocationIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *LocationIterator) Next() (*locationpb.Location, error) {
	var item *locationpb.Location
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *LocationIterator) bufLen() int {
	return len(it.items)
}

func (it *LocationIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SecurityCenterServiceIterator manages a stream of *securitycentermanagementpb.SecurityCenterService.
type SecurityCenterServiceIterator struct {
	items    []*securitycentermanagementpb.SecurityCenterService
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*securitycentermanagementpb.SecurityCenterService, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *SecurityCenterServiceIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SecurityCenterServiceIterator) Next() (*securitycentermanagementpb.SecurityCenterService, error) {
	var item *securitycentermanagementpb.SecurityCenterService
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SecurityCenterServiceIterator) bufLen() int {
	return len(it.items)
}

func (it *SecurityCenterServiceIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SecurityHealthAnalyticsCustomModuleIterator manages a stream of *securitycentermanagementpb.SecurityHealthAnalyticsCustomModule.
type SecurityHealthAnalyticsCustomModuleIterator struct {
	items    []*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *SecurityHealthAnalyticsCustomModuleIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SecurityHealthAnalyticsCustomModuleIterator) Next() (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error) {
	var item *securitycentermanagementpb.SecurityHealthAnalyticsCustomModule
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SecurityHealthAnalyticsCustomModuleIterator) bufLen() int {
	return len(it.items)
}

func (it *SecurityHealthAnalyticsCustomModuleIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
