/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// TypeDefinition struct for TypeDefinition
type TypeDefinition struct {
	Type      string              `json:"type" yaml:"type"`
	Relations *map[string]Userset `json:"relations,omitempty" yaml:"relations,omitempty"`
	Metadata  *Metadata           `json:"metadata,omitempty" yaml:"metadata,omitempty"`
}

// NewTypeDefinition instantiates a new TypeDefinition object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTypeDefinition(type_ string) *TypeDefinition {
	this := TypeDefinition{}
	this.Type = type_
	return &this
}

// NewTypeDefinitionWithDefaults instantiates a new TypeDefinition object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTypeDefinitionWithDefaults() *TypeDefinition {
	this := TypeDefinition{}
	return &this
}

// GetType returns the Type field value
func (o *TypeDefinition) GetType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Type
}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
func (o *TypeDefinition) GetTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Type, true
}

// SetType sets field value
func (o *TypeDefinition) SetType(v string) {
	o.Type = v
}

// GetRelations returns the Relations field value if set, zero value otherwise.
func (o *TypeDefinition) GetRelations() map[string]Userset {
	if o == nil || o.Relations == nil {
		var ret map[string]Userset
		return ret
	}
	return *o.Relations
}

// GetRelationsOk returns a tuple with the Relations field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TypeDefinition) GetRelationsOk() (*map[string]Userset, bool) {
	if o == nil || o.Relations == nil {
		return nil, false
	}
	return o.Relations, true
}

// HasRelations returns a boolean if a field has been set.
func (o *TypeDefinition) HasRelations() bool {
	if o != nil && o.Relations != nil {
		return true
	}

	return false
}

// SetRelations gets a reference to the given map[string]Userset and assigns it to the Relations field.
func (o *TypeDefinition) SetRelations(v map[string]Userset) {
	o.Relations = &v
}

// GetMetadata returns the Metadata field value if set, zero value otherwise.
func (o *TypeDefinition) GetMetadata() Metadata {
	if o == nil || o.Metadata == nil {
		var ret Metadata
		return ret
	}
	return *o.Metadata
}

// GetMetadataOk returns a tuple with the Metadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TypeDefinition) GetMetadataOk() (*Metadata, bool) {
	if o == nil || o.Metadata == nil {
		return nil, false
	}
	return o.Metadata, true
}

// HasMetadata returns a boolean if a field has been set.
func (o *TypeDefinition) HasMetadata() bool {
	if o != nil && o.Metadata != nil {
		return true
	}

	return false
}

// SetMetadata gets a reference to the given Metadata and assigns it to the Metadata field.
func (o *TypeDefinition) SetMetadata(v Metadata) {
	o.Metadata = &v
}

func (o TypeDefinition) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["type"] = o.Type
	if o.Relations != nil {
		toSerialize["relations"] = o.Relations
	}
	if o.Metadata != nil {
		toSerialize["metadata"] = o.Metadata
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableTypeDefinition struct {
	value *TypeDefinition
	isSet bool
}

func (v NullableTypeDefinition) Get() *TypeDefinition {
	return v.value
}

func (v *NullableTypeDefinition) Set(val *TypeDefinition) {
	v.value = val
	v.isSet = true
}

func (v NullableTypeDefinition) IsSet() bool {
	return v.isSet
}

func (v *NullableTypeDefinition) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTypeDefinition(val *TypeDefinition) *NullableTypeDefinition {
	return &NullableTypeDefinition{value: val, isSet: true}
}

func (v NullableTypeDefinition) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTypeDefinition) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
