//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/reservations/armreservations/v3"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// QuotaRequestStatusServer is a fake server for instances of the armreservations.QuotaRequestStatusClient type.
type QuotaRequestStatusServer struct {
	// Get is the fake for method QuotaRequestStatusClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, subscriptionID string, providerID string, location string, id string, options *armreservations.QuotaRequestStatusClientGetOptions) (resp azfake.Responder[armreservations.QuotaRequestStatusClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method QuotaRequestStatusClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(subscriptionID string, providerID string, location string, options *armreservations.QuotaRequestStatusClientListOptions) (resp azfake.PagerResponder[armreservations.QuotaRequestStatusClientListResponse])
}

// NewQuotaRequestStatusServerTransport creates a new instance of QuotaRequestStatusServerTransport with the provided implementation.
// The returned QuotaRequestStatusServerTransport instance is connected to an instance of armreservations.QuotaRequestStatusClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewQuotaRequestStatusServerTransport(srv *QuotaRequestStatusServer) *QuotaRequestStatusServerTransport {
	return &QuotaRequestStatusServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armreservations.QuotaRequestStatusClientListResponse]](),
	}
}

// QuotaRequestStatusServerTransport connects instances of armreservations.QuotaRequestStatusClient to instances of QuotaRequestStatusServer.
// Don't use this type directly, use NewQuotaRequestStatusServerTransport instead.
type QuotaRequestStatusServerTransport struct {
	srv          *QuotaRequestStatusServer
	newListPager *tracker[azfake.PagerResponder[armreservations.QuotaRequestStatusClientListResponse]]
}

// Do implements the policy.Transporter interface for QuotaRequestStatusServerTransport.
func (q *QuotaRequestStatusServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "QuotaRequestStatusClient.Get":
		resp, err = q.dispatchGet(req)
	case "QuotaRequestStatusClient.NewListPager":
		resp, err = q.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (q *QuotaRequestStatusServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if q.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Capacity/resourceProviders/(?P<providerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serviceLimitsRequests/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	providerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerId")])
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := q.srv.Get(req.Context(), subscriptionIDParam, providerIDParam, locationParam, idParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).QuotaRequestDetails, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (q *QuotaRequestStatusServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if q.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := q.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Capacity/resourceProviders/(?P<providerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serviceLimitsRequests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		providerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerId")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skiptokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skiptokenParam := getOptional(skiptokenUnescaped)
		var options *armreservations.QuotaRequestStatusClientListOptions
		if filterParam != nil || topParam != nil || skiptokenParam != nil {
			options = &armreservations.QuotaRequestStatusClientListOptions{
				Filter:    filterParam,
				Top:       topParam,
				Skiptoken: skiptokenParam,
			}
		}
		resp := q.srv.NewListPager(subscriptionIDParam, providerIDParam, locationParam, options)
		newListPager = &resp
		q.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armreservations.QuotaRequestStatusClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		q.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		q.newListPager.remove(req)
	}
	return resp, nil
}
