//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridnetwork

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ArmResourceDefinitionResourceElementTemplate.
func (a ArmResourceDefinitionResourceElementTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactProfile", a.ArtifactProfile)
	populate(objectMap, "parameterValues", a.ParameterValues)
	populate(objectMap, "templateType", a.TemplateType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmResourceDefinitionResourceElementTemplate.
func (a *ArmResourceDefinitionResourceElementTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactProfile":
			err = unpopulate(val, "ArtifactProfile", &a.ArtifactProfile)
			delete(rawMsg, key)
		case "parameterValues":
			err = unpopulate(val, "ParameterValues", &a.ParameterValues)
			delete(rawMsg, key)
		case "templateType":
			err = unpopulate(val, "TemplateType", &a.TemplateType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmResourceDefinitionResourceElementTemplateDetails.
func (a ArmResourceDefinitionResourceElementTemplateDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configuration", a.Configuration)
	populate(objectMap, "dependsOnProfile", a.DependsOnProfile)
	populate(objectMap, "name", a.Name)
	objectMap["type"] = TypeArmResourceDefinition
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmResourceDefinitionResourceElementTemplateDetails.
func (a *ArmResourceDefinitionResourceElementTemplateDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &a.Configuration)
			delete(rawMsg, key)
		case "dependsOnProfile":
			err = unpopulate(val, "DependsOnProfile", &a.DependsOnProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "ResourceElementType", &a.ResourceElementType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmTemplateArtifactProfile.
func (a ArmTemplateArtifactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "templateName", a.TemplateName)
	populate(objectMap, "templateVersion", a.TemplateVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmTemplateArtifactProfile.
func (a *ArmTemplateArtifactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "templateName":
			err = unpopulate(val, "TemplateName", &a.TemplateName)
			delete(rawMsg, key)
		case "templateVersion":
			err = unpopulate(val, "TemplateVersion", &a.TemplateVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmTemplateMappingRuleProfile.
func (a ArmTemplateMappingRuleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "templateParameters", a.TemplateParameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmTemplateMappingRuleProfile.
func (a *ArmTemplateMappingRuleProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "templateParameters":
			err = unpopulate(val, "TemplateParameters", &a.TemplateParameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactAccessCredential.
func (a ArtifactAccessCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["credentialType"] = a.CredentialType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactAccessCredential.
func (a *ArtifactAccessCredential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentialType":
			err = unpopulate(val, "CredentialType", &a.CredentialType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactChangeState.
func (a ArtifactChangeState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactChangeState.
func (a *ArtifactChangeState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactChangeStateProperties.
func (a ArtifactChangeStateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactState", a.ArtifactState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactChangeStateProperties.
func (a *ArtifactChangeStateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactState":
			err = unpopulate(val, "ArtifactState", &a.ArtifactState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactManifest.
func (a ArtifactManifest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactManifest.
func (a *ArtifactManifest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactManifestListResult.
func (a ArtifactManifestListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactManifestListResult.
func (a *ArtifactManifestListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactManifestPropertiesFormat.
func (a ArtifactManifestPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactManifestState", a.ArtifactManifestState)
	populate(objectMap, "artifacts", a.Artifacts)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactManifestPropertiesFormat.
func (a *ArtifactManifestPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactManifestState":
			err = unpopulate(val, "ArtifactManifestState", &a.ArtifactManifestState)
			delete(rawMsg, key)
		case "artifacts":
			err = unpopulate(val, "Artifacts", &a.Artifacts)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactManifestUpdateState.
func (a ArtifactManifestUpdateState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactManifestState", a.ArtifactManifestState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactManifestUpdateState.
func (a *ArtifactManifestUpdateState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactManifestState":
			err = unpopulate(val, "ArtifactManifestState", &a.ArtifactManifestState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactStore.
func (a ArtifactStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactStore.
func (a *ArtifactStore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactStoreListResult.
func (a ArtifactStoreListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactStoreListResult.
func (a *ArtifactStoreListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactStorePropertiesFormat.
func (a ArtifactStorePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "managedResourceGroupConfiguration", a.ManagedResourceGroupConfiguration)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "replicationStrategy", a.ReplicationStrategy)
	populate(objectMap, "storageResourceId", a.StorageResourceID)
	populate(objectMap, "storeType", a.StoreType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactStorePropertiesFormat.
func (a *ArtifactStorePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managedResourceGroupConfiguration":
			err = unpopulate(val, "ManagedResourceGroupConfiguration", &a.ManagedResourceGroupConfiguration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "replicationStrategy":
			err = unpopulate(val, "ReplicationStrategy", &a.ReplicationStrategy)
			delete(rawMsg, key)
		case "storageResourceId":
			err = unpopulate(val, "StorageResourceID", &a.StorageResourceID)
			delete(rawMsg, key)
		case "storeType":
			err = unpopulate(val, "StoreType", &a.StoreType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactStorePropertiesFormatManagedResourceGroupConfiguration.
func (a ArtifactStorePropertiesFormatManagedResourceGroupConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactStorePropertiesFormatManagedResourceGroupConfiguration.
func (a *ArtifactStorePropertiesFormatManagedResourceGroupConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureArcK8SClusterNFVIDetails.
func (a AzureArcK8SClusterNFVIDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customLocationReference", a.CustomLocationReference)
	populate(objectMap, "name", a.Name)
	objectMap["nfviType"] = NFVITypeAzureArcKubernetes
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureArcK8SClusterNFVIDetails.
func (a *AzureArcK8SClusterNFVIDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customLocationReference":
			err = unpopulate(val, "CustomLocationReference", &a.CustomLocationReference)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "nfviType":
			err = unpopulate(val, "NfviType", &a.NfviType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureArcKubernetesArtifactProfile.
func (a AzureArcKubernetesArtifactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactStore", a.ArtifactStore)
	populate(objectMap, "helmArtifactProfile", a.HelmArtifactProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureArcKubernetesArtifactProfile.
func (a *AzureArcKubernetesArtifactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactStore":
			err = unpopulate(val, "ArtifactStore", &a.ArtifactStore)
			delete(rawMsg, key)
		case "helmArtifactProfile":
			err = unpopulate(val, "HelmArtifactProfile", &a.HelmArtifactProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureArcKubernetesDeployMappingRuleProfile.
func (a AzureArcKubernetesDeployMappingRuleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationEnablement", a.ApplicationEnablement)
	populate(objectMap, "helmMappingRuleProfile", a.HelmMappingRuleProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureArcKubernetesDeployMappingRuleProfile.
func (a *AzureArcKubernetesDeployMappingRuleProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationEnablement":
			err = unpopulate(val, "ApplicationEnablement", &a.ApplicationEnablement)
			delete(rawMsg, key)
		case "helmMappingRuleProfile":
			err = unpopulate(val, "HelmMappingRuleProfile", &a.HelmMappingRuleProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureArcKubernetesHelmApplication.
func (a AzureArcKubernetesHelmApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactProfile", a.ArtifactProfile)
	objectMap["artifactType"] = AzureArcKubernetesArtifactTypeHelmPackage
	populate(objectMap, "dependsOnProfile", a.DependsOnProfile)
	populate(objectMap, "deployParametersMappingRuleProfile", a.DeployParametersMappingRuleProfile)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureArcKubernetesHelmApplication.
func (a *AzureArcKubernetesHelmApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactProfile":
			err = unpopulate(val, "ArtifactProfile", &a.ArtifactProfile)
			delete(rawMsg, key)
		case "artifactType":
			err = unpopulate(val, "ArtifactType", &a.ArtifactType)
			delete(rawMsg, key)
		case "dependsOnProfile":
			err = unpopulate(val, "DependsOnProfile", &a.DependsOnProfile)
			delete(rawMsg, key)
		case "deployParametersMappingRuleProfile":
			err = unpopulate(val, "DeployParametersMappingRuleProfile", &a.DeployParametersMappingRuleProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureArcKubernetesNetworkFunctionApplication.
func (a AzureArcKubernetesNetworkFunctionApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["artifactType"] = a.ArtifactType
	populate(objectMap, "dependsOnProfile", a.DependsOnProfile)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureArcKubernetesNetworkFunctionApplication.
func (a *AzureArcKubernetesNetworkFunctionApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactType":
			err = unpopulate(val, "ArtifactType", &a.ArtifactType)
			delete(rawMsg, key)
		case "dependsOnProfile":
			err = unpopulate(val, "DependsOnProfile", &a.DependsOnProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureArcKubernetesNetworkFunctionTemplate.
func (a AzureArcKubernetesNetworkFunctionTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkFunctionApplications", a.NetworkFunctionApplications)
	objectMap["nfviType"] = ContainerizedNetworkFunctionNFVITypeAzureArcKubernetes
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureArcKubernetesNetworkFunctionTemplate.
func (a *AzureArcKubernetesNetworkFunctionTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkFunctionApplications":
			a.NetworkFunctionApplications, err = unmarshalAzureArcKubernetesNetworkFunctionApplicationClassificationArray(val)
			delete(rawMsg, key)
		case "nfviType":
			err = unpopulate(val, "NfviType", &a.NfviType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureContainerRegistryScopedTokenCredential.
func (a AzureContainerRegistryScopedTokenCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acrServerUrl", a.AcrServerURL)
	populate(objectMap, "acrToken", a.AcrToken)
	objectMap["credentialType"] = CredentialTypeAzureContainerRegistryScopedToken
	populateDateTimeRFC3339(objectMap, "expiry", a.Expiry)
	populate(objectMap, "repositories", a.Repositories)
	populate(objectMap, "username", a.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureContainerRegistryScopedTokenCredential.
func (a *AzureContainerRegistryScopedTokenCredential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acrServerUrl":
			err = unpopulate(val, "AcrServerURL", &a.AcrServerURL)
			delete(rawMsg, key)
		case "acrToken":
			err = unpopulate(val, "AcrToken", &a.AcrToken)
			delete(rawMsg, key)
		case "credentialType":
			err = unpopulate(val, "CredentialType", &a.CredentialType)
			delete(rawMsg, key)
		case "expiry":
			err = unpopulateDateTimeRFC3339(val, "Expiry", &a.Expiry)
			delete(rawMsg, key)
		case "repositories":
			err = unpopulate(val, "Repositories", &a.Repositories)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &a.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCoreArmTemplateArtifactProfile.
func (a AzureCoreArmTemplateArtifactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactStore", a.ArtifactStore)
	populate(objectMap, "templateArtifactProfile", a.TemplateArtifactProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCoreArmTemplateArtifactProfile.
func (a *AzureCoreArmTemplateArtifactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactStore":
			err = unpopulate(val, "ArtifactStore", &a.ArtifactStore)
			delete(rawMsg, key)
		case "templateArtifactProfile":
			err = unpopulate(val, "TemplateArtifactProfile", &a.TemplateArtifactProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCoreArmTemplateDeployMappingRuleProfile.
func (a AzureCoreArmTemplateDeployMappingRuleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationEnablement", a.ApplicationEnablement)
	populate(objectMap, "templateMappingRuleProfile", a.TemplateMappingRuleProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCoreArmTemplateDeployMappingRuleProfile.
func (a *AzureCoreArmTemplateDeployMappingRuleProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationEnablement":
			err = unpopulate(val, "ApplicationEnablement", &a.ApplicationEnablement)
			delete(rawMsg, key)
		case "templateMappingRuleProfile":
			err = unpopulate(val, "TemplateMappingRuleProfile", &a.TemplateMappingRuleProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCoreNFVIDetails.
func (a AzureCoreNFVIDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	objectMap["nfviType"] = NFVITypeAzureCore
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCoreNFVIDetails.
func (a *AzureCoreNFVIDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "nfviType":
			err = unpopulate(val, "NfviType", &a.NfviType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCoreNetworkFunctionApplication.
func (a AzureCoreNetworkFunctionApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["artifactType"] = a.ArtifactType
	populate(objectMap, "dependsOnProfile", a.DependsOnProfile)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCoreNetworkFunctionApplication.
func (a *AzureCoreNetworkFunctionApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactType":
			err = unpopulate(val, "ArtifactType", &a.ArtifactType)
			delete(rawMsg, key)
		case "dependsOnProfile":
			err = unpopulate(val, "DependsOnProfile", &a.DependsOnProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCoreNetworkFunctionArmTemplateApplication.
func (a AzureCoreNetworkFunctionArmTemplateApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactProfile", a.ArtifactProfile)
	objectMap["artifactType"] = AzureCoreArtifactTypeArmTemplate
	populate(objectMap, "dependsOnProfile", a.DependsOnProfile)
	populate(objectMap, "deployParametersMappingRuleProfile", a.DeployParametersMappingRuleProfile)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCoreNetworkFunctionArmTemplateApplication.
func (a *AzureCoreNetworkFunctionArmTemplateApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactProfile":
			err = unpopulate(val, "ArtifactProfile", &a.ArtifactProfile)
			delete(rawMsg, key)
		case "artifactType":
			err = unpopulate(val, "ArtifactType", &a.ArtifactType)
			delete(rawMsg, key)
		case "dependsOnProfile":
			err = unpopulate(val, "DependsOnProfile", &a.DependsOnProfile)
			delete(rawMsg, key)
		case "deployParametersMappingRuleProfile":
			err = unpopulate(val, "DeployParametersMappingRuleProfile", &a.DeployParametersMappingRuleProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCoreNetworkFunctionTemplate.
func (a AzureCoreNetworkFunctionTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkFunctionApplications", a.NetworkFunctionApplications)
	objectMap["nfviType"] = VirtualNetworkFunctionNFVITypeAzureCore
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCoreNetworkFunctionTemplate.
func (a *AzureCoreNetworkFunctionTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkFunctionApplications":
			a.NetworkFunctionApplications, err = unmarshalAzureCoreNetworkFunctionApplicationClassificationArray(val)
			delete(rawMsg, key)
		case "nfviType":
			err = unpopulate(val, "NfviType", &a.NfviType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCoreNetworkFunctionVhdApplication.
func (a AzureCoreNetworkFunctionVhdApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactProfile", a.ArtifactProfile)
	objectMap["artifactType"] = AzureCoreArtifactTypeVhdImageFile
	populate(objectMap, "dependsOnProfile", a.DependsOnProfile)
	populate(objectMap, "deployParametersMappingRuleProfile", a.DeployParametersMappingRuleProfile)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCoreNetworkFunctionVhdApplication.
func (a *AzureCoreNetworkFunctionVhdApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactProfile":
			err = unpopulate(val, "ArtifactProfile", &a.ArtifactProfile)
			delete(rawMsg, key)
		case "artifactType":
			err = unpopulate(val, "ArtifactType", &a.ArtifactType)
			delete(rawMsg, key)
		case "dependsOnProfile":
			err = unpopulate(val, "DependsOnProfile", &a.DependsOnProfile)
			delete(rawMsg, key)
		case "deployParametersMappingRuleProfile":
			err = unpopulate(val, "DeployParametersMappingRuleProfile", &a.DeployParametersMappingRuleProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCoreVhdImageArtifactProfile.
func (a AzureCoreVhdImageArtifactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactStore", a.ArtifactStore)
	populate(objectMap, "vhdArtifactProfile", a.VhdArtifactProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCoreVhdImageArtifactProfile.
func (a *AzureCoreVhdImageArtifactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactStore":
			err = unpopulate(val, "ArtifactStore", &a.ArtifactStore)
			delete(rawMsg, key)
		case "vhdArtifactProfile":
			err = unpopulate(val, "VhdArtifactProfile", &a.VhdArtifactProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCoreVhdImageDeployMappingRuleProfile.
func (a AzureCoreVhdImageDeployMappingRuleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationEnablement", a.ApplicationEnablement)
	populate(objectMap, "vhdImageMappingRuleProfile", a.VhdImageMappingRuleProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCoreVhdImageDeployMappingRuleProfile.
func (a *AzureCoreVhdImageDeployMappingRuleProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationEnablement":
			err = unpopulate(val, "ApplicationEnablement", &a.ApplicationEnablement)
			delete(rawMsg, key)
		case "vhdImageMappingRuleProfile":
			err = unpopulate(val, "VhdImageMappingRuleProfile", &a.VhdImageMappingRuleProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureOperatorNexusArmTemplateArtifactProfile.
func (a AzureOperatorNexusArmTemplateArtifactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactStore", a.ArtifactStore)
	populate(objectMap, "templateArtifactProfile", a.TemplateArtifactProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureOperatorNexusArmTemplateArtifactProfile.
func (a *AzureOperatorNexusArmTemplateArtifactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactStore":
			err = unpopulate(val, "ArtifactStore", &a.ArtifactStore)
			delete(rawMsg, key)
		case "templateArtifactProfile":
			err = unpopulate(val, "TemplateArtifactProfile", &a.TemplateArtifactProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureOperatorNexusArmTemplateDeployMappingRuleProfile.
func (a AzureOperatorNexusArmTemplateDeployMappingRuleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationEnablement", a.ApplicationEnablement)
	populate(objectMap, "templateMappingRuleProfile", a.TemplateMappingRuleProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureOperatorNexusArmTemplateDeployMappingRuleProfile.
func (a *AzureOperatorNexusArmTemplateDeployMappingRuleProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationEnablement":
			err = unpopulate(val, "ApplicationEnablement", &a.ApplicationEnablement)
			delete(rawMsg, key)
		case "templateMappingRuleProfile":
			err = unpopulate(val, "TemplateMappingRuleProfile", &a.TemplateMappingRuleProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureOperatorNexusClusterNFVIDetails.
func (a AzureOperatorNexusClusterNFVIDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customLocationReference", a.CustomLocationReference)
	populate(objectMap, "name", a.Name)
	objectMap["nfviType"] = NFVITypeAzureOperatorNexus
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureOperatorNexusClusterNFVIDetails.
func (a *AzureOperatorNexusClusterNFVIDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customLocationReference":
			err = unpopulate(val, "CustomLocationReference", &a.CustomLocationReference)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "nfviType":
			err = unpopulate(val, "NfviType", &a.NfviType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureOperatorNexusImageArtifactProfile.
func (a AzureOperatorNexusImageArtifactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactStore", a.ArtifactStore)
	populate(objectMap, "imageArtifactProfile", a.ImageArtifactProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureOperatorNexusImageArtifactProfile.
func (a *AzureOperatorNexusImageArtifactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactStore":
			err = unpopulate(val, "ArtifactStore", &a.ArtifactStore)
			delete(rawMsg, key)
		case "imageArtifactProfile":
			err = unpopulate(val, "ImageArtifactProfile", &a.ImageArtifactProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureOperatorNexusImageDeployMappingRuleProfile.
func (a AzureOperatorNexusImageDeployMappingRuleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationEnablement", a.ApplicationEnablement)
	populate(objectMap, "imageMappingRuleProfile", a.ImageMappingRuleProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureOperatorNexusImageDeployMappingRuleProfile.
func (a *AzureOperatorNexusImageDeployMappingRuleProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationEnablement":
			err = unpopulate(val, "ApplicationEnablement", &a.ApplicationEnablement)
			delete(rawMsg, key)
		case "imageMappingRuleProfile":
			err = unpopulate(val, "ImageMappingRuleProfile", &a.ImageMappingRuleProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureOperatorNexusNetworkFunctionApplication.
func (a AzureOperatorNexusNetworkFunctionApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["artifactType"] = a.ArtifactType
	populate(objectMap, "dependsOnProfile", a.DependsOnProfile)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureOperatorNexusNetworkFunctionApplication.
func (a *AzureOperatorNexusNetworkFunctionApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactType":
			err = unpopulate(val, "ArtifactType", &a.ArtifactType)
			delete(rawMsg, key)
		case "dependsOnProfile":
			err = unpopulate(val, "DependsOnProfile", &a.DependsOnProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureOperatorNexusNetworkFunctionArmTemplateApplication.
func (a AzureOperatorNexusNetworkFunctionArmTemplateApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactProfile", a.ArtifactProfile)
	objectMap["artifactType"] = AzureOperatorNexusArtifactTypeArmTemplate
	populate(objectMap, "dependsOnProfile", a.DependsOnProfile)
	populate(objectMap, "deployParametersMappingRuleProfile", a.DeployParametersMappingRuleProfile)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureOperatorNexusNetworkFunctionArmTemplateApplication.
func (a *AzureOperatorNexusNetworkFunctionArmTemplateApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactProfile":
			err = unpopulate(val, "ArtifactProfile", &a.ArtifactProfile)
			delete(rawMsg, key)
		case "artifactType":
			err = unpopulate(val, "ArtifactType", &a.ArtifactType)
			delete(rawMsg, key)
		case "dependsOnProfile":
			err = unpopulate(val, "DependsOnProfile", &a.DependsOnProfile)
			delete(rawMsg, key)
		case "deployParametersMappingRuleProfile":
			err = unpopulate(val, "DeployParametersMappingRuleProfile", &a.DeployParametersMappingRuleProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureOperatorNexusNetworkFunctionImageApplication.
func (a AzureOperatorNexusNetworkFunctionImageApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactProfile", a.ArtifactProfile)
	objectMap["artifactType"] = AzureOperatorNexusArtifactTypeImageFile
	populate(objectMap, "dependsOnProfile", a.DependsOnProfile)
	populate(objectMap, "deployParametersMappingRuleProfile", a.DeployParametersMappingRuleProfile)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureOperatorNexusNetworkFunctionImageApplication.
func (a *AzureOperatorNexusNetworkFunctionImageApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactProfile":
			err = unpopulate(val, "ArtifactProfile", &a.ArtifactProfile)
			delete(rawMsg, key)
		case "artifactType":
			err = unpopulate(val, "ArtifactType", &a.ArtifactType)
			delete(rawMsg, key)
		case "dependsOnProfile":
			err = unpopulate(val, "DependsOnProfile", &a.DependsOnProfile)
			delete(rawMsg, key)
		case "deployParametersMappingRuleProfile":
			err = unpopulate(val, "DeployParametersMappingRuleProfile", &a.DeployParametersMappingRuleProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureOperatorNexusNetworkFunctionTemplate.
func (a AzureOperatorNexusNetworkFunctionTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkFunctionApplications", a.NetworkFunctionApplications)
	objectMap["nfviType"] = VirtualNetworkFunctionNFVITypeAzureOperatorNexus
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureOperatorNexusNetworkFunctionTemplate.
func (a *AzureOperatorNexusNetworkFunctionTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkFunctionApplications":
			a.NetworkFunctionApplications, err = unmarshalAzureOperatorNexusNetworkFunctionApplicationClassificationArray(val)
			delete(rawMsg, key)
		case "nfviType":
			err = unpopulate(val, "NfviType", &a.NfviType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStorageAccountContainerCredential.
func (a AzureStorageAccountContainerCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "containerSasUri", a.ContainerSasURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStorageAccountContainerCredential.
func (a *AzureStorageAccountContainerCredential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "containerSasUri":
			err = unpopulate(val, "ContainerSasURI", &a.ContainerSasURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStorageAccountCredential.
func (a AzureStorageAccountCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerCredentials", a.ContainerCredentials)
	objectMap["credentialType"] = CredentialTypeAzureStorageAccountToken
	populateDateTimeRFC3339(objectMap, "expiry", a.Expiry)
	populate(objectMap, "storageAccountId", a.StorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStorageAccountCredential.
func (a *AzureStorageAccountCredential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerCredentials":
			err = unpopulate(val, "ContainerCredentials", &a.ContainerCredentials)
			delete(rawMsg, key)
		case "credentialType":
			err = unpopulate(val, "CredentialType", &a.CredentialType)
			delete(rawMsg, key)
		case "expiry":
			err = unpopulateDateTimeRFC3339(val, "Expiry", &a.Expiry)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &a.StorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Component.
func (c Component) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Component.
func (c *Component) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentListResult.
func (c ComponentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentListResult.
func (c *ComponentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentProperties.
func (c ComponentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deploymentProfile", c.DeploymentProfile)
	populate(objectMap, "deploymentStatus", c.DeploymentStatus)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentProperties.
func (c *ComponentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentProfile":
			err = unpopulate(val, "DeploymentProfile", &c.DeploymentProfile)
			delete(rawMsg, key)
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &c.DeploymentStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationGroupSchema.
func (c ConfigurationGroupSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationGroupSchema.
func (c *ConfigurationGroupSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationGroupSchemaListResult.
func (c ConfigurationGroupSchemaListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationGroupSchemaListResult.
func (c *ConfigurationGroupSchemaListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationGroupSchemaPropertiesFormat.
func (c ConfigurationGroupSchemaPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "schemaDefinition", c.SchemaDefinition)
	populate(objectMap, "versionState", c.VersionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationGroupSchemaPropertiesFormat.
func (c *ConfigurationGroupSchemaPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "schemaDefinition":
			err = unpopulate(val, "SchemaDefinition", &c.SchemaDefinition)
			delete(rawMsg, key)
		case "versionState":
			err = unpopulate(val, "VersionState", &c.VersionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationGroupSchemaVersionUpdateState.
func (c ConfigurationGroupSchemaVersionUpdateState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "versionState", c.VersionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationGroupSchemaVersionUpdateState.
func (c *ConfigurationGroupSchemaVersionUpdateState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "versionState":
			err = unpopulate(val, "VersionState", &c.VersionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationGroupValue.
func (c ConfigurationGroupValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationGroupValue.
func (c *ConfigurationGroupValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			c.Properties, err = unmarshalConfigurationGroupValuePropertiesFormatClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationGroupValueListResult.
func (c ConfigurationGroupValueListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationGroupValueListResult.
func (c *ConfigurationGroupValueListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationGroupValuePropertiesFormat.
func (c ConfigurationGroupValuePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationGroupSchemaName", c.ConfigurationGroupSchemaName)
	populate(objectMap, "configurationGroupSchemaOfferingLocation", c.ConfigurationGroupSchemaOfferingLocation)
	populate(objectMap, "configurationGroupSchemaResourceReference", c.ConfigurationGroupSchemaResourceReference)
	objectMap["configurationType"] = c.ConfigurationType
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "publisherName", c.PublisherName)
	populate(objectMap, "publisherScope", c.PublisherScope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationGroupValuePropertiesFormat.
func (c *ConfigurationGroupValuePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationGroupSchemaName":
			err = unpopulate(val, "ConfigurationGroupSchemaName", &c.ConfigurationGroupSchemaName)
			delete(rawMsg, key)
		case "configurationGroupSchemaOfferingLocation":
			err = unpopulate(val, "ConfigurationGroupSchemaOfferingLocation", &c.ConfigurationGroupSchemaOfferingLocation)
			delete(rawMsg, key)
		case "configurationGroupSchemaResourceReference":
			c.ConfigurationGroupSchemaResourceReference, err = unmarshalDeploymentResourceIDReferenceClassification(val)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &c.ConfigurationType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &c.PublisherName)
			delete(rawMsg, key)
		case "publisherScope":
			err = unpopulate(val, "PublisherScope", &c.PublisherScope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationValueWithSecrets.
func (c ConfigurationValueWithSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationGroupSchemaName", c.ConfigurationGroupSchemaName)
	populate(objectMap, "configurationGroupSchemaOfferingLocation", c.ConfigurationGroupSchemaOfferingLocation)
	populate(objectMap, "configurationGroupSchemaResourceReference", c.ConfigurationGroupSchemaResourceReference)
	objectMap["configurationType"] = ConfigurationGroupValueConfigurationTypeSecret
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "publisherName", c.PublisherName)
	populate(objectMap, "publisherScope", c.PublisherScope)
	populate(objectMap, "secretConfigurationValue", c.SecretConfigurationValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationValueWithSecrets.
func (c *ConfigurationValueWithSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationGroupSchemaName":
			err = unpopulate(val, "ConfigurationGroupSchemaName", &c.ConfigurationGroupSchemaName)
			delete(rawMsg, key)
		case "configurationGroupSchemaOfferingLocation":
			err = unpopulate(val, "ConfigurationGroupSchemaOfferingLocation", &c.ConfigurationGroupSchemaOfferingLocation)
			delete(rawMsg, key)
		case "configurationGroupSchemaResourceReference":
			c.ConfigurationGroupSchemaResourceReference, err = unmarshalDeploymentResourceIDReferenceClassification(val)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &c.ConfigurationType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &c.PublisherName)
			delete(rawMsg, key)
		case "publisherScope":
			err = unpopulate(val, "PublisherScope", &c.PublisherScope)
			delete(rawMsg, key)
		case "secretConfigurationValue":
			err = unpopulate(val, "SecretConfigurationValue", &c.SecretConfigurationValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationValueWithoutSecrets.
func (c ConfigurationValueWithoutSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationGroupSchemaName", c.ConfigurationGroupSchemaName)
	populate(objectMap, "configurationGroupSchemaOfferingLocation", c.ConfigurationGroupSchemaOfferingLocation)
	populate(objectMap, "configurationGroupSchemaResourceReference", c.ConfigurationGroupSchemaResourceReference)
	objectMap["configurationType"] = ConfigurationGroupValueConfigurationTypeOpen
	populate(objectMap, "configurationValue", c.ConfigurationValue)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "publisherName", c.PublisherName)
	populate(objectMap, "publisherScope", c.PublisherScope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationValueWithoutSecrets.
func (c *ConfigurationValueWithoutSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationGroupSchemaName":
			err = unpopulate(val, "ConfigurationGroupSchemaName", &c.ConfigurationGroupSchemaName)
			delete(rawMsg, key)
		case "configurationGroupSchemaOfferingLocation":
			err = unpopulate(val, "ConfigurationGroupSchemaOfferingLocation", &c.ConfigurationGroupSchemaOfferingLocation)
			delete(rawMsg, key)
		case "configurationGroupSchemaResourceReference":
			c.ConfigurationGroupSchemaResourceReference, err = unmarshalDeploymentResourceIDReferenceClassification(val)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &c.ConfigurationType)
			delete(rawMsg, key)
		case "configurationValue":
			err = unpopulate(val, "ConfigurationValue", &c.ConfigurationValue)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &c.PublisherName)
			delete(rawMsg, key)
		case "publisherScope":
			err = unpopulate(val, "PublisherScope", &c.PublisherScope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerizedNetworkFunctionDefinitionVersion.
func (c ContainerizedNetworkFunctionDefinitionVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deployParameters", c.DeployParameters)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "networkFunctionTemplate", c.NetworkFunctionTemplate)
	objectMap["networkFunctionType"] = NetworkFunctionTypeContainerizedNetworkFunction
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "versionState", c.VersionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerizedNetworkFunctionDefinitionVersion.
func (c *ContainerizedNetworkFunctionDefinitionVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deployParameters":
			err = unpopulate(val, "DeployParameters", &c.DeployParameters)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "networkFunctionTemplate":
			c.NetworkFunctionTemplate, err = unmarshalContainerizedNetworkFunctionTemplateClassification(val)
			delete(rawMsg, key)
		case "networkFunctionType":
			err = unpopulate(val, "NetworkFunctionType", &c.NetworkFunctionType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "versionState":
			err = unpopulate(val, "VersionState", &c.VersionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerizedNetworkFunctionTemplate.
func (c ContainerizedNetworkFunctionTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["nfviType"] = c.NfviType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerizedNetworkFunctionTemplate.
func (c *ContainerizedNetworkFunctionTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nfviType":
			err = unpopulate(val, "NfviType", &c.NfviType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DaemonSet.
func (d DaemonSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "available", d.Available)
	populateDateTimeRFC3339(objectMap, "creationTime", d.CreationTime)
	populate(objectMap, "current", d.Current)
	populate(objectMap, "desired", d.Desired)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "namespace", d.Namespace)
	populate(objectMap, "ready", d.Ready)
	populate(objectMap, "upToDate", d.UpToDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DaemonSet.
func (d *DaemonSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "available":
			err = unpopulate(val, "Available", &d.Available)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &d.CreationTime)
			delete(rawMsg, key)
		case "current":
			err = unpopulate(val, "Current", &d.Current)
			delete(rawMsg, key)
		case "desired":
			err = unpopulate(val, "Desired", &d.Desired)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &d.Namespace)
			delete(rawMsg, key)
		case "ready":
			err = unpopulate(val, "Ready", &d.Ready)
			delete(rawMsg, key)
		case "upToDate":
			err = unpopulate(val, "UpToDate", &d.UpToDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DependsOnProfile.
func (d DependsOnProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "installDependsOn", d.InstallDependsOn)
	populate(objectMap, "uninstallDependsOn", d.UninstallDependsOn)
	populate(objectMap, "updateDependsOn", d.UpdateDependsOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DependsOnProfile.
func (d *DependsOnProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "installDependsOn":
			err = unpopulate(val, "InstallDependsOn", &d.InstallDependsOn)
			delete(rawMsg, key)
		case "uninstallDependsOn":
			err = unpopulate(val, "UninstallDependsOn", &d.UninstallDependsOn)
			delete(rawMsg, key)
		case "updateDependsOn":
			err = unpopulate(val, "UpdateDependsOn", &d.UpdateDependsOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Deployment.
func (d Deployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "available", d.Available)
	populateDateTimeRFC3339(objectMap, "creationTime", d.CreationTime)
	populate(objectMap, "desired", d.Desired)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "namespace", d.Namespace)
	populate(objectMap, "ready", d.Ready)
	populate(objectMap, "upToDate", d.UpToDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Deployment.
func (d *Deployment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "available":
			err = unpopulate(val, "Available", &d.Available)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &d.CreationTime)
			delete(rawMsg, key)
		case "desired":
			err = unpopulate(val, "Desired", &d.Desired)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &d.Namespace)
			delete(rawMsg, key)
		case "ready":
			err = unpopulate(val, "Ready", &d.Ready)
			delete(rawMsg, key)
		case "upToDate":
			err = unpopulate(val, "UpToDate", &d.UpToDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentResourceIDReference.
func (d DeploymentResourceIDReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["idType"] = d.IDType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentResourceIDReference.
func (d *DeploymentResourceIDReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "idType":
			err = unpopulate(val, "IDType", &d.IDType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentStatusProperties.
func (d DeploymentStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "nextExpectedUpdateAt", d.NextExpectedUpdateAt)
	populate(objectMap, "resources", d.Resources)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentStatusProperties.
func (d *DeploymentStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextExpectedUpdateAt":
			err = unpopulateDateTimeRFC3339(val, "NextExpectedUpdateAt", &d.NextExpectedUpdateAt)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &d.Resources)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecuteRequestParameters.
func (e ExecuteRequestParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requestMetadata", e.RequestMetadata)
	populate(objectMap, "serviceEndpoint", e.ServiceEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecuteRequestParameters.
func (e *ExecuteRequestParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requestMetadata":
			err = unpopulate(val, "RequestMetadata", &e.RequestMetadata)
			delete(rawMsg, key)
		case "serviceEndpoint":
			err = unpopulate(val, "ServiceEndpoint", &e.ServiceEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HelmArtifactProfile.
func (h HelmArtifactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "helmPackageName", h.HelmPackageName)
	populate(objectMap, "helmPackageVersionRange", h.HelmPackageVersionRange)
	populate(objectMap, "imagePullSecretsValuesPaths", h.ImagePullSecretsValuesPaths)
	populate(objectMap, "registryValuesPaths", h.RegistryValuesPaths)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HelmArtifactProfile.
func (h *HelmArtifactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "helmPackageName":
			err = unpopulate(val, "HelmPackageName", &h.HelmPackageName)
			delete(rawMsg, key)
		case "helmPackageVersionRange":
			err = unpopulate(val, "HelmPackageVersionRange", &h.HelmPackageVersionRange)
			delete(rawMsg, key)
		case "imagePullSecretsValuesPaths":
			err = unpopulate(val, "ImagePullSecretsValuesPaths", &h.ImagePullSecretsValuesPaths)
			delete(rawMsg, key)
		case "registryValuesPaths":
			err = unpopulate(val, "RegistryValuesPaths", &h.RegistryValuesPaths)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HelmInstallOptions.
func (h HelmInstallOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "atomic", h.Atomic)
	populate(objectMap, "timeout", h.Timeout)
	populate(objectMap, "wait", h.Wait)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HelmInstallOptions.
func (h *HelmInstallOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "atomic":
			err = unpopulate(val, "Atomic", &h.Atomic)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &h.Timeout)
			delete(rawMsg, key)
		case "wait":
			err = unpopulate(val, "Wait", &h.Wait)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HelmMappingRuleProfile.
func (h HelmMappingRuleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "helmPackageVersion", h.HelmPackageVersion)
	populate(objectMap, "options", h.Options)
	populate(objectMap, "releaseName", h.ReleaseName)
	populate(objectMap, "releaseNamespace", h.ReleaseNamespace)
	populate(objectMap, "values", h.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HelmMappingRuleProfile.
func (h *HelmMappingRuleProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "helmPackageVersion":
			err = unpopulate(val, "HelmPackageVersion", &h.HelmPackageVersion)
			delete(rawMsg, key)
		case "options":
			err = unpopulate(val, "Options", &h.Options)
			delete(rawMsg, key)
		case "releaseName":
			err = unpopulate(val, "ReleaseName", &h.ReleaseName)
			delete(rawMsg, key)
		case "releaseNamespace":
			err = unpopulate(val, "ReleaseNamespace", &h.ReleaseNamespace)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &h.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HelmMappingRuleProfileOptions.
func (h HelmMappingRuleProfileOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "installOptions", h.InstallOptions)
	populate(objectMap, "upgradeOptions", h.UpgradeOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HelmMappingRuleProfileOptions.
func (h *HelmMappingRuleProfileOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "installOptions":
			err = unpopulate(val, "InstallOptions", &h.InstallOptions)
			delete(rawMsg, key)
		case "upgradeOptions":
			err = unpopulate(val, "UpgradeOptions", &h.UpgradeOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HelmUpgradeOptions.
func (h HelmUpgradeOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "atomic", h.Atomic)
	populate(objectMap, "timeout", h.Timeout)
	populate(objectMap, "wait", h.Wait)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HelmUpgradeOptions.
func (h *HelmUpgradeOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "atomic":
			err = unpopulate(val, "Atomic", &h.Atomic)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &h.Timeout)
			delete(rawMsg, key)
		case "wait":
			err = unpopulate(val, "Wait", &h.Wait)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageArtifactProfile.
func (i ImageArtifactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "imageName", i.ImageName)
	populate(objectMap, "imageVersion", i.ImageVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageArtifactProfile.
func (i *ImageArtifactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "imageName":
			err = unpopulate(val, "ImageName", &i.ImageName)
			delete(rawMsg, key)
		case "imageVersion":
			err = unpopulate(val, "ImageVersion", &i.ImageVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageMappingRuleProfile.
func (i ImageMappingRuleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "userConfiguration", i.UserConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageMappingRuleProfile.
func (i *ImageMappingRuleProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "userConfiguration":
			err = unpopulate(val, "UserConfiguration", &i.UserConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedResourceGroupConfiguration.
func (m ManagedResourceGroupConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedResourceGroupConfiguration.
func (m *ManagedResourceGroupConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentity.
func (m *ManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManifestArtifactFormat.
func (m ManifestArtifactFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactName", m.ArtifactName)
	populate(objectMap, "artifactType", m.ArtifactType)
	populate(objectMap, "artifactVersion", m.ArtifactVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManifestArtifactFormat.
func (m *ManifestArtifactFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactName":
			err = unpopulate(val, "ArtifactName", &m.ArtifactName)
			delete(rawMsg, key)
		case "artifactType":
			err = unpopulate(val, "ArtifactType", &m.ArtifactType)
			delete(rawMsg, key)
		case "artifactVersion":
			err = unpopulate(val, "ArtifactVersion", &m.ArtifactVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NFVIs.
func (n NFVIs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", n.Name)
	objectMap["nfviType"] = n.NfviType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NFVIs.
func (n *NFVIs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "nfviType":
			err = unpopulate(val, "NfviType", &n.NfviType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NSDArtifactProfile.
func (n NSDArtifactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactName", n.ArtifactName)
	populate(objectMap, "artifactStoreReference", n.ArtifactStoreReference)
	populate(objectMap, "artifactVersion", n.ArtifactVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NSDArtifactProfile.
func (n *NSDArtifactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactName":
			err = unpopulate(val, "ArtifactName", &n.ArtifactName)
			delete(rawMsg, key)
		case "artifactStoreReference":
			err = unpopulate(val, "ArtifactStoreReference", &n.ArtifactStoreReference)
			delete(rawMsg, key)
		case "artifactVersion":
			err = unpopulate(val, "ArtifactVersion", &n.ArtifactVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunction.
func (n NetworkFunction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", n.Etag)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "identity", n.Identity)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunction.
func (n *NetworkFunction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &n.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &n.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			n.Properties, err = unmarshalNetworkFunctionPropertiesFormatClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionDefinitionGroup.
func (n NetworkFunctionDefinitionGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionDefinitionGroup.
func (n *NetworkFunctionDefinitionGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionDefinitionGroupListResult.
func (n NetworkFunctionDefinitionGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionDefinitionGroupListResult.
func (n *NetworkFunctionDefinitionGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionDefinitionGroupPropertiesFormat.
func (n NetworkFunctionDefinitionGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", n.Description)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionDefinitionGroupPropertiesFormat.
func (n *NetworkFunctionDefinitionGroupPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionDefinitionResourceElementTemplateDetails.
func (n NetworkFunctionDefinitionResourceElementTemplateDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configuration", n.Configuration)
	populate(objectMap, "dependsOnProfile", n.DependsOnProfile)
	populate(objectMap, "name", n.Name)
	objectMap["type"] = TypeNetworkFunctionDefinition
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionDefinitionResourceElementTemplateDetails.
func (n *NetworkFunctionDefinitionResourceElementTemplateDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &n.Configuration)
			delete(rawMsg, key)
		case "dependsOnProfile":
			err = unpopulate(val, "DependsOnProfile", &n.DependsOnProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "ResourceElementType", &n.ResourceElementType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionDefinitionVersion.
func (n NetworkFunctionDefinitionVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionDefinitionVersion.
func (n *NetworkFunctionDefinitionVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			n.Properties, err = unmarshalNetworkFunctionDefinitionVersionPropertiesFormatClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionDefinitionVersionListResult.
func (n NetworkFunctionDefinitionVersionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionDefinitionVersionListResult.
func (n *NetworkFunctionDefinitionVersionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionDefinitionVersionPropertiesFormat.
func (n NetworkFunctionDefinitionVersionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deployParameters", n.DeployParameters)
	populate(objectMap, "description", n.Description)
	objectMap["networkFunctionType"] = n.NetworkFunctionType
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "versionState", n.VersionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionDefinitionVersionPropertiesFormat.
func (n *NetworkFunctionDefinitionVersionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deployParameters":
			err = unpopulate(val, "DeployParameters", &n.DeployParameters)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "networkFunctionType":
			err = unpopulate(val, "NetworkFunctionType", &n.NetworkFunctionType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "versionState":
			err = unpopulate(val, "VersionState", &n.VersionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionDefinitionVersionUpdateState.
func (n NetworkFunctionDefinitionVersionUpdateState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "versionState", n.VersionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionDefinitionVersionUpdateState.
func (n *NetworkFunctionDefinitionVersionUpdateState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "versionState":
			err = unpopulate(val, "VersionState", &n.VersionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionListResult.
func (n NetworkFunctionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionListResult.
func (n *NetworkFunctionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionPropertiesFormat.
func (n NetworkFunctionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowSoftwareUpdate", n.AllowSoftwareUpdate)
	objectMap["configurationType"] = n.ConfigurationType
	populate(objectMap, "networkFunctionDefinitionGroupName", n.NetworkFunctionDefinitionGroupName)
	populate(objectMap, "networkFunctionDefinitionOfferingLocation", n.NetworkFunctionDefinitionOfferingLocation)
	populate(objectMap, "networkFunctionDefinitionVersion", n.NetworkFunctionDefinitionVersion)
	populate(objectMap, "networkFunctionDefinitionVersionResourceReference", n.NetworkFunctionDefinitionVersionResourceReference)
	populate(objectMap, "nfviId", n.NfviID)
	populate(objectMap, "nfviType", n.NfviType)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "publisherName", n.PublisherName)
	populate(objectMap, "publisherScope", n.PublisherScope)
	populate(objectMap, "roleOverrideValues", n.RoleOverrideValues)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionPropertiesFormat.
func (n *NetworkFunctionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowSoftwareUpdate":
			err = unpopulate(val, "AllowSoftwareUpdate", &n.AllowSoftwareUpdate)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &n.ConfigurationType)
			delete(rawMsg, key)
		case "networkFunctionDefinitionGroupName":
			err = unpopulate(val, "NetworkFunctionDefinitionGroupName", &n.NetworkFunctionDefinitionGroupName)
			delete(rawMsg, key)
		case "networkFunctionDefinitionOfferingLocation":
			err = unpopulate(val, "NetworkFunctionDefinitionOfferingLocation", &n.NetworkFunctionDefinitionOfferingLocation)
			delete(rawMsg, key)
		case "networkFunctionDefinitionVersion":
			err = unpopulate(val, "NetworkFunctionDefinitionVersion", &n.NetworkFunctionDefinitionVersion)
			delete(rawMsg, key)
		case "networkFunctionDefinitionVersionResourceReference":
			n.NetworkFunctionDefinitionVersionResourceReference, err = unmarshalDeploymentResourceIDReferenceClassification(val)
			delete(rawMsg, key)
		case "nfviId":
			err = unpopulate(val, "NfviID", &n.NfviID)
			delete(rawMsg, key)
		case "nfviType":
			err = unpopulate(val, "NfviType", &n.NfviType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &n.PublisherName)
			delete(rawMsg, key)
		case "publisherScope":
			err = unpopulate(val, "PublisherScope", &n.PublisherScope)
			delete(rawMsg, key)
		case "roleOverrideValues":
			err = unpopulate(val, "RoleOverrideValues", &n.RoleOverrideValues)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionValueWithSecrets.
func (n NetworkFunctionValueWithSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowSoftwareUpdate", n.AllowSoftwareUpdate)
	objectMap["configurationType"] = NetworkFunctionConfigurationTypeSecret
	populate(objectMap, "networkFunctionDefinitionGroupName", n.NetworkFunctionDefinitionGroupName)
	populate(objectMap, "networkFunctionDefinitionOfferingLocation", n.NetworkFunctionDefinitionOfferingLocation)
	populate(objectMap, "networkFunctionDefinitionVersion", n.NetworkFunctionDefinitionVersion)
	populate(objectMap, "networkFunctionDefinitionVersionResourceReference", n.NetworkFunctionDefinitionVersionResourceReference)
	populate(objectMap, "nfviId", n.NfviID)
	populate(objectMap, "nfviType", n.NfviType)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "publisherName", n.PublisherName)
	populate(objectMap, "publisherScope", n.PublisherScope)
	populate(objectMap, "roleOverrideValues", n.RoleOverrideValues)
	populate(objectMap, "secretDeploymentValues", n.SecretDeploymentValues)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionValueWithSecrets.
func (n *NetworkFunctionValueWithSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowSoftwareUpdate":
			err = unpopulate(val, "AllowSoftwareUpdate", &n.AllowSoftwareUpdate)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &n.ConfigurationType)
			delete(rawMsg, key)
		case "networkFunctionDefinitionGroupName":
			err = unpopulate(val, "NetworkFunctionDefinitionGroupName", &n.NetworkFunctionDefinitionGroupName)
			delete(rawMsg, key)
		case "networkFunctionDefinitionOfferingLocation":
			err = unpopulate(val, "NetworkFunctionDefinitionOfferingLocation", &n.NetworkFunctionDefinitionOfferingLocation)
			delete(rawMsg, key)
		case "networkFunctionDefinitionVersion":
			err = unpopulate(val, "NetworkFunctionDefinitionVersion", &n.NetworkFunctionDefinitionVersion)
			delete(rawMsg, key)
		case "networkFunctionDefinitionVersionResourceReference":
			n.NetworkFunctionDefinitionVersionResourceReference, err = unmarshalDeploymentResourceIDReferenceClassification(val)
			delete(rawMsg, key)
		case "nfviId":
			err = unpopulate(val, "NfviID", &n.NfviID)
			delete(rawMsg, key)
		case "nfviType":
			err = unpopulate(val, "NfviType", &n.NfviType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &n.PublisherName)
			delete(rawMsg, key)
		case "publisherScope":
			err = unpopulate(val, "PublisherScope", &n.PublisherScope)
			delete(rawMsg, key)
		case "roleOverrideValues":
			err = unpopulate(val, "RoleOverrideValues", &n.RoleOverrideValues)
			delete(rawMsg, key)
		case "secretDeploymentValues":
			err = unpopulate(val, "SecretDeploymentValues", &n.SecretDeploymentValues)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFunctionValueWithoutSecrets.
func (n NetworkFunctionValueWithoutSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowSoftwareUpdate", n.AllowSoftwareUpdate)
	objectMap["configurationType"] = NetworkFunctionConfigurationTypeOpen
	populate(objectMap, "deploymentValues", n.DeploymentValues)
	populate(objectMap, "networkFunctionDefinitionGroupName", n.NetworkFunctionDefinitionGroupName)
	populate(objectMap, "networkFunctionDefinitionOfferingLocation", n.NetworkFunctionDefinitionOfferingLocation)
	populate(objectMap, "networkFunctionDefinitionVersion", n.NetworkFunctionDefinitionVersion)
	populate(objectMap, "networkFunctionDefinitionVersionResourceReference", n.NetworkFunctionDefinitionVersionResourceReference)
	populate(objectMap, "nfviId", n.NfviID)
	populate(objectMap, "nfviType", n.NfviType)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "publisherName", n.PublisherName)
	populate(objectMap, "publisherScope", n.PublisherScope)
	populate(objectMap, "roleOverrideValues", n.RoleOverrideValues)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFunctionValueWithoutSecrets.
func (n *NetworkFunctionValueWithoutSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowSoftwareUpdate":
			err = unpopulate(val, "AllowSoftwareUpdate", &n.AllowSoftwareUpdate)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &n.ConfigurationType)
			delete(rawMsg, key)
		case "deploymentValues":
			err = unpopulate(val, "DeploymentValues", &n.DeploymentValues)
			delete(rawMsg, key)
		case "networkFunctionDefinitionGroupName":
			err = unpopulate(val, "NetworkFunctionDefinitionGroupName", &n.NetworkFunctionDefinitionGroupName)
			delete(rawMsg, key)
		case "networkFunctionDefinitionOfferingLocation":
			err = unpopulate(val, "NetworkFunctionDefinitionOfferingLocation", &n.NetworkFunctionDefinitionOfferingLocation)
			delete(rawMsg, key)
		case "networkFunctionDefinitionVersion":
			err = unpopulate(val, "NetworkFunctionDefinitionVersion", &n.NetworkFunctionDefinitionVersion)
			delete(rawMsg, key)
		case "networkFunctionDefinitionVersionResourceReference":
			n.NetworkFunctionDefinitionVersionResourceReference, err = unmarshalDeploymentResourceIDReferenceClassification(val)
			delete(rawMsg, key)
		case "nfviId":
			err = unpopulate(val, "NfviID", &n.NfviID)
			delete(rawMsg, key)
		case "nfviType":
			err = unpopulate(val, "NfviType", &n.NfviType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &n.PublisherName)
			delete(rawMsg, key)
		case "publisherScope":
			err = unpopulate(val, "PublisherScope", &n.PublisherScope)
			delete(rawMsg, key)
		case "roleOverrideValues":
			err = unpopulate(val, "RoleOverrideValues", &n.RoleOverrideValues)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkServiceDesignGroup.
func (n NetworkServiceDesignGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkServiceDesignGroup.
func (n *NetworkServiceDesignGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkServiceDesignGroupListResult.
func (n NetworkServiceDesignGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkServiceDesignGroupListResult.
func (n *NetworkServiceDesignGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkServiceDesignGroupPropertiesFormat.
func (n NetworkServiceDesignGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", n.Description)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkServiceDesignGroupPropertiesFormat.
func (n *NetworkServiceDesignGroupPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkServiceDesignVersion.
func (n NetworkServiceDesignVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "systemData", n.SystemData)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkServiceDesignVersion.
func (n *NetworkServiceDesignVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &n.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkServiceDesignVersionListResult.
func (n NetworkServiceDesignVersionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkServiceDesignVersionListResult.
func (n *NetworkServiceDesignVersionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkServiceDesignVersionPropertiesFormat.
func (n NetworkServiceDesignVersionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationGroupSchemaReferences", n.ConfigurationGroupSchemaReferences)
	populate(objectMap, "description", n.Description)
	populate(objectMap, "nfvisFromSite", n.NfvisFromSite)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "resourceElementTemplates", n.ResourceElementTemplates)
	populate(objectMap, "versionState", n.VersionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkServiceDesignVersionPropertiesFormat.
func (n *NetworkServiceDesignVersionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationGroupSchemaReferences":
			err = unpopulate(val, "ConfigurationGroupSchemaReferences", &n.ConfigurationGroupSchemaReferences)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "nfvisFromSite":
			err = unpopulate(val, "NfvisFromSite", &n.NfvisFromSite)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "resourceElementTemplates":
			n.ResourceElementTemplates, err = unmarshalResourceElementTemplateClassificationArray(val)
			delete(rawMsg, key)
		case "versionState":
			err = unpopulate(val, "VersionState", &n.VersionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkServiceDesignVersionUpdateState.
func (n NetworkServiceDesignVersionUpdateState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "versionState", n.VersionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkServiceDesignVersionUpdateState.
func (n *NetworkServiceDesignVersionUpdateState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "versionState":
			err = unpopulate(val, "VersionState", &n.VersionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NfviDetails.
func (n NfviDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NfviDetails.
func (n *NfviDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenDeploymentResourceReference.
func (o OpenDeploymentResourceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	objectMap["idType"] = IDTypeOpen
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenDeploymentResourceReference.
func (o *OpenDeploymentResourceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "idType":
			err = unpopulate(val, "IDType", &o.IDType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Pod.
func (p Pod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", p.CreationTime)
	populate(objectMap, "desired", p.Desired)
	populate(objectMap, "events", p.Events)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "namespace", p.Namespace)
	populate(objectMap, "ready", p.Ready)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Pod.
func (p *Pod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &p.CreationTime)
			delete(rawMsg, key)
		case "desired":
			err = unpopulate(val, "Desired", &p.Desired)
			delete(rawMsg, key)
		case "events":
			err = unpopulate(val, "Events", &p.Events)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &p.Namespace)
			delete(rawMsg, key)
		case "ready":
			err = unpopulate(val, "Ready", &p.Ready)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PodEvent.
func (p PodEvent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "lastSeenTime", p.LastSeenTime)
	populate(objectMap, "message", p.Message)
	populate(objectMap, "reason", p.Reason)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PodEvent.
func (p *PodEvent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastSeenTime":
			err = unpopulateDateTimeRFC3339(val, "LastSeenTime", &p.LastSeenTime)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &p.Message)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &p.Reason)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyArtifactListOverview.
func (p ProxyArtifactListOverview) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyArtifactListOverview.
func (p *ProxyArtifactListOverview) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyArtifactOverviewListResult.
func (p ProxyArtifactOverviewListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyArtifactOverviewListResult.
func (p *ProxyArtifactOverviewListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyArtifactOverviewPropertiesValue.
func (p ProxyArtifactOverviewPropertiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactState", p.ArtifactState)
	populate(objectMap, "artifactType", p.ArtifactType)
	populate(objectMap, "artifactVersion", p.ArtifactVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyArtifactOverviewPropertiesValue.
func (p *ProxyArtifactOverviewPropertiesValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactState":
			err = unpopulate(val, "ArtifactState", &p.ArtifactState)
			delete(rawMsg, key)
		case "artifactType":
			err = unpopulate(val, "ArtifactType", &p.ArtifactType)
			delete(rawMsg, key)
		case "artifactVersion":
			err = unpopulate(val, "ArtifactVersion", &p.ArtifactVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyArtifactVersionsListOverview.
func (p ProxyArtifactVersionsListOverview) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyArtifactVersionsListOverview.
func (p *ProxyArtifactVersionsListOverview) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyArtifactVersionsOverviewListResult.
func (p ProxyArtifactVersionsOverviewListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyArtifactVersionsOverviewListResult.
func (p *ProxyArtifactVersionsOverviewListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Publisher.
func (p Publisher) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Publisher.
func (p *Publisher) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublisherListResult.
func (p PublisherListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublisherListResult.
func (p *PublisherListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublisherPropertiesFormat.
func (p PublisherPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "scope", p.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublisherPropertiesFormat.
func (p *PublisherPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &p.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferencedResource.
func (r ReferencedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferencedResource.
func (r *ReferencedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicaSet.
func (r ReplicaSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", r.CreationTime)
	populate(objectMap, "current", r.Current)
	populate(objectMap, "desired", r.Desired)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "namespace", r.Namespace)
	populate(objectMap, "ready", r.Ready)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicaSet.
func (r *ReplicaSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &r.CreationTime)
			delete(rawMsg, key)
		case "current":
			err = unpopulate(val, "Current", &r.Current)
			delete(rawMsg, key)
		case "desired":
			err = unpopulate(val, "Desired", &r.Desired)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &r.Namespace)
			delete(rawMsg, key)
		case "ready":
			err = unpopulate(val, "Ready", &r.Ready)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestMetadata.
func (r RequestMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersion", r.APIVersion)
	populate(objectMap, "httpMethod", r.HTTPMethod)
	populate(objectMap, "relativePath", r.RelativePath)
	populate(objectMap, "serializedBody", r.SerializedBody)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestMetadata.
func (r *RequestMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &r.APIVersion)
			delete(rawMsg, key)
		case "httpMethod":
			err = unpopulate(val, "HTTPMethod", &r.HTTPMethod)
			delete(rawMsg, key)
		case "relativePath":
			err = unpopulate(val, "RelativePath", &r.RelativePath)
			delete(rawMsg, key)
		case "serializedBody":
			err = unpopulate(val, "SerializedBody", &r.SerializedBody)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceElementTemplate.
func (r ResourceElementTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOnProfile", r.DependsOnProfile)
	populate(objectMap, "name", r.Name)
	objectMap["type"] = r.ResourceElementType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceElementTemplate.
func (r *ResourceElementTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOnProfile":
			err = unpopulate(val, "DependsOnProfile", &r.DependsOnProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "ResourceElementType", &r.ResourceElementType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resources.
func (r Resources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "daemonSets", r.DaemonSets)
	populate(objectMap, "deployments", r.Deployments)
	populate(objectMap, "pods", r.Pods)
	populate(objectMap, "replicaSets", r.ReplicaSets)
	populate(objectMap, "statefulSets", r.StatefulSets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resources.
func (r *Resources) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "daemonSets":
			err = unpopulate(val, "DaemonSets", &r.DaemonSets)
			delete(rawMsg, key)
		case "deployments":
			err = unpopulate(val, "Deployments", &r.Deployments)
			delete(rawMsg, key)
		case "pods":
			err = unpopulate(val, "Pods", &r.Pods)
			delete(rawMsg, key)
		case "replicaSets":
			err = unpopulate(val, "ReplicaSets", &r.ReplicaSets)
			delete(rawMsg, key)
		case "statefulSets":
			err = unpopulate(val, "StatefulSets", &r.StatefulSets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretDeploymentResourceReference.
func (s SecretDeploymentResourceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	objectMap["idType"] = IDTypeSecret
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretDeploymentResourceReference.
func (s *SecretDeploymentResourceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "idType":
			err = unpopulate(val, "IDType", &s.IDType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Site.
func (s Site) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Site.
func (s *Site) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteListResult.
func (s SiteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteListResult.
func (s *SiteListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteNetworkService.
func (s SiteNetworkService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteNetworkService.
func (s *SiteNetworkService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteNetworkServiceListResult.
func (s SiteNetworkServiceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteNetworkServiceListResult.
func (s *SiteNetworkServiceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteNetworkServicePropertiesFormat.
func (s SiteNetworkServicePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "desiredStateConfigurationGroupValueReferences", s.DesiredStateConfigurationGroupValueReferences)
	populate(objectMap, "lastStateConfigurationGroupValueReferences", s.LastStateConfigurationGroupValueReferences)
	populate(objectMap, "lastStateNetworkServiceDesignVersionName", s.LastStateNetworkServiceDesignVersionName)
	populate(objectMap, "managedResourceGroupConfiguration", s.ManagedResourceGroupConfiguration)
	populate(objectMap, "networkServiceDesignGroupName", s.NetworkServiceDesignGroupName)
	populate(objectMap, "networkServiceDesignVersionName", s.NetworkServiceDesignVersionName)
	populate(objectMap, "networkServiceDesignVersionOfferingLocation", s.NetworkServiceDesignVersionOfferingLocation)
	populate(objectMap, "networkServiceDesignVersionResourceReference", s.NetworkServiceDesignVersionResourceReference)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "publisherName", s.PublisherName)
	populate(objectMap, "publisherScope", s.PublisherScope)
	populate(objectMap, "siteReference", s.SiteReference)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteNetworkServicePropertiesFormat.
func (s *SiteNetworkServicePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "desiredStateConfigurationGroupValueReferences":
			err = unpopulate(val, "DesiredStateConfigurationGroupValueReferences", &s.DesiredStateConfigurationGroupValueReferences)
			delete(rawMsg, key)
		case "lastStateConfigurationGroupValueReferences":
			err = unpopulate(val, "LastStateConfigurationGroupValueReferences", &s.LastStateConfigurationGroupValueReferences)
			delete(rawMsg, key)
		case "lastStateNetworkServiceDesignVersionName":
			err = unpopulate(val, "LastStateNetworkServiceDesignVersionName", &s.LastStateNetworkServiceDesignVersionName)
			delete(rawMsg, key)
		case "managedResourceGroupConfiguration":
			err = unpopulate(val, "ManagedResourceGroupConfiguration", &s.ManagedResourceGroupConfiguration)
			delete(rawMsg, key)
		case "networkServiceDesignGroupName":
			err = unpopulate(val, "NetworkServiceDesignGroupName", &s.NetworkServiceDesignGroupName)
			delete(rawMsg, key)
		case "networkServiceDesignVersionName":
			err = unpopulate(val, "NetworkServiceDesignVersionName", &s.NetworkServiceDesignVersionName)
			delete(rawMsg, key)
		case "networkServiceDesignVersionOfferingLocation":
			err = unpopulate(val, "NetworkServiceDesignVersionOfferingLocation", &s.NetworkServiceDesignVersionOfferingLocation)
			delete(rawMsg, key)
		case "networkServiceDesignVersionResourceReference":
			s.NetworkServiceDesignVersionResourceReference, err = unmarshalDeploymentResourceIDReferenceClassification(val)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &s.PublisherName)
			delete(rawMsg, key)
		case "publisherScope":
			err = unpopulate(val, "PublisherScope", &s.PublisherScope)
			delete(rawMsg, key)
		case "siteReference":
			err = unpopulate(val, "SiteReference", &s.SiteReference)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SitePropertiesFormat.
func (s SitePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nfvis", s.Nfvis)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "siteNetworkServiceReferences", s.SiteNetworkServiceReferences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SitePropertiesFormat.
func (s *SitePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nfvis":
			s.Nfvis, err = unmarshalNFVIsClassificationArray(val)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "siteNetworkServiceReferences":
			err = unpopulate(val, "SiteNetworkServiceReferences", &s.SiteNetworkServiceReferences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatefulSet.
func (s StatefulSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "desired", s.Desired)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "namespace", s.Namespace)
	populate(objectMap, "ready", s.Ready)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatefulSet.
func (s *StatefulSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "desired":
			err = unpopulate(val, "Desired", &s.Desired)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &s.Namespace)
			delete(rawMsg, key)
		case "ready":
			err = unpopulate(val, "Ready", &s.Ready)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsObject.
func (t *TagsObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VhdImageArtifactProfile.
func (v VhdImageArtifactProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vhdName", v.VhdName)
	populate(objectMap, "vhdVersion", v.VhdVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VhdImageArtifactProfile.
func (v *VhdImageArtifactProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vhdName":
			err = unpopulate(val, "VhdName", &v.VhdName)
			delete(rawMsg, key)
		case "vhdVersion":
			err = unpopulate(val, "VhdVersion", &v.VhdVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VhdImageMappingRuleProfile.
func (v VhdImageMappingRuleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "userConfiguration", v.UserConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VhdImageMappingRuleProfile.
func (v *VhdImageMappingRuleProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "userConfiguration":
			err = unpopulate(val, "UserConfiguration", &v.UserConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkFunctionDefinitionVersion.
func (v VirtualNetworkFunctionDefinitionVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deployParameters", v.DeployParameters)
	populate(objectMap, "description", v.Description)
	populate(objectMap, "networkFunctionTemplate", v.NetworkFunctionTemplate)
	objectMap["networkFunctionType"] = NetworkFunctionTypeVirtualNetworkFunction
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "versionState", v.VersionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkFunctionDefinitionVersion.
func (v *VirtualNetworkFunctionDefinitionVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deployParameters":
			err = unpopulate(val, "DeployParameters", &v.DeployParameters)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "networkFunctionTemplate":
			v.NetworkFunctionTemplate, err = unmarshalVirtualNetworkFunctionTemplateClassification(val)
			delete(rawMsg, key)
		case "networkFunctionType":
			err = unpopulate(val, "NetworkFunctionType", &v.NetworkFunctionType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "versionState":
			err = unpopulate(val, "VersionState", &v.VersionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkFunctionTemplate.
func (v VirtualNetworkFunctionTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["nfviType"] = v.NfviType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkFunctionTemplate.
func (v *VirtualNetworkFunctionTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nfviType":
			err = unpopulate(val, "NfviType", &v.NfviType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
