//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerregistry

import "time"

// ActivationProperties - The activation properties of the connected registry.
type ActivationProperties struct {
	// READ-ONLY; The activation status of the connected registry.
	Status *ActivationStatus
}

// Actor - The agent that initiated the event. For most situations, this could be from the authorization context of the request.
type Actor struct {
	// The subject or username associated with the request context that generated the event.
	Name *string
}

// AgentPool - The agentpool that has the ARM resource and properties. The agentpool will have all information to create an
// agent pool.
type AgentPool struct {
	// REQUIRED; The location of the resource. This cannot be changed after the resource is created.
	Location *string

	// The properties associated with the agent pool
	Properties *AgentPoolProperties

	// The tags of the resource.
	Tags map[string]*string

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// AgentPoolListResult - The collection of agent pools.
type AgentPoolListResult struct {
	// The URI that can be used to request the next set of paged results.
	NextLink *string

	// The collection value.
	Value []*AgentPool
}

// AgentPoolProperties - The properties of agent pool.
type AgentPoolProperties struct {
	// The count of agent machine
	Count *int32

	// The OS of agent machine
	OS *OS

	// The Tier of agent machine
	Tier *string

	// The Virtual Network Subnet Resource Id of the agent machine
	VirtualNetworkSubnetResourceID *string

	// READ-ONLY; The provisioning state of this agent pool
	ProvisioningState *ProvisioningState
}

type AgentPoolPropertiesUpdateParameters struct {
	// The count of agent machine
	Count *int32
}

// AgentPoolQueueStatus - The QueueStatus of Agent Pool
type AgentPoolQueueStatus struct {
	// The number of pending runs in the queue
	Count *int32
}

// AgentPoolUpdateParameters - The parameters for updating an agent pool.
type AgentPoolUpdateParameters struct {
	// The properties associated with the agent pool
	Properties *AgentPoolPropertiesUpdateParameters

	// The ARM resource tags.
	Tags map[string]*string
}

// AgentProperties - The properties that determine the run agent configuration.
type AgentProperties struct {
	// The CPU configuration in terms of number of cores required for the run.
	CPU *int32
}

// Archive - An object that represents a archive for a container registry.
type Archive struct {
	// The properties of the archive.
	Properties *ArchiveProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ArchiveListResult - The result of a request to list archives for a container registry.
type ArchiveListResult struct {
	// The URI that can be used to request the next list of archives.
	NextLink *string

	// The list of archives. Since this list may be incomplete, the nextLink field should be used to request the next list of
	// distributions.
	Value []*Archive
}

// ArchivePackageSourceProperties - The properties of the archive package source.
type ArchivePackageSourceProperties struct {
	// The type of package source for a archive.
	Type *PackageSourceType

	// The external repository url.
	URL *string
}

// ArchiveProperties - The properties of a archive.
type ArchiveProperties struct {
	// The package source of the archive.
	PackageSource *ArchivePackageSourceProperties

	// The published version of the archive.
	PublishedVersion         *string
	RepositoryEndpointPrefix *string

	// READ-ONLY; The provisioning state of the archive at the time the operation was called.
	ProvisioningState *ProvisioningState

	// READ-ONLY
	RepositoryEndpoint *string
}

// ArchiveUpdateParameters - The parameters for updating a archive.
type ArchiveUpdateParameters struct {
	// The properties of the connected registry update parameters.
	Properties *ArchiveUpdateProperties
}

// ArchiveUpdateProperties - The properties of a archive.
type ArchiveUpdateProperties struct {
	// The published version of the archive.
	PublishedVersion *string
}

// ArchiveVersion - An object that represents an export pipeline for a container registry.
type ArchiveVersion struct {
	// The properties of the archive.
	Properties *ArchiveVersionProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ArchiveVersionListResult - The result of a request to list export pipelines for a container registry.
type ArchiveVersionListResult struct {
	// The URI that can be used to request the next list of pipeline runs.
	NextLink *string

	// The list of export pipelines. Since this list may be incomplete, the nextLink field should be used to request the next
	// list of export pipelines.
	Value []*ArchiveVersion
}

// ArchiveVersionProperties - The properties of an export pipeline.
type ArchiveVersionProperties struct {
	// The detailed error message for the archive version in the case of failure.
	ArchiveVersionErrorMessage *string

	// READ-ONLY; The provisioning state of the archive at the time the operation was called.
	ProvisioningState *ProvisioningState
}

// Argument - The properties of a run argument.
type Argument struct {
	// REQUIRED; The name of the argument.
	Name *string

	// REQUIRED; The value of the argument.
	Value *string

	// Flag to indicate whether the argument represents a secret and want to be removed from build logs.
	IsSecret *bool
}

// AuthCredential - Authentication credential stored for an upstream.
type AuthCredential struct {
	// The name of the credential.
	Name *CredentialName

	// KeyVault Secret URI for accessing the password.
	PasswordSecretIdentifier *string

	// KeyVault Secret URI for accessing the username.
	UsernameSecretIdentifier *string

	// READ-ONLY; This provides data pertaining to the health of the auth credential.
	CredentialHealth *CredentialHealth
}

// AuthInfo - The authorization properties for accessing the source code repository.
type AuthInfo struct {
	// REQUIRED; The access token used to access the source control provider.
	Token *string

	// REQUIRED; The type of Auth token.
	TokenType *TokenType

	// Time in seconds that the token remains valid
	ExpiresIn *int32

	// The refresh token used to refresh the access token.
	RefreshToken *string

	// The scope of the access token.
	Scope *string
}

// AuthInfoUpdateParameters - The authorization properties for accessing the source code repository.
type AuthInfoUpdateParameters struct {
	// Time in seconds that the token remains valid
	ExpiresIn *int32

	// The refresh token used to refresh the access token.
	RefreshToken *string

	// The scope of the access token.
	Scope *string

	// The access token used to access the source control provider.
	Token *string

	// The type of Auth token.
	TokenType *TokenType
}

// AzureADAuthenticationAsArmPolicy - The policy for using ARM audience token for a container registry.
type AzureADAuthenticationAsArmPolicy struct {
	// The value that indicates whether the policy is enabled or not.
	Status *AzureADAuthenticationAsArmPolicyStatus
}

// BaseImageDependency - Properties that describe a base image dependency.
type BaseImageDependency struct {
	// The sha256-based digest of the image manifest.
	Digest *string

	// The registry login server.
	Registry *string

	// The repository name.
	Repository *string

	// The tag name.
	Tag *string

	// The type of the base image dependency.
	Type *BaseImageDependencyType
}

// BaseImageTrigger - The trigger based on base image dependency.
type BaseImageTrigger struct {
	// REQUIRED; The type of the auto trigger for base image dependency updates.
	BaseImageTriggerType *BaseImageTriggerType

	// REQUIRED; The name of the trigger.
	Name *string

	// The current status of trigger.
	Status *TriggerStatus

	// The endpoint URL for receiving update triggers.
	UpdateTriggerEndpoint *string

	// Type of Payload body for Base image update triggers.
	UpdateTriggerPayloadType *UpdateTriggerPayloadType
}

// BaseImageTriggerUpdateParameters - The properties for updating base image dependency trigger.
type BaseImageTriggerUpdateParameters struct {
	// REQUIRED; The name of the trigger.
	Name *string

	// The type of the auto trigger for base image dependency updates.
	BaseImageTriggerType *BaseImageTriggerType

	// The current status of trigger.
	Status *TriggerStatus

	// The endpoint URL for receiving update triggers.
	UpdateTriggerEndpoint *string

	// Type of Payload body for Base image update triggers.
	UpdateTriggerPayloadType *UpdateTriggerPayloadType
}

// CacheRule - An object that represents a cache rule for a container registry.
type CacheRule struct {
	// The properties of the cache rule.
	Properties *CacheRuleProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// CacheRuleProperties - The properties of a cache rule.
type CacheRuleProperties struct {
	// The ARM resource ID of the credential store which is associated with the cache rule.
	CredentialSetResourceID *string

	// Source repository pulled from upstream.
	SourceRepository *string

	// Target repository specified in docker pull command. Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}
	TargetRepository *string

	// READ-ONLY; The creation date of the cache rule.
	CreationDate *time.Time

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// CacheRuleUpdateParameters - The parameters for updating a cache rule.
type CacheRuleUpdateParameters struct {
	// The properties of the cache rule update parameters.
	Properties *CacheRuleUpdateProperties
}

// CacheRuleUpdateProperties - The parameters for updating cache rule properties.
type CacheRuleUpdateProperties struct {
	// The ARM resource ID of the credential store which is associated with the Cache rule.
	CredentialSetResourceID *string
}

// CacheRulesListResult - The result of a request to list cache rules for a container registry.
type CacheRulesListResult struct {
	// If provided, client must use NextLink URI to request next list of cache rules.
	NextLink *string

	// The list of cache rules.
	Value []*CacheRule
}

// CallbackConfig - The configuration of service URI and custom headers for the webhook.
type CallbackConfig struct {
	// REQUIRED; The service URI for the webhook to post notifications.
	ServiceURI *string

	// Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string
}

// ConnectedRegistry - An object that represents a connected registry for a container registry.
type ConnectedRegistry struct {
	// The properties of the connected registry.
	Properties *ConnectedRegistryProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ConnectedRegistryListResult - The result of a request to list connected registries for a container registry.
type ConnectedRegistryListResult struct {
	// The URI that can be used to request the next list of connected registries.
	NextLink *string

	// The list of connected registries. Since this list may be incomplete, the nextLink field should be used to request the next
	// list of connected registries.
	Value []*ConnectedRegistry
}

// ConnectedRegistryProperties - The properties of a connected registry.
type ConnectedRegistryProperties struct {
	// REQUIRED; The mode of the connected registry resource that indicates the permissions of the registry.
	Mode *ConnectedRegistryMode

	// REQUIRED; The parent of the connected registry.
	Parent *ParentProperties

	// The list of the ACR token resource IDs used to authenticate clients to the connected registry.
	ClientTokenIDs []*string

	// The logging properties of the connected registry.
	Logging *LoggingProperties

	// The login server properties of the connected registry.
	LoginServer *LoginServerProperties

	// The list of notifications subscription information for the connected registry.
	NotificationsList []*string

	// READ-ONLY; The activation properties of the connected registry.
	Activation *ActivationProperties

	// READ-ONLY; The current connection state of the connected registry.
	ConnectionState *ConnectionState

	// READ-ONLY; The last activity time of the connected registry.
	LastActivityTime *time.Time

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The list of current statuses of the connected registry.
	StatusDetails []*StatusDetailProperties

	// READ-ONLY; The current version of ACR runtime on the connected registry.
	Version *string
}

// ConnectedRegistryUpdateParameters - The parameters for updating a connected registry.
type ConnectedRegistryUpdateParameters struct {
	// The properties of the connected registry update parameters.
	Properties *ConnectedRegistryUpdateProperties
}

// ConnectedRegistryUpdateProperties - The parameters for updating token properties.
type ConnectedRegistryUpdateProperties struct {
	// The list of the ACR token resource IDs used to authenticate clients to the connected registry.
	ClientTokenIDs []*string

	// The logging properties of the connected registry.
	Logging *LoggingProperties

	// The list of notifications subscription information for the connected registry.
	NotificationsList []*string

	// The sync properties of the connected registry with its parent.
	SyncProperties *SyncUpdateProperties
}

// CredentialHealth - The health of the auth credential.
type CredentialHealth struct {
	// Error code representing the health check error.
	ErrorCode *string

	// Descriptive message representing the health check error.
	ErrorMessage *string

	// The health status of credential.
	Status *CredentialHealthStatus
}

// CredentialSet - An object that represents a credential set resource for a container registry.
type CredentialSet struct {
	// Identities associated with the resource. This is used to access the KeyVault secrets.
	Identity *IdentityProperties

	// The properties of the credential set.
	Properties *CredentialSetProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// CredentialSetListResult - The result of a request to list credential sets for a container registry.
type CredentialSetListResult struct {
	// The URI that can be used to request the next list of credential sets.
	NextLink *string

	// The list of credential sets. Since this list may be incomplete, the nextLink field should be used to request the next list
	// of credential sets.
	Value []*CredentialSet
}

// CredentialSetProperties - The properties of a credential set resource.
type CredentialSetProperties struct {
	// List of authentication credentials stored for an upstream. Usually consists of a primary and an optional secondary credential.
	AuthCredentials []*AuthCredential

	// The credentials are stored for this upstream or login server.
	LoginServer *string

	// READ-ONLY; The creation date of credential store resource.
	CreationDate *time.Time

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// CredentialSetUpdateParameters - The parameters for updating a credential set
type CredentialSetUpdateParameters struct {
	// Identities associated with the resource. This is used to access the KeyVault secrets.
	Identity *IdentityProperties

	// The properties of the credential set update parameters
	Properties *CredentialSetUpdateProperties
}

// CredentialSetUpdateProperties - The parameters for updating credential set properties.
type CredentialSetUpdateProperties struct {
	// List of authentication credentials stored for an upstream. Usually consists of a primary and an optional secondary credential.
	AuthCredentials []*AuthCredential
}

// Credentials - The parameters that describes a set of credentials that will be used when a run is invoked.
type Credentials struct {
	// Describes the credential parameters for accessing other custom registries. The key for the dictionary item will be the
	// registry login server (myregistry.azurecr.io) and the value of the item will be
	// the registry credentials for accessing the registry.
	CustomRegistries map[string]*CustomRegistryCredentials

	// Describes the credential parameters for accessing the source registry.
	SourceRegistry *SourceRegistryCredentials
}

// CustomRegistryCredentials - Describes the credentials that will be used to access a custom registry during a run.
type CustomRegistryCredentials struct {
	// Indicates the managed identity assigned to the custom credential. If a user-assigned identity this value is the Client
	// ID. If a system-assigned identity, the value will be system. In the case of a
	// system-assigned identity, the Client ID will be determined by the runner. This identity may be used to authenticate to
	// key vault to retrieve credentials or it may be the only source of authentication
	// used for accessing the registry.
	Identity *string

	// The password for logging into the custom registry. The password is a secret object that allows multiple ways of providing
	// the value for it.
	Password *SecretObject

	// The username for logging into the custom registry.
	UserName *SecretObject
}

// DockerBuildRequest - The parameters for a docker quick build.
type DockerBuildRequest struct {
	// REQUIRED; The Docker file path relative to the source location.
	DockerFilePath *string

	// REQUIRED; The platform properties against which the run has to happen.
	Platform *PlatformProperties

	// REQUIRED; The type of the run request.
	Type *string

	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties

	// The dedicated agent pool for the run.
	AgentPoolName *string

	// The collection of override arguments to be used when executing the run.
	Arguments []*Argument

	// The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials

	// The fully qualified image names including the repository and tag.
	ImageNames []*string

	// The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool

	// The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string

	// The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool

	// The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository. If it is relative URL,
	// the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string

	// The name of the target build stage for the docker build.
	Target *string

	// Run timeout in seconds.
	Timeout *int32
}

// GetRunRequest implements the RunRequestClassification interface for type DockerBuildRequest.
func (d *DockerBuildRequest) GetRunRequest() *RunRequest {
	return &RunRequest{
		AgentPoolName:    d.AgentPoolName,
		IsArchiveEnabled: d.IsArchiveEnabled,
		LogTemplate:      d.LogTemplate,
		Type:             d.Type,
	}
}

// DockerBuildStep - The Docker build step.
type DockerBuildStep struct {
	// REQUIRED; The Docker file path relative to the source context.
	DockerFilePath *string

	// REQUIRED; The type of the step.
	Type *StepType

	// The collection of override arguments to be used when executing this build step.
	Arguments []*Argument

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string

	// The fully qualified image names including the repository and tag.
	ImageNames []*string

	// The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool

	// The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool

	// The name of the target build stage for the docker build.
	Target *string

	// READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies []*BaseImageDependency
}

// GetTaskStepProperties implements the TaskStepPropertiesClassification interface for type DockerBuildStep.
func (d *DockerBuildStep) GetTaskStepProperties() *TaskStepProperties {
	return &TaskStepProperties{
		BaseImageDependencies: d.BaseImageDependencies,
		ContextAccessToken:    d.ContextAccessToken,
		ContextPath:           d.ContextPath,
		Type:                  d.Type,
	}
}

// DockerBuildStepUpdateParameters - The properties for updating a docker build step.
type DockerBuildStepUpdateParameters struct {
	// REQUIRED; The type of the step.
	Type *StepType

	// The collection of override arguments to be used when executing this build step.
	Arguments []*Argument

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string

	// The Docker file path relative to the source context.
	DockerFilePath *string

	// The fully qualified image names including the repository and tag.
	ImageNames []*string

	// The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool

	// The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool

	// The name of the target build stage for the docker build.
	Target *string
}

// GetTaskStepUpdateParameters implements the TaskStepUpdateParametersClassification interface for type DockerBuildStepUpdateParameters.
func (d *DockerBuildStepUpdateParameters) GetTaskStepUpdateParameters() *TaskStepUpdateParameters {
	return &TaskStepUpdateParameters{
		ContextAccessToken: d.ContextAccessToken,
		ContextPath:        d.ContextPath,
		Type:               d.Type,
	}
}

// EncodedTaskRunRequest - The parameters for a quick task run request.
type EncodedTaskRunRequest struct {
	// REQUIRED; Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string

	// REQUIRED; The platform properties against which the run has to happen.
	Platform *PlatformProperties

	// REQUIRED; The type of the run request.
	Type *string

	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties

	// The dedicated agent pool for the run.
	AgentPoolName *string

	// The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials

	// Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string

	// The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string

	// The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository. If it is relative URL,
	// the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string

	// Run timeout in seconds.
	Timeout *int32

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue
}

// GetRunRequest implements the RunRequestClassification interface for type EncodedTaskRunRequest.
func (e *EncodedTaskRunRequest) GetRunRequest() *RunRequest {
	return &RunRequest{
		AgentPoolName:    e.AgentPoolName,
		IsArchiveEnabled: e.IsArchiveEnabled,
		LogTemplate:      e.LogTemplate,
		Type:             e.Type,
	}
}

// EncodedTaskStep - The properties of a encoded task step.
type EncodedTaskStep struct {
	// REQUIRED; Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string

	// REQUIRED; The type of the step.
	Type *StepType

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string

	// Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue

	// READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies []*BaseImageDependency
}

// GetTaskStepProperties implements the TaskStepPropertiesClassification interface for type EncodedTaskStep.
func (e *EncodedTaskStep) GetTaskStepProperties() *TaskStepProperties {
	return &TaskStepProperties{
		BaseImageDependencies: e.BaseImageDependencies,
		ContextAccessToken:    e.ContextAccessToken,
		ContextPath:           e.ContextPath,
		Type:                  e.Type,
	}
}

// EncodedTaskStepUpdateParameters - The properties for updating encoded task step.
type EncodedTaskStepUpdateParameters struct {
	// REQUIRED; The type of the step.
	Type *StepType

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string

	// Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string

	// Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue
}

// GetTaskStepUpdateParameters implements the TaskStepUpdateParametersClassification interface for type EncodedTaskStepUpdateParameters.
func (e *EncodedTaskStepUpdateParameters) GetTaskStepUpdateParameters() *TaskStepUpdateParameters {
	return &TaskStepUpdateParameters{
		ContextAccessToken: e.ContextAccessToken,
		ContextPath:        e.ContextPath,
		Type:               e.Type,
	}
}

type EncryptionProperty struct {
	// Key vault properties.
	KeyVaultProperties *KeyVaultProperties

	// Indicates whether or not the encryption is enabled for container registry.
	Status *EncryptionStatus
}

// Event - The event for a webhook.
type Event struct {
	// The event request message sent to the service URI.
	EventRequestMessage *EventRequestMessage

	// The event response message received from the service URI.
	EventResponseMessage *EventResponseMessage

	// The event ID.
	ID *string
}

// EventContent - The content of the event request message.
type EventContent struct {
	// The action that encompasses the provided event.
	Action *string

	// The agent that initiated the event. For most situations, this could be from the authorization context of the request.
	Actor *Actor

	// The event ID.
	ID *string

	// The request that generated the event.
	Request *Request

	// The registry node that generated the event. Put differently, while the actor initiates the event, the source generates
	// it.
	Source *Source

	// The target of the event.
	Target *Target

	// The time at which the event occurred.
	Timestamp *time.Time
}

// EventInfo - The basic information of an event.
type EventInfo struct {
	// The event ID.
	ID *string
}

// EventListResult - The result of a request to list events for a webhook.
type EventListResult struct {
	// The URI that can be used to request the next list of events.
	NextLink *string

	// The list of events. Since this list may be incomplete, the nextLink field should be used to request the next list of events.
	Value []*Event
}

// EventRequestMessage - The event request message sent to the service URI.
type EventRequestMessage struct {
	// The content of the event request message.
	Content *EventContent

	// The headers of the event request message.
	Headers map[string]*string

	// The HTTP method used to send the event request message.
	Method *string

	// The URI used to send the event request message.
	RequestURI *string

	// The HTTP message version.
	Version *string
}

// EventResponseMessage - The event response message received from the service URI.
type EventResponseMessage struct {
	// The content of the event response message.
	Content *string

	// The headers of the event response message.
	Headers map[string]*string

	// The reason phrase of the event response message.
	ReasonPhrase *string

	// The status code of the event response message.
	StatusCode *string

	// The HTTP message version.
	Version *string
}

// ExportPipeline - An object that represents an export pipeline for a container registry.
type ExportPipeline struct {
	// The identity of the export pipeline.
	Identity *IdentityProperties

	// The location of the export pipeline.
	Location *string

	// The properties of the export pipeline.
	Properties *ExportPipelineProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ExportPipelineListResult - The result of a request to list export pipelines for a container registry.
type ExportPipelineListResult struct {
	// The URI that can be used to request the next list of pipeline runs.
	NextLink *string

	// The list of export pipelines. Since this list may be incomplete, the nextLink field should be used to request the next
	// list of export pipelines.
	Value []*ExportPipeline
}

// ExportPipelineProperties - The properties of an export pipeline.
type ExportPipelineProperties struct {
	// REQUIRED; The target properties of the export pipeline.
	Target *ExportPipelineTargetProperties

	// The list of all options configured for the pipeline.
	Options []*PipelineOptions

	// READ-ONLY; The provisioning state of the pipeline at the time the operation was called.
	ProvisioningState *ProvisioningState
}

// ExportPipelineTargetProperties - The properties of the export pipeline target.
type ExportPipelineTargetProperties struct {
	// REQUIRED; They key vault secret uri to obtain the target storage SAS token.
	KeyVaultURI *string

	// The type of target for the export pipeline.
	Type *string

	// The target uri of the export pipeline. When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
	// When 'AzureStorageBlobContainer':
	// "https://accountName.blob.core.windows.net/containerName"
	URI *string
}

// ExportPolicy - The export policy for a container registry.
type ExportPolicy struct {
	// The value that indicates whether the policy is enabled or not.
	Status *ExportPolicyStatus
}

// FileTaskRunRequest - The request parameters for a scheduling run against a task file.
type FileTaskRunRequest struct {
	// REQUIRED; The platform properties against which the run has to happen.
	Platform *PlatformProperties

	// REQUIRED; The template/definition file path relative to the source.
	TaskFilePath *string

	// REQUIRED; The type of the run request.
	Type *string

	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties

	// The dedicated agent pool for the run.
	AgentPoolName *string

	// The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials

	// The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string

	// The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository. If it is relative URL,
	// the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string

	// Run timeout in seconds.
	Timeout *int32

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue

	// The values/parameters file path relative to the source.
	ValuesFilePath *string
}

// GetRunRequest implements the RunRequestClassification interface for type FileTaskRunRequest.
func (f *FileTaskRunRequest) GetRunRequest() *RunRequest {
	return &RunRequest{
		AgentPoolName:    f.AgentPoolName,
		IsArchiveEnabled: f.IsArchiveEnabled,
		LogTemplate:      f.LogTemplate,
		Type:             f.Type,
	}
}

// FileTaskStep - The properties of a task step.
type FileTaskStep struct {
	// REQUIRED; The task template/definition file path relative to the source context.
	TaskFilePath *string

	// REQUIRED; The type of the step.
	Type *StepType

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue

	// The task values/parameters file path relative to the source context.
	ValuesFilePath *string

	// READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies []*BaseImageDependency
}

// GetTaskStepProperties implements the TaskStepPropertiesClassification interface for type FileTaskStep.
func (f *FileTaskStep) GetTaskStepProperties() *TaskStepProperties {
	return &TaskStepProperties{
		BaseImageDependencies: f.BaseImageDependencies,
		ContextAccessToken:    f.ContextAccessToken,
		ContextPath:           f.ContextPath,
		Type:                  f.Type,
	}
}

// FileTaskStepUpdateParameters - The properties of updating a task step.
type FileTaskStepUpdateParameters struct {
	// REQUIRED; The type of the step.
	Type *StepType

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string

	// The task template/definition file path relative to the source context.
	TaskFilePath *string

	// The collection of overridable values that can be passed when running a task.
	Values []*SetValue

	// The values/parameters file path relative to the source context.
	ValuesFilePath *string
}

// GetTaskStepUpdateParameters implements the TaskStepUpdateParametersClassification interface for type FileTaskStepUpdateParameters.
func (f *FileTaskStepUpdateParameters) GetTaskStepUpdateParameters() *TaskStepUpdateParameters {
	return &TaskStepUpdateParameters{
		ContextAccessToken: f.ContextAccessToken,
		ContextPath:        f.ContextPath,
		Type:               f.Type,
	}
}

// GenerateCredentialsParameters - The parameters used to generate credentials for a specified token or user of a container
// registry.
type GenerateCredentialsParameters struct {
	// The expiry date of the generated credentials after which the credentials become invalid.
	Expiry *time.Time

	// Specifies name of the password which should be regenerated if any -- password1 or password2.
	Name *TokenPasswordName

	// The resource ID of the token for which credentials have to be generated.
	TokenID *string
}

// GenerateCredentialsResult - The response from the GenerateCredentials operation.
type GenerateCredentialsResult struct {
	// The list of passwords for a container registry.
	Passwords []*TokenPassword

	// The username for a container registry.
	Username *string
}

// IPRule - IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	// REQUIRED; Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	IPAddressOrRange *string

	// The action of IP ACL rule.
	Action *Action
}

// IdentityProperties - Managed identity for the resource.
type IdentityProperties struct {
	// The identity type.
	Type *ResourceIdentityType

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/ providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserIdentityProperties

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// ImageDescriptor - Properties for a registry image.
type ImageDescriptor struct {
	// The sha256-based digest of the image manifest.
	Digest *string

	// The registry login server.
	Registry *string

	// The repository name.
	Repository *string

	// The tag name.
	Tag *string
}

// ImageUpdateTrigger - The image update trigger that caused a build.
type ImageUpdateTrigger struct {
	// The unique ID of the trigger.
	ID *string

	// The list of image updates that caused the build.
	Images []*ImageDescriptor

	// The timestamp when the image update happened.
	Timestamp *time.Time
}

type ImportImageParameters struct {
	// REQUIRED; The source of the image.
	Source *ImportSource

	// When Force, any existing target tags will be overwritten. When NoForce, any existing target tags will fail the operation
	// before any copying begins.
	Mode *ImportMode

	// List of strings of the form repo[:tag]. When tag is omitted the source will be used (or 'latest' if source tag is also
	// omitted).
	TargetTags []*string

	// List of strings of repository names to do a manifest only copy. No tag will be created.
	UntaggedTargetRepositories []*string
}

// ImportPipeline - An object that represents an import pipeline for a container registry.
type ImportPipeline struct {
	// The identity of the import pipeline.
	Identity *IdentityProperties

	// The location of the import pipeline.
	Location *string

	// The properties of the import pipeline.
	Properties *ImportPipelineProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ImportPipelineListResult - The result of a request to list import pipelines for a container registry.
type ImportPipelineListResult struct {
	// The URI that can be used to request the next list of pipeline runs.
	NextLink *string

	// The list of import pipelines. Since this list may be incomplete, the nextLink field should be used to request the next
	// list of import pipelines.
	Value []*ImportPipeline
}

// ImportPipelineProperties - The properties of an import pipeline.
type ImportPipelineProperties struct {
	// REQUIRED; The source properties of the import pipeline.
	Source *ImportPipelineSourceProperties

	// The list of all options configured for the pipeline.
	Options []*PipelineOptions

	// The properties that describe the trigger of the import pipeline.
	Trigger *PipelineTriggerProperties

	// READ-ONLY; The provisioning state of the pipeline at the time the operation was called.
	ProvisioningState *ProvisioningState
}

// ImportPipelineSourceProperties - The properties of the import pipeline source.
type ImportPipelineSourceProperties struct {
	// REQUIRED; They key vault secret uri to obtain the source storage SAS token.
	KeyVaultURI *string

	// The type of source for the import pipeline.
	Type *PipelineSourceType

	// The source uri of the import pipeline. When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
	// When 'AzureStorageBlobContainer':
	// "https://accountName.blob.core.windows.net/containerName"
	URI *string
}

type ImportSource struct {
	// REQUIRED; Repository name of the source image. Specify an image by repository ('hello-world'). This will use the 'latest'
	// tag. Specify an image by tag ('hello-world:latest'). Specify an image by sha256-based
	// manifest digest ('hello-world@sha256:abc123').
	SourceImage *string

	// Credentials used when importing from a registry uri.
	Credentials *ImportSourceCredentials

	// The address of the source registry (e.g. 'mcr.microsoft.com').
	RegistryURI *string

	// The resource identifier of the source Azure Container Registry.
	ResourceID *string
}

type ImportSourceCredentials struct {
	// REQUIRED; The password used to authenticate with the source registry.
	Password *string

	// The username to authenticate with the source registry.
	Username *string
}

type KeyVaultProperties struct {
	// The client id of the identity which will be used to access key vault.
	Identity *string

	// Key vault uri to access the encryption key.
	KeyIdentifier *string

	// READ-ONLY; Auto key rotation status for a CMK enabled registry.
	KeyRotationEnabled *bool

	// READ-ONLY; Timestamp of the last successful key rotation.
	LastKeyRotationTimestamp *time.Time

	// READ-ONLY; The fully qualified key identifier that includes the version of the key that is actually used for encryption.
	VersionedKeyIdentifier *string
}

// LoggingProperties - The logging properties of the connected registry.
type LoggingProperties struct {
	// Indicates whether audit logs are enabled on the connected registry.
	AuditLogStatus *AuditLogStatus

	// The verbosity of logs persisted on the connected registry.
	LogLevel *LogLevel
}

// LoginServerProperties - The login server properties of the connected registry.
type LoginServerProperties struct {
	// READ-ONLY; The host of the connected registry. Can be FQDN or IP.
	Host *string

	// READ-ONLY; The TLS properties of the connected registry login server.
	TLS *TLSProperties
}

// NetworkRuleSet - The network rule set for a container registry.
type NetworkRuleSet struct {
	// REQUIRED; The default action of allow or deny when no other rules match.
	DefaultAction *DefaultAction

	// The IP ACL rules.
	IPRules []*IPRule
}

// OperationDefinition - The definition of a container registry operation.
type OperationDefinition struct {
	// The display information for the container registry operation.
	Display *OperationDisplayDefinition

	// This property indicates if the operation is an action or a data action ref: https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#management-and-data-operations
	IsDataAction *bool

	// Operation name: {provider}/{resource}/{operation}.
	Name *string

	// The origin information of the container registry operation.
	Origin *string

	// The properties information for the container registry operation.
	Properties *OperationPropertiesDefinition
}

// OperationDisplayDefinition - The display information for a container registry operation.
type OperationDisplayDefinition struct {
	// The description for the operation.
	Description *string

	// The operation that users can perform.
	Operation *string

	// The resource provider name: Microsoft.ContainerRegistry.
	Provider *string

	// The resource on which the operation is performed.
	Resource *string
}

// OperationListResult - The result of a request to list container registry operations.
type OperationListResult struct {
	// The URI that can be used to request the next list of container registry operations.
	NextLink *string

	// The list of container registry operations. Since this list may be incomplete, the nextLink field should be used to request
	// the next list of operations.
	Value []*OperationDefinition
}

// OperationLogSpecificationDefinition - The definition of Azure Monitoring log.
type OperationLogSpecificationDefinition struct {
	// Log blob duration.
	BlobDuration *string

	// Log display name.
	DisplayName *string

	// Log name.
	Name *string
}

// OperationMetricSpecificationDefinition - The definition of Azure Monitoring metric.
type OperationMetricSpecificationDefinition struct {
	// Metric aggregation type.
	AggregationType *string

	// Metric description.
	DisplayDescription *string

	// Metric display name.
	DisplayName *string

	// Internal metric name.
	InternalMetricName *string

	// Metric name.
	Name *string

	// Metric unit.
	Unit *string
}

// OperationPropertiesDefinition - The definition of Azure Monitoring properties.
type OperationPropertiesDefinition struct {
	// The definition of Azure Monitoring service.
	ServiceSpecification *OperationServiceSpecificationDefinition
}

// OperationServiceSpecificationDefinition - The definition of Azure Monitoring list.
type OperationServiceSpecificationDefinition struct {
	// A list of Azure Monitoring log definitions.
	LogSpecifications []*OperationLogSpecificationDefinition

	// A list of Azure Monitoring metrics definition.
	MetricSpecifications []*OperationMetricSpecificationDefinition
}

type OverrideTaskStepProperties struct {
	// Gets or sets the collection of override arguments to be used when executing a build step.
	Arguments []*Argument

	// The source context against which run has to be queued.
	ContextPath *string

	// The file against which run has to be queued.
	File *string

	// The name of the target build stage for the docker build.
	Target *string

	// Base64 encoded update trigger token that will be attached with the base image trigger webhook.
	UpdateTriggerToken *string

	// The collection of overridable values that can be passed when running a Task.
	Values []*SetValue
}

// ParentProperties - The properties of the connected registry parent.
type ParentProperties struct {
	// REQUIRED; The sync properties of the connected registry with its parent.
	SyncProperties *SyncProperties

	// The resource ID of the parent to which the connected registry will be associated.
	ID *string
}

// PipelineRun - An object that represents a pipeline run for a container registry.
type PipelineRun struct {
	// The properties of a pipeline run.
	Properties *PipelineRunProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// PipelineRunListResult - The result of a request to list pipeline runs for a container registry.
type PipelineRunListResult struct {
	// The URI that can be used to request the next list of pipeline runs.
	NextLink *string

	// The list of pipeline runs. Since this list may be incomplete, the nextLink field should be used to request the next list
	// of pipeline runs.
	Value []*PipelineRun
}

// PipelineRunProperties - The properties of a pipeline run.
type PipelineRunProperties struct {
	// How the pipeline run should be forced to recreate even if the pipeline run configuration has not changed.
	ForceUpdateTag *string

	// The request parameters for a pipeline run.
	Request *PipelineRunRequest

	// READ-ONLY; The provisioning state of a pipeline run.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The response of a pipeline run.
	Response *PipelineRunResponse
}

// PipelineRunRequest - The request properties provided for a pipeline run.
type PipelineRunRequest struct {
	// List of source artifacts to be transferred by the pipeline. Specify an image by repository ('hello-world'). This will use
	// the 'latest' tag. Specify an image by tag ('hello-world:latest'). Specify an
	// image by sha256-based manifest digest ('hello-world@sha256:abc123').
	Artifacts []*string

	// The digest of the tar used to transfer the artifacts.
	CatalogDigest *string

	// The resource ID of the pipeline to run.
	PipelineResourceID *string

	// The source properties of the pipeline run.
	Source *PipelineRunSourceProperties

	// The target properties of the pipeline run.
	Target *PipelineRunTargetProperties
}

// PipelineRunResponse - The response properties returned for a pipeline run.
type PipelineRunResponse struct {
	// The digest of the tar used to transfer the artifacts.
	CatalogDigest *string

	// The time the pipeline run finished.
	FinishTime *time.Time

	// The artifacts imported in the pipeline run.
	ImportedArtifacts []*string

	// The detailed error message for the pipeline run in the case of failure.
	PipelineRunErrorMessage *string

	// The current progress of the copy operation.
	Progress *ProgressProperties

	// The source of the pipeline run.
	Source *ImportPipelineSourceProperties

	// The time the pipeline run started.
	StartTime *time.Time

	// The current status of the pipeline run.
	Status *string

	// The target of the pipeline run.
	Target *ExportPipelineTargetProperties

	// The trigger that caused the pipeline run.
	Trigger *PipelineTriggerDescriptor
}

type PipelineRunSourceProperties struct {
	// The name of the source.
	Name *string

	// The type of the source.
	Type *PipelineRunSourceType
}

type PipelineRunTargetProperties struct {
	// The name of the target.
	Name *string

	// The type of the target.
	Type *PipelineRunTargetType
}

type PipelineSourceTriggerDescriptor struct {
	// The timestamp when the source update happened.
	Timestamp *time.Time
}

type PipelineSourceTriggerProperties struct {
	// REQUIRED; The current status of the source trigger.
	Status *TriggerStatus
}

type PipelineTriggerDescriptor struct {
	// The source trigger that caused the pipeline run.
	SourceTrigger *PipelineSourceTriggerDescriptor
}

type PipelineTriggerProperties struct {
	// The source trigger properties of the pipeline.
	SourceTrigger *PipelineSourceTriggerProperties
}

// PlatformProperties - The platform properties against which the run has to happen.
type PlatformProperties struct {
	// REQUIRED; The operating system type required for the run.
	OS *OS

	// The OS architecture.
	Architecture *Architecture

	// Variant of the CPU.
	Variant *Variant
}

// PlatformUpdateParameters - The properties for updating the platform configuration.
type PlatformUpdateParameters struct {
	// The OS architecture.
	Architecture *Architecture

	// The operating system type required for the run.
	OS *OS

	// Variant of the CPU.
	Variant *Variant
}

// Policies - The policies for a container registry.
type Policies struct {
	// The policy for using ARM audience token for a container registry.
	AzureADAuthenticationAsArmPolicy *AzureADAuthenticationAsArmPolicy

	// The export policy for a container registry.
	ExportPolicy *ExportPolicy

	// The quarantine policy for a container registry.
	QuarantinePolicy *QuarantinePolicy

	// The retention policy for a container registry.
	RetentionPolicy *RetentionPolicy

	// The soft delete policy for a container registry.
	SoftDeletePolicy *SoftDeletePolicy

	// The content trust policy for a container registry.
	TrustPolicy *TrustPolicy
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// This is private endpoint resource created with Microsoft.Network resource provider.
	ID *string
}

// PrivateEndpointConnection - An object that represents a private endpoint connection for a container registry.
type PrivateEndpointConnection struct {
	// The properties of a private endpoint connection.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// PrivateEndpointConnectionListResult - The result of a request to list private endpoint connections for a container registry.
type PrivateEndpointConnectionListResult struct {
	// The URI that can be used to request the next list of private endpoint connections.
	NextLink *string

	// The list of private endpoint connections. Since this list may be incomplete, the nextLink field should be used to request
	// the next list of private endpoint connections.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - The properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint

	// A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// READ-ONLY; The provisioning state of private endpoint connection resource.
	ProvisioningState *ProvisioningState
}

// PrivateLinkResource - A resource that supports private link capabilities.
type PrivateLinkResource struct {
	// The resource ID.
	ID *string

	// The name of the resource.
	Name *string

	// A resource that supports private link capabilities.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; The resource type is private link resource.
	Type *string
}

// PrivateLinkResourceListResult - The result of a request to list private link resources for a container registry.
type PrivateLinkResourceListResult struct {
	// The URI that can be used to request the next list of private link resources.
	NextLink *string

	// The list of private link resources. Since this list may be incomplete, the nextLink field should be used to request the
	// next list of private link resources.
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - The properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource group id.
	GroupID *string

	// The private link resource required member names.
	RequiredMembers []*string

	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string
}

// PrivateLinkServiceConnectionState - The state of a private link service connection.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *ActionsRequired

	// The description for connection status. For example if connection is rejected it can indicate reason for rejection.
	Description *string

	// The private link service connection status.
	Status *ConnectionStatus
}

type ProgressProperties struct {
	// The percentage complete of the copy operation.
	Percentage *string
}

// QuarantinePolicy - The quarantine policy for a container registry.
type QuarantinePolicy struct {
	// The value that indicates whether the policy is enabled or not.
	Status *PolicyStatus
}

// RegenerateCredentialParameters - The parameters used to regenerate the login credential.
type RegenerateCredentialParameters struct {
	// REQUIRED; Specifies name of the password which should be regenerated -- password or password2.
	Name *PasswordName
}

// Registry - An object that represents a container registry.
type Registry struct {
	// REQUIRED; The location of the resource. This cannot be changed after the resource is created.
	Location *string

	// REQUIRED; The SKU of the container registry.
	SKU *SKU

	// The identity of the container registry.
	Identity *IdentityProperties

	// The properties of the container registry.
	Properties *RegistryProperties

	// The tags of the resource.
	Tags map[string]*string

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// RegistryListCredentialsResult - The response from the ListCredentials operation.
type RegistryListCredentialsResult struct {
	// The list of passwords for a container registry.
	Passwords []*RegistryPassword

	// The username for a container registry.
	Username *string
}

// RegistryListResult - The result of a request to list container registries.
type RegistryListResult struct {
	// The URI that can be used to request the next list of container registries.
	NextLink *string

	// The list of container registries. Since this list may be incomplete, the nextLink field should be used to request the next
	// list of container registries.
	Value []*Registry
}

// RegistryNameCheckRequest - A request to check whether a container registry name is available.
type RegistryNameCheckRequest struct {
	// REQUIRED; The name of the container registry.
	Name *string

	// CONSTANT; The resource type of the container registry. This field must be set to 'Microsoft.ContainerRegistry/registries'.
	// Field has constant value "Microsoft.ContainerRegistry/registries", any specified value is ignored.
	Type *string
}

// RegistryNameStatus - The result of a request to check the availability of a container registry name.
type RegistryNameStatus struct {
	// If any, the error message that provides more detail for the reason that the name is not available.
	Message *string

	// The value that indicates whether the name is available.
	NameAvailable *bool

	// If any, the reason that the name is not available.
	Reason *string
}

// RegistryPassword - The login password for the container registry.
type RegistryPassword struct {
	// The password name.
	Name *PasswordName

	// The password value.
	Value *string
}

// RegistryProperties - The properties of a container registry.
type RegistryProperties struct {
	// The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool

	// Enables registry-wide pull from unauthenticated clients.
	AnonymousPullEnabled *bool

	// Enable a single data endpoint per region for serving data.
	DataEndpointEnabled *bool

	// The encryption settings of container registry.
	Encryption *EncryptionProperty

	// Determines whether registry artifacts are indexed for metadata search.
	MetadataSearch *MetadataSearch

	// Whether to allow trusted Azure services to access a network restricted registry.
	NetworkRuleBypassOptions *NetworkRuleBypassOptions

	// The network rule set for a container registry.
	NetworkRuleSet *NetworkRuleSet

	// The policies for a container registry.
	Policies *Policies

	// Whether or not public network access is allowed for the container registry.
	PublicNetworkAccess *PublicNetworkAccess

	// Whether or not zone redundancy is enabled for this container registry
	ZoneRedundancy *ZoneRedundancy

	// READ-ONLY; The creation date of the container registry in ISO8601 format.
	CreationDate *time.Time

	// READ-ONLY; List of host names that will serve data when dataEndpointEnabled is true.
	DataEndpointHostNames []*string

	// READ-ONLY; The URL that can be used to log into the container registry.
	LoginServer *string

	// READ-ONLY; List of private endpoint connections for a container registry.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; The provisioning state of the container registry at the time the operation was called.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The status of the container registry at the time the operation was called.
	Status *Status
}

// RegistryPropertiesUpdateParameters - The parameters for updating the properties of a container registry.
type RegistryPropertiesUpdateParameters struct {
	// The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool

	// Enables registry-wide pull from unauthenticated clients.
	AnonymousPullEnabled *bool

	// Enable a single data endpoint per region for serving data.
	DataEndpointEnabled *bool

	// The encryption settings of container registry.
	Encryption *EncryptionProperty

	// Determines whether registry artifacts are indexed for metadata search.
	MetadataSearch *MetadataSearch

	// Whether to allow trusted Azure services to access a network restricted registry.
	NetworkRuleBypassOptions *NetworkRuleBypassOptions

	// The network rule set for a container registry.
	NetworkRuleSet *NetworkRuleSet

	// The policies for a container registry.
	Policies *Policies

	// Whether or not public network access is allowed for the container registry.
	PublicNetworkAccess *PublicNetworkAccess
}

// RegistryUpdateParameters - The parameters for updating a container registry.
type RegistryUpdateParameters struct {
	// The identity of the container registry.
	Identity *IdentityProperties

	// The properties that the container registry will be updated with.
	Properties *RegistryPropertiesUpdateParameters

	// The SKU of the container registry.
	SKU *SKU

	// The tags for the container registry.
	Tags map[string]*string
}

// RegistryUsage - The quota usage for a container registry.
type RegistryUsage struct {
	// The current value of the usage.
	CurrentValue *int64

	// The limit of the usage.
	Limit *int64

	// The name of the usage.
	Name *string

	// The unit of measurement.
	Unit *RegistryUsageUnit
}

// RegistryUsageListResult - The result of a request to get container registry quota usages.
type RegistryUsageListResult struct {
	// The list of container registry quota usages.
	Value []*RegistryUsage
}

// Replication - An object that represents a replication for a container registry.
type Replication struct {
	// REQUIRED; The location of the resource. This cannot be changed after the resource is created.
	Location *string

	// The properties of the replication.
	Properties *ReplicationProperties

	// The tags of the resource.
	Tags map[string]*string

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ReplicationListResult - The result of a request to list replications for a container registry.
type ReplicationListResult struct {
	// The URI that can be used to request the next list of replications.
	NextLink *string

	// The list of replications. Since this list may be incomplete, the nextLink field should be used to request the next list
	// of replications.
	Value []*Replication
}

// ReplicationProperties - The properties of a replication.
type ReplicationProperties struct {
	// Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication whose regional
	// endpoint is disabled, however its data will continue to be synced with
	// other replications.
	RegionEndpointEnabled *bool

	// Whether or not zone redundancy is enabled for this container registry replication
	ZoneRedundancy *ZoneRedundancy

	// READ-ONLY; The provisioning state of the replication at the time the operation was called.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The status of the replication at the time the operation was called.
	Status *Status
}

// ReplicationUpdateParameters - The parameters for updating a replication.
type ReplicationUpdateParameters struct {
	// The parameters for updating a replication's properties
	Properties *ReplicationUpdateParametersProperties

	// The tags for the replication.
	Tags map[string]*string
}

type ReplicationUpdateParametersProperties struct {
	// Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication whose regional
	// endpoint is disabled, however its data will continue to be synced with
	// other replications.
	RegionEndpointEnabled *bool
}

// Request - The request that generated the event.
type Request struct {
	// The IP or hostname and possibly port of the client connection that initiated the event. This is the RemoteAddr from the
	// standard http request.
	Addr *string

	// The externally accessible hostname of the registry instance, as specified by the http host header on incoming requests.
	Host *string

	// The ID of the request that initiated the event.
	ID *string

	// The request method that generated the event.
	Method *string

	// The user agent header of the request.
	Useragent *string
}

// RetentionPolicy - The retention policy for a container registry.
type RetentionPolicy struct {
	// The number of days to retain an untagged manifest after which it gets purged.
	Days *int32

	// The value that indicates whether the policy is enabled or not.
	Status *PolicyStatus

	// READ-ONLY; The timestamp when the policy was last updated.
	LastUpdatedTime *time.Time
}

// Run resource properties
type Run struct {
	// The properties of a run.
	Properties *RunProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// RunFilter - Properties that are enabled for Odata querying on runs.
type RunFilter struct {
	// The name of the agent pool that the run corresponds to.
	AgentPoolName *string

	// The create time for a run.
	CreateTime *time.Time

	// The time the run finished.
	FinishTime *time.Time

	// The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool

	// The list of comma-separated image manifests that were generated from the run. This is applicable if the run is of build
	// type.
	OutputImageManifests *string

	// The unique identifier for the run.
	RunID *string

	// The type of run.
	RunType *RunType

	// The current status of the run.
	Status *RunStatus

	// The name of the task that the run corresponds to.
	TaskName *string
}

// RunGetLogResult - The result of get log link operation.
type RunGetLogResult struct {
	// The link to logs in registry for a run on a azure container registry.
	LogArtifactLink *string

	// The link to logs for a run on a azure container registry.
	LogLink *string
}

// RunListResult - Collection of runs.
type RunListResult struct {
	// The URI that can be used to request the next set of paged results.
	NextLink *string

	// The collection value.
	Value []*Run
}

// RunProperties - The properties for a run.
type RunProperties struct {
	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties

	// The dedicated agent pool for the run.
	AgentPoolName *string

	// The time the run was scheduled.
	CreateTime *time.Time

	// The list of custom registries that were logged in during this run.
	CustomRegistries []*string

	// The time the run finished.
	FinishTime *time.Time

	// The image update trigger that caused the run. This is applicable if the task has base image trigger configured.
	ImageUpdateTrigger *ImageUpdateTrigger

	// The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool

	// The last updated time for the run.
	LastUpdatedTime *time.Time

	// The list of all images that were generated from the run. This is applicable if the run generates base image dependencies.
	OutputImages []*ImageDescriptor

	// The platform properties against which the run will happen.
	Platform *PlatformProperties

	// The provisioning state of a run.
	ProvisioningState *ProvisioningState

	// The unique identifier for the run.
	RunID *string

	// The type of run.
	RunType *RunType

	// The scope of the credentials that were used to login to the source registry during this run.
	SourceRegistryAuth *string

	// The source trigger that caused the run.
	SourceTrigger *SourceTriggerDescriptor

	// The time the run started.
	StartTime *time.Time

	// The current status of the run.
	Status *RunStatus

	// The task against which run was scheduled.
	Task *string

	// The timer trigger that caused the run.
	TimerTrigger *TimerTriggerDescriptor

	// The update trigger token passed for the Run.
	UpdateTriggerToken *string

	// READ-ONLY; The image description for the log artifact.
	LogArtifact *ImageDescriptor

	// READ-ONLY; The error message received from backend systems after the run is scheduled.
	RunErrorMessage *string
}

// RunRequest - The request parameters for scheduling a run.
type RunRequest struct {
	// REQUIRED; The type of the run request.
	Type *string

	// The dedicated agent pool for the run.
	AgentPoolName *string

	// The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string
}

// GetRunRequest implements the RunRequestClassification interface for type RunRequest.
func (r *RunRequest) GetRunRequest() *RunRequest { return r }

// RunUpdateParameters - The set of run properties that can be updated.
type RunUpdateParameters struct {
	// The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool
}

// SKU - The SKU of a container registry.
type SKU struct {
	// REQUIRED; The SKU name of the container registry. Required for registry creation.
	Name *SKUName

	// READ-ONLY; The SKU tier based on the SKU name.
	Tier *SKUTier
}

// ScopeMap - An object that represents a scope map for a container registry.
type ScopeMap struct {
	// The properties of the scope map.
	Properties *ScopeMapProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ScopeMapListResult - The result of a request to list scope maps for a container registry.
type ScopeMapListResult struct {
	// The URI that can be used to request the next list of scope maps.
	NextLink *string

	// The list of scope maps. Since this list may be incomplete, the nextLink field should be used to request the next list of
	// scope maps.
	Value []*ScopeMap
}

// ScopeMapProperties - The properties of a scope map.
type ScopeMapProperties struct {
	// REQUIRED; The list of scoped permissions for registry artifacts. E.g. repositories/repository-name/content/read, repositories/repository-name/metadata/write
	Actions []*string

	// The user friendly description of the scope map.
	Description *string

	// READ-ONLY; The creation date of scope map.
	CreationDate *time.Time

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The type of the scope map. E.g. BuildIn scope map.
	Type *string
}

// ScopeMapPropertiesUpdateParameters - The update parameters for scope map properties.
type ScopeMapPropertiesUpdateParameters struct {
	// The list of scope permissions for registry artifacts. E.g. repositories/repository-name/pull, repositories/repository-name/delete
	Actions []*string

	// The user friendly description of the scope map.
	Description *string
}

// ScopeMapUpdateParameters - The properties for updating the scope map.
type ScopeMapUpdateParameters struct {
	// The update parameters for scope map properties.
	Properties *ScopeMapPropertiesUpdateParameters
}

// SecretObject - Describes the properties of a secret object value.
type SecretObject struct {
	// The type of the secret object which determines how the value of the secret object has to be interpreted.
	Type *SecretObjectType

	// The value of the secret. The format of this value will be determined based on the type of the secret object. If the type
	// is Opaque, the value will be used as is without any modification.
	Value *string
}

// SetValue - The properties of a overridable value that can be passed to a task template.
type SetValue struct {
	// REQUIRED; The name of the overridable value.
	Name *string

	// REQUIRED; The overridable value.
	Value *string

	// Flag to indicate whether the value represents a secret or not.
	IsSecret *bool
}

// SoftDeletePolicy - The soft delete policy for a container registry
type SoftDeletePolicy struct {
	// The number of days after which a soft-deleted item is permanently deleted.
	RetentionDays *int32

	// The value that indicates whether the policy is enabled or not.
	Status *PolicyStatus

	// READ-ONLY; The timestamp when the policy was last updated.
	LastUpdatedTime *time.Time
}

// Source - The registry node that generated the event. Put differently, while the actor initiates the event, the source generates
// it.
type Source struct {
	// The IP or hostname and the port of the registry node that generated the event. Generally, this will be resolved by os.Hostname()
	// along with the running port.
	Addr *string

	// The running instance of an application. Changes after each restart.
	InstanceID *string
}

// SourceProperties - The properties of the source code repository.
type SourceProperties struct {
	// REQUIRED; The full URL to the source code repository
	RepositoryURL *string

	// REQUIRED; The type of source control service.
	SourceControlType *SourceControlType

	// The branch name of the source code.
	Branch *string

	// The authorization properties for accessing the source code repository and to set up webhooks for notifications.
	SourceControlAuthProperties *AuthInfo
}

// SourceRegistryCredentials - Describes the credential parameters for accessing the source registry.
type SourceRegistryCredentials struct {
	// The authentication mode which determines the source registry login scope. The credentials for the source registry will
	// be generated using the given scope. These credentials will be used to login to
	// the source registry during the run.
	LoginMode *SourceRegistryLoginMode
}

// SourceTrigger - The properties of a source based trigger.
type SourceTrigger struct {
	// REQUIRED; The name of the trigger.
	Name *string

	// REQUIRED; The properties that describes the source(code) for the task.
	SourceRepository *SourceProperties

	// REQUIRED; The source event corresponding to the trigger.
	SourceTriggerEvents []*SourceTriggerEvent

	// The current status of trigger.
	Status *TriggerStatus
}

// SourceTriggerDescriptor - The source trigger that caused a run.
type SourceTriggerDescriptor struct {
	// The branch name in the repository.
	BranchName *string

	// The unique ID that identifies a commit.
	CommitID *string

	// The event type of the trigger.
	EventType *string

	// The unique ID of the trigger.
	ID *string

	// The source control provider type.
	ProviderType *string

	// The unique ID that identifies pull request.
	PullRequestID *string

	// The repository URL.
	RepositoryURL *string
}

// SourceTriggerUpdateParameters - The properties for updating a source based trigger.
type SourceTriggerUpdateParameters struct {
	// REQUIRED; The name of the trigger.
	Name *string

	// The properties that describes the source(code) for the task.
	SourceRepository *SourceUpdateParameters

	// The source event corresponding to the trigger.
	SourceTriggerEvents []*SourceTriggerEvent

	// The current status of trigger.
	Status *TriggerStatus
}

// SourceUpdateParameters - The properties for updating the source code repository.
type SourceUpdateParameters struct {
	// The branch name of the source code.
	Branch *string

	// The full URL to the source code repository
	RepositoryURL *string

	// The authorization properties for accessing the source code repository and to set up webhooks for notifications.
	SourceControlAuthProperties *AuthInfoUpdateParameters

	// The type of source control service.
	SourceControlType *SourceControlType
}

// SourceUploadDefinition - The properties of a response to source upload request.
type SourceUploadDefinition struct {
	// The relative path to the source. This is used to submit the subsequent queue build request.
	RelativePath *string

	// The URL where the client can upload the source.
	UploadURL *string
}

// Status - The status of an Azure resource at the time the operation was called.
type Status struct {
	// READ-ONLY; The short label for the status.
	DisplayStatus *string

	// READ-ONLY; The detailed message for the status, including alerts and error messages.
	Message *string

	// READ-ONLY; The timestamp when the status was changed to the current value.
	Timestamp *time.Time
}

// StatusDetailProperties - The status detail properties of the connected registry.
type StatusDetailProperties struct {
	// READ-ONLY; The code of the status.
	Code *string

	// READ-ONLY; The correlation ID of the status.
	CorrelationID *string

	// READ-ONLY; The description of the status.
	Description *string

	// READ-ONLY; The timestamp of the status.
	Timestamp *time.Time

	// READ-ONLY; The component of the connected registry corresponding to the status.
	Type *string
}

// SyncProperties - The sync properties of the connected registry with its parent.
type SyncProperties struct {
	// REQUIRED; The period of time for which a message is available to sync before it is expired. Specify the duration using
	// the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
	MessageTTL *string

	// REQUIRED; The resource ID of the ACR token used to authenticate the connected registry to its parent during sync.
	TokenID *string

	// The cron expression indicating the schedule that the connected registry will sync with its parent.
	Schedule *string

	// The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S
	// as per ISO8601.
	SyncWindow *string

	// READ-ONLY; The gateway endpoint used by the connected registry to communicate with its parent.
	GatewayEndpoint *string

	// READ-ONLY; The last time a sync occurred between the connected registry and its parent.
	LastSyncTime *time.Time
}

// SyncUpdateProperties - The parameters for updating the sync properties of the connected registry with its parent.
type SyncUpdateProperties struct {
	// The period of time for which a message is available to sync before it is expired. Specify the duration using the format
	// P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
	MessageTTL *string

	// The cron expression indicating the schedule that the connected registry will sync with its parent.
	Schedule *string

	// The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S
	// as per ISO8601.
	SyncWindow *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource modification (UTC).
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *LastModifiedByType
}

// TLSCertificateProperties - The TLS certificate properties of the connected registry login server.
type TLSCertificateProperties struct {
	// READ-ONLY; Indicates the location of the certificates.
	Location *string

	// READ-ONLY; The type of certificate location.
	Type *CertificateType
}

// TLSProperties - The TLS properties of the connected registry login server.
type TLSProperties struct {
	// READ-ONLY; The certificate used to configure HTTPS for the login server.
	Certificate *TLSCertificateProperties

	// READ-ONLY; Indicates whether HTTPS is enabled for the login server.
	Status *TLSStatus
}

// Target - The target of the event.
type Target struct {
	// The digest of the content, as defined by the Registry V2 HTTP API Specification.
	Digest *string

	// The number of bytes of the content. Same as Size field.
	Length *int64

	// The MIME type of the referenced object.
	MediaType *string

	// The name of the artifact.
	Name *string

	// The repository name.
	Repository *string

	// The number of bytes of the content. Same as Length field.
	Size *int64

	// The tag name.
	Tag *string

	// The direct URL to the content.
	URL *string

	// The version of the artifact.
	Version *string
}

// Task - The task that has the ARM resource and task properties. The task will have all information to schedule a run against
// it.
type Task struct {
	// REQUIRED; The location of the resource. This cannot be changed after the resource is created.
	Location *string

	// Identity for the resource.
	Identity *IdentityProperties

	// The properties of a task.
	Properties *TaskProperties

	// The tags of the resource.
	Tags map[string]*string

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// TaskListResult - The collection of tasks.
type TaskListResult struct {
	// The URI that can be used to request the next set of paged results.
	NextLink *string

	// The collection value.
	Value []*Task
}

// TaskProperties - The properties of a task.
type TaskProperties struct {
	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties

	// The dedicated agent pool for the task.
	AgentPoolName *string

	// The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials

	// The value of this property indicates whether the task resource is system task or not.
	IsSystemTask *bool

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string

	// The platform properties against which the run has to happen.
	Platform *PlatformProperties

	// The current status of task.
	Status *TaskStatus

	// The properties of a task step.
	Step TaskStepPropertiesClassification

	// Run timeout in seconds.
	Timeout *int32

	// The properties that describe all triggers for the task.
	Trigger *TriggerProperties

	// READ-ONLY; The creation date of task.
	CreationDate *time.Time

	// READ-ONLY; The provisioning state of the task.
	ProvisioningState *ProvisioningState
}

// TaskPropertiesUpdateParameters - The properties for updating a task.
type TaskPropertiesUpdateParameters struct {
	// The machine configuration of the run agent.
	AgentConfiguration *AgentProperties

	// The dedicated agent pool for the task.
	AgentPoolName *string

	// The parameters that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string

	// The platform properties against which the run has to happen.
	Platform *PlatformUpdateParameters

	// The current status of task.
	Status *TaskStatus

	// The properties for updating a task step.
	Step TaskStepUpdateParametersClassification

	// Run timeout in seconds.
	Timeout *int32

	// The properties for updating trigger properties.
	Trigger *TriggerUpdateParameters
}

// TaskRun - The task run that has the ARM resource and properties. The task run will have the information of request and
// result of a run.
type TaskRun struct {
	// Identity for the resource.
	Identity *IdentityProperties

	// The location of the resource
	Location *string

	// The properties associated with the task run, i.e., request and result of the run
	Properties *TaskRunProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// TaskRunListResult - The collection of task runs.
type TaskRunListResult struct {
	// The URI that can be used to request the next set of paged results.
	NextLink *string

	// The collection value.
	Value []*TaskRun
}

// TaskRunProperties - The properties of task run.
type TaskRunProperties struct {
	// How the run should be forced to rerun even if the run request configuration has not changed
	ForceUpdateTag *string

	// The request (parameters) for the run
	RunRequest RunRequestClassification

	// READ-ONLY; The provisioning state of this task run
	ProvisioningState *ProvisioningState

	// READ-ONLY; The result of this task run
	RunResult *Run
}

// TaskRunPropertiesUpdateParameters - The properties of a task run update parameters.
type TaskRunPropertiesUpdateParameters struct {
	// How the run should be forced to rerun even if the run request configuration has not changed
	ForceUpdateTag *string

	// The request (parameters) for the new run
	RunRequest RunRequestClassification
}

// TaskRunRequest - The parameters for a task run request.
type TaskRunRequest struct {
	// REQUIRED; The resource ID of task against which run has to be queued.
	TaskID *string

	// REQUIRED; The type of the run request.
	Type *string

	// The dedicated agent pool for the run.
	AgentPoolName *string

	// The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool

	// The template that describes the repository and tag information for run log artifact.
	LogTemplate *string

	// Set of overridable parameters that can be passed when running a Task.
	OverrideTaskStepProperties *OverrideTaskStepProperties
}

// GetRunRequest implements the RunRequestClassification interface for type TaskRunRequest.
func (t *TaskRunRequest) GetRunRequest() *RunRequest {
	return &RunRequest{
		AgentPoolName:    t.AgentPoolName,
		IsArchiveEnabled: t.IsArchiveEnabled,
		LogTemplate:      t.LogTemplate,
		Type:             t.Type,
	}
}

// TaskRunUpdateParameters - The parameters for updating a task run.
type TaskRunUpdateParameters struct {
	// Identity for the resource.
	Identity *IdentityProperties

	// The location of the resource
	Location *string

	// The properties for updating a task run.
	Properties *TaskRunPropertiesUpdateParameters

	// The ARM resource tags.
	Tags map[string]*string
}

// TaskStepProperties - Base properties for any task step.
type TaskStepProperties struct {
	// REQUIRED; The type of the step.
	Type *StepType

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string

	// READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies []*BaseImageDependency
}

// GetTaskStepProperties implements the TaskStepPropertiesClassification interface for type TaskStepProperties.
func (t *TaskStepProperties) GetTaskStepProperties() *TaskStepProperties { return t }

// TaskStepUpdateParameters - Base properties for updating any task step.
type TaskStepUpdateParameters struct {
	// REQUIRED; The type of the step.
	Type *StepType

	// The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string

	// The URL(absolute or relative) of the source context for the task step.
	ContextPath *string
}

// GetTaskStepUpdateParameters implements the TaskStepUpdateParametersClassification interface for type TaskStepUpdateParameters.
func (t *TaskStepUpdateParameters) GetTaskStepUpdateParameters() *TaskStepUpdateParameters { return t }

// TaskUpdateParameters - The parameters for updating a task.
type TaskUpdateParameters struct {
	// Identity for the resource.
	Identity *IdentityProperties

	// The properties for updating a task.
	Properties *TaskPropertiesUpdateParameters

	// The ARM resource tags.
	Tags map[string]*string
}

// TimerTrigger - The properties of a timer trigger.
type TimerTrigger struct {
	// REQUIRED; The name of the trigger.
	Name *string

	// REQUIRED; The CRON expression for the task schedule
	Schedule *string

	// The current status of trigger.
	Status *TriggerStatus
}

type TimerTriggerDescriptor struct {
	// The occurrence that triggered the run.
	ScheduleOccurrence *string

	// The timer trigger name that caused the run.
	TimerTriggerName *string
}

// TimerTriggerUpdateParameters - The properties for updating a timer trigger.
type TimerTriggerUpdateParameters struct {
	// REQUIRED; The name of the trigger.
	Name *string

	// The CRON expression for the task schedule
	Schedule *string

	// The current status of trigger.
	Status *TriggerStatus
}

// Token - An object that represents a token for a container registry.
type Token struct {
	// The properties of the token.
	Properties *TokenProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// TokenCertificate - The properties of a certificate used for authenticating a token.
type TokenCertificate struct {
	// Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
	EncodedPemCertificate *string

	// The expiry datetime of the certificate.
	Expiry *time.Time
	Name   *TokenCertificateName

	// The thumbprint of the certificate.
	Thumbprint *string
}

// TokenCredentialsProperties - The properties of the credentials that can be used for authenticating the token.
type TokenCredentialsProperties struct {
	Certificates []*TokenCertificate
	Passwords    []*TokenPassword
}

// TokenListResult - The result of a request to list tokens for a container registry.
type TokenListResult struct {
	// The URI that can be used to request the next list of tokens.
	NextLink *string

	// The list of tokens. Since this list may be incomplete, the nextLink field should be used to request the next list of tokens.
	Value []*Token
}

// TokenPassword - The password that will be used for authenticating the token of a container registry.
type TokenPassword struct {
	// The creation datetime of the password.
	CreationTime *time.Time

	// The expiry datetime of the password.
	Expiry *time.Time

	// The password name "password1" or "password2"
	Name *TokenPasswordName

	// READ-ONLY; The password value.
	Value *string
}

// TokenProperties - The properties of a token.
type TokenProperties struct {
	// The credentials that can be used for authenticating the token.
	Credentials *TokenCredentialsProperties

	// The resource ID of the scope map to which the token will be associated with.
	ScopeMapID *string

	// The status of the token example enabled or disabled.
	Status *TokenStatus

	// READ-ONLY; The creation date of scope map.
	CreationDate *time.Time

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// TokenUpdateParameters - The parameters for updating a token.
type TokenUpdateParameters struct {
	// The properties of the token update parameters.
	Properties *TokenUpdateProperties
}

// TokenUpdateProperties - The parameters for updating token properties.
type TokenUpdateProperties struct {
	// The credentials that can be used for authenticating the token.
	Credentials *TokenCredentialsProperties

	// The resource ID of the scope map to which the token will be associated with.
	ScopeMapID *string

	// The status of the token example enabled or disabled.
	Status *TokenStatus
}

// TriggerProperties - The properties of a trigger.
type TriggerProperties struct {
	// The trigger based on base image dependencies.
	BaseImageTrigger *BaseImageTrigger

	// The collection of triggers based on source code repository.
	SourceTriggers []*SourceTrigger

	// The collection of timer triggers.
	TimerTriggers []*TimerTrigger
}

// TriggerUpdateParameters - The properties for updating triggers.
type TriggerUpdateParameters struct {
	// The trigger based on base image dependencies.
	BaseImageTrigger *BaseImageTriggerUpdateParameters

	// The collection of triggers based on source code repository.
	SourceTriggers []*SourceTriggerUpdateParameters

	// The collection of timer triggers.
	TimerTriggers []*TimerTriggerUpdateParameters
}

// TrustPolicy - The content trust policy for a container registry.
type TrustPolicy struct {
	// The value that indicates whether the policy is enabled or not.
	Status *PolicyStatus

	// The type of trust policy.
	Type *TrustPolicyType
}

type UserIdentityProperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string
}

// Webhook - An object that represents a webhook for a container registry.
type Webhook struct {
	// REQUIRED; The location of the resource. This cannot be changed after the resource is created.
	Location *string

	// The properties of the webhook.
	Properties *WebhookProperties

	// The tags of the resource.
	Tags map[string]*string

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// WebhookCreateParameters - The parameters for creating a webhook.
type WebhookCreateParameters struct {
	// REQUIRED; The location of the webhook. This cannot be changed after the resource is created.
	Location *string

	// The properties that the webhook will be created with.
	Properties *WebhookPropertiesCreateParameters

	// The tags for the webhook.
	Tags map[string]*string
}

// WebhookListResult - The result of a request to list webhooks for a container registry.
type WebhookListResult struct {
	// The URI that can be used to request the next list of webhooks.
	NextLink *string

	// The list of webhooks. Since this list may be incomplete, the nextLink field should be used to request the next list of
	// webhooks.
	Value []*Webhook
}

// WebhookProperties - The properties of a webhook.
type WebhookProperties struct {
	// REQUIRED; The list of actions that trigger the webhook to post notifications.
	Actions []*WebhookAction

	// The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository
	// 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
	// 'foo:latest'. Empty means all events.
	Scope *string

	// The status of the webhook at the time the operation was called.
	Status *WebhookStatus

	// READ-ONLY; The provisioning state of the webhook at the time the operation was called.
	ProvisioningState *ProvisioningState
}

// WebhookPropertiesCreateParameters - The parameters for creating the properties of a webhook.
type WebhookPropertiesCreateParameters struct {
	// REQUIRED; The list of actions that trigger the webhook to post notifications.
	Actions []*WebhookAction

	// REQUIRED; The service URI for the webhook to post notifications.
	ServiceURI *string

	// Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string

	// The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository
	// 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
	// 'foo:latest'. Empty means all events.
	Scope *string

	// The status of the webhook at the time the operation was called.
	Status *WebhookStatus
}

// WebhookPropertiesUpdateParameters - The parameters for updating the properties of a webhook.
type WebhookPropertiesUpdateParameters struct {
	// The list of actions that trigger the webhook to post notifications.
	Actions []*WebhookAction

	// Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string

	// The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository
	// 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
	// 'foo:latest'. Empty means all events.
	Scope *string

	// The service URI for the webhook to post notifications.
	ServiceURI *string

	// The status of the webhook at the time the operation was called.
	Status *WebhookStatus
}

// WebhookUpdateParameters - The parameters for updating a webhook.
type WebhookUpdateParameters struct {
	// The properties that the webhook will be updated with.
	Properties *WebhookPropertiesUpdateParameters

	// The tags for the webhook.
	Tags map[string]*string
}
