// Code generated by smithy-go-codegen DO NOT EDIT.

package codebuild

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codebuild/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets a list of sandboxes for a given project.
func (c *Client) ListSandboxesForProject(ctx context.Context, params *ListSandboxesForProjectInput, optFns ...func(*Options)) (*ListSandboxesForProjectOutput, error) {
	if params == nil {
		params = &ListSandboxesForProjectInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSandboxesForProject", params, optFns, c.addOperationListSandboxesForProjectMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSandboxesForProjectOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSandboxesForProjectInput struct {

	// The CodeBuild project name.
	//
	// This member is required.
	ProjectName *string

	// The maximum number of sandbox records to be retrieved.
	MaxResults *int32

	// The next token, if any, to get paginated results. You will get this value from
	// previous execution of list sandboxes.
	NextToken *string

	// The order in which sandbox records should be retrieved.
	SortOrder types.SortOrderType

	noSmithyDocumentSerde
}

type ListSandboxesForProjectOutput struct {

	// Information about the requested sandbox IDs.
	Ids []string

	// Information about the next token to get paginated results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSandboxesForProjectMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListSandboxesForProject{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListSandboxesForProject{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSandboxesForProject"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListSandboxesForProjectValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSandboxesForProject(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListSandboxesForProjectPaginatorOptions is the paginator options for
// ListSandboxesForProject
type ListSandboxesForProjectPaginatorOptions struct {
	// The maximum number of sandbox records to be retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSandboxesForProjectPaginator is a paginator for ListSandboxesForProject
type ListSandboxesForProjectPaginator struct {
	options   ListSandboxesForProjectPaginatorOptions
	client    ListSandboxesForProjectAPIClient
	params    *ListSandboxesForProjectInput
	nextToken *string
	firstPage bool
}

// NewListSandboxesForProjectPaginator returns a new
// ListSandboxesForProjectPaginator
func NewListSandboxesForProjectPaginator(client ListSandboxesForProjectAPIClient, params *ListSandboxesForProjectInput, optFns ...func(*ListSandboxesForProjectPaginatorOptions)) *ListSandboxesForProjectPaginator {
	if params == nil {
		params = &ListSandboxesForProjectInput{}
	}

	options := ListSandboxesForProjectPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSandboxesForProjectPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSandboxesForProjectPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSandboxesForProject page.
func (p *ListSandboxesForProjectPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSandboxesForProjectOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSandboxesForProject(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSandboxesForProjectAPIClient is a client that implements the
// ListSandboxesForProject operation.
type ListSandboxesForProjectAPIClient interface {
	ListSandboxesForProject(context.Context, *ListSandboxesForProjectInput, ...func(*Options)) (*ListSandboxesForProjectOutput, error)
}

var _ ListSandboxesForProjectAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSandboxesForProject(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSandboxesForProject",
	}
}
