# frozen_string_literal: true

class RemoveTempIndexForVulnerabilityDismissalInfo < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  milestone '17.2'

  INDEX_NAME = 'tmp_index_vulnerability_dismissal_info'

  def up
    remove_concurrent_index_by_name :vulnerabilities, INDEX_NAME
  end

  def down
    add_concurrent_index :vulnerabilities, :id,
      where: "state = 2 AND (dismissed_at IS NULL OR dismissed_by_id IS NULL)",
      name: INDEX_NAME
  end
end
