//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcontainerinstance

import "time"

// AzureFileVolume - The properties of the Azure File volume. Azure File shares are mounted as volumes.
type AzureFileVolume struct {
	// REQUIRED; The name of the Azure File share to be mounted as a volume.
	ShareName *string `json:"shareName,omitempty"`

	// REQUIRED; The name of the storage account that contains the Azure File share.
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// The flag indicating whether the Azure File shared mounted as a volume is read-only.
	ReadOnly *bool `json:"readOnly,omitempty"`

	// The storage account access key used to access the Azure File share.
	StorageAccountKey *string `json:"storageAccountKey,omitempty"`
}

// CachedImages - The cached image and OS type.
type CachedImages struct {
	// REQUIRED; The cached image name.
	Image *string `json:"image,omitempty"`

	// REQUIRED; The OS type of the cached image.
	OSType *string `json:"osType,omitempty"`
}

// CachedImagesListResult - The response containing cached images.
type CachedImagesListResult struct {
	// The URI to fetch the next page of cached images.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of cached images.
	Value []*CachedImages `json:"value,omitempty"`
}

// Capabilities - The regional capabilities.
type Capabilities struct {
	// READ-ONLY; The supported capabilities.
	Capabilities *CapabilitiesCapabilities `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; The GPU sku that this capability describes.
	Gpu *string `json:"gpu,omitempty" azure:"ro"`

	// READ-ONLY; The ip address type that this capability describes.
	IPAddressType *string `json:"ipAddressType,omitempty" azure:"ro"`

	// READ-ONLY; The resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The OS type that this capability describes.
	OSType *string `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; The resource type that this capability describes.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`
}

// CapabilitiesCapabilities - The supported capabilities.
type CapabilitiesCapabilities struct {
	// READ-ONLY; The maximum allowed CPU request in cores.
	MaxCPU *float32 `json:"maxCpu,omitempty" azure:"ro"`

	// READ-ONLY; The maximum allowed GPU count.
	MaxGpuCount *float32 `json:"maxGpuCount,omitempty" azure:"ro"`

	// READ-ONLY; The maximum allowed memory request in GB.
	MaxMemoryInGB *float32 `json:"maxMemoryInGB,omitempty" azure:"ro"`
}

// CapabilitiesListResult - The response containing list of capabilities.
type CapabilitiesListResult struct {
	// The URI to fetch the next page of capabilities.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of capabilities.
	Value []*Capabilities `json:"value,omitempty"`
}

// Container - A container instance.
type Container struct {
	// REQUIRED; The user-provided name of the container instance.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The properties of the container instance.
	Properties *ContainerProperties `json:"properties,omitempty"`
}

// ContainerAttachResponse - The information for the output stream from container attach.
type ContainerAttachResponse struct {
	// The password to the output stream from the attach. Send as an Authorization header value when connecting to the websocketUri.
	Password *string `json:"password,omitempty"`

	// The uri for the output stream from the attach.
	WebSocketURI *string `json:"webSocketUri,omitempty"`
}

// ContainerExec - The container execution command, for liveness or readiness probe
type ContainerExec struct {
	// The commands to execute within the container.
	Command []*string `json:"command,omitempty"`
}

// ContainerExecRequest - The container exec request.
type ContainerExecRequest struct {
	// The command to be executed.
	Command *string `json:"command,omitempty"`

	// The size of the terminal.
	TerminalSize *ContainerExecRequestTerminalSize `json:"terminalSize,omitempty"`
}

// ContainerExecRequestTerminalSize - The size of the terminal.
type ContainerExecRequestTerminalSize struct {
	// The column size of the terminal
	Cols *int32 `json:"cols,omitempty"`

	// The row size of the terminal
	Rows *int32 `json:"rows,omitempty"`
}

// ContainerExecResponse - The information for the container exec command.
type ContainerExecResponse struct {
	// The password to start the exec command.
	Password *string `json:"password,omitempty"`

	// The uri for the exec websocket.
	WebSocketURI *string `json:"webSocketUri,omitempty"`
}

// ContainerGroup - A container group.
type ContainerGroup struct {
	// REQUIRED; The container group properties
	Properties *ContainerGroupPropertiesProperties `json:"properties,omitempty"`

	// The identity of the container group, if configured.
	Identity *ContainerGroupIdentity `json:"identity,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// The zones for the container group.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContainerGroupDiagnostics - Container group diagnostic information.
type ContainerGroupDiagnostics struct {
	// Container group log analytics information.
	LogAnalytics *LogAnalytics `json:"logAnalytics,omitempty"`
}

// ContainerGroupIdentity - Identity for the container group.
type ContainerGroupIdentity struct {
	// The type of identity used for the container group. The type 'SystemAssigned, UserAssigned' includes both an implicitly
	// created identity and a set of user assigned identities. The type 'None' will
	// remove any identities from the container group.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the container group.
	UserAssignedIdentities map[string]*UserAssignedIdentities `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of the container group identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id associated with the container group. This property will only be provided for a system assigned
	// identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ContainerGroupListResult - The container group list response that contains the container group properties.
type ContainerGroupListResult struct {
	// The URI to fetch the next page of container groups.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of container groups.
	Value []*ContainerGroup `json:"value,omitempty"`
}

// ContainerGroupProperties - The container group properties
type ContainerGroupProperties struct {
	// REQUIRED; The container group properties
	Properties *ContainerGroupPropertiesProperties `json:"properties,omitempty"`

	// The identity of the container group, if configured.
	Identity *ContainerGroupIdentity `json:"identity,omitempty"`
}

// ContainerGroupPropertiesInstanceView - The instance view of the container group. Only valid in response.
type ContainerGroupPropertiesInstanceView struct {
	// READ-ONLY; The events of this container group.
	Events []*Event `json:"events,omitempty" azure:"ro"`

	// READ-ONLY; The state of the container group. Only valid in response.
	State *string `json:"state,omitempty" azure:"ro"`
}

// ContainerGroupPropertiesProperties - The container group properties
type ContainerGroupPropertiesProperties struct {
	// REQUIRED; The containers within the container group.
	Containers []*Container `json:"containers,omitempty"`

	// REQUIRED; The operating system type required by the containers in the container group.
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// The DNS config information for a container group.
	DNSConfig *DNSConfiguration `json:"dnsConfig,omitempty"`

	// The diagnostic information for a container group.
	Diagnostics *ContainerGroupDiagnostics `json:"diagnostics,omitempty"`

	// The encryption properties for a container group.
	EncryptionProperties *EncryptionProperties `json:"encryptionProperties,omitempty"`

	// extensions used by virtual kubelet
	Extensions []*DeploymentExtensionSpec `json:"extensions,omitempty"`

	// The IP address type of the container group.
	IPAddress *IPAddress `json:"ipAddress,omitempty"`

	// The image registry credentials by which the container group is created from.
	ImageRegistryCredentials []*ImageRegistryCredential `json:"imageRegistryCredentials,omitempty"`

	// The init containers for a container group.
	InitContainers []*InitContainerDefinition `json:"initContainers,omitempty"`

	// Restart policy for all containers within the container group.
	// * Always Always restart
	// * OnFailure Restart on failure
	// * Never Never restart
	RestartPolicy *ContainerGroupRestartPolicy `json:"restartPolicy,omitempty"`

	// The SKU for a container group.
	SKU *ContainerGroupSKU `json:"sku,omitempty"`

	// The subnet resource IDs for a container group.
	SubnetIDs []*ContainerGroupSubnetID `json:"subnetIds,omitempty"`

	// The list of volumes that can be mounted by containers in this container group.
	Volumes []*Volume `json:"volumes,omitempty"`

	// READ-ONLY; The instance view of the container group. Only valid in response.
	InstanceView *ContainerGroupPropertiesInstanceView `json:"instanceView,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the container group. This only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ContainerGroupSubnetID - Container group subnet information.
type ContainerGroupSubnetID struct {
	// REQUIRED; Resource ID of virtual network and subnet.
	ID *string `json:"id,omitempty"`

	// Friendly name for the subnet.
	Name *string `json:"name,omitempty"`
}

// ContainerGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the ContainerGroupsClient.BeginCreateOrUpdate
// method.
type ContainerGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerGroupsClientBeginDeleteOptions contains the optional parameters for the ContainerGroupsClient.BeginDelete method.
type ContainerGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerGroupsClientBeginRestartOptions contains the optional parameters for the ContainerGroupsClient.BeginRestart method.
type ContainerGroupsClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerGroupsClientBeginStartOptions contains the optional parameters for the ContainerGroupsClient.BeginStart method.
type ContainerGroupsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerGroupsClientGetOptions contains the optional parameters for the ContainerGroupsClient.Get method.
type ContainerGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContainerGroupsClientGetOutboundNetworkDependenciesEndpointsOptions contains the optional parameters for the ContainerGroupsClient.GetOutboundNetworkDependenciesEndpoints
// method.
type ContainerGroupsClientGetOutboundNetworkDependenciesEndpointsOptions struct {
	// placeholder for future optional parameters
}

// ContainerGroupsClientListByResourceGroupOptions contains the optional parameters for the ContainerGroupsClient.ListByResourceGroup
// method.
type ContainerGroupsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ContainerGroupsClientListOptions contains the optional parameters for the ContainerGroupsClient.List method.
type ContainerGroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// ContainerGroupsClientStopOptions contains the optional parameters for the ContainerGroupsClient.Stop method.
type ContainerGroupsClientStopOptions struct {
	// placeholder for future optional parameters
}

// ContainerGroupsClientUpdateOptions contains the optional parameters for the ContainerGroupsClient.Update method.
type ContainerGroupsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ContainerHTTPGet - The container Http Get settings, for liveness or readiness probe
type ContainerHTTPGet struct {
	// REQUIRED; The port number to probe.
	Port *int32 `json:"port,omitempty"`

	// The HTTP headers.
	HTTPHeaders []*HTTPHeader `json:"httpHeaders,omitempty"`

	// The path to probe.
	Path *string `json:"path,omitempty"`

	// The scheme.
	Scheme *Scheme `json:"scheme,omitempty"`
}

// ContainerPort - The port exposed on the container instance.
type ContainerPort struct {
	// REQUIRED; The port number exposed within the container group.
	Port *int32 `json:"port,omitempty"`

	// The protocol associated with the port.
	Protocol *ContainerNetworkProtocol `json:"protocol,omitempty"`
}

// ContainerProbe - The container probe, for liveness or readiness
type ContainerProbe struct {
	// The execution command to probe
	Exec *ContainerExec `json:"exec,omitempty"`

	// The failure threshold.
	FailureThreshold *int32 `json:"failureThreshold,omitempty"`

	// The Http Get settings to probe
	HTTPGet *ContainerHTTPGet `json:"httpGet,omitempty"`

	// The initial delay seconds.
	InitialDelaySeconds *int32 `json:"initialDelaySeconds,omitempty"`

	// The period seconds.
	PeriodSeconds *int32 `json:"periodSeconds,omitempty"`

	// The success threshold.
	SuccessThreshold *int32 `json:"successThreshold,omitempty"`

	// The timeout seconds.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`
}

// ContainerProperties - The container instance properties.
type ContainerProperties struct {
	// REQUIRED; The name of the image used to create the container instance.
	Image *string `json:"image,omitempty"`

	// REQUIRED; The resource requirements of the container instance.
	Resources *ResourceRequirements `json:"resources,omitempty"`

	// The commands to execute within the container instance in exec form.
	Command []*string `json:"command,omitempty"`

	// The environment variables to set in the container instance.
	EnvironmentVariables []*EnvironmentVariable `json:"environmentVariables,omitempty"`

	// The liveness probe.
	LivenessProbe *ContainerProbe `json:"livenessProbe,omitempty"`

	// The exposed ports on the container instance.
	Ports []*ContainerPort `json:"ports,omitempty"`

	// The readiness probe.
	ReadinessProbe *ContainerProbe `json:"readinessProbe,omitempty"`

	// The volume mounts available to the container instance.
	VolumeMounts []*VolumeMount `json:"volumeMounts,omitempty"`

	// READ-ONLY; The instance view of the container instance. Only valid in response.
	InstanceView *ContainerPropertiesInstanceView `json:"instanceView,omitempty" azure:"ro"`
}

// ContainerPropertiesInstanceView - The instance view of the container instance. Only valid in response.
type ContainerPropertiesInstanceView struct {
	// READ-ONLY; Current container instance state.
	CurrentState *ContainerState `json:"currentState,omitempty" azure:"ro"`

	// READ-ONLY; The events of the container instance.
	Events []*Event `json:"events,omitempty" azure:"ro"`

	// READ-ONLY; Previous container instance state.
	PreviousState *ContainerState `json:"previousState,omitempty" azure:"ro"`

	// READ-ONLY; The number of times that the container instance has been restarted.
	RestartCount *int32 `json:"restartCount,omitempty" azure:"ro"`
}

// ContainerState - The container instance state.
type ContainerState struct {
	// READ-ONLY; The human-readable status of the container instance state.
	DetailStatus *string `json:"detailStatus,omitempty" azure:"ro"`

	// READ-ONLY; The container instance exit codes correspond to those from the docker run command.
	ExitCode *int32 `json:"exitCode,omitempty" azure:"ro"`

	// READ-ONLY; The date-time when the container instance state finished.
	FinishTime *time.Time `json:"finishTime,omitempty" azure:"ro"`

	// READ-ONLY; The date-time when the container instance state started.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The state of the container instance.
	State *string `json:"state,omitempty" azure:"ro"`
}

// ContainersClientAttachOptions contains the optional parameters for the ContainersClient.Attach method.
type ContainersClientAttachOptions struct {
	// placeholder for future optional parameters
}

// ContainersClientExecuteCommandOptions contains the optional parameters for the ContainersClient.ExecuteCommand method.
type ContainersClientExecuteCommandOptions struct {
	// placeholder for future optional parameters
}

// ContainersClientListLogsOptions contains the optional parameters for the ContainersClient.ListLogs method.
type ContainersClientListLogsOptions struct {
	// The number of lines to show from the tail of the container instance log. If not provided, all available logs are shown
	// up to 4mb.
	Tail *int32
	// If true, adds a timestamp at the beginning of every line of log output. If not provided, defaults to false.
	Timestamps *bool
}

// DNSConfiguration - DNS configuration for the container group.
type DNSConfiguration struct {
	// REQUIRED; The DNS servers for the container group.
	NameServers []*string `json:"nameServers,omitempty"`

	// The DNS options for the container group.
	Options *string `json:"options,omitempty"`

	// The DNS search domains for hostname lookup in the container group.
	SearchDomains *string `json:"searchDomains,omitempty"`
}

// DeploymentExtensionSpec - Extension sidecars to be added to the deployment.
type DeploymentExtensionSpec struct {
	// REQUIRED; Name of the extension.
	Name *string `json:"name,omitempty"`

	// Extension specific properties
	Properties *DeploymentExtensionSpecProperties `json:"properties,omitempty"`
}

// DeploymentExtensionSpecProperties - Extension specific properties
type DeploymentExtensionSpecProperties struct {
	// REQUIRED; Type of extension to be added.
	ExtensionType *string `json:"extensionType,omitempty"`

	// REQUIRED; Version of the extension being used.
	Version *string `json:"version,omitempty"`

	// Protected settings for the extension.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`

	// Settings for the extension.
	Settings interface{} `json:"settings,omitempty"`
}

// EncryptionProperties - The container group encryption properties.
type EncryptionProperties struct {
	// REQUIRED; The encryption key name.
	KeyName *string `json:"keyName,omitempty"`

	// REQUIRED; The encryption key version.
	KeyVersion *string `json:"keyVersion,omitempty"`

	// REQUIRED; The keyvault base url.
	VaultBaseURL *string `json:"vaultBaseUrl,omitempty"`

	// The keyvault managed identity.
	Identity *string `json:"identity,omitempty"`
}

// EnvironmentVariable - The environment variable to set within the container instance.
type EnvironmentVariable struct {
	// REQUIRED; The name of the environment variable.
	Name *string `json:"name,omitempty"`

	// The value of the secure environment variable.
	SecureValue *string `json:"secureValue,omitempty"`

	// The value of the environment variable.
	Value *string `json:"value,omitempty"`
}

// Event - A container group or container instance event.
type Event struct {
	// READ-ONLY; The count of the event.
	Count *int32 `json:"count,omitempty" azure:"ro"`

	// READ-ONLY; The date-time of the earliest logged event.
	FirstTimestamp *time.Time `json:"firstTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The date-time of the latest logged event.
	LastTimestamp *time.Time `json:"lastTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The event message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The event name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The event type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GitRepoVolume - Represents a volume that is populated with the contents of a git repository
type GitRepoVolume struct {
	// REQUIRED; Repository URL
	Repository *string `json:"repository,omitempty"`

	// Target directory name. Must not contain or start with '..'. If '.' is supplied, the volume directory will be the git repository.
	// Otherwise, if specified, the volume will contain the git repository in
	// the subdirectory with the given name.
	Directory *string `json:"directory,omitempty"`

	// Commit hash for the specified revision.
	Revision *string `json:"revision,omitempty"`
}

// GpuResource - The GPU resource.
type GpuResource struct {
	// REQUIRED; The count of the GPU resource.
	Count *int32 `json:"count,omitempty"`

	// REQUIRED; The SKU of the GPU resource.
	SKU *GpuSKU `json:"sku,omitempty"`
}

// HTTPHeader - The HTTP header.
type HTTPHeader struct {
	// The header name.
	Name *string `json:"name,omitempty"`

	// The header value.
	Value *string `json:"value,omitempty"`
}

// IPAddress - IP address for the container group.
type IPAddress struct {
	// REQUIRED; The list of ports exposed on the container group.
	Ports []*Port `json:"ports,omitempty"`

	// REQUIRED; Specifies if the IP is exposed to the public internet or private VNET.
	Type *ContainerGroupIPAddressType `json:"type,omitempty"`

	// The value representing the security enum. The 'Unsecure' value is the default value if not selected and means the object's
	// domain name label is not secured against subdomain takeover. The
	// 'TenantReuse' value is the default value if selected and means the object's domain name label can be reused within the
	// same tenant. The 'SubscriptionReuse' value means the object's domain name label
	// can be reused within the same subscription. The 'ResourceGroupReuse' value means the object's domain name label can be
	// reused within the same resource group. The 'NoReuse' value means the object's
	// domain name label cannot be reused within the same resource group, subscription, or tenant.
	AutoGeneratedDomainNameLabelScope *DNSNameLabelReusePolicy `json:"autoGeneratedDomainNameLabelScope,omitempty"`

	// The Dns name label for the IP.
	DNSNameLabel *string `json:"dnsNameLabel,omitempty"`

	// The IP exposed to the public internet.
	IP *string `json:"ip,omitempty"`

	// READ-ONLY; The FQDN for the IP.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`
}

// ImageRegistryCredential - Image registry credential.
type ImageRegistryCredential struct {
	// REQUIRED; The Docker image registry server without a protocol such as "http" and "https".
	Server *string `json:"server,omitempty"`

	// The identity for the private registry.
	Identity *string `json:"identity,omitempty"`

	// The identity URL for the private registry.
	IdentityURL *string `json:"identityUrl,omitempty"`

	// The password for the private registry.
	Password *string `json:"password,omitempty"`

	// The username for the private registry.
	Username *string `json:"username,omitempty"`
}

// InitContainerDefinition - The init container definition.
type InitContainerDefinition struct {
	// REQUIRED; The name for the init container.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The properties for the init container.
	Properties *InitContainerPropertiesDefinition `json:"properties,omitempty"`
}

// InitContainerPropertiesDefinition - The init container definition properties.
type InitContainerPropertiesDefinition struct {
	// The command to execute within the init container in exec form.
	Command []*string `json:"command,omitempty"`

	// The environment variables to set in the init container.
	EnvironmentVariables []*EnvironmentVariable `json:"environmentVariables,omitempty"`

	// The image of the init container.
	Image *string `json:"image,omitempty"`

	// The volume mounts available to the init container.
	VolumeMounts []*VolumeMount `json:"volumeMounts,omitempty"`

	// READ-ONLY; The instance view of the init container. Only valid in response.
	InstanceView *InitContainerPropertiesDefinitionInstanceView `json:"instanceView,omitempty" azure:"ro"`
}

// InitContainerPropertiesDefinitionInstanceView - The instance view of the init container. Only valid in response.
type InitContainerPropertiesDefinitionInstanceView struct {
	// READ-ONLY; The current state of the init container.
	CurrentState *ContainerState `json:"currentState,omitempty" azure:"ro"`

	// READ-ONLY; The events of the init container.
	Events []*Event `json:"events,omitempty" azure:"ro"`

	// READ-ONLY; The previous state of the init container.
	PreviousState *ContainerState `json:"previousState,omitempty" azure:"ro"`

	// READ-ONLY; The number of times that the init container has been restarted.
	RestartCount *int32 `json:"restartCount,omitempty" azure:"ro"`
}

// LocationClientListCachedImagesOptions contains the optional parameters for the LocationClient.ListCachedImages method.
type LocationClientListCachedImagesOptions struct {
	// placeholder for future optional parameters
}

// LocationClientListCapabilitiesOptions contains the optional parameters for the LocationClient.ListCapabilities method.
type LocationClientListCapabilitiesOptions struct {
	// placeholder for future optional parameters
}

// LocationClientListUsageOptions contains the optional parameters for the LocationClient.ListUsage method.
type LocationClientListUsageOptions struct {
	// placeholder for future optional parameters
}

// LogAnalytics - Container group log analytics information.
type LogAnalytics struct {
	// REQUIRED; The workspace id for log analytics
	WorkspaceID *string `json:"workspaceId,omitempty"`

	// REQUIRED; The workspace key for log analytics
	WorkspaceKey *string `json:"workspaceKey,omitempty"`

	// The log type to be used.
	LogType *LogAnalyticsLogType `json:"logType,omitempty"`

	// Metadata for log analytics.
	Metadata map[string]*string `json:"metadata,omitempty"`

	// The workspace resource id for log analytics
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`
}

// Logs - The logs.
type Logs struct {
	// The content of the log.
	Content *string `json:"content,omitempty"`
}

// Operation - An operation for Azure Container Instance service.
type Operation struct {
	// REQUIRED; The display information of the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// REQUIRED; The name of the operation.
	Name *string `json:"name,omitempty"`

	// The intended executor of the operation.
	Origin *ContainerInstanceOperationsOrigin `json:"origin,omitempty"`

	// The additional properties.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationDisplay - The display information of the operation.
type OperationDisplay struct {
	// The description of the operation.
	Description *string `json:"description,omitempty"`

	// The friendly name of the operation.
	Operation *string `json:"operation,omitempty"`

	// The name of the provider of the operation.
	Provider *string `json:"provider,omitempty"`

	// The name of the resource type of the operation.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - The operation list response that contains all operations for Azure Container Instance service.
type OperationListResult struct {
	// The URI to fetch the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of operations.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Port - The port exposed on the container group.
type Port struct {
	// REQUIRED; The port number.
	Port *int32 `json:"port,omitempty"`

	// The protocol associated with the port.
	Protocol *ContainerGroupNetworkProtocol `json:"protocol,omitempty"`
}

// Resource - The Resource model definition.
type Resource struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// The zones for the container group.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceLimits - The resource limits.
type ResourceLimits struct {
	// The CPU limit of this container instance.
	CPU *float64 `json:"cpu,omitempty"`

	// The GPU limit of this container instance.
	Gpu *GpuResource `json:"gpu,omitempty"`

	// The memory limit in GB of this container instance.
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`
}

// ResourceRequests - The resource requests.
type ResourceRequests struct {
	// REQUIRED; The CPU request of this container instance.
	CPU *float64 `json:"cpu,omitempty"`

	// REQUIRED; The memory request in GB of this container instance.
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`

	// The GPU request of this container instance.
	Gpu *GpuResource `json:"gpu,omitempty"`
}

// ResourceRequirements - The resource requirements.
type ResourceRequirements struct {
	// REQUIRED; The resource requests of this container instance.
	Requests *ResourceRequests `json:"requests,omitempty"`

	// The resource limits of this container instance.
	Limits *ResourceLimits `json:"limits,omitempty"`
}

// SubnetServiceAssociationLinkClientBeginDeleteOptions contains the optional parameters for the SubnetServiceAssociationLinkClient.BeginDelete
// method.
type SubnetServiceAssociationLinkClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// Usage - A single usage result
type Usage struct {
	// READ-ONLY; The current usage of the resource
	CurrentValue *int32 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; Id of the usage result
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The maximum permitted usage of the resource.
	Limit *int32 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; The name object of the resource
	Name *UsageName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Unit of the usage result
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// UsageListResult - The response containing the usage data
type UsageListResult struct {
	// READ-ONLY; The usage data.
	Value []*Usage `json:"value,omitempty" azure:"ro"`
}

// UsageName - The name object of the resource
type UsageName struct {
	// READ-ONLY; The localized name of the resource
	LocalizedValue *string `json:"localizedValue,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Value *string `json:"value,omitempty" azure:"ro"`
}

// UserAssignedIdentities - The list of user identities associated with the container group. The user identity dictionary
// key references will be ARM resource ids in the form:
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
type UserAssignedIdentities struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// Volume - The properties of the volume.
type Volume struct {
	// REQUIRED; The name of the volume.
	Name *string `json:"name,omitempty"`

	// The Azure File volume.
	AzureFile *AzureFileVolume `json:"azureFile,omitempty"`

	// The empty directory volume.
	EmptyDir interface{} `json:"emptyDir,omitempty"`

	// The git repo volume.
	GitRepo *GitRepoVolume `json:"gitRepo,omitempty"`

	// The secret volume.
	Secret map[string]*string `json:"secret,omitempty"`
}

// VolumeMount - The properties of the volume mount.
type VolumeMount struct {
	// REQUIRED; The path within the container where the volume should be mounted. Must not contain colon (:).
	MountPath *string `json:"mountPath,omitempty"`

	// REQUIRED; The name of the volume mount.
	Name *string `json:"name,omitempty"`

	// The flag indicating whether the volume mount is read-only.
	ReadOnly *bool `json:"readOnly,omitempty"`
}
