"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rectifyTSI5Table = exports.rectifyTSI0123Table = void 0;
const Ot = require("@ot-builder/ot");
const shared_1 = require("../shared");
// We do not implement rectifier for TSIC since it uses a different variation model
function rectifyTSI0123Table(rg, table) {
    const t1 = new Ot.TSI0123.Table();
    t1.glyphPrograms = shared_1.RectifyImpl.Glyph.mapSome(rg, table.glyphPrograms);
    t1.preProgram = table.preProgram;
    t1.cvtProgram = table.cvtProgram;
    t1.fpgmProgram = table.fpgmProgram;
    return t1;
}
exports.rectifyTSI0123Table = rectifyTSI0123Table;
function rectifyTSI5Table(rg, table) {
    const t1 = new Ot.TSI5.Table();
    t1.charGroupFlags = shared_1.RectifyImpl.Glyph.mapSome(rg, table.charGroupFlags);
    return t1;
}
exports.rectifyTSI5Table = rectifyTSI5Table;
//# sourceMappingURL=vtt.js.map