[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
![CI](https://github.com/bitwuzla/bitwuzla/actions/workflows/ci.yml/badge.svg?branch=main)

# Bitwuzla

Bitwuzla is a Satisfiability Modulo Theories (SMT) solver for the theories
of fixed-size bit-vectors, floating-point arithmetic, arrays, uninterpreted
functions and their combinations.

If you are using Bitwuzla in your work, or if you incorporate it into software
of your own, we invite you to send us a description and link to your
project/software, so that we can link it as third party
application on [bitwuzla.github.io](https://bitwuzla.github.io).

## Website

More information about Bitwuzla is available at: https://bitwuzla.github.io

## Documentation

Documentation for Bitwuzla is available at: https://bitwuzla.github.io/docs

## Download

The latest version of Bitwuzla is available on GitHub:
https://github.com/bitwuzla/bitwuzla

## Build and Installation Instructions

Bitwuzla can be built on Linux and macOS. Windows support is planned and WIP.

For detailed build and installation instructions
see [docs/install.rst](docs/install.rst).

## Citing Bitwuzla

A [comprehensive system description](https://bitwuzla.github.io/data/NiemetzP-CAV23.pdf)
of Bitwuzla was presented and published at CAV 2023.
Please use the following Bibtex for citing Bitwuzla.

```
@inproceedings{DBLP:conf/cav/NiemetzP23,
  author       = {Aina Niemetz and
                  Mathias Preiner},
  editor       = {Constantin Enea and
                  Akash Lal},
  title        = {Bitwuzla},
  booktitle    = {Computer Aided Verification - 35th International Conference, {CAV}
                  2023, Paris, France, July 17-22, 2023, Proceedings, Part {II}},
  series       = {Lecture Notes in Computer Science},
  volume       = {13965},
  pages        = {3--17},
  publisher    = {Springer},
  year         = {2023},
  url          = {https://doi.org/10.1007/978-3-031-37703-7\_1},
  doi          = {10.1007/978-3-031-37703-7\_1},
  timestamp    = {Fri, 21 Jul 2023 17:55:59 +0200},
  biburl       = {https://dblp.org/rec/conf/cav/NiemetzP23.bib},
  bibsource    = {dblp computer science bibliography, https://dblp.org}
}
```

## Contributing

Please refer to our [contributing guidelines](CONTRIBUTING.md).
