// Copyright (c) 2026 by Philipp Schafft.
// This software comes with NO WARRANTY WHATSOEVER.
//
// This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 dated June, 1991, or, at your
//    option, any LATER version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this software; see the file COPYING.  If not, write to
//    the Free Software Foundation, 51 Franklin Street, Fifth Floor,
//    Boston, MA 02110-1301, USA.

#include <string>
#include <sqlite3.h>

bool        Write(sqlite3 *db, const std::string &theKey, const std::string &theValue);
bool        Read(sqlite3 *db, const std::string &theKey, std::string &theValue);
sqlite3 *   OpenFile(std::string dbfile);
void        CloseFile(sqlite3 *db);
void        SetLast(sqlite3 * db, const std::string &newKey);
std::string GetLast(sqlite3 * db);
void        SetDbType(sqlite3 *db, const std::string &newType, bool plural);
std::string GetDbType(sqlite3 *db, bool plural);
bool        IsAnimal(sqlite3 *db, const std::string &theKey);
